/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.codeInsight.JUnit5MalformedParameterizedInspectionKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/junit/codeInsight/NullOrEmptySourceChecker;", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "checkEmptySource", "", "method", "Lorg/jetbrains/uast/UMethod;", "psiAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "checkFormalParameters", "size", "", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "sourceName", "", "checkNullSource", "intellij.junit"})
final class NullOrEmptySourceChecker {
    @NotNull
    private final ProblemsHolder holder;

    public final void checkNullSource(@NotNull UMethod method, @NotNull PsiAnnotation psiAnnotation) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)psiAnnotation, (String)"psiAnnotation");
        int size = method.getUastParameters().size();
        if (size != 1) {
            UElement uElement = UastContextKt.toUElement((PsiElement)JUnit5MalformedParameterizedInspectionKt.getElementToHighlight$default((PsiElement)psiAnnotation, method, null, 4, null));
            if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
                return;
            }
            UElement sourcePsi = uElement;
            this.checkFormalParameters(size, (PsiElement)sourcePsi, psiAnnotation.getQualifiedName());
        }
    }

    private final void checkFormalParameters(int size, PsiElement sourcePsi, String sourceName) {
        if (sourceName == null) {
            return;
        }
        String errorMessageKey = size == 0 ? "junit5.malformed.parameterized.inspection.description.nullsource.cannot.provide.argument.no.params" : "junit5.malformed.parameterized.inspection.description.nullsource.cannot.provide.argument.too.many.params";
        this.holder.registerProblem(sourcePsi, JUnitBundle.message(errorMessageKey, StringUtil.getShortName((String)sourceName)), new LocalQuickFix[0]);
    }

    public final void checkEmptySource(@NotNull UMethod method, @NotNull PsiAnnotation psiAnnotation) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)psiAnnotation, (String)"psiAnnotation");
        UElement uElement = UastContextKt.toUElement((PsiElement)JUnit5MalformedParameterizedInspectionKt.getElementToHighlight$default((PsiElement)psiAnnotation, method, null, 4, null));
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            return;
        }
        UElement sourcePsi = uElement;
        int size = method.getUastParameters().size();
        String string = psiAnnotation.getQualifiedName();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiAnnotation.qualifiedName ?: return");
        String shortName = string;
        if (size == 1) {
            PsiType type = ((UParameter)method.getUastParameters().get(0)).getType();
            if (type instanceof PsiArrayType || type.equalsToText("java.lang.String") || type.equalsToText("java.util.List") || type.equalsToText("java.util.Set") || type.equalsToText("java.util.Map")) {
                return;
            }
            this.holder.registerProblem((PsiElement)sourcePsi, JUnitBundle.message("junit5.malformed.parameterized.inspection.description.emptysource.cannot.provide.argument", StringUtil.getShortName((String)shortName), type.getPresentableText()), new LocalQuickFix[0]);
        } else {
            this.checkFormalParameters(size, (PsiElement)sourcePsi, shortName);
        }
    }

    @NotNull
    public final ProblemsHolder getHolder() {
        return this.holder;
    }

    public NullOrEmptySourceChecker(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }
}

