/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JUnitImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final String MOCK = "org.mockito.Mock";
    private static final String KOTLIN_JVM_STATIC = "kotlin.jvm.JvmStatic";
    private static final List<String> INJECTED_FIELD_ANNOTATIONS = Arrays.asList("org.mockito.Mock", "org.mockito.Spy", "org.mockito.Captor", "org.mockito.InjectMocks", "org.assertj.core.api.junit.jupiter.InjectSoftAssertions", "org.junit.jupiter.api.io.TempDir");

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return element instanceof PsiParameter && JUnitImplicitUsageProvider.isParameterUsedInParameterizedPresentation((PsiParameter)element) || JUnitImplicitUsageProvider.isReferencedInsideEnumSourceAnnotation(element) || JUnitImplicitUsageProvider.isReferencedInsideMethodSourceAnnotation(element);
    }

    private static boolean isParameterUsedInParameterizedPresentation(PsiParameter parameter) {
        PsiAnnotationMemberValue attributeValue;
        PsiMethod method;
        PsiAnnotation annotation;
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (declarationScope instanceof PsiMethod && (annotation = (method = (PsiMethod)declarationScope).getModifierList().findAnnotation("org.junit.jupiter.params.ParameterizedTest")) != null && (attributeValue = annotation.findDeclaredAttributeValue("name")) instanceof PsiExpression) {
            String indexInDisplayName = "{" + method.getParameterList().getParameterIndex(parameter) + "}";
            Object value = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)attributeValue), null, (boolean)false);
            return indexInDisplayName.equals(value);
        }
        return false;
    }

    private static boolean isReferencedInsideEnumSourceAnnotation(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiEnumConstant) {
            PsiClass psiClass = ((PsiEnumConstant)element).getContainingClass();
            return psiClass != null && (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create((Object)JUnitImplicitUsageProvider.isEnumClassReferencedInEnumSourceAnnotation(psiClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT})) != false;
        }
        return false;
    }

    private static boolean isReferencedInsideMethodSourceAnnotation(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiMethod, () -> CachedValueProvider.Result.create((Object)JUnitImplicitUsageProvider.isReferencedInsideMethodSourceAnnotation(psiMethod), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        }
        return false;
    }

    private static boolean isReferencedInsideMethodSourceAnnotation(@NotNull PsiMethod psiMethod) {
        PsiElement parent;
        if (psiMethod == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        String methodName = psiMethod.getName();
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiMethod.getAnnotation("org.junit.jupiter.params.provider.MethodSource") != null) {
            return false;
        }
        if (psiMethod.getParameterList().getParametersCount() != 0) {
            return false;
        }
        if (!TestUtils.isInTestSourceContent((PsiElement)psiClass)) {
            return false;
        }
        if (psiMethod.hasAnnotation(KOTLIN_JVM_STATIC) && (parent = psiClass.getParent()) != null) {
            psiClass = (PsiClass)parent;
        }
        return ContainerUtil.exists((Object[])psiClass.findMethodsByName(methodName, false), it -> psiMethod != it && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)it, Collections.singleton("org.junit.jupiter.params.provider.MethodSource")) && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)it, Collections.singleton("org.junit.jupiter.params.ParameterizedTest")));
    }

    private static boolean isEnumClassReferencedInEnumSourceAnnotation(PsiClass psiClass) {
        String className = psiClass.getName();
        if (className == null) {
            return false;
        }
        SearchScope useScope = psiClass.getUseScope();
        if (!JUnitImplicitUsageProvider.shouldCheckClassUsages(psiClass, className, useScope)) {
            return false;
        }
        return ReferencesSearch.search((PsiElement)psiClass, (SearchScope)useScope, (boolean)false).anyMatch(reference -> {
            String annotationName;
            PsiElement referenceElement = reference.getElement();
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiAnnotation.class, (boolean)true, (Class[])new Class[]{PsiStatement.class, PsiMember.class});
            return annotation != null && "org.junit.jupiter.params.provider.EnumSource".equals(annotationName = annotation.getQualifiedName()) && annotation.getAttributes().size() == 1;
        });
    }

    private static boolean shouldCheckClassUsages(PsiClass psiClass, String name, SearchScope useScope) {
        if (!(useScope instanceof LocalSearchScope)) {
            PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)psiClass.getProject());
            if (PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES == searchHelper.isCheapEnoughToSearch("EnumSource", (GlobalSearchScope)useScope, null, null)) {
                return false;
            }
            PsiSearchHelper.SearchCostResult cheapEnough = searchHelper.isCheapEnoughToSearch(name, (GlobalSearchScope)useScope, null, null);
            if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES || cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return false;
            }
        }
        return true;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(5);
        }
        return element instanceof PsiParameter && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiParameter)element), (String)MOCK, (int)0) || element instanceof PsiField && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiField)element), INJECTED_FIELD_ANNOTATIONS, (int)0);
    }

    public boolean isImplicitlyNotNullInitialized(@NotNull PsiElement element) {
        if (element == null) {
            JUnitImplicitUsageProvider.$$$reportNull$$$0(6);
        }
        return this.isImplicitWrite(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit2/inspection/JUnitImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferencedInsideEnumSourceAnnotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferencedInsideMethodSourceAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitlyNotNullInitialized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

