/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.fus;

import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ)\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\u0002\b\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/grazie/ide/fus/GrazieFUSCounter;", "", "()V", "languagesSuggested", "", "languages", "", "Lcom/intellij/grazie/detector/model/Language;", "isEnabled", "", "log", "eventId", "", "body", "Lkotlin/Function1;", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "Lkotlin/ExtensionFunctionType;", "quickFixInvoked", "rule", "Lcom/intellij/grazie/text/Rule;", "project", "Lcom/intellij/openapi/project/Project;", "actionInfo", "typoFound", "problem", "Lcom/intellij/grazie/text/TextProblem;", "intellij.grazie.core"})
public final class GrazieFUSCounter {
    @NotNull
    public static final GrazieFUSCounter INSTANCE;

    public final void languagesSuggested(@NotNull Collection<? extends Language> languages2, boolean isEnabled) {
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        for (Language language : languages2) {
            this.log("language.suggested", (Function1<? super FeatureUsageData, Unit>)((Function1)new Function1<FeatureUsageData, Unit>(language, isEnabled){
                final /* synthetic */ Language $language;
                final /* synthetic */ boolean $isEnabled;

                public final void invoke(@NotNull FeatureUsageData $this$log) {
                    Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$receiver");
                    $this$log.addData("language", this.$language.getIso().toString());
                    $this$log.addData("enabled", this.$isEnabled);
                }
                {
                    this.$language = language;
                    this.$isEnabled = bl;
                    super(1);
                }
            }));
        }
    }

    public final void typoFound(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        this.log("typo.found", (Function1<? super FeatureUsageData, Unit>)((Function1)new Function1<FeatureUsageData, Unit>(problem){
            final /* synthetic */ TextProblem $problem;

            public final void invoke(@NotNull FeatureUsageData $this$log) {
                Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$receiver");
                Rule rule = this.$problem.getRule();
                Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"problem.rule");
                String string = rule.getGlobalId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"problem.rule.globalId");
                $this$log.addData("id", string);
                $this$log.addPluginInfo(PluginInfoDetectorKt.getPluginInfo(this.$problem.getRule().getClass()));
                $this$log.addData("fixes", this.$problem.getCorrections().size());
                TextContent textContent = this.$problem.getText();
                Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
                PsiFile psiFile = textContent.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"problem.text.containingFile");
                $this$log.addProject(psiFile.getProject());
            }
            {
                this.$problem = textProblem;
                super(1);
            }
        }));
    }

    public final void quickFixInvoked(@NotNull Rule rule, @NotNull Project project, @NotNull String actionInfo) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        this.log("quick.fix.invoked", (Function1<? super FeatureUsageData, Unit>)((Function1)new Function1<FeatureUsageData, Unit>(rule, actionInfo, project){
            final /* synthetic */ Rule $rule;
            final /* synthetic */ String $actionInfo;
            final /* synthetic */ Project $project;

            public final void invoke(@NotNull FeatureUsageData $this$log) {
                Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$receiver");
                String string = this.$rule.getGlobalId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rule.globalId");
                $this$log.addData("id", string);
                $this$log.addData("info", this.$actionInfo);
                $this$log.addPluginInfo(PluginInfoDetectorKt.getPluginInfo(this.$rule.getClass()));
                $this$log.addProject(this.$project);
            }
            {
                this.$rule = rule;
                this.$actionInfo = string;
                this.$project = project;
                super(1);
            }
        }));
    }

    private final void log(String eventId, Function1<? super FeatureUsageData, Unit> body2) {
        FUCounterUsageLogger fUCounterUsageLogger = FUCounterUsageLogger.getInstance();
        FeatureUsageData featureUsageData = new FeatureUsageData();
        body2.invoke((Object)featureUsageData);
        fUCounterUsageLogger.logEvent("grazie.count", eventId, featureUsageData);
    }

    private GrazieFUSCounter() {
    }

    static {
        GrazieFUSCounter grazieFUSCounter;
        INSTANCE = grazieFUSCounter = new GrazieFUSCounter();
    }
}

