/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.download.IndexDownloadHistoryEntry;
import com.intellij.indexing.shared.download.IndexDownloadHistoryState;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@State(name="shared-index-download-history", storages={@Storage(value="$CACHE_FILE$")}, allowLoadInTests=true)
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0003\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0006\u0010\u000e\u001a\u00020\fJ$\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadHistoryStore;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/indexing/shared/download/IndexDownloadHistoryState;", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "isDownloadMakeSenseFor", "", "indexId", "Lcom/intellij/indexing/shared/download/SharedIndexId;", "checkDescriptor", "loadState", "", "state", "reset", "updateLastDownload", "indexIds", "", "chunkId", "", "downloadSize", "", "intellij.indexing.shared"})
public final class SharedIndexDownloadHistoryStore
extends SimplePersistentStateComponent<IndexDownloadHistoryState> {
    private final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull IndexDownloadHistoryState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            super.loadState((BaseState)state);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void reset() {
        this.loadState(new IndexDownloadHistoryState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void updateLastDownload(@NotNull List<SharedIndexId> indexIds, @NotNull String chunkId, long downloadSize) {
        Intrinsics.checkNotNullParameter(indexIds, (String)"indexIds");
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        List indexesToProcess = CollectionsKt.distinct((Iterable)indexIds);
        if (indexesToProcess.isEmpty()) {
            return;
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            void $this$mapTo$iv$iv;
            Object it;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            IndexDownloadHistoryState state = (IndexDownloadHistoryState)this.getState();
            Iterable $this$mapNotNull$iv = indexesToProcess;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<IndexDownloadHistoryEntry> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IndexDownloadHistoryEntry indexDownloadHistoryEntry;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                it = (SharedIndexId)element$iv$iv;
                boolean bl3 = false;
                IndexDownloadHistoryEntry indexDownloadHistoryEntry2 = state.filterEntry((SharedIndexId)it);
                if (indexDownloadHistoryEntry2 == null) continue;
                IndexDownloadHistoryEntry it$iv$iv = indexDownloadHistoryEntry = indexDownloadHistoryEntry2;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            Iterable $this$map$iv = indexesToProcess;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void indexId2;
                element$iv$iv$iv = (SharedIndexId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                IndexDownloadHistoryEntry indexDownloadHistoryEntry = new IndexDownloadHistoryEntry();
                it = indexDownloadHistoryEntry;
                boolean bl6 = false;
                ((IndexDownloadHistoryEntry)((Object)it)).setIndexKind(indexId2.getKind());
                ((IndexDownloadHistoryEntry)((Object)it)).setIndexId(indexId2.getIndexId());
                ((IndexDownloadHistoryEntry)((Object)it)).setLastDeliveredChunkUniqueId(chunkId);
                ((IndexDownloadHistoryEntry)((Object)it)).setLastDownloadSize(String.valueOf(downloadSize));
                ((IndexDownloadHistoryEntry)((Object)it)).setLastDownloadDate(ZonedDateTime.now().format(DateTimeFormatter.ISO_ZONED_DATE_TIME.withLocale(Locale.US)));
                IndexDownloadHistoryEntry indexDownloadHistoryEntry3 = indexDownloadHistoryEntry;
                collection.add(indexDownloadHistoryEntry3);
            }
            List toAdd = (List)destination$iv$iv2;
            state.getEntries().removeAll(toRemove);
            state.getEntries().addAll(toAdd);
            state.intIncrementModificationCount();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDownloadMakeSenseFor(@NotNull SharedIndexId indexId2, @VisibleForTesting boolean checkDescriptor) {
        Intrinsics.checkNotNullParameter((Object)indexId2, (String)"indexId");
        Lock lock = this.lock;
        lock.lock();
        try {
            IndexDownloadHistoryEntry indexDownloadHistoryEntry;
            boolean bl = false;
            IndexDownloadHistoryState state = (IndexDownloadHistoryState)this.getState();
            if (state.filterEntry(indexId2) == null) {
                boolean bl2 = true;
                return bl2;
            }
            IndexDownloadHistoryEntry candidate = indexDownloadHistoryEntry;
            String lastChunkId = candidate.getLastDeliveredChunkUniqueId();
            if (lastChunkId == null || candidate.getLastDownloadDate() == null) {
                state.removeEntry(candidate);
                boolean bl3 = true;
                return bl3;
            }
            if (!checkDescriptor) {
                boolean bl4 = false;
                return bl4;
            }
            if (!SharedIndexChunkConfiguration.getInstance().isAvailableChunk(lastChunkId)) {
                state.removeEntry(candidate);
                boolean bl5 = true;
                return bl5;
            }
            boolean bl6 = false;
            return bl6;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ boolean isDownloadMakeSenseFor$default(SharedIndexDownloadHistoryStore sharedIndexDownloadHistoryStore, SharedIndexId sharedIndexId, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return sharedIndexDownloadHistoryStore.isDownloadMakeSenseFor(sharedIndexId, bl);
    }

    public SharedIndexDownloadHistoryStore() {
        super((BaseState)new IndexDownloadHistoryState());
    }
}

