/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.util;

import java.awt.Font;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.data.FontDataHolder;
import org.jetbrains.projector.common.protocol.data.TtfFontData;
import org.jetbrains.projector.server.core.util.ObjectIdCacher;
import org.jetbrains.projector.server.service.ProjectorFontProvider;
import org.jetbrains.projector.server.util.FontCacher;
import org.jetbrains.projector.util.loading.ReflectKt;
import sun.font.CompositeFont;
import sun.font.FileFont;
import sun.font.Font2D;
import sun.font.PhysicalFont;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u0010H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u0013H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/projector/server/util/FontCacher;", "", "()V", "filePathCacher", "Lorg/jetbrains/projector/server/core/util/ObjectIdCacher;", "", "", "getFont2DMethod", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "publicFileNameMethod", "getFontData", "Lorg/jetbrains/projector/common/protocol/data/FontDataHolder;", "fontId", "getId", "font", "Ljava/awt/Font;", "(Ljava/awt/Font;)Ljava/lang/Short;", "getFilePath", "Lsun/font/Font2D;", "projector-server"})
public final class FontCacher {
    @NotNull
    public static final FontCacher INSTANCE;
    @NotNull
    private static final ObjectIdCacher<Short, String> filePathCacher;
    private static final Method publicFileNameMethod;
    private static final Method getFont2DMethod;

    private FontCacher() {
    }

    @Nullable
    public final Short getId(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        String string = this.getFilePath(font);
        if (string == null) {
            return null;
        }
        String filePath = string;
        return filePathCacher.getIdBy(filePath);
    }

    @NotNull
    public final FontDataHolder getFontData(short fontId) {
        String filePath = filePathCacher.getObjectBy((Short)((Number)fontId));
        byte[] data = FilesKt.readBytes((File)new File(filePath));
        byte[] byArray = Base64.getEncoder().encode(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoder().encode(data)");
        String base64 = new String(byArray, Charsets.UTF_8);
        return new FontDataHolder(fontId, new TtfFontData(base64));
    }

    private final String getFilePath(Font2D $this$getFilePath) {
        Font2D font2D = $this$getFilePath;
        if (font2D instanceof CompositeFont) {
            int n = 0;
            int n2 = ((CompositeFont)$this$getFilePath).getNumSlots();
            if (n < n2) {
                int i = n++;
                PhysicalFont physicalFont = ((CompositeFont)$this$getFilePath).getSlotFont(i);
                Intrinsics.checkNotNullExpressionValue((Object)physicalFont, (String)"physicalFont");
                return this.getFilePath(physicalFont);
            }
            return null;
        }
        if (font2D instanceof FileFont) {
            Object object = publicFileNameMethod.invoke((Object)$this$getFilePath, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return (String)object;
        }
        return null;
    }

    private final String getFilePath(Font $this$getFilePath) {
        String string = $this$getFilePath.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        return this.getFilePath(ProjectorFontProvider.INSTANCE.findFont2D(string, $this$getFilePath.getStyle(), 0));
    }

    static {
        Method method;
        INSTANCE = new FontCacher();
        filePathCacher = new ObjectIdCacher((short)0, filePathCacher.1.INSTANCE);
        Method $this$publicFileNameMethod_u24lambda_u2d0 = method = FileFont.class.getDeclaredMethod("getPublicFileName", new Class[0]);
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$publicFileNameMethod_u24lambda_u2d0, (String)"");
        ReflectKt.unprotect($this$publicFileNameMethod_u24lambda_u2d0);
        publicFileNameMethod = method;
        Method $this$getFont2DMethod_u24lambda_u2d1 = method = Font.class.getDeclaredMethod("getFont2D", new Class[0]);
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$getFont2DMethod_u24lambda_u2d1, (String)"");
        ReflectKt.unprotect($this$getFont2DMethod_u24lambda_u2d1);
        getFont2DMethod = method;
    }
}

