/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.FinalizationRequest;
import com.intellij.util.io.Page;
import com.intellij.util.io.PoolPageKey;
import com.intellij.util.io.RandomAccessDataFile;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PagePool {
    private final Map<PoolPageKey, Page> myProtectedQueue;
    private final Map<PoolPageKey, Page> myProbationalQueue;
    private int finalizationId = 0;
    private final SortedMap<PoolPageKey, FinalizationRequest> myFinalizationQueue = new TreeMap<PoolPageKey, FinalizationRequest>();
    private final Object lock = new Object();
    private PoolPageKey lastFinalizedKey = null;
    private static int hits = 0;
    private static int cache_misses = 0;
    private static int same_page_hits = 0;
    private static int protected_queue_hits = 0;
    private static int probational_queue_hits = 0;
    private static int finalization_queue_hits = 0;
    public static final PagePool SHARED = new PagePool(SystemProperties.getIntProperty("idea.io.protected.pool.size", 256), SystemProperties.getIntProperty("idea.io.probatonal.pool.size", 256));
    private RandomAccessDataFile lastOwner = null;
    private long lastOffset = 0L;
    private Page lastHit = null;

    public PagePool(final int protectedPagesLimit, final int probationalPagesLimit) {
        this.myProbationalQueue = new LinkedHashMap<PoolPageKey, Page>(probationalPagesLimit * 2, 1.0f, true){

            protected boolean removeEldestEntry(Map.Entry<PoolPageKey, Page> eldest) {
                if (this.size() > probationalPagesLimit) {
                    PagePool.this.scheduleFinalization(eldest.getValue());
                    return true;
                }
                return false;
            }
        };
        this.myProtectedQueue = new LinkedHashMap<PoolPageKey, Page>(protectedPagesLimit, 1.0f, true){

            protected boolean removeEldestEntry(Map.Entry<PoolPageKey, Page> eldest) {
                if (this.size() > protectedPagesLimit) {
                    PagePool.this.myProbationalQueue.put(eldest.getKey(), eldest.getValue());
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Page alloc(@NotNull RandomAccessDataFile owner, long offset) {
        if (owner == null) {
            PagePool.$$$reportNull$$$0(0);
        }
        Object object = this.lock;
        // MONITORENTER : object
        RandomAccessDataFile.ensureNonNegative(offset, "offset");
        offset -= offset % (long)Page.PAGE_SIZE;
        ++hits;
        if (owner == this.lastOwner && offset == this.lastOffset) {
            ++same_page_hits;
            Page page = this.lastHit;
            // MONITOREXIT : object
            if (page != null) return page;
            PagePool.$$$reportNull$$$0(1);
            return page;
        }
        this.lastOffset = offset;
        this.lastOwner = owner;
        this.lastHit = this.hitQueues(owner, offset);
        this.flushFinalizationQueue();
        Page page = this.lastHit;
        // MONITOREXIT : object
        if (page != null) return page;
        PagePool.$$$reportNull$$$0(2);
        return page;
    }

    private Page hitQueues(@NotNull RandomAccessDataFile owner, long offset) {
        PoolPageKey key;
        Page page;
        if (owner == null) {
            PagePool.$$$reportNull$$$0(3);
        }
        if ((page = this.myProtectedQueue.get(key = new PoolPageKey(owner, offset))) != null) {
            ++protected_queue_hits;
            return page;
        }
        page = this.myProbationalQueue.remove(key);
        if (page != null) {
            ++probational_queue_hits;
            this.toProtectedQueue(page);
            return page;
        }
        FinalizationRequest request = (FinalizationRequest)this.myFinalizationQueue.remove(key);
        if (request != null) {
            page = request.page;
            ++finalization_queue_hits;
            this.toProtectedQueue(page);
            return page;
        }
        ++cache_misses;
        page = new Page(new PoolPageKey(owner, offset));
        this.myProbationalQueue.put(page.getKey(), page);
        return page;
    }

    private static double percent(int part, int whole) {
        return (double)part * 1000.0 / (double)whole / 10.0;
    }

    public static void printStatistics() {
        System.out.println("Total requests: " + hits);
        System.out.println("Same page hits: " + same_page_hits + " (" + PagePool.percent(same_page_hits, hits) + "%)");
        System.out.println("Protected queue hits: " + protected_queue_hits + " (" + PagePool.percent(protected_queue_hits, hits) + "%)");
        System.out.println("Probatinonal queue hits: " + probational_queue_hits + " (" + PagePool.percent(probational_queue_hits, hits) + "%)");
        System.out.println("Finalization queue hits: " + finalization_queue_hits + " (" + PagePool.percent(finalization_queue_hits, hits) + "%)");
        System.out.println("Cache misses: " + cache_misses + " (" + PagePool.percent(cache_misses, hits) + "%)");
        System.out.println("Total reads: " + RandomAccessDataFile.totalReads + ". Bytes read: " + RandomAccessDataFile.totalReadBytes);
        System.out.println("Total writes: " + RandomAccessDataFile.totalWrites + ". Bytes written: " + RandomAccessDataFile.totalWriteBytes);
    }

    private void toProtectedQueue(Page page) {
        this.myProtectedQueue.put(page.getKey(), page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPages(RandomAccessDataFile owner) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastOwner == owner) {
                this.scheduleFinalization(this.lastHit);
                this.lastHit = null;
                this.lastOwner = null;
            }
            boolean hasFlushes = this.scanQueue(owner, this.myProtectedQueue);
        }
        if (hasFlushes |= this.scanQueue(owner, this.myProbationalQueue)) {
            this.flushFinalizationQueue();
        }
    }

    private void flushFinalizationQueue() {
        FinalizationRequest request;
        while ((request = this.retrieveFinalizationRequest()) != null) {
            this.processFinalizationRequest(request);
        }
        return;
    }

    private boolean scanQueue(RandomAccessDataFile owner, Map<?, Page> queue) {
        Iterator<Page> iterator = queue.values().iterator();
        boolean hasFlushes = false;
        while (iterator.hasNext()) {
            Page page = iterator.next();
            if (page.getOwner() != owner) continue;
            this.scheduleFinalization(page);
            iterator.remove();
            hasFlushes = true;
        }
        return hasFlushes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFinalization(Page page) {
        int curFinalizationId;
        Object object = this.lock;
        synchronized (object) {
            curFinalizationId = ++this.finalizationId;
        }
        FinalizationRequest request = page.prepareForFinalization(curFinalizationId);
        if (request == null) {
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.myFinalizationQueue.put(page.getKey(), request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinalizationRequest(FinalizationRequest request) {
        Page page = request.page;
        try {
            page.flushIfFinalizationIdIsEqualTo(request.finalizationId);
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.myFinalizationQueue.remove(page.getKey());
            }
            page.recycleIfFinalizationIdIsEqualTo(request.finalizationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FinalizationRequest retrieveFinalizationRequest() {
        FinalizationRequest request = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.myFinalizationQueue.isEmpty()) {
                PoolPageKey key;
                if (this.lastFinalizedKey == null) {
                    key = this.myFinalizationQueue.firstKey();
                } else {
                    PoolPageKey k = this.lastFinalizedKey;
                    PoolPageKey kk = new PoolPageKey((RandomAccessDataFile)k.getOwner(), ((RandomAccessDataFile)k.getOwner()).physicalLength());
                    SortedMap<PoolPageKey, FinalizationRequest> tail = this.myFinalizationQueue.tailMap(kk);
                    if (tail.isEmpty()) {
                        tail = this.myFinalizationQueue.tailMap(k);
                    }
                    key = tail.isEmpty() ? this.myFinalizationQueue.firstKey() : tail.firstKey();
                }
                this.lastFinalizedKey = key;
                request = (FinalizationRequest)this.myFinalizationQueue.get(key);
            } else {
                this.lastFinalizedKey = null;
            }
        }
        return request;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PagePool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PagePool";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "alloc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "alloc";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hitQueues";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

