/*
 * Decompiled with CFR 0.152.
 */
package training.actions;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.actions.IftDumpMode;
import training.actions.TextCollector;
import training.dsl.LessonContext;
import training.dsl.TaskContext;
import training.dsl.impl.LessonExecutorUtil;
import training.dsl.impl.TaskProperties;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\f\u001a\u00020\r2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0002\b\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltraining/actions/ApplyTaskLessonContext;", "Ltraining/dsl/LessonContext;", "buffer", "Ljava/lang/StringBuffer;", "project", "Lcom/intellij/openapi/project/Project;", "mode", "Ltraining/actions/IftDumpMode;", "(Ljava/lang/StringBuffer;Lcom/intellij/openapi/project/Project;Ltraining/actions/IftDumpMode;)V", "internalTaskNumber", "", "taskVisualIndex", "task", "", "taskContent", "Lkotlin/Function1;", "Ltraining/dsl/TaskContext;", "Lkotlin/ExtensionFunctionType;", "intellij.featuresTrainer"})
final class ApplyTaskLessonContext
extends LessonContext {
    private int internalTaskNumber;
    private int taskVisualIndex;
    private final StringBuffer buffer;
    private final Project project;
    private final IftDumpMode mode;

    @Override
    public void task(@NotNull Function1<? super TaskContext, Unit> taskContent) {
        int n;
        TaskProperties taskProperties;
        Intrinsics.checkNotNullParameter(taskContent, (String)"taskContent");
        this.buffer.append("(" + this.internalTaskNumber + " -> " + this.taskVisualIndex + ") ");
        if (this.mode == IftDumpMode.TEXT_ONLY) {
            TaskContext taskContext = new TextCollector(this.buffer, this.project);
            taskContent.invoke((Object)taskContext);
        }
        if (this.mode == IftDumpMode.CODE_POSITIONS) {
            this.buffer.append(LessonExecutorUtil.INSTANCE.getTaskCallInfo());
            this.buffer.append('\n');
        }
        if ((taskProperties = LessonExecutorUtil.INSTANCE.taskProperties(taskContent, this.project)).getHasDetection() && taskProperties.getMessagesNumber() > 0) {
            n = this.taskVisualIndex;
            this.taskVisualIndex = n + 1;
        }
        n = this.internalTaskNumber;
        this.internalTaskNumber = n + 1;
    }

    public ApplyTaskLessonContext(@NotNull StringBuffer buffer, @NotNull Project project, @NotNull IftDumpMode mode) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.buffer = buffer;
        this.project = project;
        this.mode = mode;
        this.taskVisualIndex = 1;
    }
}

