/*
 * Decompiled with CFR 0.152.
 */
package training.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.FeaturesTrainerIcons;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.ui.LearnToolWindow;
import training.ui.LearningUiManager;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Ltraining/actions/RestartLessonAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.featuresTrainer"})
final class RestartLessonAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
        if (learnToolWindow == null) {
            return;
        }
        LearnToolWindow activeToolWindow = learnToolWindow;
        Lesson lesson = LessonManager.Companion.getInstance().getCurrentLesson();
        if (lesson == null) {
            return;
        }
        Lesson lesson2 = lesson;
        StatisticBase.Companion.logLessonStopped(StatisticBase.LessonStopReason.RESTART);
        LessonManager.Companion.getInstance().stopLesson();
        LangSupport langSupport2 = lesson2.getModule().getPrimaryLanguage();
        if (langSupport2 != null) {
            LangSupport langSupport3;
            LangSupport it = langSupport3 = langSupport2;
            boolean bl = false;
            it.setOnboardingFeedbackData(null);
        }
        CourseManager.openLesson$default(CourseManager.Companion.getInstance(), activeToolWindow.getProject(), lesson2, LessonStartingWay.RESTART_BUTTON, false, 8, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LearnToolWindow activeToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(activeToolWindow != null && Intrinsics.areEqual((Object)activeToolWindow.getProject(), (Object)e.getProject()));
    }

    public RestartLessonAction() {
        super(FeaturesTrainerIcons.Img.ResetLesson);
    }
}

