/*
 * Decompiled with CFR 0.152.
 */
package training.statistic;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FusInputEvent;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.TimeoutUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.impl.LessonExecutor;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.course.IftModule;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.statistic.FeedbackEntryPlace;
import training.statistic.FeedbackLikenessAnswer;
import training.statistic.LearnProjectState;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.statistic.StatisticBase$$special$;
import training.util.KeymapUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00052\u00020\u0001:\u0004\u0005\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Ltraining/statistic/StatisticBase;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "LearnProjectOpeningWay", "LessonProgress", "LessonStopReason", "intellij.featuresTrainer"})
public final class StatisticBase
extends CounterUsagesCollector {
    private static final Logger LOG;
    private static final ConcurrentHashMap<String, Long> sessionLessonTimestamp;
    private static LessonProgress prevRestoreLessonProgress;
    private static final EventLogGroup GROUP;
    private static boolean isLearnProjectCloseLogged;
    private static final StringEventField lessonIdField;
    private static final StringEventField languageField;
    private static final IntEventField completedCountField;
    private static final IntEventField courseSizeField;
    private static final StringEventField moduleNameField;
    private static final StringEventField taskIdField;
    private static final StringEventField actionIdField;
    private static final StringEventField keymapSchemeField;
    private static final PrimitiveEventField<String> versionField;
    private static final PrimitiveEventField<FusInputEvent> inputEventField;
    private static final EnumEventField<LearnProjectOpeningWay> learnProjectOpeningWayField;
    private static final EnumEventField<LessonStopReason> reasonField;
    private static final IntEventField newLessonsCount;
    private static final BooleanEventField showNewLessonsState;
    private static final StringEventField tipFilenameField;
    private static final EnumEventField<LessonStartingWay> lessonStartingWayField;
    private static final EnumEventField<FeedbackEntryPlace> feedbackEntryPlace;
    private static final BooleanEventField feedbackHasBeenSent;
    private static final BooleanEventField feedbackOpenedViaNotification;
    private static final EnumEventField<FeedbackLikenessAnswer> feedbackLikenessAnswer;
    private static final BooleanEventField feedbackExperiencedUser;
    private static final Companion.lastBuildLearningOpened.1 lastBuildLearningOpened;
    private static final EventId3<String, String, LessonStartingWay> lessonStartedEvent;
    private static final EventId3<String, String, Long> lessonPassedEvent;
    private static final VarargEventId lessonStoppedEvent;
    private static final VarargEventId progressUpdatedEvent;
    private static final EventId2<String, String> moduleStartedEvent;
    private static final EventId1<String> welcomeScreenPanelExpandedEvent;
    private static final VarargEventId shortcutClickedEvent;
    private static final VarargEventId restorePerformedEvent;
    private static final EventId2<LearnProjectOpeningWay, String> learnProjectOpenedFirstTimeEvent;
    private static final EventId1<LearnProjectOpeningWay> nonLearningProjectOpened;
    private static final EventId2<Integer, String> newLessonsNotificationShown;
    private static final EventId2<Integer, String> showNewLessonsEvent;
    private static final EventId3<Integer, String, Boolean> needShowNewLessonsNotifications;
    private static final EventId3<String, String, String> lessonLinkClickedFromTip;
    private static final EventId2<String, String> helpLinkClicked;
    private static final EventId1<FeedbackEntryPlace> onboardingFeedbackNotificationShown;
    private static final VarargEventId onboardingFeedbackDialogResult;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger22 = false;
        Logger logger = Logger.getInstance(StatisticBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        sessionLessonTimestamp = new ConcurrentHashMap();
        prevRestoreLessonProgress = new LessonProgress("", 0);
        GROUP = new EventLogGroup("ideFeaturesTrainer", 16);
        lessonIdField = EventFields.StringValidatedByCustomRule((String)"lesson_id", (String)"lesson_id");
        languageField = EventFields.StringValidatedByCustomRule((String)"language", (String)"language");
        completedCountField = EventFields.Int((String)"completed_count");
        courseSizeField = EventFields.Int((String)"course_size");
        moduleNameField = EventFields.StringValidatedByCustomRule((String)"module_name", (String)"module_name");
        taskIdField = EventFields.StringValidatedByCustomRule((String)"task_id", (String)"task_id");
        actionIdField = EventFields.StringValidatedByCustomRule((String)"action_id", (String)"action_id");
        keymapSchemeField = EventFields.StringValidatedByCustomRule((String)"keymap_scheme", (String)"keymap_scheme");
        versionField = EventFields.Version;
        inputEventField = EventFields.InputEvent;
        EventFields $i$f$logger22 = EventFields.INSTANCE;
        String name$iv = "learn_opening_way";
        Function1 transform$iv = $special$$inlined$Enum$1.INSTANCE;
        boolean $i$f$Enum = false;
        learnProjectOpeningWayField = new EnumEventField(name$iv, LearnProjectOpeningWay.class, transform$iv);
        EventFields this_$iv = EventFields.INSTANCE;
        name$iv = "reason";
        transform$iv = $special$$inlined$Enum$2.INSTANCE;
        $i$f$Enum = false;
        reasonField = new EnumEventField(name$iv, LessonStopReason.class, transform$iv);
        newLessonsCount = EventFields.Int((String)"new_lessons_count");
        showNewLessonsState = EventFields.Boolean((String)"show_it");
        tipFilenameField = EventFields.StringValidatedByCustomRule((String)"filename", (String)"tip_info");
        this_$iv = EventFields.INSTANCE;
        name$iv = "starting_way";
        transform$iv = $special$$inlined$Enum$3.INSTANCE;
        $i$f$Enum = false;
        lessonStartingWayField = new EnumEventField(name$iv, LessonStartingWay.class, transform$iv);
        this_$iv = EventFields.INSTANCE;
        name$iv = "feedback_entry_place";
        transform$iv = $special$$inlined$Enum$4.INSTANCE;
        $i$f$Enum = false;
        feedbackEntryPlace = new EnumEventField(name$iv, FeedbackEntryPlace.class, transform$iv);
        feedbackHasBeenSent = EventFields.Boolean((String)"feedback_has_been_sent");
        feedbackOpenedViaNotification = EventFields.Boolean((String)"feedback_opened_via_notification");
        this_$iv = EventFields.INSTANCE;
        name$iv = "feedback_likeness_answer";
        transform$iv = $special$$inlined$Enum$5.INSTANCE;
        $i$f$Enum = false;
        feedbackLikenessAnswer = new EnumEventField(name$iv, FeedbackLikenessAnswer.class, transform$iv);
        feedbackExperiencedUser = EventFields.Boolean((String)"feedback_experienced_user");
        lastBuildLearningOpened = new PrimitiveEventField<String>(){
            @NotNull
            private final String name;

            @NotNull
            public String getName() {
                return this.name;
            }

            @NotNull
            public List<String> getValidationRule() {
                return CollectionsKt.listOf((Object)"{regexp#version}");
            }

            public void addData(@NotNull FeatureUsageData fuData, @Nullable String value) {
                Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
                if (value != null) {
                    fuData.addData(this.getName(), value);
                }
            }
            {
                this.name = "last_build_learning_opened";
            }
        };
        lessonStartedEvent = GROUP.registerEvent("start", (EventField)lessonIdField, (EventField)languageField, (EventField)lessonStartingWayField);
        lessonPassedEvent = GROUP.registerEvent("passed", (EventField)lessonIdField, (EventField)languageField, (EventField)EventFields.Long((String)"duration"));
        lessonStoppedEvent = GROUP.registerVarargEvent("stopped", new EventField[]{(EventField)lessonIdField, (EventField)taskIdField, (EventField)languageField, (EventField)reasonField});
        progressUpdatedEvent = GROUP.registerVarargEvent("progress", new EventField[]{(EventField)lessonIdField, (EventField)completedCountField, (EventField)courseSizeField, (EventField)languageField});
        moduleStartedEvent = GROUP.registerEvent("start_module_action", (EventField)moduleNameField, (EventField)languageField);
        welcomeScreenPanelExpandedEvent = GROUP.registerEvent("expand_welcome_screen", (EventField)languageField);
        shortcutClickedEvent = GROUP.registerVarargEvent("shortcut_clicked", new EventField[]{(EventField)inputEventField, (EventField)keymapSchemeField, (EventField)lessonIdField, (EventField)taskIdField, (EventField)actionIdField, (EventField)versionField});
        restorePerformedEvent = GROUP.registerVarargEvent("restore", new EventField[]{(EventField)lessonIdField, (EventField)taskIdField, (EventField)versionField});
        learnProjectOpenedFirstTimeEvent = GROUP.registerEvent("learn_project_opened_first_time", (EventField)learnProjectOpeningWayField, (EventField)languageField);
        nonLearningProjectOpened = GROUP.registerEvent("non_learning_project_opened", (EventField)learnProjectOpeningWayField);
        newLessonsNotificationShown = GROUP.registerEvent("new_lessons_notification_shown", (EventField)newLessonsCount, (EventField)lastBuildLearningOpened);
        showNewLessonsEvent = GROUP.registerEvent("show_new_lessons", (EventField)newLessonsCount, (EventField)lastBuildLearningOpened);
        needShowNewLessonsNotifications = GROUP.registerEvent("need_show_new_lessons_notifications", (EventField)newLessonsCount, (EventField)lastBuildLearningOpened, (EventField)showNewLessonsState);
        lessonLinkClickedFromTip = GROUP.registerEvent("lesson_link_clicked_from_tip", (EventField)lessonIdField, (EventField)languageField, (EventField)tipFilenameField);
        helpLinkClicked = GROUP.registerEvent("help_link_clicked", (EventField)lessonIdField, (EventField)languageField);
        onboardingFeedbackNotificationShown = GROUP.registerEvent("onboarding_feedback_notification_shown", (EventField)feedbackEntryPlace);
        onboardingFeedbackDialogResult = GROUP.registerVarargEvent("onboarding_feedback_dialog_result", new EventField[]{(EventField)feedbackEntryPlace, (EventField)feedbackHasBeenSent, (EventField)feedbackOpenedViaNotification, (EventField)feedbackLikenessAnswer, (EventField)feedbackExperiencedUser});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ltraining/statistic/StatisticBase$LessonProgress;", "", "lessonId", "", "taskId", "", "(Ljava/lang/String;I)V", "getLessonId", "()Ljava/lang/String;", "getTaskId", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.featuresTrainer"})
    private static final class LessonProgress {
        @NotNull
        private final String lessonId;
        private final int taskId;

        @NotNull
        public final String getLessonId() {
            return this.lessonId;
        }

        public final int getTaskId() {
            return this.taskId;
        }

        public LessonProgress(@NotNull String lessonId, int taskId) {
            Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
            this.lessonId = lessonId;
            this.taskId = taskId;
        }

        @NotNull
        public final String component1() {
            return this.lessonId;
        }

        public final int component2() {
            return this.taskId;
        }

        @NotNull
        public final LessonProgress copy(@NotNull String lessonId, int taskId) {
            Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
            return new LessonProgress(lessonId, taskId);
        }

        public static /* synthetic */ LessonProgress copy$default(LessonProgress lessonProgress, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = lessonProgress.lessonId;
            }
            if ((n2 & 2) != 0) {
                n = lessonProgress.taskId;
            }
            return lessonProgress.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "LessonProgress(lessonId=" + this.lessonId + ", taskId=" + this.taskId + ")";
        }

        public int hashCode() {
            String string = this.lessonId;
            return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.taskId);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LessonProgress)) break block3;
                    LessonProgress lessonProgress = (LessonProgress)object;
                    if (!Intrinsics.areEqual((Object)this.lessonId, (Object)lessonProgress.lessonId) || this.taskId != lessonProgress.taskId) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ltraining/statistic/StatisticBase$LearnProjectOpeningWay;", "", "(Ljava/lang/String;I)V", "LEARN_IDE", "ONBOARDING_PROMOTER", "intellij.featuresTrainer"})
    public static final class LearnProjectOpeningWay
    extends Enum<LearnProjectOpeningWay> {
        public static final /* enum */ LearnProjectOpeningWay LEARN_IDE;
        public static final /* enum */ LearnProjectOpeningWay ONBOARDING_PROMOTER;
        private static final /* synthetic */ LearnProjectOpeningWay[] $VALUES;

        static {
            LearnProjectOpeningWay[] learnProjectOpeningWayArray = new LearnProjectOpeningWay[2];
            LearnProjectOpeningWay[] learnProjectOpeningWayArray2 = learnProjectOpeningWayArray;
            learnProjectOpeningWayArray[0] = LEARN_IDE = new LearnProjectOpeningWay();
            learnProjectOpeningWayArray[1] = ONBOARDING_PROMOTER = new LearnProjectOpeningWay();
            $VALUES = learnProjectOpeningWayArray;
        }

        public static LearnProjectOpeningWay[] values() {
            return (LearnProjectOpeningWay[])$VALUES.clone();
        }

        public static LearnProjectOpeningWay valueOf(String string) {
            return Enum.valueOf(LearnProjectOpeningWay.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ltraining/statistic/StatisticBase$LessonStopReason;", "", "(Ljava/lang/String;I)V", "CLOSE_PROJECT", "RESTART", "CLOSE_FILE", "OPEN_MODULES", "OPEN_NEXT_OR_PREV_LESSON", "EXIT_LINK", "intellij.featuresTrainer"})
    public static final class LessonStopReason
    extends Enum<LessonStopReason> {
        public static final /* enum */ LessonStopReason CLOSE_PROJECT;
        public static final /* enum */ LessonStopReason RESTART;
        public static final /* enum */ LessonStopReason CLOSE_FILE;
        public static final /* enum */ LessonStopReason OPEN_MODULES;
        public static final /* enum */ LessonStopReason OPEN_NEXT_OR_PREV_LESSON;
        public static final /* enum */ LessonStopReason EXIT_LINK;
        private static final /* synthetic */ LessonStopReason[] $VALUES;

        static {
            LessonStopReason[] lessonStopReasonArray = new LessonStopReason[6];
            LessonStopReason[] lessonStopReasonArray2 = lessonStopReasonArray;
            lessonStopReasonArray[0] = CLOSE_PROJECT = new LessonStopReason();
            lessonStopReasonArray[1] = RESTART = new LessonStopReason();
            lessonStopReasonArray[2] = CLOSE_FILE = new LessonStopReason();
            lessonStopReasonArray[3] = OPEN_MODULES = new LessonStopReason();
            lessonStopReasonArray[4] = OPEN_NEXT_OR_PREV_LESSON = new LessonStopReason();
            lessonStopReasonArray[5] = EXIT_LINK = new LessonStopReason();
            $VALUES = lessonStopReasonArray;
        }

        public static LessonStopReason[] values() {
            return (LessonStopReason[])$VALUES.clone();
        }

        public static LessonStopReason valueOf(String string) {
            return Enum.valueOf(LessonStopReason.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00d9\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010*\u0001$\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010L\u001a\u000206H\u0002J\b\u0010M\u001a\u00020\u0018H\u0002J\u0012\u0010N\u001a\u0004\u0018\u00010\u001b2\u0006\u0010O\u001a\u00020\u0018H\u0002J\n\u0010P\u001a\u0004\u0018\u00010QH\u0002J\u0012\u0010R\u001a\u0004\u0018\u00010\u00182\u0006\u0010S\u001a\u00020TH\u0002J\u000e\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020\u0018J\u000e\u0010X\u001a\u00020V2\u0006\u0010Y\u001a\u00020'J\u0016\u0010Z\u001a\u00020V2\u0006\u0010W\u001a\u00020\u00182\u0006\u0010[\u001a\u00020\u0018J\u000e\u0010\\\u001a\u00020V2\u0006\u0010S\u001a\u00020TJ\u0016\u0010]\u001a\u00020V2\u0006\u0010S\u001a\u00020T2\u0006\u0010^\u001a\u00020/J\u000e\u0010_\u001a\u00020V2\u0006\u0010`\u001a\u00020AJ\u000e\u0010a\u001a\u00020V2\u0006\u0010b\u001a\u00020cJ\u0018\u0010d\u001a\u00020V2\u0006\u00107\u001a\u0002062\b\u0010e\u001a\u0004\u0018\u00010fJ\u000e\u0010g\u001a\u00020V2\u0006\u0010Y\u001a\u00020'J.\u0010h\u001a\u00020V2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010j\u001a\u00020\u001d2\u0006\u0010k\u001a\u00020\u001d2\u0006\u0010l\u001a\u00020\u00142\u0006\u0010m\u001a\u00020\u001dJ\u000e\u0010n\u001a\u00020V2\u0006\u0010i\u001a\u00020\u000fJ\u0016\u0010o\u001a\u00020V2\u0006\u0010S\u001a\u00020T2\u0006\u0010p\u001a\u000206J\u000e\u0010q\u001a\u00020V2\u0006\u0010O\u001a\u00020\u0018J\u0018\u0010r\u001a\u00020V2\u0006\u00107\u001a\u0002062\b\u0010e\u001a\u0004\u0018\u00010fJ \u0010s\u001a\u00020V2\u0006\u00107\u001a\u0002062\b\u0010e\u001a\u0004\u0018\u00010f2\u0006\u0010t\u001a\u00020\u001dJ\u0006\u0010u\u001a\u00020VR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u001c\u0010&\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010*\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00180+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010,\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020-0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010.\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020/0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020/0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00105\u001a\u0016\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u001d0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00108\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020'0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020-0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010F\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010K\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Ltraining/statistic/StatisticBase$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "actionIdField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "completedCountField", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "courseSizeField", "feedbackEntryPlace", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Ltraining/statistic/FeedbackEntryPlace;", "feedbackExperiencedUser", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "feedbackHasBeenSent", "feedbackLikenessAnswer", "Ltraining/statistic/FeedbackLikenessAnswer;", "feedbackOpenedViaNotification", "helpLinkClicked", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "inputEventField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/eventLog/events/FusInputEvent;", "isLearnProjectCloseLogged", "", "()Z", "setLearnProjectCloseLogged", "(Z)V", "keymapSchemeField", "languageField", "lastBuildLearningOpened", "training/statistic/StatisticBase$Companion$lastBuildLearningOpened$1", "Ltraining/statistic/StatisticBase$Companion$lastBuildLearningOpened$1;", "learnProjectOpenedFirstTimeEvent", "Ltraining/statistic/StatisticBase$LearnProjectOpeningWay;", "learnProjectOpeningWayField", "lessonIdField", "lessonLinkClickedFromTip", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "lessonPassedEvent", "", "lessonStartedEvent", "Ltraining/statistic/LessonStartingWay;", "lessonStartingWayField", "lessonStoppedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "moduleNameField", "moduleStartedEvent", "needShowNewLessonsNotifications", "", "newLessonsCount", "newLessonsNotificationShown", "nonLearningProjectOpened", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "onboardingFeedbackDialogResult", "onboardingFeedbackNotificationShown", "prevRestoreLessonProgress", "Ltraining/statistic/StatisticBase$LessonProgress;", "progressUpdatedEvent", "reasonField", "Ltraining/statistic/StatisticBase$LessonStopReason;", "restorePerformedEvent", "sessionLessonTimestamp", "Ljava/util/concurrent/ConcurrentHashMap;", "shortcutClickedEvent", "showNewLessonsEvent", "showNewLessonsState", "taskIdField", "tipFilenameField", "versionField", "welcomeScreenPanelExpandedEvent", "completedCount", "courseLanguage", "createInputEvent", "actionId", "getDefaultKeymap", "Lcom/intellij/openapi/keymap/Keymap;", "getPluginVersion", "lesson", "Ltraining/learn/course/Lesson;", "logHelpLinkClicked", "", "lessonId", "logLearnProjectOpenedForTheFirstTime", "way", "logLessonLinkClickedFromTip", "tipFilename", "logLessonPassed", "logLessonStarted", "startingWay", "logLessonStopped", "reason", "logModuleStarted", "module", "Ltraining/learn/course/IftModule;", "logNewLessonsNotification", "previousOpenedVersion", "Lcom/intellij/openapi/util/BuildNumber;", "logNonLearningProjectOpened", "logOnboardingFeedbackDialogResult", "place", "hasBeenSent", "openedViaNotification", "likenessAnswer", "experiencedUser", "logOnboardingFeedbackNotification", "logRestorePerformed", "taskId", "logShortcutClicked", "logShowNewLessonsEvent", "logShowNewLessonsNotificationState", "showNewLessons", "logWelcomeScreenPanelExpanded", "intellij.featuresTrainer"})
    public static final class Companion {
        public final boolean isLearnProjectCloseLogged() {
            return isLearnProjectCloseLogged;
        }

        public final void setLearnProjectCloseLogged(boolean bl) {
            isLearnProjectCloseLogged = bl;
        }

        public final void logLessonStarted(@NotNull Lesson lesson, @NotNull LessonStartingWay startingWay) {
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            Intrinsics.checkNotNullParameter((Object)((Object)startingWay), (String)"startingWay");
            ((Map)sessionLessonTimestamp).put(lesson.getId(), System.nanoTime());
            lessonStartedEvent.log((Object)lesson.getId(), (Object)this.courseLanguage(), (Object)startingWay);
        }

        public final void logLessonPassed(@NotNull Lesson lesson) {
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            Long timestamp = (Long)sessionLessonTimestamp.get(lesson.getId());
            if (timestamp == null) {
                LOG.warn("Unable to find timestamp for a lesson: " + lesson.getName());
                return;
            }
            long delta = TimeoutUtil.getDurationMillis((long)timestamp);
            lessonPassedEvent.log((Object)lesson.getId(), (Object)this.courseLanguage(), (Object)delta);
            progressUpdatedEvent.log(new EventPair[]{lessonIdField.with((Object)lesson.getId()), completedCountField.with((Object)this.completedCount()), courseSizeField.with((Object)CourseManager.Companion.getInstance().getLessonsForModules().size()), languageField.with((Object)this.courseLanguage())});
        }

        public final void logLessonStopped(@NotNull LessonStopReason reason) {
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            LessonManager lessonManager = LessonManager.Companion.getInstance();
            if (lessonManager.lessonIsRunning()) {
                Lesson lesson = lessonManager.getCurrentLesson();
                Intrinsics.checkNotNull((Object)lesson);
                String lessonId = lesson.getId();
                LessonExecutor lessonExecutor = lessonManager.getCurrentLessonExecutor$intellij_featuresTrainer();
                Intrinsics.checkNotNull((Object)lessonExecutor);
                int taskId = lessonExecutor.getCurrentTaskIndex$intellij_featuresTrainer();
                lessonStoppedEvent.log(new EventPair[]{lessonIdField.with((Object)lessonId), taskIdField.with((Object)String.valueOf(taskId)), languageField.with((Object)this.courseLanguage()), reasonField.with((Object)reason)});
                if (reason == LessonStopReason.CLOSE_PROJECT || reason == LessonStopReason.EXIT_LINK) {
                    this.setLearnProjectCloseLogged(true);
                }
            }
        }

        public final void logModuleStarted(@NotNull IftModule module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            moduleStartedEvent.log((Object)module.getId(), (Object)this.courseLanguage());
        }

        public final void logWelcomeScreenPanelExpanded() {
            welcomeScreenPanelExpandedEvent.log((Object)this.courseLanguage());
        }

        public final void logShortcutClicked(@NotNull String actionId) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            LessonManager lessonManager = LessonManager.Companion.getInstance();
            if (lessonManager.lessonIsRunning()) {
                Lesson lesson = lessonManager.getCurrentLesson();
                Intrinsics.checkNotNull((Object)lesson);
                Lesson lesson2 = lesson;
                Keymap keymap = this.getDefaultKeymap();
                if (keymap == null) {
                    return;
                }
                Keymap keymap2 = keymap;
                EventPair[] eventPairArray = new EventPair[6];
                eventPairArray[0] = inputEventField.with((Object)this.createInputEvent(actionId));
                eventPairArray[1] = keymapSchemeField.with((Object)keymap2.getName());
                eventPairArray[2] = lessonIdField.with((Object)lesson2.getId());
                LessonExecutor lessonExecutor = lessonManager.getCurrentLessonExecutor$intellij_featuresTrainer();
                eventPairArray[3] = taskIdField.with((Object)String.valueOf(lessonExecutor != null ? Integer.valueOf(lessonExecutor.getCurrentTaskIndex$intellij_featuresTrainer()) : null));
                eventPairArray[4] = actionIdField.with((Object)actionId);
                eventPairArray[5] = versionField.with((Object)this.getPluginVersion(lesson2));
                shortcutClickedEvent.log(eventPairArray);
            }
        }

        public final void logRestorePerformed(@NotNull Lesson lesson, int taskId) {
            Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
            LessonProgress curLessonProgress = new LessonProgress(lesson.getId(), taskId);
            if (Intrinsics.areEqual((Object)curLessonProgress, (Object)prevRestoreLessonProgress) ^ true) {
                prevRestoreLessonProgress = curLessonProgress;
                restorePerformedEvent.log(new EventPair[]{lessonIdField.with((Object)lesson.getId()), taskIdField.with((Object)String.valueOf(taskId)), versionField.with((Object)this.getPluginVersion(lesson))});
            }
        }

        public final void logLearnProjectOpenedForTheFirstTime(@NotNull LearnProjectOpeningWay way) {
            Intrinsics.checkNotNullParameter((Object)((Object)way), (String)"way");
            LangManager langManager = LangManager.Companion.getInstance();
            LangSupport langSupport2 = langManager.getLangSupport();
            if (langSupport2 == null) {
                return;
            }
            LangSupport langSupport3 = langSupport2;
            if (langManager.getLearningProjectPath(langSupport3) == null) {
                LearnProjectState.Companion.getInstance$intellij_featuresTrainer().setFirstTimeOpenedWay(way);
                learnProjectOpenedFirstTimeEvent.log((Object)way, (Object)this.courseLanguage());
            }
        }

        public final void logNonLearningProjectOpened(@NotNull LearnProjectOpeningWay way) {
            Intrinsics.checkNotNullParameter((Object)((Object)way), (String)"way");
            nonLearningProjectOpened.log((Object)way);
        }

        public final void logNewLessonsNotification(int newLessonsCount, @Nullable BuildNumber previousOpenedVersion) {
            BuildNumber buildNumber = previousOpenedVersion;
            newLessonsNotificationShown.log((Object)newLessonsCount, (Object)(buildNumber != null ? buildNumber.asString() : null));
        }

        public final void logShowNewLessonsEvent(int newLessonsCount, @Nullable BuildNumber previousOpenedVersion) {
            BuildNumber buildNumber = previousOpenedVersion;
            showNewLessonsEvent.log((Object)newLessonsCount, (Object)(buildNumber != null ? buildNumber.asString() : null));
        }

        public final void logShowNewLessonsNotificationState(int newLessonsCount, @Nullable BuildNumber previousOpenedVersion, boolean showNewLessons) {
            BuildNumber buildNumber = previousOpenedVersion;
            needShowNewLessonsNotifications.log((Object)newLessonsCount, (Object)(buildNumber != null ? buildNumber.asString() : null), (Object)showNewLessons);
        }

        public final void logLessonLinkClickedFromTip(@NotNull String lessonId, @NotNull String tipFilename) {
            Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
            Intrinsics.checkNotNullParameter((Object)tipFilename, (String)"tipFilename");
            lessonLinkClickedFromTip.log((Object)lessonId, (Object)this.courseLanguage(), (Object)tipFilename);
        }

        public final void logHelpLinkClicked(@NotNull String lessonId) {
            Intrinsics.checkNotNullParameter((Object)lessonId, (String)"lessonId");
            helpLinkClicked.log((Object)lessonId, (Object)this.courseLanguage());
        }

        public final void logOnboardingFeedbackNotification(@NotNull FeedbackEntryPlace place) {
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            onboardingFeedbackNotificationShown.log((Object)place);
        }

        public final void logOnboardingFeedbackDialogResult(@NotNull FeedbackEntryPlace place, boolean hasBeenSent, boolean openedViaNotification, @NotNull FeedbackLikenessAnswer likenessAnswer, boolean experiencedUser) {
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            Intrinsics.checkNotNullParameter((Object)((Object)likenessAnswer), (String)"likenessAnswer");
            onboardingFeedbackDialogResult.log(new EventPair[]{feedbackEntryPlace.with((Object)place), feedbackHasBeenSent.with((Object)hasBeenSent), feedbackOpenedViaNotification.with((Object)openedViaNotification), feedbackLikenessAnswer.with((Object)likenessAnswer), feedbackExperiencedUser.with((Object)experiencedUser)});
        }

        private final String courseLanguage() {
            String string;
            Object object = LangManager.Companion.getInstance().getLangSupport();
            if (object != null && (object = object.getPrimaryLanguage()) != null) {
                Object object2 = object;
                String string2 = ((String)object2).toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
                string = string2;
            } else {
                string = "";
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final int completedCount() {
            int n;
            Iterable $this$count$iv = CourseManager.Companion.getInstance().getLessonsForModules();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    int n2;
                    Lesson it = (Lesson)element$iv;
                    boolean bl = false;
                    if (!it.getPassed$intellij_featuresTrainer() || (n2 = ++count$iv) >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var3_3;
            }
            return n;
        }

        private final FusInputEvent createInputEvent(String actionId) {
            KeyStroke keyStroke = KeymapUtil.INSTANCE.getShortcutByActionId(actionId);
            if (keyStroke == null) {
                return null;
            }
            KeyStroke keyStroke2 = keyStroke;
            KeyEvent inputEvent = new KeyEvent(JOptionPane.getRootFrame(), 401, System.currentTimeMillis(), keyStroke2.getModifiers(), keyStroke2.getKeyCode(), keyStroke2.getKeyChar(), 1);
            return new FusInputEvent((InputEvent)inputEvent, "");
        }

        private final String getPluginVersion(Lesson lesson) {
            PluginDescriptor pluginDescriptor = PluginManager.getPluginByClass(lesson.getClass());
            return pluginDescriptor != null ? pluginDescriptor.getVersion() : null;
        }

        private final Keymap getDefaultKeymap() {
            KeymapManager keymapManager = KeymapManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
            Keymap keymap = keymapManager.getActiveKeymap();
            Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"KeymapManager.getInstance().activeKeymap");
            Keymap keymap2 = keymap;
            if (keymap2 instanceof DefaultKeymapImpl) {
                return keymap2;
            }
            Keymap keymap3 = keymap2.getParent();
            if (!(keymap3 instanceof DefaultKeymapImpl)) {
                keymap3 = null;
            }
            return (Keymap)((DefaultKeymapImpl)keymap3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

