/*
 * Decompiled with CFR 0.152.
 */
package training.util;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.MacKeymapUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\b\b\u0001\u0010\n\u001a\u00020\u000bJ$\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d*\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001eR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u001f"}, d2={"Ltraining/util/KeymapUtil;", "", "()V", "isNumpadKey", "", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "(Lcom/intellij/openapi/actionSystem/KeyboardShortcut;)Z", "findCustomShortcut", "activeKeymap", "Lcom/intellij/openapi/keymap/Keymap;", "actionId", "", "getGotoActionData", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "getKeyStrokeData", "keyStroke", "Ljavax/swing/KeyStroke;", "getModifiersText", "modifiers", "", "getShortcutByActionId", "getStringForMacSymbol", "c", "", "specificKeyString", "code", "getModifiers", "", "(Ljava/lang/String;)[Ljava/lang/String;", "intellij.featuresTrainer"})
public final class KeymapUtil {
    @NotNull
    public static final KeymapUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KeyStroke getShortcutByActionId(@Nullable String actionId) {
        KeyboardShortcut bestShortcut;
        KeyboardShortcut keyboardShortcut;
        Object v3;
        List kbShortcuts;
        block5: {
            Iterable iterable;
            List list2;
            void $this$filterIsInstanceTo$iv$iv;
            if (actionId == null) {
                return null;
            }
            KeymapManager keymapManager = KeymapManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
            Keymap keymap = keymapManager.getActiveKeymap();
            Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"KeymapManager.getInstance().activeKeymap");
            Keymap activeKeymap = keymap;
            KeyboardShortcut keyboardShortcut2 = this.findCustomShortcut(activeKeymap, actionId);
            if (keyboardShortcut2 != null) {
                KeyboardShortcut keyboardShortcut3;
                KeyboardShortcut it = keyboardShortcut3 = keyboardShortcut2;
                boolean bl = false;
                return it.getFirstKeyStroke();
            }
            Shortcut[] shortcuts = activeKeymap.getShortcuts(actionId);
            Intrinsics.checkNotNullExpressionValue((Object)shortcuts, (String)"shortcuts");
            Shortcut[] $this$filterIsInstance$iv = shortcuts;
            boolean $i$f$filterIsInstance = false;
            Shortcut[] shortcutArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KeyboardShortcut)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            kbShortcuts = list2 = (List)destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = iterable = (Iterable)kbShortcuts;
            for (Object t : iterable2) {
                KeyboardShortcut it = (KeyboardShortcut)t;
                boolean bl2 = false;
                if (!(!INSTANCE.isNumpadKey(it))) continue;
                v3 = t;
                break block5;
            }
            v3 = null;
        }
        if ((keyboardShortcut = (KeyboardShortcut)v3) == null) {
            keyboardShortcut = (KeyboardShortcut)CollectionsKt.firstOrNull((List)kbShortcuts);
        }
        KeyboardShortcut keyboardShortcut4 = bestShortcut = keyboardShortcut;
        return keyboardShortcut4 != null ? keyboardShortcut4.getFirstKeyStroke() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final KeyboardShortcut findCustomShortcut(Keymap activeKeymap, String actionId) {
        void $this$filterIsInstanceTo$iv$iv;
        Object[] objectArray = activeKeymap.getShortcuts(actionId);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"activeKeymap.getShortcuts(actionId)");
        List currentShortcuts = ArraysKt.toList((Object[])objectArray);
        if (!activeKeymap.canModify()) {
            return null;
        }
        Object object = activeKeymap.getParent();
        if (object == null || (object = object.getShortcuts(actionId)) == null || (object = ArraysKt.toList((Object[])object)) == null) {
            return null;
        }
        Object parentShortcuts = object;
        List shortcuts = CollectionsKt.minus((Iterable)currentShortcuts, (Iterable)((Iterable)parentShortcuts));
        if (shortcuts.isEmpty()) {
            return null;
        }
        Iterable $this$filterIsInstance$iv = CollectionsKt.reversed((Iterable)shortcuts);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KeyboardShortcut)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (KeyboardShortcut)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNumpadKey(KeyboardShortcut $this$isNumpadKey) {
        KeyStroke keyStroke = $this$isNumpadKey.getFirstKeyStroke();
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"firstKeyStroke");
        int n = keyStroke.getKeyCode();
        if (96 <= n) {
            if (111 >= n) return true;
        }
        KeyStroke keyStroke2 = $this$isNumpadKey.getFirstKeyStroke();
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke2, (String)"firstKeyStroke");
        if (keyStroke2.getKeyCode() != 144) return false;
        return true;
    }

    private final String specificKeyString(int code) {
        String string;
        switch (code) {
            case 37: {
                string = "\u2190";
                break;
            }
            case 39: {
                string = "\u2192";
                break;
            }
            case 38: {
                string = "\u2191";
                break;
            }
            case 40: {
                string = "\u2193";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public final Pair<String, List<IntRange>> getKeyStrokeData(@Nullable KeyStroke keyStroke) {
        if (keyStroke == null) {
            return new Pair((Object)"", (Object)CollectionsKt.emptyList());
        }
        String modifiers = this.getModifiersText(keyStroke.getModifiers());
        int keyCode = keyStroke.getKeyCode();
        String string = this.specificKeyString(keyCode);
        if (string == null) {
            string = SystemInfo.isMac ? MacKeymapUtil.getKeyText((int)keyCode) : KeyEvent.getKeyText(keyCode);
        }
        Object key = string;
        String string2 = key;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key");
        if (StringsKt.contains$default((CharSequence)string2, (char)' ', (boolean)false, (int)2, null)) {
            String string3 = key;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"key");
            key = StringsKt.replace$default((String)string3, (char)' ', (char)'\u00a0', (boolean)false, (int)4, null);
        }
        if (((String)key).length() == 1) {
            String string4 = this.getStringForMacSymbol(((String)key).charAt(0));
            if (string4 != null) {
                String string5;
                String it = string5 = string4;
                boolean bl = false;
                key = (String)key + "\u00a0" + it;
            }
        }
        String separator = "\u00a0\u00a0\u00a0\u00a0";
        List intervals = new ArrayList();
        StringBuilder builder = new StringBuilder();
        var $fun$addPart$2 = new Function1<String, Unit>(builder, intervals){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ List $intervals;

            public final void invoke(@NotNull String part) {
                Intrinsics.checkNotNullParameter((Object)part, (String)"part");
                int start = this.$builder.length();
                this.$builder.append(part);
                this.$intervals.add(new IntRange(start, this.$builder.length() - 1));
            }
            {
                this.$builder = stringBuilder;
                this.$intervals = list2;
                super(1);
            }
        };
        for (String m : this.getModifiers(modifiers)) {
            Object object;
            if (SystemInfo.isMac) {
                String modifierName;
                String string6 = modifierName = m.length() == 1 ? this.getStringForMacSymbol(m.charAt(0)) : null;
                object = modifierName != null ? m + "\u00a0" + modifierName : m;
            } else {
                object = m;
            }
            String part = object;
            $fun$addPart$2.invoke(part);
            builder.append(separator);
        }
        Object object = key;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key");
        $fun$addPart$2.invoke((String)object);
        String string7 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"builder.toString()");
        return new Pair((Object)string7, (Object)intervals);
    }

    @NotNull
    public final Pair<String, List<IntRange>> getGotoActionData(@NonNls @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        KeyStroke keyStroke = this.getShortcutByActionId("GotoAction");
        Pair<String, List<IntRange>> gotoAction = this.getKeyStrokeData(keyStroke);
        Presentation presentation = UtilsKt.getActionById(actionId).getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getActionById(actionId).templatePresentation");
        String string = presentation.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionById(actionId).templatePresentation.text");
        String actionName = UtilsKt.replaceSpacesWithNonBreakSpace(string);
        ArrayList<IntRange> updated = new ArrayList<IntRange>((Collection)gotoAction.getSecond());
        int start = ((String)gotoAction.getFirst()).length() + 5;
        updated.add(new IntRange(start, start + actionName.length() - 1));
        return new Pair((Object)((String)gotoAction.getFirst() + "  \u2192  " + actionName), updated);
    }

    private final String getModifiersText(int modifiers) {
        String string = KeyEvent.getKeyModifiersText(modifiers);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KeyEvent.getKeyModifiersText(modifiers)");
        return string;
    }

    private final String[] getModifiers(String $this$getModifiers) {
        List list2;
        CharSequence charSequence = $this$getModifiers;
        String string = "[ +]";
        string = new Regex(string);
        int n = 0;
        List $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                CharSequence charSequence2 = it;
                if (charSequence2.length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return stringArray;
    }

    private final String getStringForMacSymbol(char c) {
        if (!SystemInfo.isMac) {
            return null;
        }
        switch (c) {
            case '\u238b': {
                return "Esc";
            }
            case '\u21e5': {
                return "Tab";
            }
            case '\u21ea': {
                return "Caps";
            }
            case '\u21e7': {
                return "Shift";
            }
            case '\u2303': {
                return "Ctrl";
            }
            case '\u2325': {
                return "Opt";
            }
            case '\u2318': {
                return "Cmd";
            }
            case '\u23ce': {
                return "Enter";
            }
            case '\u232b': {
                return "Backspace";
            }
            case '\u2326': {
                return "Del";
            }
            case '\u2196': {
                return "Home";
            }
            case '\u2198': {
                return "End";
            }
            case '\u21de': {
                return "PageUp";
            }
            case '\u21df': {
                return "PageDown";
            }
            case '\u21ed': {
                return "NumLock";
            }
            case '\u2328': {
                return "NumPad";
            }
        }
        return null;
    }

    private KeymapUtil() {
    }

    static {
        KeymapUtil keymapUtil;
        INSTANCE = keymapUtil = new KeymapUtil();
    }
}

