/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.settingsSync.FileState;
import com.intellij.settingsSync.FileStateKt;
import com.intellij.settingsSync.GitSettingsLog;
import com.intellij.settingsSync.SettingsLog;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0002EFB1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010(\u001a\u00020#H\u0016J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\u001eH\u0016J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\fH\u0002J\b\u00106\u001a\u00020 H\u0016J\b\u00107\u001a\u00020 H\u0016J\b\u00108\u001a\u00020 H\u0016J\u0010\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020\fH\u0002J\u0012\u0010;\u001a\u00020\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010<\u001a\u000200H\u0016J\b\u0010=\u001a\u00020\u001eH\u0002J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020 H\u0016J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020 H\u0016J\u0018\u0010A\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010B\u001a\u00020 H\u0002J\f\u0010C\u001a\u00020D*\u00020\u0016H\u0002R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006G"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog;", "Lcom/intellij/settingsSync/SettingsLog;", "Lcom/intellij/openapi/Disposable;", "settingsSyncStorage", "Ljava/nio/file/Path;", "rootConfigPath", "parentDisposable", "collectFilesToExportFromSettings", "Lkotlin/Function0;", "", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "cloud", "Lorg/eclipse/jgit/lib/Ref;", "getCloud", "()Lorg/eclipse/jgit/lib/Ref;", "git", "Lorg/eclipse/jgit/api/Git;", "ide", "getIde", "master", "getMaster", "repository", "Lorg/eclipse/jgit/lib/Repository;", "short", "", "Lorg/eclipse/jgit/lib/ObjectId;", "getShort", "(Lorg/eclipse/jgit/lib/ObjectId;)Ljava/lang/String;", "(Lorg/eclipse/jgit/lib/Ref;)Ljava/lang/String;", "abortMerge", "", "advanceMaster", "Lcom/intellij/settingsSync/SettingsLog$Position;", "applyCloudState", "snapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "applyIdeState", "applySnapshotAndCommit", "refName", "applyState", "collectCurrentSnapshot", "copyDirectory", "dirToCopy", "targetDir", "copyExistingSettings", "createBranchIfNeeded", "name", "newRepository", "", "dispose", "fastForwardMaster", "Lcom/intellij/settingsSync/GitSettingsLog$BranchPosition;", "branchOnSamePosition", "targetBranch", "getCloudPosition", "getIdePosition", "getMasterPosition", "getPosition", "ref", "initRepository", "initialize", "mergeUsingSimplifiedLastModifiedStrategy", "setCloudPosition", "position", "setIdePosition", "updateBranchPosition", "targetPosition", "headCommit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "BranchPosition", "Companion", "intellij.settingsSync"})
public final class GitSettingsLog
implements SettingsLog,
Disposable {
    private Repository repository;
    private Git git;
    private final Path settingsSyncStorage;
    private final Path rootConfigPath;
    private final Function0<Collection<Path>> collectFilesToExportFromSettings;
    @Deprecated
    @NotNull
    private static final Logger LOG;
    @Deprecated
    @NotNull
    public static final String MASTER_REF_NAME = "master";
    @Deprecated
    @NotNull
    public static final String IDE_REF_NAME = "ide";
    @Deprecated
    @NotNull
    public static final String CLOUD_REF_NAME = "cloud";
    @NotNull
    private static final Companion Companion;

    private final Ref getMaster() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref = repository.findRef(MASTER_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    private final Ref getIde() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref = repository.findRef(IDE_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    private final Ref getCloud() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref = repository.findRef(CLOUD_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    @Override
    public boolean initialize() {
        boolean newRepository;
        Path dotGit = this.settingsSyncStorage.resolve(".git");
        Repository repository = FileRepositoryBuilder.create(dotGit.toFile());
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"FileRepositoryBuilder.create(dotGit.toFile())");
        Repository repository2 = this.repository = repository;
        if (repository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        this.git = new Git(repository2);
        Path path = dotGit;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dotGit");
        boolean bl = newRepository = !PathKt.exists((Path)path);
        if (newRepository) {
            LOG.info("Initializing new Git repository for Settings Sync at " + this.settingsSyncStorage);
            Repository repository3 = this.repository;
            if (repository3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            }
            repository3.create();
            Repository repository4 = this.repository;
            if (repository4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            }
            this.initRepository(repository4);
            Repository repository5 = this.repository;
            if (repository5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            }
            this.copyExistingSettings(repository5);
        }
        this.createBranchIfNeeded(MASTER_REF_NAME, newRepository);
        this.createBranchIfNeeded(CLOUD_REF_NAME, newRepository);
        this.createBranchIfNeeded(IDE_REF_NAME, newRepository);
        return newRepository;
    }

    private final void createBranchIfNeeded(String name, boolean newRepository) {
        Ref ref;
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        if ((ref = repository.findRef(name)) == null) {
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            }
            RevCommit head = this.headCommit(repository2);
            if (!newRepository) {
                ObjectId objectId = head.toObjectId();
                Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"head.toObjectId()");
                LOG.warn("Ref with name " + name + " not found in existing repository. Recreating at position of HEAD@" + this.getShort(objectId));
            }
            Git git = this.git;
            if (git == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            }
            git.branchCreate().setName(name).setStartPoint(head).call();
        }
    }

    private final void copyExistingSettings(Repository repository) {
        Iterable path2;
        LOG.info("Copying existing settings from " + this.rootConfigPath + " to " + this.settingsSyncStorage);
        List copiedFileSpecs = new ArrayList();
        Collection filesToExport = (Collection)this.collectFilesToExportFromSettings.invoke();
        for (Iterable path2 : filesToExport) {
            String fileSpec = ((Object)PathsKt.relativeTo(path2, (Path)this.rootConfigPath)).toString();
            if (PathKt.isFile(path2)) {
                Path target;
                Path path3 = target = this.settingsSyncStorage.resolve(fileSpec);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"target");
                NioFiles.createDirectories((Path)path3.getParent());
                Files.copy(path2, target, new CopyOption[]{LinkOption.NOFOLLOW_LINKS});
            } else {
                this.copyDirectory((Path)path2, this.settingsSyncStorage);
            }
            copiedFileSpecs.add(fileSpec);
        }
        path2 = copiedFileSpecs;
        if (!path2.isEmpty()) {
            Git git = new Git(repository);
            AddCommand addCommand = git.add();
            for (String fileSpec : copiedFileSpecs) {
                addCommand.addFilepattern(fileSpec);
            }
            addCommand.call();
            git.commit().setMessage("Copy existing configs").call();
        }
    }

    private final void copyDirectory(Path dirToCopy, Path targetDir) {
        Files.walkFileTree(dirToCopy, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(targetDir, dirToCopy){
            final /* synthetic */ Path $targetDir;
            final /* synthetic */ Path $dirToCopy;

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Path target;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                Path path = target = this.$targetDir.resolve(this.$dirToCopy.getParent().relativize(file));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"target");
                NioFiles.createDirectories((Path)path.getParent());
                Files.copy(file, target, LinkOption.NOFOLLOW_LINKS);
                return FileVisitResult.CONTINUE;
            }
            {
                this.$targetDir = $captured_local_variable$0;
                this.$dirToCopy = $captured_local_variable$1;
            }
        });
    }

    private final void initRepository(Repository repository) {
        Path path = this.settingsSyncStorage.resolve(".gitignore");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"settingsSyncStorage.resolve(\".gitignore\")");
        Path gitignore = PathKt.createFile((Path)path);
        PathKt.write$default((Path)gitignore, (CharSequence)"event-log-metadata\njdbc-drivers\nssl\nport\nport.lock\nupdatedBrokenPlugins.db\n", null, (boolean)false, (int)6, null);
        Git git = new Git(repository);
        git.add().addFilepattern(".gitignore").call();
        git.commit().setMessage("Initial").call();
    }

    @Override
    public void applyIdeState(@NotNull SettingsSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.applyState(IDE_REF_NAME, snapshot);
    }

    @Override
    public void applyCloudState(@NotNull SettingsSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.applyState(CLOUD_REF_NAME, snapshot);
    }

    private final void applyState(String refName, SettingsSnapshot snapshot) {
        if (snapshot.isEmpty()) {
            LOG.error("Empty snapshot");
            return;
        }
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        git.checkout().setName(refName).call();
        this.applySnapshotAndCommit(refName, snapshot);
    }

    private final void applySnapshotAndCommit(String refName, SettingsSnapshot snapshot) {
        LOG.info("Applying settings changes to branch " + refName + ": " + CollectionsKt.joinToString$default((Iterable)snapshot.getFileStates(), null, null, null, (int)5, null, (Function1)applySnapshotAndCommit.1.INSTANCE, (int)23, null));
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        AddCommand addCommand = git.add();
        String message = "Apply changes received from " + refName;
        for (FileState fileState : snapshot.getFileStates()) {
            Path file = this.settingsSyncStorage.resolve(fileState.getFile());
            FileState fileState2 = fileState;
            if (fileState2 instanceof FileState.Modified) {
                Path path = file;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                PathKt.write((Path)path, (byte[])((FileState.Modified)fileState).getContent(), (int)0, (int)((FileState.Modified)fileState).getSize());
            } else if (fileState2 instanceof FileState.Deleted) {
                Path path = file;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                PathKt.write$default((Path)path, (CharSequence)"DELETED", null, (boolean)false, (int)6, null);
            }
            addCommand.addFilepattern(fileState.getFile());
        }
        addCommand.call();
        try {
            Git git2 = this.git;
            if (git2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            }
            git2.commit().setMessage(message).setAllowEmpty(false).call();
        }
        catch (EmptyCommitException e) {
            LOG.info("No actual changes in the settings");
        }
    }

    public void dispose() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        repository.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SettingsSnapshot collectCurrentSnapshot() {
        void var3_2;
        void $this$mapTo$iv;
        File file = this.settingsSyncStorage.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"settingsSyncStorage.toFile()");
        Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file).onEnter((Function1)collectCurrentSnapshot.files.1.INSTANCE)), (Function1)collectCurrentSnapshot.files.2.INSTANCE);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            File file2 = (File)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
            FileState fileState = FileStateKt.getFileStateFromFileWithDeletedMarker(path, this.settingsSyncStorage);
            collection.add(fileState);
        }
        HashSet files2 = (HashSet)var3_2;
        return new SettingsSnapshot(files2);
    }

    @Override
    @NotNull
    public SettingsLog.Position getIdePosition() {
        return this.getPosition(this.getIde());
    }

    @Override
    @NotNull
    public SettingsLog.Position getCloudPosition() {
        return this.getPosition(this.getCloud());
    }

    @Override
    @NotNull
    public SettingsLog.Position getMasterPosition() {
        return this.getPosition(this.getMaster());
    }

    private final BranchPosition getPosition(Ref ref) {
        String string = ref.getObjectId().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ref.objectId.name()");
        return new BranchPosition(string);
    }

    @Override
    public void setIdePosition(@NotNull SettingsLog.Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.updateBranchPosition(IDE_REF_NAME, position);
    }

    @Override
    public void setCloudPosition(@NotNull SettingsLog.Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.updateBranchPosition(CLOUD_REF_NAME, position);
    }

    private final Ref updateBranchPosition(String refName, SettingsLog.Position targetPosition) {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref = repository.findRef(refName);
        Intrinsics.checkNotNull((Object)ref);
        Ref ref2 = ref;
        ObjectId previousObjectId = ref2.getObjectId();
        ObjectId targetObjectId = ObjectId.fromString(targetPosition.getId());
        Repository repository2 = this.repository;
        if (repository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        RefUpdate refUpdate = repository2.updateRef(ref2.getName());
        refUpdate.setNewObjectId(targetObjectId);
        RefUpdate.Result result2 = refUpdate.update();
        String string = this.getShort(ref2);
        ObjectId objectId = previousObjectId;
        Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"previousObjectId");
        LOG.info("Updated position of " + string + " from " + this.getShort(objectId) + " to " + targetPosition + ": " + result2);
        Repository repository3 = this.repository;
        if (repository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        Ref ref3 = repository3.findRef(ref2.getName());
        Intrinsics.checkNotNull((Object)ref3);
        return ref3;
    }

    private final BranchPosition fastForwardMaster(Ref branchOnSamePosition, Ref targetBranch) {
        MergeResult mergeResult;
        String string = this.getShort(branchOnSamePosition);
        ObjectId objectId = this.getMaster().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"master.objectId");
        String string2 = this.getShort(objectId);
        String string3 = this.getShort(targetBranch);
        ObjectId objectId2 = targetBranch.getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId2, (String)"targetBranch.objectId");
        LOG.info("Advancing master. Its position is equal to " + string + ": " + string2 + ". Fast-forwarding to " + string3 + " " + this.getShort(objectId2));
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        MergeResult mergeResult2 = mergeResult = git.merge().include(targetBranch).call();
        Intrinsics.checkNotNullExpressionValue((Object)mergeResult2, (String)"mergeResult");
        if (mergeResult2.getMergeStatus() != MergeResult.MergeStatus.FAST_FORWARD) {
            LOG.warn("Non-fast-forward result: " + mergeResult);
        }
        return this.getPosition(this.getMaster());
    }

    @Override
    @NotNull
    public SettingsLog.Position advanceMaster() {
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        git.checkout().setName(MASTER_REF_NAME).call();
        if (Intrinsics.areEqual((Object)this.getMaster().getObjectId(), (Object)this.getIde().getObjectId())) {
            return this.fastForwardMaster(this.getIde(), this.getCloud());
        }
        if (Intrinsics.areEqual((Object)this.getMaster().getObjectId(), (Object)this.getCloud().getObjectId())) {
            return this.fastForwardMaster(this.getCloud(), this.getIde());
        }
        ObjectId objectId = this.getMaster().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"master.objectId");
        String string = this.getShort(objectId);
        ObjectId objectId2 = this.getIde().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId2, (String)"ide.objectId");
        String string2 = this.getShort(objectId2);
        ObjectId objectId3 = this.getCloud().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId3, (String)"cloud.objectId");
        LOG.info("Advancing master@" + string + ". Need merge of ide@" + string2 + " and cloud@" + this.getShort(objectId3));
        Git git2 = this.git;
        if (git2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        git2.reset().setRef(IDE_REF_NAME).setMode(ResetCommand.ResetType.HARD).call();
        Git git3 = this.git;
        if (git3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        MergeResult mergeResult = git3.merge().include(this.getCloud()).call();
        ObjectId objectId4 = this.getMaster().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId4, (String)"master.objectId");
        String string3 = this.getShort(objectId4);
        ObjectId objectId5 = this.getCloud().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId5, (String)"cloud.objectId");
        LOG.info("Merge of master&ide@" + string3 + " with cloud@" + this.getShort(objectId5) + ": " + mergeResult);
        MergeResult mergeResult2 = mergeResult;
        Intrinsics.checkNotNullExpressionValue((Object)mergeResult2, (String)"mergeResult");
        if (mergeResult2.getMergeStatus() == MergeResult.MergeStatus.CONFLICTING) {
            LOG.info("Merge of master&ide with cloud failed with conflicts. Aborting and merging with simplified last-modified strategy...");
            this.abortMerge();
            this.mergeUsingSimplifiedLastModifiedStrategy();
        }
        return this.getPosition(this.getMaster());
    }

    private final void mergeUsingSimplifiedLastModifiedStrategy() {
        RevCommit cloudTip;
        RevCommit ideTip;
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        Object object = git.log().add(this.getIde().getObjectId()).setMaxCount(1).call();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"git.log().add(ide.objectId).setMaxCount(1).call()");
        RevCommit revCommit = ideTip = (RevCommit)CollectionsKt.first((Iterable)object);
        Intrinsics.checkNotNullExpressionValue((Object)revCommit, (String)"ideTip");
        int ideLastDate = revCommit.getCommitTime();
        Git git2 = this.git;
        if (git2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        Object object2 = git2.log().add(this.getCloud().getObjectId()).setMaxCount(1).call();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"git.log().add(cloud.obje\u2026Id).setMaxCount(1).call()");
        RevCommit revCommit2 = cloudTip = (RevCommit)CollectionsKt.first((Iterable)object2);
        Intrinsics.checkNotNullExpressionValue((Object)revCommit2, (String)"cloudTip");
        int cloudLastDate = revCommit2.getCommitTime();
        MergeStrategy mergeStrategy = ideLastDate >= cloudLastDate ? MergeStrategy.OURS : MergeStrategy.THEIRS;
        Git git3 = this.git;
        if (git3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        MergeResult mergeResult = git3.merge().include(this.getCloud()).setStrategy(mergeStrategy).call();
        LOG.info("Merging with the last-modified strategy completed with result: " + mergeResult);
    }

    private final void abortMerge() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        repository.writeMergeCommitMsg(null);
        Repository repository2 = this.repository;
        if (repository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        }
        repository2.writeMergeHeads(null);
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
        }
        git.reset().setMode(ResetCommand.ResetType.HARD).call();
    }

    private final RevCommit headCommit(Repository $this$headCommit) {
        Ref ref;
        Ref ref2 = ref = $this$headCommit.findRef("HEAD");
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"ref");
        RevCommit revCommit = $this$headCommit.parseCommit(ref2.getObjectId());
        Intrinsics.checkNotNullExpressionValue((Object)revCommit, (String)"this.parseCommit(ref.objectId)");
        return revCommit;
    }

    private final String getShort(Ref $this$short) {
        String string = $this$short.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        return StringsKt.removePrefix((String)string, (CharSequence)"refs/heads/");
    }

    private final String getShort(ObjectId $this$short) {
        String string = $this$short.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        String string2 = string;
        int n = 0;
        int n2 = 8;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string3;
    }

    public GitSettingsLog(@NotNull Path settingsSyncStorage, @NotNull Path rootConfigPath, @NotNull Disposable parentDisposable, @NotNull Function0<? extends Collection<? extends Path>> collectFilesToExportFromSettings) {
        Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
        Intrinsics.checkNotNullParameter((Object)rootConfigPath, (String)"rootConfigPath");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(collectFilesToExportFromSettings, (String)"collectFilesToExportFromSettings");
        this.settingsSyncStorage = settingsSyncStorage;
        this.rootConfigPath = rootConfigPath;
        this.collectFilesToExportFromSettings = collectFilesToExportFromSettings;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitSettingsLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog$BranchPosition;", "Lcom/intellij/settingsSync/SettingsLog$Position;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.settingsSync"})
    private static final class BranchPosition
    implements SettingsLog.Position {
        @NotNull
        private final String id;

        @NotNull
        public String toString() {
            String string = this.getId();
            int n = 0;
            int n2 = 8;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string2;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        public BranchPosition(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String component1() {
            return this.getId();
        }

        @NotNull
        public final BranchPosition copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new BranchPosition(id);
        }

        public static /* synthetic */ BranchPosition copy$default(BranchPosition branchPosition, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = branchPosition.getId();
            }
            return branchPosition.copy(string);
        }

        public int hashCode() {
            String string = this.getId();
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BranchPosition)) break block3;
                    BranchPosition branchPosition = (BranchPosition)object;
                    if (!Intrinsics.areEqual((Object)this.getId(), (Object)branchPosition.getId())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog$Companion;", "", "()V", "CLOUD_REF_NAME", "", "IDE_REF_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MASTER_REF_NAME", "intellij.settingsSync"})
    private static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

