/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.PathStringUtil;
import com.google.common.base.Joiner;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011B9\b\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0007\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0011\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0000H\u0096\u0002J\u001c\u0010=\u001a\u00020!2\b\u0010>\u001a\u0004\u0018\u00010\u00002\b\u0010?\u001a\u0004\u0018\u00010\u0000H\u0002J\b\u0010@\u001a\u00020\u0007H\u0002J\u0010\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u0007H\u0002J\u0010\u0010C\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005H\u0002J\u0013\u0010D\u001a\u00020!2\b\u0010<\u001a\u0004\u0018\u00010EH\u0096\u0002J\u0011\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010F\u001a\u00020\u00002\u0006\u0010H\u001a\u00020IH\u0086\u0002J\b\u0010J\u001a\u00020\u0007H\u0016J\u0006\u0010K\u001a\u00020\u0000J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0000J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0000J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0005J\u0010\u0010N\u001a\u00020!2\u0006\u0010<\u001a\u00020\u0000H\u0002J\u000e\u0010O\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0007J\u000e\u0010P\u001a\u00020!2\u0006\u0010Q\u001a\u00020\u0000J\u001a\u0010R\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u00072\b\b\u0002\u0010S\u001a\u00020\u0007H\u0002J\u001c\u0010T\u001a\u0004\u0018\u00010\u00002\u0006\u0010G\u001a\u00020\u00072\b\b\u0002\u0010S\u001a\u00020\u0007H\u0002J\u0016\u0010U\u001a\u00020\u00002\u0006\u0010V\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010W\u001a\u00020\u0005J\b\u0010X\u001a\u0004\u0018\u00010\u000eJ\b\u0010Y\u001a\u0004\u0018\u00010\u0010J\b\u0010Z\u001a\u00020\u0005H\u0016J\u0006\u0010[\u001a\u00020\u0000R\u0014\u0010\u0018\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8G\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020!8G\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020!8G\u00a2\u0006\u0006\u001a\u0004\b%\u0010\"R\u0011\u0010&\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001aR\u0011\u0010(\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u0013\u0010*\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0013\u0010-\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001dR\u0011\u0010/\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b0\u0010,R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001dR\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001dR\u0013\u00105\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b6\u0010,R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020\u0005088F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lcom/android/ide/common/util/PathString;", "", "filesystem", "Ljava/net/URI;", "path", "", "rootLength", "", "(Ljava/net/URI;Ljava/lang/String;I)V", "protocol", "(Ljava/lang/String;Ljava/lang/String;)V", "filesystemUri", "(Ljava/net/URI;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "startIndex", "suffixEndIndex", "prefixEndIndex", "separator", "", "(Ljava/net/URI;Ljava/lang/String;IIIC)V", "endIndex", "getEndIndex", "()I", "fileName", "getFileName", "()Ljava/lang/String;", "getFilesystemUri", "()Ljava/net/URI;", "hasTrailingSeparator", "", "()Z", "hash", "isAbsolute", "isEmptyPath", "nameCount", "getNameCount", "nativePath", "getNativePath", "parent", "getParent", "()Lcom/android/ide/common/util/PathString;", "parentFileName", "getParentFileName", "parentOrRoot", "getParentOrRoot", "portablePath", "getPortablePath", "rawPath", "getRawPath", "root", "getRoot", "segments", "", "getSegments", "()Ljava/util/List;", "compareTo", "other", "compatibleRoots", "root1", "root2", "computeHash", "computeNameStart", "end", "driveName", "equals", "", "get", "index", "range", "Lkotlin/ranges/IntRange;", "hashCode", "normalize", "relativize", "resolve", "sameRootAs", "segment", "startsWith", "possiblePrefix", "subRange", "length", "subRangeOrNull", "subpath", "beginIndex", "toDebugString", "toFile", "toPath", "toString", "withoutTrailingSeparator", "android.sdktools.sdk-common"})
public final class PathString
implements Comparable<PathString> {
    @NotNull
    private final URI filesystemUri;
    @NotNull
    private final String path;
    private final int startIndex;
    private final int suffixEndIndex;
    private final int prefixEndIndex;
    private final char separator;
    private int hash;

    private PathString(URI filesystemUri, String path, int startIndex, int suffixEndIndex, int prefixEndIndex, char separator) {
        this.filesystemUri = filesystemUri;
        this.path = path;
        this.startIndex = startIndex;
        this.suffixEndIndex = suffixEndIndex;
        this.prefixEndIndex = prefixEndIndex;
        this.separator = separator;
    }

    /* synthetic */ PathString(URI uRI, String string, int n, int n2, int n3, char c, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(uRI, string, n, n2, n3, c);
    }

    @NotNull
    public final URI getFilesystemUri() {
        return this.filesystemUri;
    }

    private PathString(URI filesystem, String path, int rootLength) {
        this(filesystem, path, rootLength, path.length(), rootLength, PathStringUtil.access$detectSeparator(path, rootLength));
    }

    public PathString(@NotNull String protocol, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this(PathStringUtil.access$getUri(protocol), path, PathStringUtil.access$prefixLength(path));
    }

    public PathString(@NotNull URI filesystemUri, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)filesystemUri, (String)"filesystemUri");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this(filesystemUri, path, PathStringUtil.access$prefixLength(path));
    }

    public PathString(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this(PathStringUtil.getDefaultFilesystemUri(), path);
    }

    public PathString(@NotNull File path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        URI uRI = PathStringUtil.getDefaultFilesystemUri();
        String string = path.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path.path");
        this(uRI, string);
    }

    public PathString(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        URI uRI = path.getFileSystem().getPath(path.getFileSystem().getSeparator(), new String[0]).toUri();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"path.fileSystem.getPath(\u2026System.separator).toUri()");
        this(uRI, ((Object)path).toString());
    }

    @NotNull
    public final String getRawPath() {
        String string;
        if (this.startIndex == this.prefixEndIndex) {
            String string2 = this.path;
            int n = 0;
            int n2 = this.suffixEndIndex;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            String string5 = this.path;
            int n = 0;
            int n3 = this.prefixEndIndex;
            boolean bl = false;
            String string6 = string5;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string5 = this.path;
            n = this.startIndex;
            n3 = this.suffixEndIndex;
            bl = false;
            String string8 = string5;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = Intrinsics.stringPlus((String)string7, (Object)string9);
        }
        return string;
    }

    @NotNull
    public final String getPortablePath() {
        return StringsKt.replace$default((String)this.getRawPath(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getNativePath() {
        return PathStringUtil.access$withSeparator(this.getRawPath(), File.separatorChar);
    }

    @NotNull
    public String toString() {
        String string = this.filesystemUri.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filesystemUri.toString()");
        String schemeString = string;
        if (StringsKt.startsWith$default((String)schemeString, (String)"file:///", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)schemeString, (String)":/", (boolean)false, (int)2, null) && schemeString.length() == "file:///".length() + ":/".length() + 1) {
            schemeString = "file:///";
        }
        String path = this.getRawPath();
        StringBuilder buf = new StringBuilder(schemeString.length() + 1 + path.length());
        if (StringsKt.endsWith$default((String)schemeString, (String)"///", (boolean)false, (int)2, null)) {
            buf.append(schemeString, 0, schemeString.length() - 1);
        } else {
            buf.append(schemeString);
            if (!StringsKt.endsWith$default((CharSequence)schemeString, (char)'/', (boolean)false, (int)2, null)) {
                buf.append("!/");
            }
        }
        buf.append(path);
        String string2 = buf.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"buf.toString()");
        return string2;
    }

    @NotNull
    public final String toDebugString() {
        return "PathString filesystemUri=\"" + this.filesystemUri + "\" path=\"" + this.path + "\" startIndex=" + this.startIndex + " suffixEndIndex=" + this.suffixEndIndex + " prefixEndIndex=" + this.prefixEndIndex + " separator='" + this.separator + '\'';
    }

    @Nullable
    public final File toFile() {
        if (Intrinsics.areEqual((Object)this.filesystemUri.getScheme(), (Object)"file")) {
            return new File(this.getRawPath());
        }
        return null;
    }

    @Nullable
    public final Path toPath() {
        Path path;
        try {
            path = Paths.get(this.filesystemUri).getFileSystem().getPath(this.getRawPath(), new String[0]);
        }
        catch (FileSystemNotFoundException e) {
            path = null;
        }
        catch (IllegalArgumentException e) {
            path = null;
        }
        catch (ProviderNotFoundException e) {
            path = null;
        }
        return path;
    }

    @JvmName(name="isAbsolute")
    public final boolean isAbsolute() {
        return this.prefixEndIndex != 0 && PathStringUtil.access$isSeparator(this.path.charAt(this.prefixEndIndex - 1));
    }

    @NotNull
    public final String getFileName() {
        int end = this.getEndIndex();
        String string = this.path;
        int n = this.computeNameStart(end);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, end);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String segment(int index) {
        int n;
        int lengthCount;
        int subRangeStart;
        int n2;
        int n3;
        int n4;
        block14: {
            void $this$countUntil$iv;
            int n5;
            int n6;
            int n7;
            int n8;
            block13: {
                void $this$countUntil$iv2;
                if (index < 0) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Negative index: ", (Object)index));
                }
                int separatorCount = 0;
                IntProgression intProgression = (IntProgression)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
                n4 = this.startIndex;
                boolean $i$f$countUntil = false;
                int result$iv = 0;
                n3 = $this$countUntil$iv2.getFirst();
                int n9 = $this$countUntil$iv2.getLast();
                n8 = $this$countUntil$iv2.getStep();
                if (n8 > 0 && n3 <= n9 || n8 < 0 && n9 <= n3) {
                    int item$iv;
                    do {
                        item$iv = n3;
                        n3 += n8;
                        int it = item$iv;
                        boolean bl = false;
                        if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                            n7 = separatorCount;
                            separatorCount = n7 + 1;
                        }
                        if (separatorCount >= index) {
                            n6 = result$iv;
                            break block13;
                        }
                        n5 = result$iv;
                        result$iv = n5 + 1;
                    } while (item$iv != n9);
                }
                n6 = result$iv;
            }
            n2 = n6;
            subRangeStart = n4 + n2;
            if (subRangeStart >= this.getEndIndex() - 1) {
                throw new IllegalArgumentException("Invalid index " + index + " for path " + this);
            }
            if (PathStringUtil.access$isSeparator(this.path.charAt(subRangeStart))) {
                int $this$countUntil$iv2 = subRangeStart;
                subRangeStart = $this$countUntil$iv2 + 1;
            }
            lengthCount = 0;
            IntProgression result$iv = (IntProgression)RangesKt.until((int)subRangeStart, (int)this.getEndIndex());
            n4 = subRangeStart;
            boolean $i$f$countUntil = false;
            int result$iv2 = 0;
            n8 = $this$countUntil$iv.getFirst();
            int n10 = $this$countUntil$iv.getLast();
            n5 = $this$countUntil$iv.getStep();
            if (n5 > 0 && n8 <= n10 || n5 < 0 && n10 <= n8) {
                int item$iv;
                do {
                    item$iv = n8;
                    n8 += n5;
                    int it = item$iv;
                    boolean bl = false;
                    if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                        int n11 = lengthCount;
                        lengthCount = n11 + 1;
                    }
                    if (lengthCount >= 1) {
                        n = result$iv2;
                        break block14;
                    }
                    n7 = result$iv2;
                    result$iv2 = n7 + 1;
                } while (item$iv != n10);
            }
            n = result$iv2;
        }
        n2 = n;
        int subRangeEnd = n4 + n2;
        if (lengthCount < 0) {
            throw new IllegalArgumentException();
        }
        String string = this.path;
        n3 = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(subRangeStart, subRangeEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final PathString get(int index) {
        return PathString.subRange$default(this, index, 0, 2, null);
    }

    @NotNull
    public final PathString get(@NotNull IntRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        if (range.getStep() != 1) {
            throw new IllegalArgumentException("Step must be 1");
        }
        return this.subRange(range.getStart(), range.getEndInclusive() - range.getStart() + 1);
    }

    @NotNull
    public final PathString subpath(int beginIndex, int endIndex) {
        return this.subRange(beginIndex, endIndex - beginIndex);
    }

    public final boolean startsWith(@NotNull PathString possiblePrefix) {
        Intrinsics.checkParameterIsNotNull((Object)possiblePrefix, (String)"possiblePrefix");
        PathString toTest = possiblePrefix.withoutTrailingSeparator();
        if (!this.sameRootAs(toTest)) {
            return false;
        }
        int ourEnd = this.getEndIndex();
        int thisLength = ourEnd - this.startIndex;
        int prefixLength = toTest.getEndIndex() - toTest.startIndex;
        if (prefixLength > thisLength) {
            return false;
        }
        if (prefixLength == 0) {
            return true;
        }
        int requiredSeparatorPosition = this.startIndex + prefixLength;
        if (requiredSeparatorPosition > ourEnd || requiredSeparatorPosition < ourEnd && !PathStringUtil.access$isSeparator(this.path.charAt(requiredSeparatorPosition))) {
            return false;
        }
        int n = 0;
        if (n < prefixLength) {
            do {
                char otherChar;
                int idx;
                char thisChar;
                if ((thisChar = this.path.charAt(this.startIndex + (idx = n++))) == (otherChar = toTest.path.charAt(toTest.startIndex + idx)) || PathStringUtil.access$isSeparator(thisChar) && PathStringUtil.access$isSeparator(otherChar)) continue;
                return false;
            } while (n < prefixLength);
        }
        return true;
    }

    @NotNull
    public final PathString getParentOrRoot() {
        PathString pathString = this.getParent();
        return pathString == null ? this : pathString;
    }

    @Nullable
    public final PathString getParent() {
        if (this.getEndIndex() <= this.startIndex) {
            return null;
        }
        int newEnd = this.computeNameStart(this.getEndIndex()) - 1;
        if (newEnd <= this.startIndex) {
            return this.getRoot();
        }
        PathString result2 = new PathString(this.filesystemUri, this.path, this.startIndex, newEnd, this.prefixEndIndex, this.separator);
        if (this.hash != 0) {
            int parentHash = this.hash;
            int hashCodeForSegment = 0;
            int n = newEnd;
            int n2 = this.suffixEndIndex;
            if (n < n2) {
                do {
                    int i;
                    char nextChar;
                    if (PathStringUtil.access$isSeparator(nextChar = this.path.charAt(i = n++))) {
                        parentHash -= hashCodeForSegment;
                        hashCodeForSegment = 0;
                    }
                    hashCodeForSegment = 31 * hashCodeForSegment + nextChar;
                } while (n < n2);
            }
            result2.hash = parentHash -= hashCodeForSegment;
        }
        return result2;
    }

    @Nullable
    public final String getParentFileName() {
        PathString pathString = this.getParent();
        return pathString == null ? null : pathString.getFileName();
    }

    @Nullable
    public final PathString getRoot() {
        if (this.prefixEndIndex == 0) {
            return null;
        }
        return new PathString(this.filesystemUri, this.path, this.prefixEndIndex, this.prefixEndIndex, this.prefixEndIndex, this.separator);
    }

    /*
     * WARNING - void declaration
     */
    public final int getNameCount() {
        int n;
        if (this.getEndIndex() == this.prefixEndIndex) {
            return 0;
        }
        Iterable $this$count$iv = (Iterable)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            Iterator iterator = $this$count$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                if (!PathStringUtil.access$isSeparator(this.path.charAt(it))) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n + 1;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.util.PathString");
        }
        PathString cfr_ignored_0 = (PathString)other;
        if (!Intrinsics.areEqual((Object)this.filesystemUri, (Object)((PathString)other).filesystemUri)) {
            return false;
        }
        int length = this.suffixEndIndex - this.startIndex;
        if (length != ((PathString)other).suffixEndIndex - ((PathString)other).startIndex) {
            return false;
        }
        if (this.prefixEndIndex != ((PathString)other).prefixEndIndex) {
            return false;
        }
        int n = 0;
        int n2 = this.prefixEndIndex;
        if (n < n2) {
            do {
                int i;
                if (this.path.charAt(i = n++) == ((PathString)other).path.charAt(i)) continue;
                return false;
            } while (n < n2);
        }
        if ((n = 0) < length) {
            do {
                int i;
                if (this.path.charAt(this.startIndex + (i = n++)) == ((PathString)other).path.charAt(((PathString)other).startIndex + i)) continue;
                return false;
            } while (n < length);
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHash();
        }
        return this.hash;
    }

    private final int computeHash() {
        int result2 = this.filesystemUri.hashCode();
        int n = 0;
        int n2 = this.prefixEndIndex;
        if (n < n2) {
            do {
                int i = n++;
                result2 = 31 * result2 + this.path.charAt(i);
            } while (n < n2);
        }
        int hashCodeForSegment = 0;
        n2 = this.startIndex;
        int n3 = this.suffixEndIndex;
        if (n2 < n3) {
            do {
                int i;
                char nextChar;
                if (PathStringUtil.access$isSeparator(nextChar = this.path.charAt(i = n2++))) {
                    result2 += hashCodeForSegment;
                    hashCodeForSegment = 0;
                }
                hashCodeForSegment = 31 * hashCodeForSegment + nextChar;
            } while (n2 < n3);
        }
        return result2 += hashCodeForSegment;
    }

    @NotNull
    public final PathString normalize() {
        String string;
        PathString pathString;
        boolean absolute = this.isAbsolute();
        ArrayDeque<String> newNames = new ArrayDeque<String>();
        Iterable $this$forEach$iv = this.getSegments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"..")) {
                String lastName = (String)newNames.peekLast();
                if (lastName != null && !Intrinsics.areEqual((Object)lastName, (Object)"..")) {
                    newNames.removeLast();
                    continue;
                }
                if (absolute) continue;
                newNames.add(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)it, (Object)".")) continue;
            newNames.add(it);
        }
        if (this.hasTrailingSeparator()) {
            newNames.addLast("");
        }
        if ((pathString = this.getRoot()) == null) {
            string = "";
        } else {
            String string2 = pathString.getRawPath();
            string = PathStringUtil.access$withSeparator(string2, this.separator);
        }
        String rootString = string;
        return new PathString(this.filesystemUri, Intrinsics.stringPlus((String)rootString, (Object)Joiner.on((char)this.separator).join((Iterable)newNames)));
    }

    @NotNull
    public final PathString withoutTrailingSeparator() {
        return this.hasTrailingSeparator() ? new PathString(this.filesystemUri, this.path, this.startIndex, this.getEndIndex(), this.prefixEndIndex, this.separator) : this;
    }

    @JvmName(name="hasTrailingSeparator")
    public final boolean hasTrailingSeparator() {
        return this.suffixEndIndex > this.startIndex && PathStringUtil.access$isSeparator(this.path.charAt(this.suffixEndIndex - 1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PathString relativize(@NotNull PathString other) {
        Object object;
        Collection collection;
        int item$iv$iv;
        Iterable $this$mapTo$iv$iv;
        int n;
        int n2;
        List<String> otherSegments;
        List<String> segments;
        block23: {
            void $this$countUntil$iv;
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            if (this.isEmptyPath()) {
                return other;
            }
            if (this.isAbsolute() && other.isEmptyPath()) {
                return other;
            }
            PathString otherRoot = other.getRoot();
            if (!Intrinsics.areEqual((Object)this.getRoot(), (Object)otherRoot)) {
                String convertedRootString;
                String string;
                PathString pathString = otherRoot;
                String otherRootString = pathString == null ? "" : pathString.getRawPath();
                PathString pathString2 = this.getRoot();
                if (pathString2 == null) {
                    string = "";
                } else {
                    String string2 = pathString2.getRawPath();
                    string = convertedRootString = PathStringUtil.access$withSeparator(string2, other.separator);
                }
                if (!Intrinsics.areEqual((Object)otherRootString, (Object)convertedRootString)) {
                    int result$iv3;
                    int $i$f$countUntil3;
                    int n3;
                    int item$iv;
                    int n4;
                    int n5;
                    int n6;
                    String rootString;
                    block21: {
                        void $this$countUntil$iv2;
                        rootString = otherRootString;
                        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.prefixEndIndex)));
                        n6 = this.prefixEndIndex;
                        boolean $i$f$countUntil2 = false;
                        int result$iv2 = 0;
                        int n7 = $this$countUntil$iv2.getFirst();
                        n5 = $this$countUntil$iv2.getLast();
                        n4 = $this$countUntil$iv2.getStep();
                        if (n4 > 0 && n7 <= n5 || n4 < 0 && n5 <= n7) {
                            do {
                                item$iv = n7;
                                n7 += n4;
                                int it = item$iv;
                                boolean bl = false;
                                if (this.path.charAt(it) == ':') {
                                    n3 = result$iv2;
                                    break block21;
                                }
                                it = result$iv2;
                                result$iv2 = it + 1;
                            } while (item$iv != n5);
                        }
                        n3 = result$iv2;
                    }
                    int n8 = n3;
                    int afterDriveSeparator = n6 - n8;
                    if (afterDriveSeparator > 0) {
                        int firstDifference;
                        String $this$countUntil$iv3;
                        block22: {
                            int n9;
                            IntProgression $i$f$countUntil2 = (IntProgression)RangesKt.until((int)0, (int)Math.min(afterDriveSeparator, other.prefixEndIndex));
                            $i$f$countUntil3 = 0;
                            result$iv3 = 0;
                            n5 = $this$countUntil$iv3.getFirst();
                            n4 = $this$countUntil$iv3.getLast();
                            item$iv = $this$countUntil$iv3.getStep();
                            if (item$iv > 0 && n5 <= n4 || item$iv < 0 && n4 <= n5) {
                                int item$iv2;
                                do {
                                    item$iv2 = n5;
                                    n5 += item$iv;
                                    int it = item$iv2;
                                    boolean bl = false;
                                    if (this.path.charAt(it) != other.path.charAt(it)) {
                                        n9 = result$iv3;
                                        break block22;
                                    }
                                    it = result$iv3;
                                    result$iv3 = it + 1;
                                } while (item$iv2 != n4);
                            }
                            n9 = firstDifference = result$iv3;
                        }
                        if (firstDifference >= afterDriveSeparator) {
                            $this$countUntil$iv3 = other.path;
                            $i$f$countUntil3 = other.prefixEndIndex;
                            result$iv3 = 0;
                            String string3 = $this$countUntil$iv3;
                            if (string3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string4 = string3.substring(afterDriveSeparator, $i$f$countUntil3);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            rootString = string4;
                        }
                    }
                    String firstDifference = other.path;
                    int $this$countUntil$iv3 = other.startIndex;
                    $i$f$countUntil3 = other.suffixEndIndex;
                    result$iv3 = 0;
                    String string5 = firstDifference;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.substring($this$countUntil$iv3, $i$f$countUntil3);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    return new PathString(this.filesystemUri, Intrinsics.stringPlus((String)rootString, (Object)string6), rootString.length());
                }
            }
            segments = this.getSegments();
            otherSegments = other.getSegments();
            Collection afterDriveSeparator = segments;
            boolean firstDifference = false;
            int n10 = afterDriveSeparator.size();
            afterDriveSeparator = otherSegments;
            firstDifference = false;
            afterDriveSeparator = (IntProgression)RangesKt.until((int)0, (int)Math.min(n10, afterDriveSeparator.size()));
            boolean $i$f$countUntil = false;
            int result$iv = 0;
            int $i$f$countUntil3 = $this$countUntil$iv.getFirst();
            int result$iv3 = $this$countUntil$iv.getLast();
            int n11 = $this$countUntil$iv.getStep();
            if (n11 > 0 && $i$f$countUntil3 <= result$iv3 || n11 < 0 && result$iv3 <= $i$f$countUntil3) {
                int item$iv;
                do {
                    item$iv = $i$f$countUntil3;
                    $i$f$countUntil3 += n11;
                    int it = item$iv;
                    n2 = 0;
                    if (!Intrinsics.areEqual((Object)segments.get(it), (Object)otherSegments.get(it))) {
                        n = result$iv;
                        break block23;
                    }
                    it = result$iv;
                    result$iv = it + 1;
                } while (item$iv != result$iv3);
            }
            n = result$iv;
        }
        int commonPrefixLength = n;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)commonPrefixLength, (int)segments.size());
        boolean $i$f$map = false;
        Iterable $i$f$countUntil3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            object = "..";
            collection.add(object);
        }
        $this$map$iv = (Iterable)RangesKt.until((int)commonPrefixLength, (int)otherSegments.size());
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int it = item$iv$iv = ((IntIterator)iterator).nextInt();
            object = destination$iv$iv;
            boolean bl = false;
            String string = otherSegments.get(it);
            object.add(string);
        }
        object = (List)destination$iv$iv;
        List newSegments = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        char newSeparator = PathStringUtil.access$chooseSeparator(other.separator, this.separator);
        String finalString = Intrinsics.stringPlus((String)Joiner.on((char)newSeparator).join((Iterable)newSegments), (Object)(other.hasTrailingSeparator() && !newSegments.isEmpty() ? Character.valueOf(newSeparator) : ""));
        return new PathString(this.filesystemUri, finalString, 0, finalString.length(), 0, this.separator);
    }

    @JvmName(name="isEmptyPath")
    public final boolean isEmptyPath() {
        return this.prefixEndIndex == 0 && this.startIndex == this.suffixEndIndex;
    }

    @NotNull
    public final PathString resolve(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.resolve(new PathString(this.filesystemUri, other));
    }

    @NotNull
    public final PathString resolve(@NotNull PathString other) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        PathString otherRoot = other.getRoot();
        if (this.isEmptyPath()) {
            return other;
        }
        if (other.isAbsolute()) {
            if (otherRoot != null && otherRoot.prefixEndIndex == 1) {
                String string2;
                int indexOfDriveSeparator = StringsKt.lastIndexOf$default((CharSequence)this.path, (char)':', (int)this.prefixEndIndex, (boolean)false, (int)4, null);
                if (indexOfDriveSeparator > 0) {
                    String string3 = this.path;
                    int n = 0;
                    int n2 = indexOfDriveSeparator + 1;
                    boolean bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = Intrinsics.stringPlus((String)string5, (Object)other.getRawPath());
                } else {
                    string2 = other.getRawPath();
                }
                String newPath = string2;
                return new PathString(this.filesystemUri, newPath);
            }
            return other;
        }
        if (otherRoot != null && !this.compatibleRoots(this.getRoot(), otherRoot)) {
            return other;
        }
        if (other.isEmptyPath() || other.startIndex == other.suffixEndIndex) {
            return this;
        }
        String newPath = other.path;
        int n = other.startIndex;
        int n3 = other.suffixEndIndex;
        boolean bl = false;
        String string6 = newPath;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.substring(n, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String otherRelPath = string7;
        if (this.separator == '\u0000') {
            if (this.startIndex == this.path.length()) {
                string = Intrinsics.stringPlus((String)this.path, (Object)otherRelPath);
            } else {
                char newSeparator = PathStringUtil.access$chooseSeparator(other.separator, '\u0000');
                string = this.path + newSeparator + PathStringUtil.access$withSeparator(otherRelPath, newSeparator);
            }
        } else {
            string = this.startIndex < this.suffixEndIndex && !PathStringUtil.access$isSeparator(this.path.charAt(this.suffixEndIndex - 1)) ? this.getRawPath() + this.separator + PathStringUtil.access$withSeparator(otherRelPath, this.separator) : Intrinsics.stringPlus((String)this.getRawPath(), (Object)PathStringUtil.access$withSeparator(otherRelPath, this.separator));
        }
        newPath = string;
        return new PathString(this.filesystemUri, newPath);
    }

    @NotNull
    public final List<String> getSegments() {
        ArrayList<String> result2 = new ArrayList<String>();
        int lastSegment = 0;
        lastSegment = this.startIndex;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (!PathStringUtil.access$isSeparator(this.path.charAt(it))) continue;
            String string = this.path;
            int n = lastSegment;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, it);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            result2.add(string3);
            lastSegment = it + 1;
        }
        if (lastSegment < this.getEndIndex()) {
            String string = this.path;
            int n = lastSegment;
            int n2 = this.getEndIndex();
            boolean bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            result2.add(string5);
        }
        return result2;
    }

    @Override
    public int compareTo(@NotNull PathString other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int schemeResult = this.filesystemUri.compareTo(other.filesystemUri);
        if (schemeResult != 0) {
            return schemeResult;
        }
        int n = 0;
        int otherPrefixEndIndex = other.prefixEndIndex;
        int n2 = Math.min(otherPrefixEndIndex, this.prefixEndIndex);
        if (n < n2) {
            do {
                int i;
                int cmpResult;
                if ((cmpResult = Intrinsics.compare((int)this.path.charAt(i = n++), (int)other.path.charAt(i))) == 0) continue;
                return cmpResult;
            } while (n < n2);
        }
        if (otherPrefixEndIndex != this.prefixEndIndex) {
            return Intrinsics.compare((int)this.prefixEndIndex, (int)otherPrefixEndIndex);
        }
        int n3 = 0;
        int length = this.suffixEndIndex - this.startIndex;
        int otherLength = other.suffixEndIndex - other.startIndex;
        int min = Math.min(length, otherLength);
        if (n3 < min) {
            do {
                int i;
                int cmpResult;
                if ((cmpResult = Intrinsics.compare((int)this.path.charAt(this.startIndex + (i = n3++)), (int)other.path.charAt(other.startIndex + i))) == 0) continue;
                return cmpResult;
            } while (n3 < min);
        }
        return Intrinsics.compare((int)length, (int)otherLength);
    }

    private final boolean sameRootAs(PathString other) {
        if (!Intrinsics.areEqual((Object)this.filesystemUri, (Object)other.filesystemUri)) {
            return false;
        }
        if (this.prefixEndIndex != other.prefixEndIndex) {
            return false;
        }
        int n = 0;
        int n2 = this.prefixEndIndex;
        if (n < n2) {
            do {
                int idx;
                if (this.path.charAt(idx = n++) == other.path.charAt(idx) || PathStringUtil.access$isSeparator(this.path.charAt(idx)) && PathStringUtil.access$isSeparator(other.path.charAt(idx))) continue;
                return false;
            } while (n < n2);
        }
        return true;
    }

    private final boolean compatibleRoots(PathString root1, PathString root2) {
        if (Intrinsics.areEqual((Object)root1, (Object)root2)) {
            return true;
        }
        if (root1 == null || root2 == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.driveName(root1.getRawPath()), (Object)this.driveName(root2.getRawPath()));
    }

    private final String driveName(String rawPath) {
        String string = rawPath;
        int n = 0;
        int n2 = PathStringUtil.countUntil$default(rawPath, ':', 0, false, 6, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
        return string5;
    }

    /*
     * WARNING - void declaration
     */
    private final PathString subRangeOrNull(int index, int length) {
        int n;
        int lengthCount;
        int subRangeStart;
        int n2;
        int n3;
        block14: {
            void $this$countUntil$iv;
            int n4;
            int n5;
            int n6;
            int n7;
            block13: {
                void $this$countUntil$iv2;
                if (index < 0 || length < 0) {
                    return null;
                }
                if (length == 0) {
                    return new PathString(this.filesystemUri, "");
                }
                int separatorCount = 0;
                IntProgression intProgression = (IntProgression)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
                n3 = this.startIndex;
                boolean $i$f$countUntil = false;
                int result$iv = 0;
                int n8 = $this$countUntil$iv2.getFirst();
                int n9 = $this$countUntil$iv2.getLast();
                n7 = $this$countUntil$iv2.getStep();
                if (n7 > 0 && n8 <= n9 || n7 < 0 && n9 <= n8) {
                    int item$iv;
                    do {
                        item$iv = n8;
                        n8 += n7;
                        int it = item$iv;
                        boolean bl = false;
                        if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                            n6 = separatorCount;
                            separatorCount = n6 + 1;
                        }
                        if (separatorCount >= index) {
                            n5 = result$iv;
                            break block13;
                        }
                        n4 = result$iv;
                        result$iv = n4 + 1;
                    } while (item$iv != n9);
                }
                n5 = result$iv;
            }
            n2 = n5;
            subRangeStart = n3 + n2;
            if (subRangeStart >= this.getEndIndex() - 1) {
                return null;
            }
            if (PathStringUtil.access$isSeparator(this.path.charAt(subRangeStart))) {
                int $this$countUntil$iv2 = subRangeStart;
                subRangeStart = $this$countUntil$iv2 + 1;
            }
            lengthCount = 0;
            IntProgression result$iv = (IntProgression)RangesKt.until((int)subRangeStart, (int)this.getEndIndex());
            n3 = subRangeStart;
            boolean $i$f$countUntil = false;
            int result$iv2 = 0;
            n7 = $this$countUntil$iv.getFirst();
            int n10 = $this$countUntil$iv.getLast();
            n4 = $this$countUntil$iv.getStep();
            if (n4 > 0 && n7 <= n10 || n4 < 0 && n10 <= n7) {
                int item$iv;
                do {
                    item$iv = n7;
                    n7 += n4;
                    int it = item$iv;
                    boolean bl = false;
                    if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                        int n11 = lengthCount;
                        lengthCount = n11 + 1;
                    }
                    if (lengthCount >= length) {
                        n = result$iv2;
                        break block14;
                    }
                    n6 = result$iv2;
                    result$iv2 = n6 + 1;
                } while (item$iv != n10);
            }
            n = result$iv2;
        }
        n2 = n;
        int subRangeEnd = n3 + n2;
        if (lengthCount < length - 1) {
            return null;
        }
        return new PathString(this.filesystemUri, this.path, subRangeStart, subRangeEnd, 0, this.separator);
    }

    static /* synthetic */ PathString subRangeOrNull$default(PathString pathString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return pathString.subRangeOrNull(n, n2);
    }

    private final PathString subRange(int index, int length) {
        PathString pathString = this.subRangeOrNull(index, length);
        if (pathString == null) {
            throw new IllegalArgumentException("beginIndex " + index + " and suffixEndIndex " + (index + length) + " are out of range for path " + this);
        }
        return pathString;
    }

    static /* synthetic */ PathString subRange$default(PathString pathString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return pathString.subRange(n, n2);
    }

    private final int getEndIndex() {
        return this.hasTrailingSeparator() ? this.suffixEndIndex - 1 : this.suffixEndIndex;
    }

    /*
     * WARNING - void declaration
     */
    private final int computeNameStart(int end) {
        int n;
        int n2;
        block3: {
            void $this$countUntil$iv;
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)this.startIndex, (int)end)));
            n2 = end;
            boolean $i$f$countUntil = false;
            int result$iv = 0;
            int n3 = $this$countUntil$iv.getFirst();
            int n4 = $this$countUntil$iv.getLast();
            int n5 = $this$countUntil$iv.getStep();
            if (n5 > 0 && n3 <= n4 || n5 < 0 && n4 <= n3) {
                int item$iv;
                do {
                    item$iv = n3;
                    n3 += n5;
                    int it = item$iv;
                    boolean bl = false;
                    if (PathStringUtil.access$isSeparator(this.path.charAt(it))) {
                        n = result$iv;
                        break block3;
                    }
                    int n6 = result$iv;
                    result$iv = n6 + 1;
                } while (item$iv != n4);
            }
            n = result$iv;
        }
        int n7 = n;
        return n2 - n7;
    }
}

