/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.automotiveMessagingService.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"messageReplyReceiverKt", "", "kotlinEscapedPackageName", "replyReceiverName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class MessageReplyReceiverKtKt {
    @NotNull
    public static final String messageReplyReceiverKt(@NotNull String kotlinEscapedPackageName, @NotNull String replyReceiverName, boolean useAndroidX) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinEscapedPackageName, (String)"kotlinEscapedPackageName");
        Intrinsics.checkParameterIsNotNull((Object)replyReceiverName, (String)"replyReceiverName");
        return "\npackage " + kotlinEscapedPackageName + "\n\nimport android.content.BroadcastReceiver\nimport android.content.Context\nimport android.content.Intent\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.RemoteInput", useAndroidX) + "\nimport android.util.Log\n\nprivate const val TAG = \"" + StringsKt.take((String)replyReceiverName, (int)23) + "\"\n\n/**\n * A receiver that gets called when a reply is sent to a given conversationId\n */\nclass " + replyReceiverName + " : BroadcastReceiver() {\n\n    override fun onReceive(context: Context, intent: Intent) {\n        if (REPLY_ACTION == intent.action) {\n            val conversationId = intent.getIntExtra(CONVERSATION_ID, -1)\n            val reply = getMessageText(intent)\n            Log.d(TAG, \"Got reply ($reply) for ConversationId $conversationId\")\n        }\n    }\n\n    /**\n     * Get the message text from the intent.\n     * Note that you should call `RemoteInput#getResultsFromIntent(intent)` to process\n     * the RemoteInput.\n     */\n    private fun getMessageText(intent: Intent): CharSequence? {\n        val remoteInput = RemoteInput.getResultsFromIntent(intent)\n        return remoteInput?.getCharSequence(EXTRA_VOICE_REPLY)\n    }\n}\n";
    }
}

