/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.action.GradleRerunFailedTestsAction;
import org.jetbrains.plugins.gradle.execution.filters.ReRunTaskFilter;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestEventsProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsoleOutputProcessor;
import org.jetbrains.plugins.gradle.service.project.GradleTasksIndices;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleTaskData;

public class GradleTestsExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<GradleTestsExecutionConsole, ProcessHandler> {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(0);
        }
        return projectSystemId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public GradleTestsExecutionConsole attachExecutionConsole(final @NotNull Project project, final @NotNull ExternalSystemTask task, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler) {
        TestTreeRenderer originalRenderer;
        RunConfiguration configuration;
        if (project == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(1);
        }
        if (task == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(2);
        }
        if (env == null) {
            return null;
        }
        SMTRunnerConsoleProperties consoleProperties = null;
        RunnerAndConfigurationSettings settings = env.getRunnerAndConfigurationSettings();
        if (settings == null) {
            RunProfile runProfile = env.getRunProfile();
            if (!(runProfile instanceof AbstractImportTestsAction.ImportRunProfile)) return null;
            configuration = ((AbstractImportTestsAction.ImportRunProfile)runProfile).getInitialConfiguration();
            if (configuration instanceof SMRunnerConsolePropertiesProvider) {
                consoleProperties = ((SMRunnerConsolePropertiesProvider)configuration).createTestConsoleProperties(DefaultRunExecutor.getRunExecutorInstance());
            }
        } else {
            configuration = settings.getConfiguration();
        }
        if (!(configuration instanceof ExternalSystemRunConfiguration)) {
            return null;
        }
        ExternalSystemRunConfiguration externalSystemRunConfiguration = (ExternalSystemRunConfiguration)configuration;
        if (consoleProperties == null) {
            consoleProperties = new GradleConsoleProperties(externalSystemRunConfiguration, env.getExecutor());
        }
        String testFrameworkName = externalSystemRunConfiguration.getSettings().getExternalSystemId().getReadableName();
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName((String)testFrameworkName);
        GradleTestsExecutionConsole consoleView = new GradleTestsExecutionConsole(project, task.getId(), (TestConsoleProperties)consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView, (String)testFrameworkName);
        final SMTestRunnerResultsForm resultsViewer = consoleView.getResultsViewer();
        TestTreeView testTreeView = resultsViewer.getTreeView();
        if (testTreeView != null && (originalRenderer = (TestTreeRenderer)ObjectUtils.tryCast((Object)testTreeView.getCellRenderer(), TestTreeRenderer.class)) != null) {
            originalRenderer.setAdditionalRootFormatter(new SMRootTestProxyFormatter(){

                public void format(@NotNull SMTestProxy.SMRootTestProxy testProxy, @NotNull TestTreeRenderer renderer) {
                    if (testProxy == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (renderer == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!testProxy.isInProgress() && testProxy.isEmptySuite()) {
                        renderer.clear();
                        renderer.append(GradleBundle.message((String)"gradle.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "testProxy";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "renderer";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleManager$1";
                    objectArray[2] = "format";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        final SMTestProxy.SMRootTestProxy testsRootNode = resultsViewer.getTestsRootNode();
        testsRootNode.setExecutionId(env.getExecutionId());
        testsRootNode.setSuiteStarted();
        consoleView.getEventPublisher().onTestingStarted(testsRootNode);
        if (processHandler != null) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (testsRootNode.isInProgress()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (event.getExitCode() == 1) {
                                testsRootNode.setTestFailed("", null, false);
                            } else {
                                testsRootNode.setFinished();
                            }
                            resultsViewer.onBeforeTestingFinished(testsRootNode);
                            resultsViewer.onTestingFinished(testsRootNode);
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleManager$2", "processTerminated"));
                }
            });
        }
        if (task instanceof ExternalSystemExecuteTaskTask) {
            consoleView.addMessageFilter((Filter)new ReRunTaskFilter((ExternalSystemExecuteTaskTask)task, env));
        }
        final Disposable disposable = Disposer.newDisposable((Disposable)consoleView, (String)"Gradle test runner build event listener disposable");
        final BuildViewManager buildViewManager = (BuildViewManager)project.getService(BuildViewManager.class);
        ((ExternalSystemRunConfigurationViewManager)project.getService(ExternalSystemRunConfigurationViewManager.class)).addListener(new BuildProgressListener(){

            public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
                if (buildId == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (buildId != task.getId()) {
                    return;
                }
                if (event instanceof FinishBuildEvent) {
                    Disposer.dispose((Disposable)disposable);
                } else if (event instanceof StartBuildEvent) {
                    BuildDescriptor buildDescriptor = ((StartBuildEvent)event).getBuildDescriptor();
                    DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor(buildDescriptor.getId(), buildDescriptor.getTitle(), buildDescriptor.getWorkingDir(), buildDescriptor.getStartTime());
                    defaultBuildDescriptor.setActivateToolWindowWhenFailed(false);
                    event = new StartBuildEventImpl((BuildDescriptor)defaultBuildDescriptor, event.getMessage());
                }
                buildViewManager.onEvent(buildId, event);
                if (event instanceof StartEvent) {
                    ProgressBuildEventImpl progressBuildEvent = new ProgressBuildEventImpl(event.getId(), event.getParentId(), event.getEventTime(), event.getMessage(), -1L, -1L, "");
                    progressBuildEvent.setHint("- " + GradleBundle.message((String)"gradle.test.runner.build.tw.link.title", (Object[])new Object[0]));
                    buildViewManager.onEvent(buildId, (BuildEvent)progressBuildEvent);
                }
                GradleTestsExecutionConsoleManager.maybeOpenBuildToolWindow(event, project, testsRootNode);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "buildId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleManager$3";
                objectArray[2] = "onEvent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
        return consoleView;
    }

    private static void maybeOpenBuildToolWindow(@NotNull BuildEvent event, @NotNull Project project, @NotNull SMTestProxy.SMRootTestProxy testsRootNode) {
        EventResult buildResult;
        if (event == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(4);
        }
        if (testsRootNode == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(5);
        }
        if (event instanceof FileMessageEvent && ((FileMessageEvent)event).getKind() == MessageEvent.Kind.ERROR) {
            GradleTestsExecutionConsoleManager.openBuildToolWindow(project);
            return;
        }
        if (event instanceof FinishBuildEvent && (buildResult = ((FinishBuildEvent)event).getResult()) instanceof FailureResult) {
            if (!((FailureResult)buildResult).getFailures().isEmpty()) {
                GradleTestsExecutionConsoleManager.openBuildToolWindow(project);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!testsRootNode.isInProgress() && testsRootNode.isEmptySuite()) {
                        GradleTestsExecutionConsoleManager.openBuildToolWindow(project);
                    }
                });
            }
        }
    }

    private static void openBuildToolWindow(@NotNull Project project) {
        if (project == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow toolWindow = BuildContentManager.getInstance((Project)project).getOrCreateToolWindow();
            if (toolWindow.isAvailable() && !toolWindow.isVisible()) {
                toolWindow.show(null);
            }
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    public void onOutput(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull ProcessHandler processHandler, @NotNull String text, @NotNull Key processOutputType) {
        if (executionConsole == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(7);
        }
        if (processHandler == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(8);
        }
        if (text == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(9);
        }
        if (processOutputType == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(10);
        }
        GradleTestsExecutionConsoleOutputProcessor.onOutput(executionConsole, text, processOutputType);
    }

    public void onStatusChange(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull ExternalSystemTaskNotificationEvent event) {
        ExternalSystemProgressEvent progressEvent;
        OperationDescriptor descriptor;
        if (executionConsole == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(11);
        }
        if (event == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(12);
        }
        if (event instanceof ExternalSystemTaskExecutionEvent && (descriptor = (progressEvent = ((ExternalSystemTaskExecutionEvent)event).getProgressEvent()).getDescriptor()) instanceof TestOperationDescriptor) {
            GradleTestEventsProcessor.onStatusChange(executionConsole, (ExternalSystemProgressEvent<? extends TestOperationDescriptor>)progressEvent);
        }
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        ExternalSystemExecuteTaskTask taskTask;
        if (task == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(13);
        }
        if (task instanceof ExternalSystemExecuteTaskTask && StringUtil.equals((CharSequence)(taskTask = (ExternalSystemExecuteTaskTask)task).getExternalSystemId().getId(), (CharSequence)GradleConstants.SYSTEM_ID.getId()) && (GradleTestsExecutionConsoleManager.hasTestOption(taskTask) || GradleTestsExecutionConsoleManager.hasTestTasks(taskTask))) {
            taskTask.putUserData(GradleConstants.RUN_TASK_AS_TEST, (Object)true);
            return true;
        }
        return false;
    }

    private static boolean hasTestOption(@NotNull ExternalSystemExecuteTaskTask task) {
        if (task == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(14);
        }
        String options = task.getArguments();
        List tasksAndArguments = task.getTasksToExecute();
        return options != null && StringUtil.contains((CharSequence)options, (CharSequence)"--tests") || tasksAndArguments.contains("--tests");
    }

    private static boolean hasTestTasks(@NotNull ExternalSystemExecuteTaskTask task) {
        if (task == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(15);
        }
        String modulePath = GradleTestsExecutionConsoleManager.getModulePath(task);
        List tasksAndArguments = task.getTasksToExecute();
        GradleTasksIndices tasksIndices = GradleTasksIndices.getInstance((Project)task.getIdeProject());
        List tasks = tasksIndices.findTasks(modulePath, tasksAndArguments);
        return ContainerUtil.or((Iterable)tasks, it -> GradleTestsExecutionConsoleManager.isTestTask(it));
    }

    private static boolean isTestTask(@Nullable GradleTaskData task) {
        return task != null && (task.isTest() || "check".equals(task.getName()) && "verification".equals(task.getGroup()));
    }

    @NotNull
    private static String getModulePath(@NotNull ExternalSystemExecuteTaskTask task) {
        String externalProjectPath;
        File file;
        if (task == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(16);
        }
        if ((file = new File(externalProjectPath = task.getExternalProjectPath())).isFile()) {
            String string = StringUtil.trimEnd((String)externalProjectPath, (String)("/" + file.getName()));
            if (string == null) {
                GradleTestsExecutionConsoleManager.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = externalProjectPath;
        if (string == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(18);
        }
        return string;
    }

    public AnAction[] getRestartActions(@NotNull GradleTestsExecutionConsole consoleView) {
        if (consoleView == null) {
            GradleTestsExecutionConsoleManager.$$$reportNull$$$0(19);
        }
        GradleRerunFailedTestsAction rerunFailedTestsAction = new GradleRerunFailedTestsAction(consoleView);
        rerunFailedTestsAction.setModelProvider(() -> consoleView.getResultsViewer());
        return new AnAction[]{rerunFailedTestsAction};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleManager";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRootNode";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutputType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestsExecutionConsoleManager";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attachExecutionConsole";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "maybeOpenBuildToolWindow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openBuildToolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onOutput";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onStatusChange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasTestOption";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasTestTasks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModulePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRestartActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

