/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KDateSpan;
import circlet.platform.api.KDateTime;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import runtime.date.DateFormat;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010\u001f\u001a\u0016\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b\u001a\u0016\u0010#\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b\u001a\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001cH\u0002\u001a\u0012\u0010&\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010%\u001a\u00020\u001c\u001a\u0012\u0010'\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010(\u001a\u00020\u001c\u001a\u0016\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0**\u00020\u001c\u001a\u0015\u0010+\u001a\u00020\u001c*\u00020\u000b2\u0006\u0010,\u001a\u00020\u000bH\u0086\u0002\u001a\u000e\u0010\u001d\u001a\u00020\u001e*\u00060-j\u0002`.\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u000b\u001a\u0016\u0010/\u001a\u00020\t*\u00060-j\u0002`.2\u0006\u0010/\u001a\u000200\u001a\u0016\u0010/\u001a\u00020\t*\u000601j\u0002`22\u0006\u0010/\u001a\u000200\u001a\u0012\u0010/\u001a\u00020\t*\u00020\u000b2\u0006\u0010/\u001a\u000200\u001a\u001a\u00103\u001a\u00020\u0013*\u00060-j\u0002`.2\n\u00104\u001a\u00060-j\u0002`.\u001a\u0012\u00103\u001a\u00020\u0013*\u00020\u000b2\u0006\u00104\u001a\u00020\u000b\u001a\u001a\u00105\u001a\u00020\u0013*\u00060-j\u0002`.2\n\u00104\u001a\u00060-j\u0002`.\u001a\u0012\u00105\u001a\u00020\u0013*\u00020\u000b2\u0006\u00104\u001a\u00020\u000b\u001a\u0012\u00106\u001a\u00020\u0013*\u00020\u000b2\u0006\u00104\u001a\u00020\u000b\u001a\u000e\u00107\u001a\u000208*\u00060-j\u0002`.\u001a\u0012\u00109\u001a\u0004\u0018\u00010\u000b*\b\u0012\u0004\u0012\u00020\u000b0:\u001a\u0015\u0010;\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010<\u001a\u00020=H\u0086\u0006\u001a\n\u0010>\u001a\u00020\u001c*\u00020\u000b\u001a\u0015\u0010?\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010<\u001a\u00020=H\u0086\u0006\u001a\u0012\u0010@\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010%\u001a\u00020\u001c\u001a\u0012\u0010A\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010(\u001a\u00020\u001c\u001a\n\u0010B\u001a\u00020\u000b*\u00020\u000f\u001a\n\u0010B\u001a\u00020\u000b*\u00020C\u001a\n\u0010B\u001a\u00020\u000b*\u00020\u001e\u001a\n\u0010$\u001a\u00020\u001c*\u00020\u000b\u001a\u001c\u0010$\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010%\u001a\u00020\u001c2\b\b\u0002\u0010D\u001a\u00020\u0013\u001a\n\u0010$\u001a\u00020\u001c*\u00020\u001e\"\u001c\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0016\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0006\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0004\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u000f*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\u000b*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006E"}, d2={"DEFAULT_DATE_FORMAT", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDEFAULT_DATE_FORMAT", "()Lorg/joda/time/format/DateTimeFormatter;", "DEFAULT_DATE_TIME_FORMAT", "DEFAULT_DATE_TIME_FORMAT_NO_TZ", "getDEFAULT_DATE_TIME_FORMAT_NO_TZ", "ZERO_TIME", "", "now", "Lcirclet/platform/api/KDateTime;", "getNow", "()Lcirclet/platform/api/KDateTime;", "nowMs", "", "getNowMs", "()J", "isValid", "", "(Lcirclet/platform/api/KDateTime;)Z", "millis", "getMillis", "(Lcirclet/platform/api/KDateTime;)J", "startOfDay", "getStartOfDay", "(Lcirclet/platform/api/KDateTime;)Lcirclet/platform/api/KDateTime;", "dayEncoded", "", "dateTime", "Lorg/joda/time/DateTime;", "(Lorg/joda/time/DateTime;)Ljava/lang/Integer;", "maxOf", "a", "b", "minOf", "utcOffset", "minutes", "addMinutes", "addSeconds", "seconds", "birthDayDecode", "Lkotlin/Pair;", "compareTo", "another", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "format", "Lruntime/date/DateFormat;", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "isAfter", "other", "isBefore", "isSame", "localDate", "Lorg/joda/time/LocalDate;", "max", "", "minus", "span", "Lcirclet/platform/api/KDateSpan;", "minutesOfDay", "plus", "subtractMinutes", "subtractSeconds", "toKDateTime", "Lkotlinx/datetime/Instant;", "keepLocalTime", "platform-api"})
public final class PrimitivesExKt {
    private static final DateTimeFormatter DEFAULT_DATE_FORMAT = ISODateTimeFormat.date();
    private static final DateTimeFormatter DEFAULT_DATE_TIME_FORMAT_NO_TZ = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter DEFAULT_DATE_TIME_FORMAT = ISODateTimeFormat.dateTime();
    @NotNull
    private static final String ZERO_TIME = "1970-01-01T00:00:00+00:00";

    public static final DateTimeFormatter getDEFAULT_DATE_FORMAT() {
        return DEFAULT_DATE_FORMAT;
    }

    public static final DateTimeFormatter getDEFAULT_DATE_TIME_FORMAT_NO_TZ() {
        return DEFAULT_DATE_TIME_FORMAT_NO_TZ;
    }

    @NotNull
    public static final KDateTime getNow() {
        String string2 = DEFAULT_DATE_TIME_FORMAT.print(DateTime.now());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEFAULT_DATE_TIME_FORMAT.print(DateTime.now())");
        return new KDateTime(string2);
    }

    public static final long getNowMs() {
        return DateTime.now().getMillis();
    }

    @NotNull
    public static final LocalDate localDate(@NotNull KotlinXDate $this$localDate) {
        Intrinsics.checkNotNullParameter((Object)$this$localDate, (String)"<this>");
        LocalDate localDate = LocalDate.parse(ADateJvmKt.getInternal($this$localDate));
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(this.internal)");
        return localDate;
    }

    @NotNull
    public static final DateTime dateTime(@NotNull KDateTime $this$dateTime) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$dateTime, (String)"<this>");
        String it = string2 = $this$dateTime.getValue();
        boolean bl = false;
        String string3 = ((CharSequence)it).length() > 0 ? string2 : null;
        if (string3 == null) {
            string3 = ZERO_TIME;
        }
        DateTime dateTime2 = DateTime.parse(string3);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"parse(this.value.takeIf \u2026otEmpty() } ?: ZERO_TIME)");
        return dateTime2;
    }

    @NotNull
    public static final DateTime dateTime(@NotNull KotlinXDate $this$dateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$dateTime, (String)"<this>");
        DateTime dateTime2 = DateTime.parse(ADateJvmKt.getInternal($this$dateTime), ISODateTimeFormat.dateTimeParser());
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"parse(this.internal, ISO\u2026eFormat.dateTimeParser())");
        return dateTime2;
    }

    @NotNull
    public static final KDateTime toKDateTime(@NotNull DateTime $this$toKDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toKDateTime, (String)"<this>");
        String string2 = DEFAULT_DATE_TIME_FORMAT.print($this$toKDateTime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEFAULT_DATE_TIME_FORMAT.print(this)");
        return new KDateTime(string2);
    }

    @NotNull
    public static final KDateTime toKDateTime(@NotNull Instant $this$toKDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toKDateTime, (String)"<this>");
        return new KDateTime($this$toKDateTime.toString());
    }

    @NotNull
    public static final KDateTime toKDateTime(long $this$toKDateTime) {
        return PrimitivesExKt.toKDateTime(new DateTime($this$toKDateTime));
    }

    public static final boolean isBefore(@NotNull KotlinXDate $this$isBefore, @NotNull KotlinXDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$isBefore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$isBefore.getDate().compareTo(other.getDate()) < 0;
    }

    public static final boolean isAfter(@NotNull KotlinXDate $this$isAfter, @NotNull KotlinXDate other) {
        Intrinsics.checkNotNullParameter((Object)$this$isAfter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$isAfter.getDate().compareTo(other.getDate()) > 0;
    }

    @NotNull
    public static final String format(@NotNull KotlinXDate $this$format, @NotNull DateFormat format2) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)format2), (String)"format");
        String string2 = format2.getJavaFormatter().format(ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)$this$format.getDate()));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.javaFormatter.for\u2026t(date.toJavaLocalDate())");
        return string2;
    }

    @NotNull
    public static final KDateTime getStartOfDay(@NotNull KDateTime $this$startOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$startOfDay, (String)"<this>");
        DateTime dateTime2 = PrimitivesExKt.dateTime($this$startOfDay).withHourOfDay(0).withMinuteOfHour(0);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime().withHourOfDay(0).withMinuteOfHour(0)");
        return PrimitivesExKt.toKDateTime(dateTime2);
    }

    @NotNull
    public static final String format(@NotNull KDateTime $this$format, @NotNull DateFormat format2) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)format2), (String)"format");
        String string2 = format2.getJodaTimeFormatter().print(PrimitivesExKt.dateTime($this$format));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.jodaTimeFormatter.print(this.dateTime())");
        return string2;
    }

    @NotNull
    public static final String format(@NotNull KotlinXDateTime $this$format, @NotNull DateFormat format2) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)format2), (String)"format");
        String string2 = format2.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)$this$format.getDateTime()));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.javaFormatter.for\u2026me.toJavaLocalDateTime())");
        return string2;
    }

    public static final boolean isBefore(@NotNull KDateTime $this$isBefore, @NotNull KDateTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$isBefore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return PrimitivesExKt.dateTime($this$isBefore).isBefore(PrimitivesExKt.dateTime(other));
    }

    public static final boolean isAfter(@NotNull KDateTime $this$isAfter, @NotNull KDateTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$isAfter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return PrimitivesExKt.dateTime($this$isAfter).isAfter(PrimitivesExKt.dateTime(other));
    }

    public static final boolean isSame(@NotNull KDateTime $this$isSame, @NotNull KDateTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$isSame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return PrimitivesExKt.dateTime($this$isSame).isEqual(PrimitivesExKt.dateTime(other));
    }

    @Nullable
    public static final KDateTime max(@NotNull List<KDateTime> $this$max) {
        Object v0;
        Intrinsics.checkNotNullParameter($this$max, (String)"<this>");
        Iterable $this$maxByOrNull$iv = $this$max;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                KDateTime it = (KDateTime)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = PrimitivesExKt.dateTime(it);
                do {
                    Object e$iv = iterator$iv.next();
                    KDateTime it2 = (KDateTime)e$iv;
                    $i$a$-maxByOrNull-PrimitivesExKt$max$1 = false;
                    Comparable v$iv = PrimitivesExKt.dateTime(it2);
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    @NotNull
    public static final KDateTime minOf(@NotNull KDateTime a, @NotNull KDateTime b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return PrimitivesExKt.isBefore(a, b) ? a : b;
    }

    @NotNull
    public static final KDateTime maxOf(@NotNull KDateTime a, @NotNull KDateTime b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return PrimitivesExKt.isAfter(a, b) ? a : b;
    }

    @NotNull
    public static final KDateTime plus(@NotNull KDateTime $this$plus, @NotNull KDateSpan span) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        DateTime dateTime2 = PrimitivesExKt.dateTime($this$plus).plusMonths(span.getMonths()).plusDays(span.getDays());
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime().plusMonths(sp\u2026nths).plusDays(span.days)");
        return PrimitivesExKt.toKDateTime(dateTime2);
    }

    @NotNull
    public static final KDateTime minus(@NotNull KDateTime $this$minus, @NotNull KDateSpan span) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        DateTime dateTime2 = PrimitivesExKt.dateTime($this$minus).minusMonths(span.getMonths()).minusDays(span.getDays());
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"dateTime().minusMonths(s\u2026ths).minusDays(span.days)");
        return PrimitivesExKt.toKDateTime(dateTime2);
    }

    @Nullable
    public static final Integer dayEncoded(@Nullable DateTime dateTime2) {
        Integer n;
        DateTime dateTime3 = dateTime2;
        if (dateTime3 == null) {
            n = null;
        } else {
            DateTime it = dateTime3;
            boolean bl = false;
            n = (it.getMonthOfYear() - 1) * 31 + it.getDayOfMonth();
        }
        return n;
    }

    @NotNull
    public static final Pair<Integer, Integer> birthDayDecode(int $this$birthDayDecode) {
        return $this$birthDayDecode % 31 == 0 ? new Pair((Object)($this$birthDayDecode / 31), (Object)31) : new Pair((Object)($this$birthDayDecode / 31 + 1), (Object)($this$birthDayDecode % 31));
    }

    public static final int compareTo(@NotNull KDateTime $this$compareTo, @NotNull KDateTime another) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return PrimitivesExKt.dateTime($this$compareTo).compareTo(PrimitivesExKt.dateTime(another));
    }

    public static final long getMillis(@NotNull KDateTime $this$millis) {
        Intrinsics.checkNotNullParameter((Object)$this$millis, (String)"<this>");
        return PrimitivesExKt.dateTime($this$millis).getMillis();
    }

    public static final int utcOffset(@NotNull KDateTime $this$utcOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$utcOffset, (String)"<this>");
        return PrimitivesExKt.utcOffset(PrimitivesExKt.dateTime($this$utcOffset));
    }

    public static final int utcOffset(@NotNull DateTime $this$utcOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$utcOffset, (String)"<this>");
        int offset = $this$utcOffset.getZone().getOffset($this$utcOffset.getMillis());
        return (int)TimeUnit.MILLISECONDS.toMinutes(offset);
    }

    @NotNull
    public static final KDateTime utcOffset(@NotNull KDateTime $this$utcOffset, int minutes, boolean keepLocalTime) {
        Intrinsics.checkNotNullParameter((Object)$this$utcOffset, (String)"<this>");
        DateTime value2 = !keepLocalTime ? PrimitivesExKt.dateTime($this$utcOffset) : PrimitivesExKt.dateTime($this$utcOffset).plusMinutes(PrimitivesExKt.utcOffset($this$utcOffset) - minutes);
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
        return PrimitivesExKt.toKDateTime(PrimitivesExKt.utcOffset(value2, minutes));
    }

    public static /* synthetic */ KDateTime utcOffset$default(KDateTime kDateTime, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return PrimitivesExKt.utcOffset(kDateTime, n, bl);
    }

    private static final DateTime utcOffset(DateTime dateTime2, int minutes) {
        DateTimeZone tz = DateTimeZone.forOffsetMillis(minutes * 60 * 1000);
        DateTime dateTime3 = dateTime2.withZone(tz);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime3, (String)"dateTime.withZone(tz)");
        return dateTime3;
    }

    @NotNull
    public static final KDateTime addMinutes(@NotNull KDateTime $this$addMinutes, int minutes) {
        Intrinsics.checkNotNullParameter((Object)$this$addMinutes, (String)"<this>");
        DateTime dateTime2 = PrimitivesExKt.dateTime($this$addMinutes).plusMinutes(minutes);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"this.dateTime().plusMinutes(minutes)");
        return PrimitivesExKt.toKDateTime(dateTime2);
    }

    @NotNull
    public static final KDateTime subtractMinutes(@NotNull KDateTime $this$subtractMinutes, int minutes) {
        Intrinsics.checkNotNullParameter((Object)$this$subtractMinutes, (String)"<this>");
        return PrimitivesExKt.addMinutes($this$subtractMinutes, -minutes);
    }

    @NotNull
    public static final KDateTime addSeconds(@NotNull KDateTime $this$addSeconds, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$addSeconds, (String)"<this>");
        DateTime dateTime2 = PrimitivesExKt.dateTime($this$addSeconds).plusSeconds(seconds);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"this.dateTime().plusSeconds(seconds)");
        return PrimitivesExKt.toKDateTime(dateTime2);
    }

    @NotNull
    public static final KDateTime subtractSeconds(@NotNull KDateTime $this$subtractSeconds, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$subtractSeconds, (String)"<this>");
        DateTime dateTime2 = PrimitivesExKt.dateTime($this$subtractSeconds).minusSeconds(seconds);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"this.dateTime().minusSeconds(seconds)");
        return PrimitivesExKt.toKDateTime(dateTime2);
    }

    public static final boolean isValid(@NotNull KDateTime $this$isValid) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        try {
            PrimitivesExKt.dateTime($this$isValid);
            bl = true;
        }
        catch (IllegalArgumentException e) {
            bl = false;
        }
        return bl;
    }

    public static final int minutesOfDay(@NotNull KDateTime $this$minutesOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$minutesOfDay, (String)"<this>");
        DateTime dt = PrimitivesExKt.dateTime($this$minutesOfDay);
        return dt.getMinuteOfDay();
    }
}

