/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.kotlin;

import circlet.pipelines.config.ivy.resolver.AutomationResolverKt;
import circlet.pipelines.config.utils.AutomationArtifactsLocation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.kotlin.SpaceKtsRuntimeJarsLoader;
import com.intellij.space.kotlin.messages.SpaceKotlinBundle;
import com.intellij.space.kotlin.scriptdefinition.ProjectScriptCompilationConfigurationKt;
import com.intellij.space.settings.SpaceLoginState;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptDiagnostic;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005J\u0014\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0007J\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/space/kotlin/SpaceKtsRuntimeJarsLoader;", "", "()V", "lastLoadingResult", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "", "Ljava/io/File;", "getCurrentCurrentResult", "loadSpaceKtsRuntimeJar", "loadSpaceKtsRuntimeJarImpl", "Companion", "intellij.space.kotlin"})
public final class SpaceKtsRuntimeJarsLoader {
    private final AtomicReference<ResultWithDiagnostics<List<File>>> lastLoadingResult = new AtomicReference();
    public static final int AUTH_ERROR_CODE = 4;
    public static final int DEPENDENCIES_LOADING_ERROR_CODE = 5;
    public static final int DEPENDENCIES_NOT_LOADED_ERROR_CODE = 6;
    public static final int CONNECTING_TO_SPACE_ERROR_CODE = 7;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ResultWithDiagnostics<List<File>> getCurrentCurrentResult() {
        ResultWithDiagnostics resultWithDiagnostics;
        ResultWithDiagnostics<List<File>> currentLoadLoadingResult = this.lastLoadingResult.get();
        if (currentLoadLoadingResult != null) {
            return currentLoadLoadingResult;
        }
        SpaceLoginState spaceLoginState = SpaceWorkspaceComponent.Companion.getInstance().getLoginState().getValue();
        if (spaceLoginState instanceof SpaceLoginState.Connected) {
            resultWithDiagnostics = (ResultWithDiagnostics)SpaceKtsRuntimeJarsLoader.Companion.getDEPENDENCIES_NOT_LOADED_ERROR();
        } else if (spaceLoginState instanceof SpaceLoginState.Connecting) {
            resultWithDiagnostics = (ResultWithDiagnostics)SpaceKtsRuntimeJarsLoader.Companion.getCONNECTING_TO_SPACE_ERROR();
        } else if (spaceLoginState instanceof SpaceLoginState.Disconnected) {
            resultWithDiagnostics = (ResultWithDiagnostics)SpaceKtsRuntimeJarsLoader.Companion.getAUTH_ERROR();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resultWithDiagnostics;
    }

    @RequiresBackgroundThread
    @NotNull
    public final ResultWithDiagnostics<List<File>> loadSpaceKtsRuntimeJar() {
        ResultWithDiagnostics<List<File>> result2 = this.loadSpaceKtsRuntimeJarImpl();
        this.lastLoadingResult.set(result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final ResultWithDiagnostics<List<File>> loadSpaceKtsRuntimeJarImpl() {
        void cancellable$iv;
        void title$iv;
        void project$iv;
        AutomationArtifactsLocation artifactsLocation2 = (AutomationArtifactsLocation)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)loadSpaceKtsRuntimeJarImpl.artifactsLocation.1.INSTANCE, (int)1, null);
        if (artifactsLocation2 == null) {
            LOG.info("[space-kts] User not logged in to Space, cannot fetch Automation runtime");
            return (ResultWithDiagnostics)SpaceKtsRuntimeJarsLoader.Companion.getAUTH_ERROR();
        }
        CompletableFuture result2 = new CompletableFuture();
        Object var3_3 = null;
        String string2 = SpaceKotlinBundle.message("space.kts.loading.jars.indicator.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceKotlinBundle.messag\u2026ng.jars.indicator.title\")");
        String string3 = string2;
        boolean bl = false;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, (boolean)cancellable$iv, (Project)project$iv, (String)title$iv, (boolean)cancellable$iv, artifactsLocation2, result2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ AutomationArtifactsLocation $artifactsLocation$inlined;
            final /* synthetic */ CompletableFuture $result$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$artifactsLocation$inlined = automationArtifactsLocation;
                this.$result$inlined = completableFuture;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$onFailure$iv;
                ResultWithDiagnostics resultWithDiagnostics;
                void $this$onSuccess$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                ResultWithDiagnostics<List<File>> resultWithDiagnostics2 = ProjectScriptCompilationConfigurationKt.resolveScriptArtifact(AutomationResolverKt.getIvyResolver(this.$artifactsLocation$inlined), "com.jetbrains", "space-automation-runtime", "latest.integration");
                boolean $i$f$onSuccess = false;
                void var6_6 = $this$onSuccess$iv;
                if (var6_6 instanceof ResultWithDiagnostics.Success) {
                    void jars;
                    List list2 = (List)((ResultWithDiagnostics.Success)$this$onSuccess$iv).getValue();
                    List list3 = $this$onSuccess$iv.getReports();
                    boolean bl2 = false;
                    SpaceKtsRuntimeJarsLoader.access$getLOG$cp().info("[space-kts] Successfully resolved space-automation-runtime");
                    ResultWithDiagnostics resultWithDiagnostics3 = (ResultWithDiagnostics)ErrorHandlingKt.asSuccess$default((Object)jars, null, (int)1, null);
                    resultWithDiagnostics = ErrorHandlingKt.plus((List)list3, (ResultWithDiagnostics)resultWithDiagnostics3);
                } else if (var6_6 instanceof ResultWithDiagnostics.Failure) {
                    resultWithDiagnostics = $this$onSuccess$iv;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                $this$onSuccess$iv = resultWithDiagnostics;
                boolean $i$f$onFailure = false;
                if ($this$onFailure$iv instanceof ResultWithDiagnostics.Failure) {
                    void diagnostics = $this$onFailure$iv;
                    boolean bl3 = false;
                    SpaceKtsRuntimeJarsLoader.access$getLOG$cp().info("[space-kts] Failure while downloading dependencies for .space.kts file: " + (ResultWithDiagnostics)diagnostics);
                    com.intellij.space.kotlin.SpaceKtsRuntimeJarsLoader$Companion.access$getDEPENDENCIES_LOADING_ERROR$p(SpaceKtsRuntimeJarsLoader.Companion);
                }
                void resolveResult = $this$onFailure$iv;
                this.$result$inlined.complete(resolveResult);
            }
        });
        Object t = result2.join();
        Intrinsics.checkNotNullExpressionValue(t, (String)"result.join()");
        return (ResultWithDiagnostics)t;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(SpaceKtsRuntimeJarsLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        LOG = logger2;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/space/kotlin/SpaceKtsRuntimeJarsLoader$Companion;", "", "()V", "AUTH_ERROR", "Lkotlin/script/experimental/api/ResultWithDiagnostics$Failure;", "getAUTH_ERROR", "()Lkotlin/script/experimental/api/ResultWithDiagnostics$Failure;", "AUTH_ERROR_CODE", "", "CONNECTING_TO_SPACE_ERROR", "getCONNECTING_TO_SPACE_ERROR", "CONNECTING_TO_SPACE_ERROR_CODE", "DEPENDENCIES_LOADING_ERROR", "getDEPENDENCIES_LOADING_ERROR", "DEPENDENCIES_LOADING_ERROR_CODE", "DEPENDENCIES_NOT_LOADED_ERROR", "getDEPENDENCIES_NOT_LOADED_ERROR", "DEPENDENCIES_NOT_LOADED_ERROR_CODE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/space/kotlin/SpaceKtsRuntimeJarsLoader;", "intellij.space.kotlin"})
    public static final class Companion {
        private final ResultWithDiagnostics.Failure getAUTH_ERROR() {
            ScriptDiagnostic[] scriptDiagnosticArray = new ScriptDiagnostic[1];
            String string2 = SpaceKotlinBundle.message("kts.file.login.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceKotlinBundle.message(\"kts.file.login.error\")");
            scriptDiagnosticArray[0] = new ScriptDiagnostic(4, string2, null, null, null, null, 60, null);
            return new ResultWithDiagnostics.Failure(scriptDiagnosticArray);
        }

        private final ResultWithDiagnostics.Failure getDEPENDENCIES_LOADING_ERROR() {
            ScriptDiagnostic[] scriptDiagnosticArray = new ScriptDiagnostic[1];
            String string2 = SpaceKotlinBundle.message("kts.file.dependencies.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceKotlinBundle.messag\u2026file.dependencies.error\")");
            scriptDiagnosticArray[0] = new ScriptDiagnostic(5, string2, null, null, null, null, 60, null);
            return new ResultWithDiagnostics.Failure(scriptDiagnosticArray);
        }

        private final ResultWithDiagnostics.Failure getDEPENDENCIES_NOT_LOADED_ERROR() {
            ScriptDiagnostic[] scriptDiagnosticArray = new ScriptDiagnostic[1];
            String string2 = SpaceKotlinBundle.message("kts.file.dependencies.not.loaded.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceKotlinBundle.messag\u2026encies.not.loaded.error\")");
            scriptDiagnosticArray[0] = new ScriptDiagnostic(6, string2, null, null, null, null, 60, null);
            return new ResultWithDiagnostics.Failure(scriptDiagnosticArray);
        }

        private final ResultWithDiagnostics.Failure getCONNECTING_TO_SPACE_ERROR() {
            ScriptDiagnostic[] scriptDiagnosticArray = new ScriptDiagnostic[1];
            String string2 = SpaceKotlinBundle.message("kts.file.connecting.to.space.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceKotlinBundle.messag\u2026nnecting.to.space.error\")");
            scriptDiagnosticArray[0] = new ScriptDiagnostic(7, string2, null, null, null, null, 60, null);
            return new ResultWithDiagnostics.Failure(scriptDiagnosticArray);
        }

        @NotNull
        public final SpaceKtsRuntimeJarsLoader getInstance() {
            boolean $i$f$service = false;
            Class<SpaceKtsRuntimeJarsLoader> serviceClass$iv = SpaceKtsRuntimeJarsLoader.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ")");
            }
            return (SpaceKtsRuntimeJarsLoader)object;
        }

        private Companion() {
        }

        public static final /* synthetic */ ResultWithDiagnostics.Failure access$getDEPENDENCIES_LOADING_ERROR$p(Companion $this) {
            return $this.getDEPENDENCIES_LOADING_ERROR();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

