/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.resolve.VisitData;
import org.apache.ivy.core.resolve.VisitNode;
import org.apache.ivy.util.Message;

public class ResolveData {
    private ResolveEngine engine;
    private Map<ModuleRevisionId, VisitData> visitData;
    private ConfigurationResolveReport report;
    private ResolveOptions options;
    private VisitNode currentVisitNode = null;
    private ResolvedModuleRevision currentResolvedModuleRevision;

    public ResolveData(ResolveData data2, boolean validate) {
        this(data2.engine, new ResolveOptions(data2.options).setValidate(validate), data2.report, data2.visitData);
        this.setCurrentVisitNode(data2.currentVisitNode);
        this.setCurrentResolvedModuleRevision(data2.currentResolvedModuleRevision);
    }

    public ResolveData(ResolveEngine engine, ResolveOptions options2) {
        this(engine, options2, null, new LinkedHashMap<ModuleRevisionId, VisitData>());
    }

    public ResolveData(ResolveEngine engine, ResolveOptions options2, ConfigurationResolveReport report2) {
        this(engine, options2, report2, new LinkedHashMap<ModuleRevisionId, VisitData>());
    }

    public ResolveData(ResolveEngine engine, ResolveOptions options2, ConfigurationResolveReport report2, Map<ModuleRevisionId, VisitData> visitData) {
        this.engine = engine;
        this.report = report2;
        this.visitData = visitData;
        this.options = options2;
    }

    public ConfigurationResolveReport getReport() {
        return this.report;
    }

    public IvyNode getNode(ModuleRevisionId mrid) {
        VisitData visitData = this.getVisitData(mrid);
        return visitData == null ? null : visitData.getNode();
    }

    public Collection<IvyNode> getNodes() {
        ArrayList<IvyNode> nodes2 = new ArrayList<IvyNode>();
        for (VisitData vdata : this.visitData.values()) {
            nodes2.add(vdata.getNode());
        }
        return nodes2;
    }

    public Collection<ModuleRevisionId> getNodeIds() {
        return this.visitData.keySet();
    }

    public VisitData getVisitData(ModuleRevisionId mrid) {
        VisitData result2 = this.visitData.get(mrid);
        if (result2 == null) {
            for (Map.Entry<ModuleRevisionId, VisitData> entry : this.visitData.entrySet()) {
                ModuleRevisionId current2 = entry.getKey();
                if (!ResolveData.isSubMap(mrid.getAttributes(), current2.getAttributes())) continue;
                result2 = entry.getValue();
                break;
            }
        }
        return result2;
    }

    private static <K, V> boolean isSubMap(Map<K, V> map1, Map<K, V> map2) {
        int map2Size;
        int map1Size = map1.size();
        if (map1Size == (map2Size = map2.size())) {
            return map1.equals(map2);
        }
        Map<K, V> smallest = map1Size < map2Size ? map1 : map2;
        Map<K, V> largest = map1Size < map2Size ? map2 : map1;
        for (Map.Entry<K, V> entry : smallest.entrySet()) {
            V map2Value;
            if (!largest.containsKey(entry.getKey())) {
                return false;
            }
            V map1Value = smallest.get(entry.getKey());
            if (ResolveData.isEqual(map1Value, map2Value = largest.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    public VisitNode getCurrentVisitNode() {
        return this.currentVisitNode;
    }

    void setCurrentVisitNode(VisitNode currentVisitNode) {
        this.currentVisitNode = currentVisitNode;
    }

    public void register(VisitNode node) {
        this.register(node.getId(), node);
    }

    public void register(ModuleRevisionId mrid, VisitNode node) {
        VisitData visitData = this.getVisitData(mrid);
        if (visitData == null) {
            visitData = new VisitData(node.getNode());
            visitData.addVisitNode(node);
            this.visitData.put(mrid, visitData);
        } else {
            visitData.setNode(node.getNode());
            visitData.addVisitNode(node);
        }
    }

    void replaceNode(ModuleRevisionId mrid, IvyNode node, String rootModuleConf) {
        VisitData visitData = this.getVisitData(mrid);
        if (visitData == null) {
            throw new IllegalArgumentException("impossible to replace node for id " + mrid + ". No registered node found.");
        }
        VisitData keptVisitData = this.getVisitData(node.getId());
        if (keptVisitData == null) {
            throw new IllegalArgumentException("impossible to replace node with " + node + ". No registered node found for " + node.getId() + ".");
        }
        this.visitData.put(mrid, keptVisitData);
        keptVisitData.addVisitNodes(rootModuleConf, visitData.getVisitNodes(rootModuleConf));
        this.report.updateDependency(mrid, node);
    }

    public void setReport(ConfigurationResolveReport report2) {
        this.report = report2;
    }

    public Date getDate() {
        return this.options.getDate();
    }

    public boolean isValidate() {
        return this.options.isValidate();
    }

    public boolean isTransitive() {
        return this.options.isTransitive();
    }

    public ResolveOptions getOptions() {
        return this.options;
    }

    public ResolveEngineSettings getSettings() {
        return this.engine.getSettings();
    }

    public EventManager getEventManager() {
        return this.engine.getEventManager();
    }

    public ResolveEngine getEngine() {
        return this.engine;
    }

    void blacklist(IvyNode node) {
        Iterator<Map.Entry<ModuleRevisionId, VisitData>> iter = this.visitData.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ModuleRevisionId, VisitData> entry = iter.next();
            if (entry.getValue().getNode() != node || node.getResolvedId().equals(entry.getKey())) continue;
            iter.remove();
        }
    }

    public boolean isBlacklisted(String rootModuleConf, ModuleRevisionId mrid) {
        IvyNode node = this.getNode(mrid);
        return node != null && node.isBlacklisted(rootModuleConf);
    }

    public DependencyDescriptor mediate(DependencyDescriptor dd) {
        DependencyDescriptor originalDD = dd;
        dd = this.getEngine().mediate(dd, this.getOptions());
        VisitNode current2 = this.getCurrentVisitNode();
        if (current2 != null) {
            ArrayList<VisitNode> dependers = new ArrayList<VisitNode>(current2.getPath());
            dependers.remove(dependers.size() - 1);
            Collections.reverse(dependers);
            for (VisitNode n : dependers) {
                ModuleDescriptor md = n.getDescriptor();
                if (md == null) continue;
                dd = md.mediate(dd);
            }
        }
        if (originalDD != dd) {
            Message.verbose("dependency descriptor has been mediated: " + originalDD + " => " + dd);
        }
        return dd;
    }

    public void setCurrentResolvedModuleRevision(ResolvedModuleRevision mr) {
        this.currentResolvedModuleRevision = mr;
    }

    public ResolvedModuleRevision getCurrentResolvedModuleRevision() {
        return this.currentResolvedModuleRevision;
    }
}

