/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.Stack;
import org.apache.ivy.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContextualSAXHandler
extends DefaultHandler {
    private Stack<String> contextStack = new Stack();
    private StringBuilder buffer = new StringBuilder();

    @Override
    public void characters(char[] ch, int start2, int length) throws SAXException {
        this.buffer.append(ch, start2, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.contextStack.push(qName);
        this.buffer.setLength(0);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.contextStack.pop();
        this.buffer.setLength(0);
    }

    protected String getContext() {
        return StringUtils.joinArray(this.contextStack.toArray(new String[this.contextStack.size()]), "/");
    }

    protected String getText() {
        return this.buffer.toString();
    }
}

