/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import kotlin.Metadata;
import runtime.utils.RetryPolicy;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lruntime/utils/RetryPolicyImpl;", "Lruntime/utils/RetryPolicy;", "()V", "maxRetryCount", "", "getMaxRetryCount", "()I", "pauseTime", "curRetryCount", "platform-runtime"})
public final class RetryPolicyImpl
implements RetryPolicy {
    private final int maxRetryCount;

    public RetryPolicyImpl() {
        this.maxRetryCount = 0x7FFFFFFE;
    }

    @Override
    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    @Override
    public int pauseTime(int curRetryCount) {
        int n;
        if (!(curRetryCount >= 1)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        boolean bl = 0 <= curRetryCount ? curRetryCount < 4 : false;
        if (bl) {
            n = curRetryCount * 60000;
        } else {
            boolean bl2 = 3 <= curRetryCount ? curRetryCount < 8 : false;
            if (bl2) {
                n = curRetryCount * 60000 * 30;
            } else if (curRetryCount > 7) {
                n = Math.min(86400000, curRetryCount * 60000 * 60 * 2);
            } else {
                throw new IllegalStateException(("Unexpected curRetryCount: " + curRetryCount + '.').toString());
            }
        }
        return n;
    }
}

