/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.ddmlib.AdbHelper;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;

public class AdbSocketUtils {
    private static final String EOF_MESSAGE = "EOF";

    static void read(SocketChannel socket, ByteBuffer buf) throws IOException {
        while (buf.remaining() > 0) {
            int count = socket.read(buf);
            if (count >= 0) continue;
            throw new IOException(EOF_MESSAGE);
        }
    }

    static ByteBuffer read(SocketChannel socket, int length) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(length);
        AdbSocketUtils.read(socket, buf);
        buf.rewind();
        return buf;
    }

    static String read(SocketChannel socket, byte[] buffer) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(buffer, 0, buffer.length);
        AdbSocketUtils.read(socket, buf);
        return new String(buffer, 0, buf.position(), AdbHelper.DEFAULT_CHARSET);
    }

    static int readLength(SocketChannel socket, byte[] buffer) throws IOException {
        String msg = AdbSocketUtils.read(socket, buffer);
        if (msg != null) {
            try {
                return Integer.parseInt(msg, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("Unable to read length");
    }

    static String readNullTerminatedString(SocketChannel socket) throws IOException {
        return AdbSocketUtils.readNullTerminatedString(socket, AdbHelper.DEFAULT_CHARSET);
    }

    static String readNullTerminatedString(SocketChannel socket, Charset charset) throws IOException {
        byte[] buffer = new byte[64];
        ByteBuffer buf = ByteBuffer.wrap(buffer, 0, buffer.length);
        ByteArrayDataOutput output = ByteStreams.newDataOutput((int)64);
        boolean end = false;
        while (!end) {
            int nullPosition;
            buf.rewind();
            try {
                AdbSocketUtils.read(socket, buf);
            }
            catch (IOException e10) {
                if (e10.getMessage().equals(EOF_MESSAGE)) {
                    end = true;
                }
                throw e10;
            }
            for (nullPosition = 0; nullPosition < buf.position(); ++nullPosition) {
                if (buffer[nullPosition] != 0) continue;
                end = true;
                break;
            }
            output.write(buffer, 0, nullPosition);
        }
        return new String(output.toByteArray(), charset);
    }
}

