/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp;

import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.JdwpHandshake;
import com.android.ddmlib.internal.jdwp.DdmCommandPacket;
import com.android.ddmlib.internal.jdwp.JdwpLoggingUtils;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleAppName;
import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class JdwpConnectionReader {
    @VisibleForTesting
    static final String JDWP_DISCONNECT = "disconnect:";
    private ByteBuffer mReadBuffer;
    private SocketChannel mSocket;

    public JdwpConnectionReader(SocketChannel channelToReadFrom, int initialBufferSize) {
        this.mReadBuffer = ByteBuffer.allocate(initialBufferSize);
        this.mSocket = channelToReadFrom;
    }

    public int read() throws IOException {
        return this.mSocket.read(this.mReadBuffer);
    }

    public boolean isHostTransport() {
        return this.bufferOffsetStartsWith(4, "host:transport:");
    }

    public boolean isJdwpPid() {
        return this.bufferOffsetStartsWith(4, "jdwp:");
    }

    public boolean isDisconnect() {
        return this.bufferOffsetStartsWith(4, JDWP_DISCONNECT);
    }

    public boolean isHandshake() {
        return JdwpHandshake.findHandshake(this.mReadBuffer) == 1;
    }

    public boolean isAPNMPacket() throws IOException {
        JdwpPacket packet = this.readPacketHeader();
        if (packet != null && packet.is(199, 1)) {
            ByteBuffer payload = this.readPacketPayloadPartial(4);
            return payload.getInt() == HandleAppName.CHUNK_APNM;
        }
        return false;
    }

    public DdmCommandPacket parseCommandPacket() {
        return new DdmCommandPacket(this.mReadBuffer);
    }

    public void consumeData(int length) {
        this.mReadBuffer.flip();
        this.mReadBuffer.position(length);
        this.mReadBuffer.compact();
    }

    public JdwpPacket readPacket() throws IOException {
        int packetLength = JdwpPacket.getPacketLength(this.mReadBuffer);
        if (packetLength <= 0) {
            return null;
        }
        if (packetLength > DdmPreferences.getJdwpMaxPacketSize()) {
            JdwpLoggingUtils.logPacketError("Packet size exceeds expected max", this.mReadBuffer);
            throw new BufferOverflowException();
        }
        if (this.mReadBuffer.capacity() < packetLength) {
            this.resizeBuffer(packetLength);
        }
        while (packetLength > this.mReadBuffer.position()) {
            this.mSocket.read(this.mReadBuffer);
        }
        return JdwpPacket.findPacket(this.mReadBuffer);
    }

    public JdwpPacket readPacketHeader() throws IOException {
        int packetLength = JdwpPacket.getPacketLength(this.mReadBuffer);
        if (packetLength <= 0) {
            return null;
        }
        while (this.mReadBuffer.position() < 11) {
            this.mSocket.read(this.mReadBuffer);
        }
        return JdwpPacket.findPacketHeader(this.mReadBuffer);
    }

    public ByteBuffer readPacketPayloadPartial(int size) throws IOException {
        if (size <= 0) {
            return ByteBuffer.allocate(0);
        }
        while (this.mReadBuffer.position() < 11 + size) {
            this.mSocket.read(this.mReadBuffer);
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put(this.mReadBuffer.array(), 11, size);
        buffer.flip();
        return buffer;
    }

    private void resizeBuffer(int requestedSize) {
        ByteBuffer newBuffer = ByteBuffer.allocate(requestedSize);
        int currPosition = this.mReadBuffer.position();
        this.mReadBuffer.position(0);
        newBuffer.put(this.mReadBuffer);
        newBuffer.position(currPosition);
        this.mReadBuffer = newBuffer;
    }

    public void consumePacket() throws IOException {
        JdwpPacket packet = this.readPacket();
        if (packet != null) {
            packet.consume();
        }
    }

    private boolean bufferOffsetStartsWith(int offset, String match2) {
        int j10 = 0;
        for (int i10 = offset; j10 < match2.length() && i10 < this.mReadBuffer.position(); ++i10, ++j10) {
            if (match2.charAt(j10) == this.mReadBuffer.get(i10)) continue;
            return false;
        }
        return true;
    }
}

