/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.ui.ImageViewer;
import com.android.draw9patch.ui.PatchInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class StretchesViewer
extends JPanel {
    public static final float DEFAULT_SCALE = 2.0f;
    private static final int MARGIN = 24;
    private final Container container;
    private final ImageViewer viewer;
    private final TexturePaint texture;
    private BufferedImage image;
    private PatchInfo patchInfo;
    private StretchView horizontal;
    private StretchView vertical;
    private StretchView both;
    private Dimension size;
    private float horizontalPatchesSum;
    private float verticalPatchesSum;
    private boolean showPadding;

    StretchesViewer(Container container, ImageViewer viewer, TexturePaint texture) {
        this.container = container;
        this.viewer = viewer;
        this.texture = texture;
        this.image = viewer.getImage();
        this.patchInfo = viewer.getPatchInfo();
        viewer.addPatchUpdateListener(new ImageViewer.PatchUpdateListener(){

            @Override
            public void patchesUpdated() {
                StretchesViewer.this.computePatches();
            }
        });
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(24, 24, 24, 24));
        this.horizontal = new StretchView();
        this.vertical = new StretchView();
        this.both = new StretchView();
        this.setScale(2.0f);
        this.add((Component)this.vertical, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.horizontal, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.both, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void paintComponent(Graphics g10) {
        Graphics2D g22 = (Graphics2D)g10.create();
        g22.setPaint(this.texture);
        g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        g22.dispose();
    }

    void setScale(float scale) {
        int patchWidth = this.image.getWidth() - 2;
        int patchHeight = this.image.getHeight() - 2;
        int scaledWidth = (int)((float)patchWidth * scale);
        int scaledHeight = (int)((float)patchHeight * scale);
        this.horizontal.scaledWidth = scaledWidth;
        this.vertical.scaledHeight = scaledHeight;
        this.both.scaledWidth = scaledWidth;
        this.both.scaledHeight = scaledHeight;
        this.size = new Dimension(scaledWidth, scaledHeight);
        this.computePatches();
    }

    void computePatches() {
        int start;
        this.image = this.viewer.getImage();
        this.patchInfo = this.viewer.getPatchInfo();
        boolean measuredWidth = false;
        boolean endRow = true;
        int remainderHorizontal = 0;
        int remainderVertical = 0;
        if (!this.patchInfo.fixed.isEmpty()) {
            start = this.patchInfo.fixed.get((int)0).y;
            for (Rectangle rect : this.patchInfo.fixed) {
                if (rect.y > start) {
                    endRow = true;
                    measuredWidth = true;
                }
                if (!measuredWidth) {
                    remainderHorizontal += rect.width;
                }
                if (!endRow) continue;
                remainderVertical += rect.height;
                endRow = false;
                start = rect.y;
            }
        } else {
            for (Rectangle rect : this.patchInfo.verticalPatches) {
                remainderHorizontal += rect.width;
            }
            for (Rectangle rect : this.patchInfo.horizontalPatches) {
                remainderVertical += rect.height;
            }
        }
        this.horizontal.remainderHorizontal = this.horizontal.scaledWidth - remainderHorizontal;
        this.vertical.remainderHorizontal = this.vertical.scaledWidth - remainderHorizontal;
        this.both.remainderHorizontal = this.both.scaledWidth - remainderHorizontal;
        this.horizontal.remainderVertical = this.horizontal.scaledHeight - remainderVertical;
        this.vertical.remainderVertical = this.vertical.scaledHeight - remainderVertical;
        this.both.remainderVertical = this.both.scaledHeight - remainderVertical;
        this.horizontalPatchesSum = 0.0f;
        if (!this.patchInfo.horizontalPatches.isEmpty()) {
            start = -1;
            for (Rectangle rect : this.patchInfo.horizontalPatches) {
                if (rect.x <= start) continue;
                this.horizontalPatchesSum += (float)rect.width;
                start = rect.x;
            }
        } else {
            start = -1;
            for (Rectangle rect : this.patchInfo.patches) {
                if (rect.x <= start) continue;
                this.horizontalPatchesSum += (float)rect.width;
                start = rect.x;
            }
        }
        this.verticalPatchesSum = 0.0f;
        if (!this.patchInfo.verticalPatches.isEmpty()) {
            start = -1;
            for (Rectangle rect : this.patchInfo.verticalPatches) {
                if (rect.y <= start) continue;
                this.verticalPatchesSum += (float)rect.height;
                start = rect.y;
            }
        } else {
            start = -1;
            for (Rectangle rect : this.patchInfo.patches) {
                if (rect.y <= start) continue;
                this.verticalPatchesSum += (float)rect.height;
                start = rect.y;
            }
        }
        this.setSize(this.size);
        this.container.validate();
        this.repaint();
    }

    void setPaddingVisible(boolean visible) {
        this.showPadding = visible;
        this.repaint();
    }

    private class StretchView
    extends JComponent {
        private final Color PADDING_COLOR = new Color(0.37f, 0.37f, 1.0f, 0.5f);
        int scaledWidth;
        int scaledHeight;
        int remainderHorizontal;
        int remainderVertical;

        StretchView() {
            this.scaledWidth = StretchesViewer.this.image.getWidth();
            this.scaledHeight = StretchesViewer.this.image.getHeight();
        }

        @Override
        protected void paintComponent(Graphics g10) {
            int x10 = (this.getWidth() - this.scaledWidth) / 2;
            int y10 = (this.getHeight() - this.scaledHeight) / 2;
            Graphics2D g22 = (Graphics2D)g10.create();
            g22.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g10.translate(x10, y10);
            x10 = 0;
            y10 = 0;
            if (((StretchesViewer)StretchesViewer.this).patchInfo.patches.isEmpty()) {
                g10.drawImage(StretchesViewer.this.image, 0, 0, this.scaledWidth, this.scaledHeight, null);
                g22.dispose();
                return;
            }
            int fixedIndex = 0;
            int horizontalIndex = 0;
            int verticalIndex = 0;
            int patchIndex = 0;
            float vWeightSum = 1.0f;
            float vRemainder = this.remainderVertical;
            boolean vStretch = ((StretchesViewer)StretchesViewer.this).patchInfo.verticalStartWithPatch;
            while (y10 < this.scaledHeight - 1) {
                boolean hStretch = ((StretchesViewer)StretchesViewer.this).patchInfo.horizontalStartWithPatch;
                int height = 0;
                float vExtra = 0.0f;
                float hWeightSum = 1.0f;
                float hRemainder = this.remainderHorizontal;
                while (x10 < this.scaledWidth - 1) {
                    int width;
                    float extra;
                    Rectangle r10;
                    if (!vStretch) {
                        if (hStretch) {
                            r10 = ((StretchesViewer)StretchesViewer.this).patchInfo.horizontalPatches.get(horizontalIndex++);
                            extra = (float)r10.width / StretchesViewer.this.horizontalPatchesSum;
                            width = (int)(extra * hRemainder / hWeightSum);
                            hWeightSum -= extra;
                            hRemainder -= (float)width;
                            g10.drawImage(StretchesViewer.this.image, x10, y10, x10 + width, y10 + r10.height, r10.x, r10.y, r10.x + r10.width, r10.y + r10.height, null);
                            x10 += width;
                        } else {
                            r10 = ((StretchesViewer)StretchesViewer.this).patchInfo.fixed.get(fixedIndex++);
                            g10.drawImage(StretchesViewer.this.image, x10, y10, x10 + r10.width, y10 + r10.height, r10.x, r10.y, r10.x + r10.width, r10.y + r10.height, null);
                            x10 += r10.width;
                        }
                        height = r10.height;
                    } else if (hStretch) {
                        r10 = ((StretchesViewer)StretchesViewer.this).patchInfo.patches.get(patchIndex++);
                        vExtra = (float)r10.height / StretchesViewer.this.verticalPatchesSum;
                        height = (int)(vExtra * vRemainder / vWeightSum);
                        extra = (float)r10.width / StretchesViewer.this.horizontalPatchesSum;
                        width = (int)(extra * hRemainder / hWeightSum);
                        hWeightSum -= extra;
                        hRemainder -= (float)width;
                        g10.drawImage(StretchesViewer.this.image, x10, y10, x10 + width, y10 + height, r10.x, r10.y, r10.x + r10.width, r10.y + r10.height, null);
                        x10 += width;
                    } else {
                        r10 = ((StretchesViewer)StretchesViewer.this).patchInfo.verticalPatches.get(verticalIndex++);
                        vExtra = (float)r10.height / StretchesViewer.this.verticalPatchesSum;
                        height = (int)(vExtra * vRemainder / vWeightSum);
                        g10.drawImage(StretchesViewer.this.image, x10, y10, x10 + r10.width, y10 + height, r10.x, r10.y, r10.x + r10.width, r10.y + r10.height, null);
                        x10 += r10.width;
                    }
                    hStretch = !hStretch;
                }
                x10 = 0;
                y10 += height;
                if (vStretch) {
                    vWeightSum -= vExtra;
                    vRemainder -= (float)height;
                }
                vStretch = !vStretch;
            }
            if (StretchesViewer.this.showPadding) {
                g10.setColor(this.PADDING_COLOR);
                g10.fillRect((Integer)((StretchesViewer)StretchesViewer.this).patchInfo.horizontalPadding.first, (Integer)((StretchesViewer)StretchesViewer.this).patchInfo.verticalPadding.first, this.scaledWidth - (Integer)((StretchesViewer)StretchesViewer.this).patchInfo.horizontalPadding.first - (Integer)((StretchesViewer)StretchesViewer.this).patchInfo.horizontalPadding.second, this.scaledHeight - (Integer)((StretchesViewer)StretchesViewer.this).patchInfo.verticalPadding.first - (Integer)((StretchesViewer)StretchesViewer.this).patchInfo.verticalPadding.second);
            }
            g22.dispose();
        }

        @Override
        public Dimension getPreferredSize() {
            return StretchesViewer.this.size;
        }
    }
}

