/*
 * Decompiled with CFR 0.152.
 */
package com.android.ninepatch;

import com.android.ninepatch.GraphicsUtilities;
import com.android.ninepatch.NinePatchChunk;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class NinePatch {
    public static final String EXTENSION_9PATCH = ".9.png";
    private BufferedImage mImage;
    private NinePatchChunk mChunk;

    public BufferedImage getImage() {
        return this.mImage;
    }

    public NinePatchChunk getChunk() {
        return this.mChunk;
    }

    public static NinePatch load(URL fileUrl, boolean convert) throws IOException {
        BufferedImage image = null;
        try {
            image = GraphicsUtilities.loadCompatibleImage(fileUrl);
        }
        catch (MalformedURLException e10) {
            return null;
        }
        boolean is9Patch = fileUrl.getPath().toLowerCase(Locale.US).endsWith(EXTENSION_9PATCH);
        return NinePatch.load(image, is9Patch, convert);
    }

    public static NinePatch load(InputStream stream, boolean is9Patch, boolean convert) throws IOException {
        BufferedImage image = null;
        try {
            image = GraphicsUtilities.loadCompatibleImage(stream);
        }
        catch (MalformedURLException e10) {
            return null;
        }
        return NinePatch.load(image, is9Patch, convert);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NinePatch load(BufferedImage image, boolean is9Patch, boolean convert) {
        if (!is9Patch) {
            if (!convert) return null;
            image = NinePatch.convertTo9Patch(image);
        } else {
            NinePatch.ensure9Patch(image);
        }
        if (image.getWidth() >= 2 && image.getHeight() >= 2) return new NinePatch(image);
        return null;
    }

    public int getWidth() {
        return this.mImage.getWidth();
    }

    public int getHeight() {
        return this.mImage.getHeight();
    }

    public boolean getPadding(int[] padding) {
        this.mChunk.getPadding(padding);
        return true;
    }

    public void draw(Graphics2D graphics2D, int x10, int y10, int scaledWidth, int scaledHeight) {
        this.mChunk.draw(this.mImage, graphics2D, x10, y10, scaledWidth, scaledHeight, 0, 0);
    }

    private NinePatch(BufferedImage image) {
        this.mChunk = NinePatchChunk.create(image);
        this.mImage = this.extractBitmapContent(image);
    }

    private static void ensure9Patch(BufferedImage image) {
        int pixel;
        int i10;
        int width = image.getWidth();
        int height = image.getHeight();
        for (i10 = 0; i10 < width; ++i10) {
            pixel = image.getRGB(i10, 0);
            if (pixel != 0 && pixel != -16777216) {
                image.setRGB(i10, 0, 0);
            }
            if ((pixel = image.getRGB(i10, height - 1)) == 0 || pixel == -16777216) continue;
            image.setRGB(i10, height - 1, 0);
        }
        for (i10 = 0; i10 < height; ++i10) {
            pixel = image.getRGB(0, i10);
            if (pixel != 0 && pixel != -16777216) {
                image.setRGB(0, i10, 0);
            }
            if ((pixel = image.getRGB(width - 1, i10)) == 0 || pixel == -16777216) continue;
            image.setRGB(width - 1, i10, 0);
        }
    }

    private static BufferedImage convertTo9Patch(BufferedImage image) {
        BufferedImage buffer = GraphicsUtilities.createTranslucentCompatibleImage(image.getWidth() + 2, image.getHeight() + 2);
        Graphics2D g22 = buffer.createGraphics();
        g22.drawImage((Image)image, 1, 1, null);
        g22.dispose();
        return buffer;
    }

    private BufferedImage extractBitmapContent(BufferedImage image) {
        return image.getSubimage(1, 1, image.getWidth() - 2, image.getHeight() - 2);
    }
}

