/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.PathUtils;
import java.nio.file.Path;

public class ArchivePathEntry
extends ArchiveEntry {
    private long rawFileSize = -1L;
    private long downloadFileSize = -1L;

    public ArchivePathEntry(Archive archive, Path path2, String pathPrefix) {
        super(archive, path2, pathPrefix);
    }

    @Override
    public void setRawFileSize(long rawFileSize) {
        this.rawFileSize = rawFileSize;
    }

    @Override
    public long getRawFileSize() {
        return this.rawFileSize;
    }

    @Override
    public void setDownloadFileSize(long downloadFileSize) {
        this.downloadFileSize = downloadFileSize;
    }

    @Override
    public long getDownloadFileSize() {
        return this.downloadFileSize;
    }

    @Override
    public String getNodeDisplayString() {
        Path base = this.getPath().getFileName();
        String name = base == null ? "" : base.toString();
        return ArchivePathEntry.trimEnd(name, "/");
    }

    @Override
    public String getSummaryDisplayString() {
        return this.getPathPrefix() + PathUtils.pathWithTrailingSeparator(this.getPath());
    }

    private static String trimEnd(String s10, String suffix) {
        boolean endsWith = s10.endsWith(suffix);
        if (endsWith) {
            return s10.substring(0, s10.length() - suffix.length());
        }
        return s10;
    }
}

