/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex.tree;

import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.immutable.reference.ImmutableReference;
import org.jf.dexlib2.immutable.reference.ImmutableTypeReference;

public class DexClassNode
extends DexElementNode {
    private long size = 0L;

    public DexClassNode(String displayName, ImmutableTypeReference reference) {
        super(displayName, true, (ImmutableReference)reference);
    }

    @Override
    public boolean isSeed(ProguardSeedsMap seedsMap, ProguardMap map, boolean checkChildren) {
        TypeReference reference;
        if (seedsMap != null && (reference = this.getReference()) != null && seedsMap.hasClass(PackageTreeCreator.decodeClassName(reference.getType(), map))) {
            return true;
        }
        return super.isSeed(seedsMap, map, checkChildren);
    }

    @Override
    public long getSize() {
        long size = this.size;
        int n10 = this.getChildCount();
        for (int i10 = 0; i10 < n10; ++i10) {
            DexElementNode node = this.getChildAt(i10);
            if (node.isDefined()) continue;
            size += node.getSize();
        }
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public TypeReference getReference() {
        return (TypeReference)super.getReference();
    }

    @Override
    public void update() {
        super.update();
        int methodDefinitions = 0;
        int methodReferences = 0;
        int n10 = this.getChildCount();
        for (int i10 = 0; i10 < n10; ++i10) {
            DexElementNode node = this.getChildAt(i10);
            methodDefinitions += node.getMethodDefinitionsCount();
            methodReferences += node.getMethodReferencesCount();
        }
        this.setMethodDefinitionsCount(methodDefinitions);
        this.setMethodReferencesCount(methodReferences);
    }
}

