/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.ApiClassOwner;
import com.android.tools.lint.checks.ApiParser;
import com.android.tools.lint.checks.PrivateApiClass;
import com.android.tools.lint.checks.PrivateApiParser;
import com.android.utils.XmlUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class Api<C extends ApiClassBase> {
    private final Map<String, C> mClasses;
    private final Map<String, ApiClassOwner<C>> mContainers;

    public static Api<ApiClass> parseApi(File apiFile) {
        Api<ApiClass> api;
        FileInputStream inputStream = new FileInputStream(apiFile);
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            XmlUtils.configureSaxFactory((SAXParserFactory)parserFactory, (boolean)false, (boolean)false);
            SAXParser parser = XmlUtils.createSaxParser((SAXParserFactory)parserFactory);
            ApiParser apiParser = new ApiParser();
            parser.parse((InputStream)inputStream, (DefaultHandler)apiParser);
            ((InputStream)inputStream).close();
            api = new Api<ApiClass>(apiParser.getClasses(), apiParser.getContainers());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | SAXException e10) {
                throw new RuntimeException(e10);
            }
        }
        ((InputStream)inputStream).close();
        return api;
    }

    public static Api<PrivateApiClass> parseHiddenApi(URL input) {
        Api<PrivateApiClass> api;
        block8: {
            InputStream inputStream = input.openStream();
            try {
                PrivateApiParser privateApiParser = new PrivateApiParser();
                privateApiParser.parse(inputStream);
                api = new Api<PrivateApiClass>(privateApiParser.getClasses(), privateApiParser.getContainers());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e10) {
                    throw new RuntimeException(e10);
                }
            }
            inputStream.close();
        }
        return api;
    }

    private Api(Map<String, C> classes, Map<String, ApiClassOwner<C>> containers) {
        this.mClasses = Collections.unmodifiableMap(new MyHashMap<C>(classes));
        this.mContainers = Collections.unmodifiableMap(new MyHashMap<ApiClassOwner<C>>(containers));
    }

    C getClass(String fqcn) {
        return (C)((ApiClassBase)this.mClasses.get(fqcn));
    }

    Map<String, C> getClasses() {
        return this.mClasses;
    }

    Map<String, ApiClassOwner<C>> getContainers() {
        return this.mContainers;
    }

    private static class MyHashMap<V>
    extends THashMap<String, V> {
        private static final TObjectHashingStrategy<String> myHashingStrategy = new TObjectHashingStrategy<String>(){

            public int computeHashCode(String str) {
                int h10 = 0;
                for (int i10 = 0; i10 < str.length(); ++i10) {
                    char c10 = str.charAt(i10);
                    c10 = MyHashMap.normalizeSeparator(c10);
                    h10 = 31 * h10 + c10;
                }
                return h10;
            }

            public boolean equals(String s12, String s22) {
                if (s12.length() != s22.length()) {
                    return false;
                }
                for (int i10 = 0; i10 < s12.length(); ++i10) {
                    if (MyHashMap.normalizeSeparator(s12.charAt(i10)) == MyHashMap.normalizeSeparator(s22.charAt(i10))) continue;
                    return false;
                }
                return true;
            }
        };

        private static char normalizeSeparator(char c10) {
            if (c10 == '/' || c10 == '$') {
                c10 = (char)46;
            }
            return c10;
        }

        MyHashMap(Map<String, V> data) {
            super(data, myHashingStrategy);
        }
    }
}

