/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.support.AndroidxName;
import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightMethodBuilder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "SuperCallVisitor", "android.sdktools.lint-checks"})
public final class CallSuperDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    public static final String KEY_METHOD = "method";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("MissingSuperCall", "Missing Super Call", "\n            Some methods, such as `View#onDetachedFromWindow`, require that you also call the \\\n            super implementation as part of your method.\n            ", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);
    private static final AndroidxName CALL_SUPER_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"CallSuper");
    @NotNull
    private static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";
    @NotNull
    private static final String ON_VISIBILITY_CHANGED = "onVisibilityChanged";

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        return new UElementHandler(context2, this){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ CallSuperDetector this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
            }

            public void visitMethod(@NotNull UMethod node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                JavaEvaluator evaluator = this.$context.getEvaluator();
                PsiMethod psiMethod = CallSuperDetector.Issues.getRequiredSuperMethod(evaluator, (PsiMethod)node);
                if (psiMethod == null) {
                    return;
                }
                PsiMethod superMethod = psiMethod;
                SuperCallVisitor visitor2 = new SuperCallVisitor(superMethod);
                node.accept((UastVisitor)visitor2);
                if (visitor2.getUncertain()) {
                    return;
                }
                int count = visitor2.getCallsSuperCount();
                if (count == 0) {
                    String methodName = node.getName();
                    if (Intrinsics.areEqual((Object)methodName, (Object)"onCreate") && visitor2.getAnySuperCallCount() > 0) {
                        String superMethodClass;
                        PsiClass psiClass = superMethod.getContainingClass();
                        String string = superMethodClass = psiClass == null ? null : psiClass.getQualifiedName();
                        if (Intrinsics.areEqual((Object)superMethodClass, (Object)"androidx.appcompat.app.AppCompatActivity")) {
                            return;
                        }
                    }
                    String message2 = "Overriding method should call `super." + methodName + '`';
                    Location location = this.$context.getNameLocation(node);
                    Object[] objectArray = new Object[]{"method", superMethod};
                    LintFix fix = CallSuperDetector.access$fix(this.this$0).data(objectArray);
                    this.$context.report(CallSuperDetector.ISSUE, node, location, message2, fix);
                } else if (count > 1 && Intrinsics.areEqual((Object)node.getName(), (Object)"onCreate")) {
                    Object message2 = visitor2.findFirstOverlap(node);
                    if (message2 == null) {
                        return;
                    }
                    USuperExpression overlap = message2;
                    message2 = "Calling `super." + node.getName() + "` more than once can lead to crashes";
                    Location location = this.$context.getNameLocation((UElement)overlap);
                    this.$context.report(CallSuperDetector.ISSUE, node, location, (String)message2);
                }
            }
        };
    }

    public static final /* synthetic */ LintFix.Builder access$fix(CallSuperDetector $this) {
        return $this.fix();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector$Issues;", "", "()V", "CALL_SUPER_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_METHOD", "", "ON_DETACHED_FROM_WINDOW", "ON_VISIBILITY_CHANGED", "getRequiredSuperMethod", "Lcom/intellij/psi/PsiMethod;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "method", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        @Nullable
        public final PsiMethod getRequiredSuperMethod(@NotNull JavaEvaluator evaluator, @NotNull PsiMethod method) {
            PsiAnnotation[] annotations;
            Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
            Intrinsics.checkParameterIsNotNull((Object)method, (String)CallSuperDetector.KEY_METHOD);
            PsiMethod psiMethod = evaluator.getSuperMethod(method);
            if (psiMethod == null) {
                return null;
            }
            PsiMethod directSuper = psiMethod;
            String string = method.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
            String name = string;
            if (Intrinsics.areEqual((Object)CallSuperDetector.ON_DETACHED_FROM_WINDOW, (Object)name)) {
                if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
                    return null;
                }
                return directSuper;
            }
            if (Intrinsics.areEqual((Object)CallSuperDetector.ON_VISIBILITY_CHANGED, (Object)name)) {
                if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.support.wearable.watchface.WatchFaceService.Engine", false)) {
                    return null;
                }
                return directSuper;
            }
            for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)directSuper, true)) {
                String signature = annotation.getQualifiedName();
                if (!CALL_SUPER_ANNOTATION.isEquals(signature) && (signature == null || !StringsKt.endsWith$default((String)signature, (String)".OverrideMustInvoke", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)signature, (String)".OverridingMethodsMustInvokeSuper", (boolean)false, (int)2, null))) continue;
                return directSuper;
            }
            return null;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u000fH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector$SuperCallVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "targetMethod", "Lcom/intellij/psi/PsiMethod;", "(Lcom/intellij/psi/PsiMethod;)V", "anySuperCallCount", "", "getAnySuperCallCount", "()I", "setAnySuperCallCount", "(I)V", "callsSuperCount", "getCallsSuperCount", "superCalls", "", "Lorg/jetbrains/uast/USuperExpression;", "getSuperCalls", "()Ljava/util/List;", "uncertain", "", "getUncertain", "()Z", "setUncertain", "(Z)V", "findFirstOverlap", "method", "Lorg/jetbrains/uast/UMethod;", "visitSuperExpression", "node", "android.sdktools.lint-checks"})
    private static final class SuperCallVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final PsiMethod targetMethod;
        @NotNull
        private final List<USuperExpression> superCalls;
        private int anySuperCallCount;
        private boolean uncertain;

        public SuperCallVisitor(@NotNull PsiMethod targetMethod) {
            Intrinsics.checkParameterIsNotNull((Object)targetMethod, (String)"targetMethod");
            this.targetMethod = targetMethod;
            boolean bl2 = false;
            this.superCalls = new ArrayList();
        }

        @NotNull
        public final List<USuperExpression> getSuperCalls() {
            return this.superCalls;
        }

        public final int getCallsSuperCount() {
            return this.superCalls.size();
        }

        public final int getAnySuperCallCount() {
            return this.anySuperCallCount;
        }

        public final void setAnySuperCallCount(int n10) {
            this.anySuperCallCount = n10;
        }

        public final boolean getUncertain() {
            return this.uncertain;
        }

        public final void setUncertain(boolean bl2) {
            this.uncertain = bl2;
        }

        public boolean visitSuperExpression(@NotNull USuperExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            SuperCallVisitor superCallVisitor = this;
            int n10 = superCallVisitor.anySuperCallCount;
            superCallVisitor.anySuperCallCount = n10 + 1;
            UElement parent = Lint.skipParentheses(node.getUastParent());
            if (parent instanceof UReferenceExpression) {
                PsiElement resolved = ((UReferenceExpression)parent).resolve();
                if (resolved == null || this.targetMethod.isEquivalentTo(resolved)) {
                    this.superCalls.add(node);
                } else if (resolved instanceof LightMethodBuilder && Intrinsics.areEqual((Object)resolved.getClass().getName(), (Object)"org.jetbrains.uast.kotlin.psi.UastDescriptorLightMethod")) {
                    this.uncertain = true;
                }
            }
            return super.visitSuperExpression(node);
        }

        @Nullable
        public final USuperExpression findFirstOverlap(@NotNull UMethod method) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)CallSuperDetector.KEY_METHOD);
            int n10 = 0;
            int n11 = this.superCalls.size();
            if (n10 < n11) {
                do {
                    int n12;
                    int i10;
                    int n13;
                    if ((n13 = (i10 = n10++) + 1) >= (n12 = this.superCalls.size())) continue;
                    do {
                        int j10 = n13++;
                        if (!CutPasteDetector.isReachableFrom(method, (UElement)this.superCalls.get(i10), (UElement)this.superCalls.get(j10))) continue;
                        return this.superCalls.get(j10);
                    } while (n13 < n12);
                } while (n10 < n11);
            }
            return null;
        }
    }
}

