/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0002J0\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0018\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u000bH\u0016J \u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkEditorApplied", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "checkRecycled", "recycleType", "", "recycleName", "checkResourceRecycled", "method", "checkTransactionCommits", "getApplicableConstructorTypes", "", "getApplicableMethodNames", "isBeginTransaction", "", "isEditorApplyMethodCall", "call", "isEditorCommitMethodCall", "isMethodOnFragmentClass", "fragmentClass", "v4FragmentClass", "returnForUnresolved", "isSharedEditorCreation", "isShowFragmentMethodCall", "isTransactionCommitMethodCall", "suggestApplyIfApplicable", "visitConstructor", "constructor", "visitMethodCall", "Companion", "android.sdktools.lint-checks"})
public final class CleanupDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue RECYCLE_RESOURCE;
    @JvmField
    @NotNull
    public static final Issue COMMIT_FRAGMENT;
    @JvmField
    @NotNull
    public static final Issue SHARED_PREF;
    @JvmField
    @NotNull
    public static final Issue APPLY_SHARED_PREF;
    @NotNull
    private static final String OF_INT = "ofInt";
    @NotNull
    private static final String OF_ARGB = "ofArgb";
    @NotNull
    private static final String OF_FLOAT = "ofFloat";
    @NotNull
    private static final String OF_OBJECT = "ofObject";
    @NotNull
    private static final String OF_PROPERTY_VALUES_HOLDER = "ofPropertyValuesHolder";
    @NotNull
    private static final String START = "start";
    @NotNull
    private static final String RECYCLE = "recycle";
    @NotNull
    private static final String RELEASE = "release";
    @NotNull
    private static final String OBTAIN = "obtain";
    @NotNull
    private static final String SHOW = "show";
    @NotNull
    private static final String ACQUIRE_CPC = "acquireContentProviderClient";
    @NotNull
    private static final String OBTAIN_NO_HISTORY = "obtainNoHistory";
    @NotNull
    private static final String OBTAIN_ATTRIBUTES = "obtainAttributes";
    @NotNull
    private static final String OBTAIN_TYPED_ARRAY = "obtainTypedArray";
    @NotNull
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";
    @NotNull
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    @NotNull
    private static final String COMMIT = "commit";
    @NotNull
    private static final String COMMIT_NOW = "commitNow";
    @NotNull
    private static final String APPLY = "apply";
    @NotNull
    private static final String COMMIT_ALLOWING_LOSS = "commitAllowingStateLoss";
    @NotNull
    private static final String COMMIT_NOW_ALLOWING_LOSS = "commitNowAllowingStateLoss";
    @NotNull
    private static final String QUERY = "query";
    @NotNull
    private static final String RAW_QUERY = "rawQuery";
    @NotNull
    private static final String QUERY_WITH_FACTORY = "queryWithFactory";
    @NotNull
    private static final String RAW_QUERY_WITH_FACTORY = "rawQueryWithFactory";
    @NotNull
    private static final String CLOSE = "close";
    @NotNull
    private static final String EDIT = "edit";
    @NotNull
    public static final String MOTION_EVENT_CLS = "android.view.MotionEvent";
    @NotNull
    private static final String PARCEL_CLS = "android.os.Parcel";
    @NotNull
    private static final String VELOCITY_TRACKER_CLS = "android.view.VelocityTracker";
    @NotNull
    private static final String DIALOG_FRAGMENT = "android.app.DialogFragment";
    @NotNull
    private static final String DIALOG_V4_FRAGMENT = "android.support.v4.app.DialogFragment";
    @NotNull
    private static final String FRAGMENT_MANAGER_CLS = "android.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_MANAGER_V4_CLS = "android.support.v4.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_CLS = "android.app.FragmentTransaction";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_V4_CLS = "android.support.v4.app.FragmentTransaction";
    @NotNull
    private static final String VALUE_ANIMATOR_CLS = "android.animation.ValueAnimator";
    @NotNull
    private static final String OBJECT_ANIMATOR_CLS = "android.animation.ObjectAnimator";
    @NotNull
    private static final String ANIMATOR_SET_CLS = "android.animation.AnimatorSet";
    @NotNull
    public static final String SURFACE_CLS = "android.view.Surface";
    @NotNull
    public static final String SURFACE_TEXTURE_CLS = "android.graphics.SurfaceTexture";
    @NotNull
    public static final String CONTENT_PROVIDER_CLIENT_CLS = "android.content.ContentProviderClient";
    @NotNull
    public static final String CONTENT_RESOLVER_CLS = "android.content.ContentResolver";
    @NotNull
    public static final String SQLITE_DATABASE_CLS = "android.database.sqlite.SQLiteDatabase";
    @NotNull
    public static final String CURSOR_CLS = "android.database.Cursor";
    @NotNull
    public static final String ANDROID_CONTENT_SHARED_PREFERENCES = "android.content.SharedPreferences";
    @NotNull
    private static final String ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR = "android.content.SharedPreferences.Editor";

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{BEGIN_TRANSACTION, OBTAIN, OBTAIN_NO_HISTORY, OBTAIN_STYLED_ATTRIBUTES, OBTAIN_ATTRIBUTES, OBTAIN_TYPED_ARRAY, ACQUIRE_CPC, QUERY, RAW_QUERY, QUERY_WITH_FACTORY, RAW_QUERY_WITH_FACTORY, EDIT, OF_INT, OF_ARGB, OF_FLOAT, OF_OBJECT, OF_PROPERTY_VALUES_HOLDER};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> getApplicableConstructorTypes() {
        Object[] objectArray = new String[]{SURFACE_TEXTURE_CLS, SURFACE_CLS, VALUE_ANIMATOR_CLS, OBJECT_ANIMATOR_CLS, ANIMATOR_SET_CLS};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        switch (method.getName()) {
            case "beginTransaction": {
                this.checkTransactionCommits(context2, node, method);
                break;
            }
            case "edit": {
                this.checkEditorApplied(context2, node, method);
                break;
            }
            default: {
                this.checkResourceRecycled(context2, node, method);
            }
        }
    }

    @Override
    public void visitConstructor(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        PsiClass psiClass = constructor.getContainingClass();
        String string2 = string = psiClass == null ? null : psiClass.getQualifiedName();
        if (string == null) {
            return;
        }
        String string3 = string;
        String type = string3;
        if (Intrinsics.areEqual((Object)type, (Object)SURFACE_TEXTURE_CLS) || Intrinsics.areEqual((Object)type, (Object)SURFACE_CLS)) {
            this.checkRecycled(context2, node, type, RELEASE);
        } else {
            this.checkRecycled(context2, node, type, START);
        }
    }

    private final void checkResourceRecycled(JavaContext context2, UCallExpression node, PsiMethod method) {
        PsiClass psiClass;
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String name = string;
        Object object = method.getContainingClass();
        if (object == null) {
            return;
        }
        PsiClass containingClass = psiClass = object;
        JavaEvaluator evaluator = context2.getEvaluator();
        switch (name) {
            case "obtain": 
            case "obtainNoHistory": {
                if (evaluator.extendsClass(containingClass, MOTION_EVENT_CLS, false)) {
                    this.checkRecycled(context2, node, MOTION_EVENT_CLS, RECYCLE);
                    break;
                }
                if (evaluator.extendsClass(containingClass, PARCEL_CLS, false)) {
                    this.checkRecycled(context2, node, PARCEL_CLS, RECYCLE);
                    break;
                }
                if (!evaluator.extendsClass(containingClass, VELOCITY_TRACKER_CLS, false)) break;
                this.checkRecycled(context2, node, VELOCITY_TRACKER_CLS, RECYCLE);
                break;
            }
            case "obtainTypedArray": 
            case "obtainStyledAttributes": 
            case "obtainAttributes": {
                PsiClass cls;
                PsiType returnType;
                if (!evaluator.extendsClass(containingClass, "android.content.Context", false) && !evaluator.extendsClass(containingClass, "android.content.res.Resources", false) || !((returnType = method.getReturnType()) instanceof PsiClassType) || (cls = ((PsiClassType)returnType).resolve()) == null || !Intrinsics.areEqual((Object)"android.content.res.TypedArray", (Object)cls.getQualifiedName())) break;
                this.checkRecycled(context2, node, "android.content.res.TypedArray", RECYCLE);
                break;
            }
            case "acquireContentProviderClient": {
                if (!evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false)) break;
                this.checkRecycled(context2, node, CONTENT_PROVIDER_CLIENT_CLS, RELEASE);
                break;
            }
            case "query": 
            case "queryWithFactory": 
            case "rawQueryWithFactory": 
            case "rawQuery": {
                if (!evaluator.extendsClass(containingClass, SQLITE_DATABASE_CLS, false) && !evaluator.extendsClass(containingClass, CONTENT_RESOLVER_CLS, false) && !evaluator.extendsClass(containingClass, "android.content.ContentProvider", false) && !evaluator.extendsClass(containingClass, CONTENT_PROVIDER_CLIENT_CLS, false)) break;
                for (UElement curr = (UElement)node; curr != null; curr = curr.getUastParent()) {
                    PsiElement psi = curr.getSourcePsi();
                    if (psi == null) continue;
                    if (PsiTreeUtil.getParentOfType((PsiElement)psi, PsiResourceVariable.class) == null) break;
                    return;
                }
                this.checkRecycled(context2, node, CURSOR_CLS, CLOSE);
                break;
            }
            case "ofArgb": 
            case "ofFloat": 
            case "ofPropertyValuesHolder": 
            case "ofInt": 
            case "ofObject": {
                String string2;
                String string3 = containingClass.getQualifiedName();
                if (string3 == null) {
                    return;
                }
                String type = string2 = string3;
                this.checkRecycled(context2, node, type, START);
            }
        }
    }

    private final void checkRecycled(JavaContext context2, UCallExpression node, String recycleType, String recycleName) {
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        Ref.BooleanRef recycled = new Ref.BooleanRef();
        Ref.BooleanRef escapes = new Ref.BooleanRef();
        Set set = SetsKt.setOf((Object)node);
        Object object = CollectionsKt.emptyList();
        DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(recycled, recycleName, context2, recycleType, escapes, set, (List<? extends PsiVariable>)object){
            final /* synthetic */ Ref.BooleanRef $recycled;
            final /* synthetic */ String $recycleName;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ String $recycleType;
            final /* synthetic */ Ref.BooleanRef $escapes;
            {
                this.$recycled = $recycled;
                this.$recycleName = $recycleName;
                this.$context = $context;
                this.$recycleType = $recycleType;
                this.$escapes = $escapes;
                super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
            }

            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                if (this.isCleanup(call)) {
                    this.$recycled.element = true;
                }
            }

            private final boolean isCleanup(UCallExpression call) {
                String methodName = Lint.getMethodName(call);
                if (Intrinsics.areEqual((Object)"use", (Object)methodName)) {
                    PsiElement resolved;
                    UExpression operand = call.getReceiver();
                    if (operand != null && this.getInstances().contains(operand)) {
                        return true;
                    }
                    if (operand instanceof UResolvable && (resolved = ((UResolvable)operand).resolve()) != null && this.getReferences().contains(resolved)) {
                        return true;
                    }
                }
                if (!Intrinsics.areEqual((Object)this.$recycleName, (Object)methodName)) {
                    return false;
                }
                PsiMethod resolved = call.resolve();
                if (resolved != null) {
                    PsiClass containingClass = resolved.getContainingClass();
                    return this.$context.getEvaluator().extendsClass(containingClass, this.$recycleType, false);
                }
                return false;
            }

            public void field(@NotNull UElement field) {
                Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                this.$escapes.element = true;
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                PsiMethod resolved;
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                if (Intrinsics.areEqual((Object)this.$recycleType, (Object)"android.graphics.SurfaceTexture") && UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) && (resolved = call.resolve()) != null && this.$context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.view.Surface")) {
                    return;
                }
                if (Intrinsics.areEqual((Object)"obtain", (Object)Lint.getMethodName(call))) {
                    resolved = call.resolve();
                    if (this.$context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.view.MotionEvent")) {
                        return;
                    }
                }
                this.$escapes.element = true;
            }

            public void returns(@NotNull UReturnExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                this.$escapes.element = true;
            }
        };
        method.accept((UastVisitor)visitor2);
        if (!recycled.element && !escapes.element) {
            String string;
            boolean bl2;
            Object[] objectArray;
            String string2;
            object = recycleType;
            int n10 = StringsKt.lastIndexOf$default((CharSequence)recycleType, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl3 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)object2).substring(n10);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String className = string3;
            String string4 = recycleName;
            if (Intrinsics.areEqual((Object)string4, (Object)RECYCLE)) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "This `%1$s` should be recycled after use with `#recycle()`";
                objectArray = new Object[]{className};
                bl2 = false;
                String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
            } else if (Intrinsics.areEqual((Object)string4, (Object)START)) {
                string = "This animation should be started with `#start()`";
            } else {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "This `%1$s` should be freed up after use with `#%2$s()`";
                objectArray = new Object[]{className, recycleName};
                bl2 = false;
                String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
            }
            String message2 = string;
            UElement locationNode = (UElement)node.getMethodIdentifier();
            if (locationNode == null) {
                locationNode = (UElement)node;
            }
            Location location = context2.getLocation(locationNode);
            JavaContext.report$default(context2, RECYCLE_RESOURCE, (UElement)node, location, message2, null, 16, null);
        }
    }

    private final void checkTransactionCommits(JavaContext context2, UCallExpression node, PsiMethod calledMethod) {
        if (this.isBeginTransaction(context2, calledMethod)) {
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return;
            }
            UMethod method = uMethod;
            Ref.BooleanRef committed = new Ref.BooleanRef();
            Ref.BooleanRef escaped = new Ref.BooleanRef();
            Set set = SetsKt.setOf((Object)node);
            List list2 = CollectionsKt.emptyList();
            DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(this, context2, committed, escaped, set, list2){
                final /* synthetic */ CleanupDetector this$0;
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ Ref.BooleanRef $committed;
                final /* synthetic */ Ref.BooleanRef $escaped;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$committed = $committed;
                    this.$escaped = $escaped;
                    super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
                }

                public void receiver(@NotNull UCallExpression call) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    if (CleanupDetector.access$isTransactionCommitMethodCall(this.this$0, this.$context, call) || CleanupDetector.access$isShowFragmentMethodCall(this.this$0, this.$context, call)) {
                        this.$committed.element = true;
                    }
                }

                public void field(@NotNull UElement field) {
                    Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                    this.$escaped.element = true;
                }

                public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                    this.$escaped.element = true;
                }

                public void returns(@NotNull UReturnExpression expression) {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    this.$escaped.element = true;
                }
            };
            method.accept((UastVisitor)visitor2);
            if (!committed.element && !escaped.element) {
                String message2 = "This transaction should be completed with a `commit()` call";
                JavaContext.report$default(context2, COMMIT_FRAGMENT, (UElement)node, context2.getNameLocation((UElement)node), message2, null, 16, null);
            }
        }
    }

    private final boolean isTransactionCommitMethodCall(JavaContext context2, UCallExpression call) {
        String methodName = Lint.getMethodName(call);
        return (Intrinsics.areEqual((Object)COMMIT, (Object)methodName) || Intrinsics.areEqual((Object)COMMIT_ALLOWING_LOSS, (Object)methodName) || Intrinsics.areEqual((Object)COMMIT_NOW_ALLOWING_LOSS, (Object)methodName) || Intrinsics.areEqual((Object)COMMIT_NOW, (Object)methodName)) && this.isMethodOnFragmentClass(context2, call, FRAGMENT_TRANSACTION_CLS, FRAGMENT_TRANSACTION_V4_CLS, true);
    }

    private final boolean isShowFragmentMethodCall(JavaContext context2, UCallExpression call) {
        String methodName = Lint.getMethodName(call);
        return Intrinsics.areEqual((Object)SHOW, (Object)methodName) && this.isMethodOnFragmentClass(context2, call, DIALOG_FRAGMENT, DIALOG_V4_FRAGMENT, true);
    }

    private final boolean isMethodOnFragmentClass(JavaContext context2, UCallExpression call, String fragmentClass, String v4FragmentClass, boolean returnForUnresolved) {
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return returnForUnresolved;
        }
        PsiMethod method = psiMethod;
        PsiClass containingClass = method.getContainingClass();
        JavaEvaluator evaluator = context2.getEvaluator();
        return evaluator.extendsClass(containingClass, fragmentClass, false) || evaluator.extendsClass(containingClass, v4FragmentClass, false);
    }

    private final void checkEditorApplied(JavaContext context2, UCallExpression node, PsiMethod calledMethod) {
        if (this.isSharedEditorCreation(context2, calledMethod)) {
            Collection collection = node.getValueArguments();
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                return;
            }
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return;
            }
            UMethod method = uMethod;
            Ref.BooleanRef applied = new Ref.BooleanRef();
            Ref.BooleanRef escaped = new Ref.BooleanRef();
            Set set = SetsKt.setOf((Object)node);
            List list2 = CollectionsKt.emptyList();
            DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(this, context2, applied, escaped, set, list2){
                final /* synthetic */ CleanupDetector this$0;
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ Ref.BooleanRef $applied;
                final /* synthetic */ Ref.BooleanRef $escaped;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$applied = $applied;
                    this.$escaped = $escaped;
                    super((Collection<? extends UElement>)$super_call_param$1, (Collection<? extends PsiVariable>)$super_call_param$2);
                }

                public void receiver(@NotNull UCallExpression call) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    if (CleanupDetector.access$isEditorApplyMethodCall(this.this$0, this.$context, call) || CleanupDetector.access$isEditorCommitMethodCall(this.this$0, this.$context, call)) {
                        this.$applied.element = true;
                    }
                }

                public void field(@NotNull UElement field) {
                    Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
                    this.$escaped.element = true;
                }

                public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                    this.$escaped.element = true;
                }

                public void returns(@NotNull UReturnExpression expression) {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    this.$escaped.element = true;
                }
            };
            method.accept((UastVisitor)visitor2);
            if (!applied.element && !escaped.element) {
                String message2 = "`SharedPreferences.edit()` without a corresponding `commit()` or `apply()` call";
                JavaContext.report$default(context2, SHARED_PREF, (UElement)node, context2.getLocation((UElement)node), message2, null, 16, null);
            }
        }
    }

    private final boolean isSharedEditorCreation(JavaContext context2, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)EDIT, (Object)methodName)) {
            PsiClass psiClass;
            PsiClass psiClass2 = method.getContainingClass();
            if (psiClass2 == null) {
                return false;
            }
            PsiClass containingClass = psiClass = psiClass2;
            PsiType psiType = method.getReturnType();
            if (psiType == null) {
                return false;
            }
            PsiClass type = psiClass2 = psiType;
            JavaEvaluator evaluator = context2.getEvaluator();
            return evaluator.implementsInterface(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES, false) && evaluator.typeMatches((PsiType)type, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR);
        }
        return false;
    }

    private final boolean isEditorCommitMethodCall(JavaContext context2, UCallExpression call) {
        String methodName = Lint.getMethodName(call);
        if (Intrinsics.areEqual((Object)COMMIT, (Object)methodName)) {
            PsiMethod method = call.resolve();
            if (method != null) {
                PsiClass containingClass = method.getContainingClass();
                JavaEvaluator evaluator = context2.getEvaluator();
                if (evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false)) {
                    this.suggestApplyIfApplicable(context2, call);
                    return true;
                }
            } else if (call.getValueArgumentCount() == 0) {
                return true;
            }
        }
        return false;
    }

    private final boolean isEditorApplyMethodCall(JavaContext context2, UCallExpression call) {
        String methodName = Lint.getMethodName(call);
        if (Intrinsics.areEqual((Object)APPLY, (Object)methodName)) {
            PsiMethod method = call.resolve();
            if (method != null) {
                PsiClass containingClass = method.getContainingClass();
                JavaEvaluator evaluator = context2.getEvaluator();
                return evaluator.extendsClass(containingClass, ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR, false);
            }
            if (call.getValueArgumentCount() == 0) {
                return true;
            }
        }
        return false;
    }

    private final void suggestApplyIfApplicable(JavaContext context2, UCallExpression node) {
        UExpression condition;
        UElement qualifiedNode = (UElement)node;
        UElement parent = Lint.skipParentheses(node.getUastParent());
        while (parent instanceof UReferenceExpression) {
            qualifiedNode = parent;
            parent = Lint.skipParentheses(((UReferenceExpression)parent).getUastParent());
        }
        boolean returnValueIgnored = true;
        if (parent instanceof UCallExpression || parent instanceof UVariable || parent instanceof UPolyadicExpression || parent instanceof UUnaryExpression || parent instanceof UReturnExpression) {
            returnValueIgnored = false;
        } else if (parent instanceof UIfExpression) {
            condition = ((UIfExpression)parent).getCondition();
            returnValueIgnored = !Intrinsics.areEqual((Object)condition, (Object)qualifiedNode);
        } else if (parent instanceof UWhileExpression) {
            condition = ((UWhileExpression)parent).getCondition();
            returnValueIgnored = !Intrinsics.areEqual((Object)condition, (Object)qualifiedNode);
        } else if (parent instanceof UDoWhileExpression) {
            condition = ((UDoWhileExpression)parent).getCondition();
            boolean bl2 = returnValueIgnored = !Intrinsics.areEqual((Object)condition, (Object)qualifiedNode);
        }
        if (returnValueIgnored) {
            String message2 = "Consider using `apply()` instead; `commit` writes its data to persistent storage immediately, whereas `apply` will handle it in the background";
            Location location = context2.getCallLocation(node, false, true);
            LintFix fix = LintFix.Companion.create().name("Replace commit() with apply()").replace().pattern("(commit)\\s*\\(").with(APPLY).build();
            context2.report(APPLY_SHARED_PREF, (UElement)node, location, message2, fix);
        }
    }

    private final boolean isBeginTransaction(JavaContext context2, PsiMethod method) {
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String methodName = string;
        if (Intrinsics.areEqual((Object)BEGIN_TRANSACTION, (Object)methodName)) {
            PsiClass containingClass = method.getContainingClass();
            JavaEvaluator evaluator = context2.getEvaluator();
            if (evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_CLS, false) || evaluator.extendsClass(containingClass, FRAGMENT_MANAGER_V4_CLS, false)) {
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
        return Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
        return Companion.getVariableElement(rhs, allowChainedCalls);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
        return Companion.getVariableElement(rhs);
    }

    public static final /* synthetic */ boolean access$isTransactionCommitMethodCall(CleanupDetector $this, JavaContext context2, UCallExpression call) {
        return $this.isTransactionCommitMethodCall(context2, call);
    }

    public static final /* synthetic */ boolean access$isShowFragmentMethodCall(CleanupDetector $this, JavaContext context2, UCallExpression call) {
        return $this.isShowFragmentMethodCall(context2, call);
    }

    public static final /* synthetic */ boolean access$isEditorApplyMethodCall(CleanupDetector $this, JavaContext context2, UCallExpression call) {
        return $this.isEditorApplyMethodCall(context2, call);
    }

    public static final /* synthetic */ boolean access$isEditorCommitMethodCall(CleanupDetector $this, JavaContext context2, UCallExpression call) {
        return $this.isEditorCommitMethodCall(context2, call);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        RECYCLE_RESOURCE = Issue.Companion.create$default(companion, "Recycle", "Missing `recycle()` calls", "\n                Many resources, such as TypedArrays, VelocityTrackers, etc., should be recycled \\\n                (with a `recycle()` call) after use. This lint check looks for missing \\\n                `recycle()` calls.", implementation, null, category, 7, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        COMMIT_FRAGMENT = Issue.Companion.create$default(companion, "CommitTransaction", "Missing `commit()` calls", "\n                After creating a `FragmentTransaction`, you typically need to commit it as well\n                ", implementation, null, category, 7, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        SHARED_PREF = Issue.Companion.create$default(companion, "CommitPrefEdits", "Missing `commit()` on `SharedPreference` editor", "\n                After calling `edit()` on a `SharedPreference`, you must call `commit()` or \\\n                `apply()` on the editor to save the results.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(CleanupDetector.class, Scope.JAVA_FILE_SCOPE);
        APPLY_SHARED_PREF = Issue.Companion.create$default(companion, "ApplySharedPref", "Use `apply()` on `SharedPreferences`", "\n                Consider using `apply()` instead of `commit` on shared preferences. Whereas \\\n                `commit` blocks and writes its data to persistent storage immediately, `apply` \\\n                will handle it in the background.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020?2\b\b\u0002\u0010@\u001a\u00020?H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/tools/lint/checks/CleanupDetector$Companion;", "", "()V", "ACQUIRE_CPC", "", "ANDROID_CONTENT_SHARED_PREFERENCES", "ANDROID_CONTENT_SHARED_PREFERENCES_EDITOR", "ANIMATOR_SET_CLS", "APPLY", "APPLY_SHARED_PREF", "Lcom/android/tools/lint/detector/api/Issue;", "BEGIN_TRANSACTION", "CLOSE", "COMMIT", "COMMIT_ALLOWING_LOSS", "COMMIT_FRAGMENT", "COMMIT_NOW", "COMMIT_NOW_ALLOWING_LOSS", "CONTENT_PROVIDER_CLIENT_CLS", "CONTENT_RESOLVER_CLS", "CURSOR_CLS", "DIALOG_FRAGMENT", "DIALOG_V4_FRAGMENT", "EDIT", "FRAGMENT_MANAGER_CLS", "FRAGMENT_MANAGER_V4_CLS", "FRAGMENT_TRANSACTION_CLS", "FRAGMENT_TRANSACTION_V4_CLS", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MOTION_EVENT_CLS", "OBJECT_ANIMATOR_CLS", "OBTAIN", "OBTAIN_ATTRIBUTES", "OBTAIN_NO_HISTORY", "OBTAIN_STYLED_ATTRIBUTES", "OBTAIN_TYPED_ARRAY", "OF_ARGB", "OF_FLOAT", "OF_INT", "OF_OBJECT", "OF_PROPERTY_VALUES_HOLDER", "PARCEL_CLS", "QUERY", "QUERY_WITH_FACTORY", "RAW_QUERY", "RAW_QUERY_WITH_FACTORY", "RECYCLE", "RECYCLE_RESOURCE", "RELEASE", "SHARED_PREF", "SHOW", "SQLITE_DATABASE_CLS", "START", "SURFACE_CLS", "SURFACE_TEXTURE_CLS", "VALUE_ANIMATOR_CLS", "VELOCITY_TRACKER_CLS", "getVariableElement", "Lcom/intellij/psi/PsiVariable;", "rhs", "Lorg/jetbrains/uast/UCallExpression;", "allowChainedCalls", "", "allowFields", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
            Intrinsics.checkParameterIsNotNull((Object)rhs, (String)"rhs");
            return DataFlowAnalyzer.Companion.getVariableElement(rhs, allowChainedCalls, allowFields);
        }

        public static /* synthetic */ PsiVariable getVariableElement$default(Companion companion, UCallExpression uCallExpression, boolean bl2, boolean bl3, int n10, Object object) {
            if ((n10 & 2) != 0) {
                bl2 = false;
            }
            if ((n10 & 4) != 0) {
                bl3 = false;
            }
            return companion.getVariableElement(uCallExpression, bl2, bl3);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls) {
            Intrinsics.checkParameterIsNotNull((Object)rhs, (String)"rhs");
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, allowChainedCalls, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs) {
            Intrinsics.checkParameterIsNotNull((Object)rhs, (String)"rhs");
            return com.android.tools.lint.checks.CleanupDetector$Companion.getVariableElement$default(this, rhs, false, false, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

