/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/IgnoreWithoutReasonDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "IgnoreAnnotationVisitor", "android.sdktools.lint-checks"})
public final class IgnoreWithoutReasonDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UMethod.class, UClass.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        return new IgnoreAnnotationVisitor(context2);
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        ISSUE = Issue.Companion.create("IgnoreWithoutReason", "@Ignore without Reason", "\n            Ignoring a test without a reason makes it difficult to figure out the problem later.\n            Please define an explicit reason why it is ignored, and when it can be resolved.", Category.TESTING, 2, Severity.WARNING, new Implementation(IgnoreWithoutReasonDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES), enumSetArray));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/IgnoreWithoutReasonDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/IgnoreWithoutReasonDetector$IgnoreAnnotationVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "processAnnotations", "", "element", "Lorg/jetbrains/uast/UElement;", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "visitClass", "node", "Lorg/jetbrains/uast/UClass;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "android.sdktools.lint-checks"})
    public static final class IgnoreAnnotationVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public IgnoreAnnotationVisitor(@NotNull JavaContext context2) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            this.context = context2;
        }

        @Override
        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            this.processAnnotations((UElement)node, (UAnnotated)node);
        }

        @Override
        public void visitClass(@NotNull UClass node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            this.processAnnotations((UElement)node, (UAnnotated)node);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void processAnnotations(UElement element, UAnnotated annotated) {
            Object v02;
            block6: {
                PsiElement source = element.getSourcePsi();
                if (source instanceof KtObjectDeclaration && ((KtObjectDeclaration)source).isCompanion()) {
                    return;
                }
                List<UAnnotation> annotations = this.context.getEvaluator().getAllAnnotations(annotated, false);
                Iterable $this$firstOrNull$iv = annotations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    UAnnotation it2 = (UAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getQualifiedName(), (Object)"org.junit.Ignore")) continue;
                    v02 = element$iv;
                    break block6;
                }
                v02 = null;
            }
            UAnnotation ignoreAnnotation = v02;
            if (ignoreAnnotation == null) return;
            UExpression attribute = ignoreAnnotation.findAttributeValue("value");
            if (attribute != null) {
                String value;
                IgnoreAnnotationVisitor ignoreAnnotationVisitor = this;
                boolean bl3 = false;
                boolean bl4 = false;
                IgnoreAnnotationVisitor $this$processAnnotations_u24lambda_u2d1 = ignoreAnnotationVisitor;
                boolean bl5 = false;
                Object object = ConstantEvaluator.evaluate($this$processAnnotations_u24lambda_u2d1.context, (UElement)attribute);
                String string = value = object instanceof String ? (String)object : null;
                if (value != null) {
                    object = value;
                    boolean bl6 = false;
                    if (!StringsKt.isBlank((CharSequence)object) && !Intrinsics.areEqual((Object)value, (Object)"TODO")) {
                        return;
                    }
                }
                boolean bl7 = false;
                if (bl7) {
                    return;
                }
            }
            boolean bl8 = false;
            boolean hasDescription = bl8;
            if (hasDescription) return;
            LintFix fix = attribute == null || ignoreAnnotation.getAttributeValues().isEmpty() ? LintFix.Companion.create().name("Give reason").replace().end().with("(\"TODO\")").select("TODO").build() : (LintFix)null;
            this.context.report(ISSUE, element, this.context.getLocation((UElement)ignoreAnnotation), "Test is ignored without giving any explanation", fix);
        }
    }
}

