/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.uast.UAnnotation;

class IntRangeConstraint
extends RangeConstraint {
    final long from;
    final long to;

    public static IntRangeConstraint create(UAnnotation annotation) {
        assert (AnnotationDetector.INT_RANGE_ANNOTATION.isEquals(annotation.getQualifiedName()));
        long from = UastLintUtils.getAnnotationLongValue(annotation, "from", Long.MIN_VALUE);
        long to2 = UastLintUtils.getAnnotationLongValue(annotation, "to", Long.MAX_VALUE);
        return new IntRangeConstraint(from, to2);
    }

    @VisibleForTesting
    static IntRangeConstraint atLeast(long value) {
        return new IntRangeConstraint(value, Long.MAX_VALUE);
    }

    @VisibleForTesting
    static IntRangeConstraint atMost(long value) {
        return new IntRangeConstraint(Long.MIN_VALUE, value);
    }

    @VisibleForTesting
    static IntRangeConstraint range(long from, long to2) {
        return new IntRangeConstraint(from, to2);
    }

    private IntRangeConstraint(long from, long to2) {
        this.from = from;
        this.to = to2;
    }

    public boolean isValid(long value) {
        return value >= this.from && value <= this.to;
    }

    public String describe() {
        return this.describe(null);
    }

    public String describe(long argument) {
        return this.describe((Long)argument);
    }

    private String describe(Long actualValue) {
        StringBuilder sb2 = new StringBuilder(20);
        if (actualValue != null && !this.isValid(actualValue)) {
            long value = actualValue;
            if (value < this.from) {
                sb2.append("Value must be \u2265 ");
                sb2.append(Long.toString(this.from));
            } else {
                assert (value > this.to);
                sb2.append("Value must be \u2264 ");
                sb2.append(Long.toString(this.to));
            }
            sb2.append(" (was ").append(value).append(')');
            return sb2.toString();
        }
        if (this.to == Long.MAX_VALUE) {
            sb2.append("Value must be \u2265 ");
            sb2.append(Long.toString(this.from));
        } else if (this.from == Long.MIN_VALUE) {
            sb2.append("Value must be \u2264 ");
            sb2.append(Long.toString(this.to));
        } else {
            sb2.append("Value must be \u2265 ");
            sb2.append(Long.toString(this.from));
            sb2.append(" and \u2264 ");
            sb2.append(Long.toString(this.to));
        }
        if (actualValue != null) {
            sb2.append(" (is ").append(actualValue).append(')');
        }
        return sb2.toString();
    }

    public String toString() {
        return this.describe(null);
    }

    @Override
    public Boolean contains(RangeConstraint other) {
        if (other instanceof IntRangeConstraint) {
            IntRangeConstraint otherRange = (IntRangeConstraint)other;
            return otherRange.from >= this.from && otherRange.to <= this.to;
        }
        if (other instanceof FloatRangeConstraint) {
            FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
            if (!otherRange.fromInclusive && otherRange.from == (double)this.from || !otherRange.toInclusive && otherRange.to == (double)this.to) {
                return false;
            }
            if (otherRange.to > (double)this.to && (!Double.isInfinite(otherRange.to) || this.to != Long.MAX_VALUE)) {
                return false;
            }
            if (otherRange.from < (double)this.from && (!Double.isInfinite(otherRange.from) || this.from != Long.MIN_VALUE)) {
                return false;
            }
            return true;
        }
        return null;
    }
}

