/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/IntentDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableConstructorTypes", "", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class IntentDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String INTENT_CLASS = "android.content.Intent";
    @NotNull
    private static final String ANDROID_NET_URI = "android.net.Uri";
    @NotNull
    private static final String SET_DATA = "setData";
    @NotNull
    private static final String SET_TYPE = "setType";

    @Override
    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)INTENT_CLASS);
    }

    @Override
    public void visitConstructor(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        int n10;
        int n11;
        PsiElement parent;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        PsiElement constructorStatement = null;
        PsiElement variable = null;
        UBlockExpression block = null;
        UElement p10 = node.getUastParent();
        while (p10 != null) {
            if (p10 instanceof UVariable) {
                variable = (PsiElement)((UVariable)p10).getPsi();
            } else if (UastExpressionUtils.isAssignment((UElement)p10)) {
                UElement uElement = p10;
                variable = UastUtils.tryResolve((UElement)((UElement)((UBinaryExpression)uElement).getLeftOperand()));
            }
            parent = p10.getUastParent();
            if (parent instanceof UBlockExpression) {
                block = (UBlockExpression)parent;
                UElement uElement = p10;
                constructorStatement = uElement instanceof UExpression ? (UExpression)uElement : null;
                break;
            }
            p10 = parent;
        }
        if ((parent = variable) == null) {
            return;
        }
        parent = constructorStatement;
        if (parent == null) {
            return;
        }
        parent = block;
        if (parent == null) {
            return;
        }
        List statements = block.getExpressions();
        int start = statements.indexOf(constructorStatement);
        if (start == -1) {
            return;
        }
        boolean seenInConstructor = false;
        UElement seenData = null;
        UElement seenType = null;
        for (UExpression argument : node.getValueArguments()) {
            PsiType type;
            PsiType psiType = argument.getExpressionType();
            if (psiType == null || !Intrinsics.areEqual((Object)(type = psiType).getCanonicalText(), (Object)ANDROID_NET_URI) || argument instanceof ULiteralExpression && ((ULiteralExpression)argument).isNull()) continue;
            seenInConstructor = true;
            seenData = (UElement)argument;
            break;
        }
        if ((n11 = start + 1) < (n10 = statements.size())) {
            do {
                String string;
                UElement prev;
                UExpression arg;
                List args;
                UExpression call;
                PsiElement statementReceiver;
                int index;
                UExpression statement;
                if (!((statement = (UExpression)statements.get(index = n11++)) instanceof UQualifiedReferenceExpression) || !Intrinsics.areEqual((Object)(statementReceiver = UastUtils.tryResolve((UElement)((UElement)((UQualifiedReferenceExpression)statement).getReceiver()))), (Object)variable) || !((call = ((UQualifiedReferenceExpression)statement).getSelector()) instanceof UCallExpression) || (args = ((UCallExpression)call).getValueArguments()).size() != 1 || (arg = (UExpression)args.get(0)) instanceof ULiteralExpression && ((ULiteralExpression)arg).isNull()) continue;
                String name = ((UCallExpression)call).getMethodName();
                if (Intrinsics.areEqual((Object)name, (Object)SET_DATA)) {
                    seenData = (UElement)call;
                } else {
                    if (!Intrinsics.areEqual((Object)name, (Object)SET_TYPE)) continue;
                    seenType = (UElement)call;
                }
                if (seenData == null || seenType == null) continue;
                UElement uElement = prev = Intrinsics.areEqual((Object)name, (Object)SET_DATA) ? seenType : seenData;
                if (seenInConstructor) {
                    string = "setting URI in `Intent` constructor";
                } else {
                    UCallExpression uCallExpression = prev instanceof UCallExpression ? (UCallExpression)prev : null;
                    string = "calling `" + (uCallExpression == null ? null : uCallExpression.getMethodName()) + '`';
                }
                String prevDesc = string;
                String data = Intrinsics.areEqual((Object)name, (Object)SET_DATA) ? "type" : "data";
                Location location = Location.withSecondary$default(context2.getLocation((UElement)call), context2.getLocation(prev), "Originally set here", false, 4, null);
                context2.report(ISSUE, (UElement)call, location, "Calling `" + name + "` after " + prevDesc + " will clear the " + data + ": Call `setDataAndType` instead?", null);
            } while (n11 < n10);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(IntentDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "IntentReset", "Suspicious mix of `setType` and `setData`", "\n                Intent provides the following APIs: `setData(Uri)` and `setType(String)`. \\\n                Unfortunately, setting one clears the other. If you want to set both, you \\\n                should call `setDataAndType(Uri, String)` instead.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/IntentDetector$Companion;", "", "()V", "ANDROID_NET_URI", "", "INTENT_CLASS", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "SET_DATA", "SET_TYPE", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

