/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.kotlin.KotlinUClass;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016JH\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002J0\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J0\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u001cH\u0002J \u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/MissingClassDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/ClassScanner;", "()V", "checkedClasses", "", "", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkClassReference", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "pkg", "className", "classNameNode", "Lorg/w3c/dom/Node;", "element", "Lorg/w3c/dom/Element;", "requireInstantiatable", "expectedParent", "checkExpectedParent", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "nameNode", "cls", "Lcom/intellij/psi/PsiClass;", "checkInnerClassReference", "checkInstantiatable", "fqcn", "getApplicableElements", "", "getRefLocation", "Lcom/android/tools/lint/detector/api/Location;", "hasImplicitDefaultConstructor", "psiClass", "reportMissing", "location", "Lcom/android/tools/lint/detector/api/Context;", "visitElement", "Companion", "android.sdktools.lint-checks"})
public final class MissingClassDetector
extends LayoutDetector
implements ClassScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, Boolean> checkedClasses;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING;
    @JvmField
    @NotNull
    public static final Issue INSTANTIATABLE;
    @JvmField
    @NotNull
    public static final Issue INNERCLASS;

    public MissingClassDetector() {
        boolean bl2 = false;
        this.checkedClasses = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        List list2 = LayoutDetector.ALL;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ALL");
        return list2;
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.TRANSITION;
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String tag = element.getTagName();
        ResourceFolderType resourceFolderType = context2.getResourceFolderType();
        int n10 = resourceFolderType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resourceFolderType.ordinal()];
        switch (n10) {
            case -1: {
                String string;
                if (!Intrinsics.areEqual((Object)"application", (Object)tag) && !Intrinsics.areEqual((Object)"activity", (Object)tag) && !Intrinsics.areEqual((Object)"service", (Object)tag) && !Intrinsics.areEqual((Object)"receiver", (Object)tag) && !Intrinsics.areEqual((Object)"provider", (Object)tag)) break;
                Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (attr == null) {
                    return;
                }
                Attr attr2 = attr;
                String pkg2 = context2.getProject().getPackage();
                String string2 = attr2.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"attr.value");
                String string3 = string2;
                Node node = attr2;
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"tag");
                switch (tag) {
                    case "activity": {
                        string = "android.app.Activity";
                        break;
                    }
                    case "service": {
                        string = "android.app.Service";
                        break;
                    }
                    case "receiver": {
                        string = "android.content.BroadcastReceiver";
                        break;
                    }
                    case "provider": {
                        string = "android.content.ContentProvider";
                        break;
                    }
                    case "application": {
                        string = "android.app.Application";
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                this.checkClassReference(context2, pkg2, string3, node, element, true, string);
                break;
            }
            case 1: {
                if (!Intrinsics.areEqual((Object)tag, (Object)"string") || !SdkUtils.endsWith((CharSequence)context2.file.getPath(), (CharSequence)"analytics.xml")) break;
                Object pkg2 = element.getAttributeNode("name");
                if (pkg2 == null) {
                    return;
                }
                Attr attr = pkg2;
                pkg2 = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)pkg2, (String)"attr.value");
                MissingClassDetector.checkClassReference$default(this, context2, null, (String)pkg2, attr, element, false, null, 96, null);
                break;
            }
            case 2: {
                Object pkg2;
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"tag");
                if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) > 0) {
                    MissingClassDetector.checkClassReference$default(this, context2, null, tag, element, element, false, LintClient.Companion.isStudio() ? null : "android.view.View", 32, null);
                    break;
                }
                if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
                    Object pkg2 = element.getAttributeNode("class");
                    if (pkg2 == null) {
                        return;
                    }
                    Attr attr = pkg2;
                    pkg2 = attr.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pkg2, (String)"attr.value");
                    MissingClassDetector.checkClassReference$default(this, context2, null, (String)pkg2, attr, element, false, LintClient.Companion.isStudio() ? null : "android.view.View", 32, null);
                    break;
                }
                if (!Intrinsics.areEqual((Object)tag, (Object)"fragment")) break;
                Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                Object object = pkg2 = attr == null ? element.getAttributeNode("class") : attr;
                if (pkg2 == null) {
                    return;
                }
                Attr attr3 = pkg2;
                pkg2 = attr3.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)pkg2, (String)"attr.value");
                this.checkClassReference(context2, null, (String)pkg2, attr3, element, true, "android.app.Fragment");
                break;
            }
            case 3: {
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"tag");
                if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) > 0) {
                    MissingClassDetector.checkClassReference$default(this, context2, null, tag, element, element, false, null, 96, null);
                    break;
                }
                if (!Intrinsics.areEqual((Object)tag, (Object)"drawable")) break;
                Object pkg2 = element.getAttributeNode("class");
                if (pkg2 == null) {
                    return;
                }
                Attr attr = pkg2;
                pkg2 = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)pkg2, (String)"attr.value");
                MissingClassDetector.checkClassReference$default(this, context2, null, (String)pkg2, attr, element, false, "android.graphics.drawable.Drawable", 32, null);
                break;
            }
            case 4: {
                if (!Intrinsics.areEqual((Object)tag, (Object)"transition") && !Intrinsics.areEqual((Object)tag, (Object)"pathMotion")) break;
                Attr pkg2 = element.getAttributeNode("class");
                if (pkg2 == null) {
                    return;
                }
                Attr attr = pkg2;
                String expectedParent = Intrinsics.areEqual((Object)tag, (Object)"transition") ? "android.transition.Transition" : "android.transition.PathMotion";
                String string = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attr.value");
                MissingClassDetector.checkClassReference$default(this, context2, null, string, attr, element, false, expectedParent, 32, null);
                break;
            }
            case 5: {
                if (!Intrinsics.areEqual((Object)tag, (Object)"header")) break;
                Object expectedParent = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fragment");
                if (expectedParent == null) {
                    return;
                }
                Attr attr = expectedParent;
                expectedParent = attr.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)expectedParent, (String)"attr.value");
                this.checkClassReference(context2, null, (String)expectedParent, attr, element, true, "android.app.Fragment");
                break;
            }
            case 6: {
                Attr attr;
                Object object;
                Attr view;
                if (!Intrinsics.areEqual((Object)tag, (Object)"item")) break;
                Object expectedParent = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "actionViewClass");
                Attr attr4 = view = expectedParent == null ? element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "actionViewClass") : expectedParent;
                if (view != null) {
                    expectedParent = view.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)expectedParent, (String)"view.value");
                    MissingClassDetector.checkClassReference$default(this, context2, null, (String)expectedParent, view, element, false, "android.view.View", 32, null);
                }
                Object object2 = object = (attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "actionProviderClass")) == null ? element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "actionProviderClass") : attr;
                if (object == null) {
                    return;
                }
                Attr provider = object;
                object = provider.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"provider.value");
                MissingClassDetector.checkClassReference$default(this, context2, null, (String)object, provider, element, false, null, 96, null);
            }
        }
    }

    private final void checkClassReference(XmlContext context2, String pkg, String className, Node classNameNode, Element element, boolean requireInstantiatable, String expectedParent) {
        CharSequence charSequence = className;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return;
        }
        String fqcn = null;
        int dotIndex = StringsKt.indexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex <= 0) {
            if (pkg == null) {
                return;
            }
            fqcn = dotIndex == 0 ? Intrinsics.stringPlus((String)pkg, (Object)className) : pkg + '.' + className;
        } else {
            fqcn = className;
        }
        if (StringsKt.startsWith$default((String)fqcn, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqcn, (String)"com.android.internal.", (boolean)false, (int)2, null)) {
            return;
        }
        Boolean ok2 = this.checkedClasses.get(fqcn);
        if (ok2 == null) {
            UastParser parser = context2.getClient().getUastParser(context2.getProject());
            JavaEvaluator evaluator = parser.getEvaluator();
            PsiClass cls = evaluator.findClass(StringsKt.replace$default((String)fqcn, (char)'$', (char)'.', (boolean)false, (int)4, null));
            if (cls != null) {
                ok2 = true;
                if (requireInstantiatable) {
                    this.checkInstantiatable(context2, evaluator, cls, fqcn, classNameNode);
                }
                this.checkInnerClassReference(context2, cls, className, classNameNode, element);
                if (expectedParent != null) {
                    this.checkExpectedParent(context2, evaluator, classNameNode, cls, expectedParent);
                }
            } else {
                ok2 = false;
            }
            Map<String, Boolean> map = this.checkedClasses;
            boolean bl3 = false;
            map.put(fqcn, ok2);
        }
        if (Intrinsics.areEqual((Object)ok2, (Object)false)) {
            Location location = this.getRefLocation(context2, classNameNode);
            this.reportMissing(location, fqcn, context2);
        }
    }

    static /* synthetic */ void checkClassReference$default(MissingClassDetector missingClassDetector, XmlContext xmlContext, String string, String string2, Node node, Element element, boolean bl2, String string3, int n10, Object object) {
        if ((n10 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n10 & 0x40) != 0) {
            string3 = null;
        }
        missingClassDetector.checkClassReference(xmlContext, string, string2, node, element, bl2, string3);
    }

    private final void checkExpectedParent(XmlContext context2, JavaEvaluator evaluator, Node nameNode, PsiClass cls, String expectedParent) {
        if (!evaluator.inheritsFrom(cls, expectedParent, false)) {
            PsiClass psiClass;
            if (Intrinsics.areEqual((Object)expectedParent, (Object)"android.app.Fragment")) {
                String string = SdkConstants.CLASS_V4_FRAGMENT.oldName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS_V4_FRAGMENT.oldName()");
                this.checkExpectedParent(context2, evaluator, nameNode, cls, string);
                return;
            }
            if (Intrinsics.areEqual((Object)expectedParent, (Object)SdkConstants.CLASS_V4_FRAGMENT.oldName())) {
                String string = SdkConstants.CLASS_V4_FRAGMENT.newName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CLASS_V4_FRAGMENT.newName()");
                this.checkExpectedParent(context2, evaluator, nameNode, cls, string);
                return;
            }
            PsiClass psiClass2 = cls.getSuperClass();
            if (psiClass2 == null) {
                return;
            }
            PsiClass curr = psiClass = psiClass2;
            while (true) {
                String qualifiedName;
                if (Intrinsics.areEqual((Object)(qualifiedName = curr.getQualifiedName()), (Object)expectedParent)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)qualifiedName, (Object)"java.lang.Object")) break;
                psiClass2 = curr.getSuperClass();
                if (psiClass2 == null) {
                    return;
                }
                curr = psiClass2;
            }
            String message2 = StringsKt.contains$default((CharSequence)expectedParent, (CharSequence)"Fragment", (boolean)false, (int)2, null) ? '`' + cls.getName() + "` must be a fragment" : '`' + cls.getName() + "` must extend " + expectedParent;
            Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message2, null, 8, null);
        }
    }

    private final void checkInnerClassReference(XmlContext context2, PsiClass cls, String className, Node nameNode, Element element) {
        String full;
        String string;
        String name = cls.getName();
        if (cls.getContainingClass() == null || name == null || StringsKt.contains$default((CharSequence)className, (CharSequence)"$", (boolean)false, (int)2, null)) {
            return;
        }
        String string2 = Lint.getInternalName(cls);
        String string3 = string = string2 == null ? null : StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
        if (string == null) {
            return;
        }
        string2 = full = string;
        int n10 = full.length() - className.length();
        boolean bl2 = false;
        String string4 = string2.substring(n10);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String fixed = string4;
        String message2 = "Use '$' instead of '.' for inner classes; replace \"" + className + "\" with \"" + fixed + '\"';
        Location location = this.getRefLocation(context2, nameNode);
        LintFix fix = this.fix().replace().text(className).with(fixed).autoFix().build();
        context2.report(INNERCLASS, element, location, message2, fix);
    }

    private final void checkInstantiatable(XmlContext context2, JavaEvaluator evaluator, PsiClass cls, String fqcn, Node nameNode) {
        if (evaluator.isPrivate((PsiModifierListOwner)cls)) {
            String message2 = "This class should be public (`" + fqcn + "`)";
            Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message2, null, 8, null);
        } else if (cls.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)cls)) {
            String message3 = "This inner class should be static (`" + fqcn + "`)";
            Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message3, null, 8, null);
        } else {
            PsiMethod[] constructors = cls.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull((Object)constructors, (String)"constructors");
            PsiMethod[] psiMethodArray = constructors;
            boolean bl2 = false;
            if (psiMethodArray.length == 0 && this.hasImplicitDefaultConstructor(cls)) {
                return;
            }
            PsiMethod[] psiMethodArray2 = cls.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray2, (String)"cls.constructors");
            for (PsiMethod constructor : psiMethodArray2) {
                if (!constructor.getParameterList().isEmpty()) continue;
                if (evaluator.isPrivate((PsiModifierListOwner)constructor)) {
                    String message4 = "The default constructor must be public in `" + fqcn + '`';
                    Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message4, null, 8, null);
                    return;
                }
                return;
            }
            String message5 = "This class should provide a default constructor (a public constructor with no arguments) (`" + fqcn + "`)";
            Context.report$default(context2, INSTANTIATABLE, this.getRefLocation(context2, nameNode), message5, null, 8, null);
        }
    }

    private final Location getRefLocation(XmlContext context2, Node nameNode) {
        return nameNode instanceof Attr ? context2.getValueLocation((Attr)nameNode) : context2.getLocation(nameNode);
    }

    private final boolean hasImplicitDefaultConstructor(PsiClass psiClass) {
        if (psiClass instanceof KotlinUClass && ((KotlinUClass)psiClass).getSourcePsi() == null) {
            return false;
        }
        PsiMethod[] constructors = psiClass.getConstructors();
        Intrinsics.checkExpressionValueIsNotNull((Object)constructors, (String)"constructors");
        PsiMethod[] psiMethodArray = constructors;
        boolean bl2 = false;
        if (psiMethodArray.length == 0 && !psiClass.isInterface() && !psiClass.isAnnotationType() && !psiClass.isEnum()) {
            if (PsiUtil.hasDefaultConstructor((PsiClass)psiClass)) {
                return true;
            }
            if (psiClass.hasModifierProperty("final") && !psiClass.hasModifierProperty("abstract") && psiClass.hasModifierProperty("public")) {
                return true;
            }
        }
        return false;
    }

    private final void reportMissing(Location location, String fqcn, Context context2) {
        String string;
        File parentFile = location.getFile().getParentFile();
        if (parentFile != null) {
            String parent = parentFile.getName();
            ResourceFolderType type = ResourceFolderType.getFolderType((String)parent);
            int n10 = type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
            switch (n10) {
                case -1: {
                    string = "manifest";
                    break;
                }
                case 2: {
                    string = "layout file";
                    break;
                }
                case 5: {
                    string = "preference header file";
                    break;
                }
                case 1: {
                    string = "analytics file";
                    break;
                }
                default: {
                    String string2 = type.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type.getName()");
                    Locale locale = Locale.US;
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"US");
                    boolean bl2 = false;
                    String string3 = string2;
                    boolean bl3 = false;
                    String string4 = string3.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                    string = Intrinsics.stringPlus((String)string4, (Object)" file");
                    break;
                }
            }
        } else {
            string = "the manifest";
        }
        String target2 = string;
        String message2 = "Class referenced in the " + target2 + ", `" + fqcn + "`, was not found in the project or the libraries";
        Context.report$default(context2, MISSING, location, message2, null, 8, null);
    }

    static {
        Object object = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)MissingClassDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, (EnumSet<Scope>)object);
        object = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        MISSING = Issue.Companion.create$default((Issue.Companion)object, "MissingClass", "Missing registered class", "\n                    If a class is referenced in the manifest or in a layout file, it must \\\n                    also exist in the project (or in one of the libraries included by the \\\n                    project. This check helps uncover typos in registration names, or \\\n                    attempts to rename or move classes without updating the XML references\n                    properly.\n                    ", implementation, "https://developer.android.com/guide/topics/manifest/manifest-intro.html", category, 8, severity, false, true, null, null, 3328, null).setAliases(CollectionsKt.listOf((Object)"MissingRegistered"));
        object = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.FATAL;
        implementation = IMPLEMENTATION;
        INSTANTIATABLE = Issue.Companion.create$default((Issue.Companion)object, "Instantiatable", "Registered class is not instantiatable", "\n                    Activities, services, broadcast receivers etc. registered in the \\\n                    manifest file (or for custom views, in a layout file) must be \\\n                    \"instantiatable\" by the system, which means that the class must \\\n                    be public, it must have an empty public constructor, and if it's an \\\n                    inner class, it must be a static inner class.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        object = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        INNERCLASS = Issue.Companion.create$default((Issue.Companion)object, "InnerclassSeparator", "Inner classes should use `$` rather than `.`", "\n                    When you reference an inner class in a manifest file, you must use '$' \\\n                    instead of '.' as the separator character, i.e. Outer$Inner instead of \\\n                    Outer.Inner.\n\n                    (If you get this warning for a class which is not actually an inner class, \\\n                    it's because you are using uppercase characters in your package name, which \\\n                    is not conventional.)\n                    ", implementation, null, category, 3, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/MissingClassDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "INNERCLASS", "Lcom/android/tools/lint/detector/api/Issue;", "INSTANTIATABLE", "MISSING", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceFolderType.values().length];
            nArray[ResourceFolderType.VALUES.ordinal()] = 1;
            nArray[ResourceFolderType.LAYOUT.ordinal()] = 2;
            nArray[ResourceFolderType.DRAWABLE.ordinal()] = 3;
            nArray[ResourceFolderType.TRANSITION.ordinal()] = 4;
            nArray[ResourceFolderType.XML.ordinal()] = 5;
            nArray[ResourceFolderType.MENU.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

