/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.support.AndroidxName;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelModule;
import com.android.utils.DomExtensions;
import com.google.common.collect.Sets;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002DEB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0002J \u0010\u001c\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010\u0014H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010\u00182\u0006\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u00182\b\u0010.\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010/\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00100\u001a\u00020#H\u0002J\u0018\u00101\u001a\u00020\f2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u001dH\u0002J<\u00107\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00108\u001a\u0002092\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010)\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u00182\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J\u0018\u0010>\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J \u0010B\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010C\u001a\u00020#2\u0006\u0010)\u001a\u00020:H\u0016R\u0018\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "mAlreadyWarned", "", "", "sceneIds", "", "Lcom/android/tools/lint/checks/ObjectAnimatorDetector$SceneReference;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkProperty", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "propertyNameExpression", "Lorg/jetbrains/uast/UExpression;", "targetClass", "Lcom/intellij/psi/PsiClass;", "expectedType", "", "checkPropertyValueHolders", "expressions", "", "filterIncident", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "findHolderConstruction", "Lorg/jetbrains/uast/UCallExpression;", "arg", "getApplicableElements", "", "getApplicableMethodNames", "getExpectedType", "method", "evaluatorIndex", "", "getMethodName", "prefix", "propertyName", "isHolderConstructionMethod", "callExpression", "isInSameCompilationUnit", "element1", "Lorg/jetbrains/uast/UElement;", "element2", "Lcom/intellij/psi/PsiElement;", "isShrinking", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "Lcom/intellij/psi/PsiMethod;", "originalMessage", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "node", "Companion", "SceneReference", "android.sdktools.lint-checks"})
public final class ObjectAnimatorDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<Object> mAlreadyWarned;
    @Nullable
    private List<SceneReference> sceneIds;
    @NotNull
    private static final String MOTION_LAYOUT_URI = "http://schemas.android.com/apk/res-auto";
    private static final AndroidxName KEEP_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"Keep");
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING_KEEP;
    @JvmField
    @NotNull
    public static final Issue BROKEN_PROPERTY;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"ofInt", "ofArgb", "ofFloat", "ofMultiInt", "ofMultiFloat", "ofObject", "ofPropertyValuesHolder"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        PsiClassType psiClassType;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JavaEvaluator evaluator = context2.getEvaluator();
        if (!(evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator") || Intrinsics.areEqual((Object)method.getName(), (Object)"ofPropertyValuesHolder") && evaluator.isMemberInClass((PsiMember)method, "android.animation.ValueAnimator"))) {
            return;
        }
        List expressions = node.getValueArguments();
        if (expressions.size() < 2) {
            return;
        }
        PsiType psiType = TypeEvaluator.evaluate((UElement)expressions.get(0));
        PsiClassType psiClassType2 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return;
        }
        PsiClassType type = psiClassType;
        Object object = type.resolve();
        if (object == null) {
            return;
        }
        PsiType targetClass = psiType = object;
        object = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"method.name");
        Object methodName = object;
        if (Intrinsics.areEqual((Object)methodName, (Object)"ofPropertyValuesHolder")) {
            if (!evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator")) {
                return;
            }
            this.checkPropertyValueHolders(context2, (PsiClass)targetClass, expressions);
        } else {
            String string = this.getExpectedType(node, 2);
            if (string == null) {
                return;
            }
            String expectedType = string;
            this.checkProperty(context2, (UExpression)expressions.get(1), (PsiClass)targetClass, expectedType);
        }
    }

    private final void checkPropertyValueHolders(JavaContext context2, PsiClass targetClass, List<? extends UExpression> expressions) {
        int n10 = 1;
        int n11 = expressions.size();
        if (n10 < n11) {
            do {
                int i10;
                UExpression arg;
                UCallExpression uCallExpression;
                if ((uCallExpression = this.findHolderConstruction(context2, arg = expressions.get(i10 = n10++))) == null) {
                    return;
                }
                UCallExpression holder = uCallExpression;
                List args = holder.getValueArguments();
                if (args.size() < 2) continue;
                String string = this.getExpectedType(holder, 1);
                if (string == null) {
                    return;
                }
                String expectedType = string;
                this.checkProperty(context2, (UExpression)args.get(0), targetClass, expectedType);
            } while (n10 < n11);
        }
    }

    private final void checkProperty(JavaContext context2, UExpression propertyNameExpression, PsiClass targetClass, String expectedType) {
        String string;
        Object object = ConstantEvaluator.evaluate(context2, (UElement)propertyNameExpression);
        String string2 = string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String property = string;
        String string3 = targetClass.getQualifiedName();
        if (string3 == null) {
            return;
        }
        object = string3;
        Object qualifiedName = object;
        if (StringsKt.indexOf$default((CharSequence)((CharSequence)qualifiedName), (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            return;
        }
        String methodName = this.getMethodName("set", property);
        PsiMethod[] methods = targetClass.findMethodsByName(methodName, true);
        PsiMethod bestMethod = null;
        boolean isExactMatch = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)methods, (String)"methods");
        PsiMethod[] psiMethodArray = methods;
        int n10 = 0;
        int n11 = psiMethodArray.length;
        while (n10 < n11) {
            PsiMethod m10 = psiMethodArray[n10];
            ++n10;
            if (m10.getParameterList().getParametersCount() == 1) {
                if (bestMethod == null) {
                    bestMethod = m10;
                }
                JavaEvaluator javaEvaluator = context2.getEvaluator();
                Intrinsics.checkExpressionValueIsNotNull((Object)m10, (String)"m");
                String[] stringArray = new String[]{expectedType};
                if (!javaEvaluator.parametersMatch(m10, stringArray)) continue;
                bestMethod = m10;
                isExactMatch = true;
                break;
            }
            if (bestMethod != null) continue;
            bestMethod = m10;
        }
        if (bestMethod == null) {
            this.report(context2, BROKEN_PROPERTY, propertyNameExpression, null, "Could not find property setter method `" + methodName + "` on `" + (String)qualifiedName + '`', null);
            return;
        }
        if (!isExactMatch) {
            this.report(context2, BROKEN_PROPERTY, propertyNameExpression, bestMethod, "The setter for this property does not match the expected signature (`public void " + methodName + '(' + expectedType + " arg`)", null);
        } else if (context2.getEvaluator().isStatic((PsiModifierListOwner)bestMethod)) {
            this.report(context2, BROKEN_PROPERTY, propertyNameExpression, bestMethod, "The setter for this property (" + (String)qualifiedName + '.' + methodName + ") should not be static", null);
        } else {
            PsiModifierListOwner owner = (PsiModifierListOwner)bestMethod;
            while (owner != null) {
                for (PsiAnnotation annotation : context2.getEvaluator().getAllAnnotations(owner, false)) {
                    if (!KEEP_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
                    return;
                }
                owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)owner), PsiModifierListOwner.class, (boolean)true);
            }
            if (!this.isShrinking(context2)) {
                return;
            }
            LintFix.Builder builder = this.fix();
            String string4 = KEEP_ANNOTATION.newName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"KEEP_ANNOTATION.newName()");
            LintFix fix = LintFix.Builder.annotate$default(builder, string4, false, 2, null).range(context2.getLocation((PsiElement)bestMethod)).build();
            this.report(context2, MISSING_KEEP, propertyNameExpression, bestMethod, "This method is accessed from an ObjectAnimator so it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds", fix);
        }
    }

    private final void report(JavaContext context2, Issue issue, UExpression propertyNameExpression, PsiMethod method, String originalMessage, LintFix fix) {
        Set alreadyWarned;
        Set set;
        boolean bl2;
        boolean reportOnMethod;
        String message2 = originalMessage;
        boolean bl3 = reportOnMethod = issue == MISSING_KEEP && method != null;
        if (reportOnMethod && method instanceof PsiCompiledElement) {
            return;
        }
        UExpression locationNode = reportOnMethod && method != null ? method : propertyNameExpression;
        Set set2 = this.mAlreadyWarned;
        if (set2 == null) {
            Set set3;
            ObjectAnimatorDetector objectAnimatorDetector = this;
            boolean bl4 = false;
            bl2 = false;
            ObjectAnimatorDetector $this$report_u24lambda_u2d0 = objectAnimatorDetector;
            boolean bl5 = false;
            Set set4 = Sets.newIdentityHashSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"newIdentityHashSet()");
            $this$report_u24lambda_u2d0.mAlreadyWarned = set3 = set4;
            set = set3;
        } else {
            set = alreadyWarned = set2;
        }
        if (alreadyWarned.contains(locationNode)) {
            return;
        }
        alreadyWarned.add((Object)locationNode);
        Location methodLocation = null;
        if (method != null && !(method instanceof PsiCompiledElement)) {
            Location location;
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                PsiElement psiElement = (PsiElement)nameIdentifier;
                PsiParameterList psiParameterList = method.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
                location = context2.getRangeLocation(psiElement, 0, (PsiElement)psiParameterList, 0);
            } else {
                location = context2.getNameLocation((PsiElement)method);
            }
            methodLocation = location;
        }
        Location location = null;
        if (reportOnMethod && methodLocation != null && method != null) {
            location = methodLocation;
            Location secondary = context2.getLocation((UElement)propertyNameExpression);
            location.setSecondary(secondary);
            secondary.setMessage("ObjectAnimator usage here");
            if (this.isInSameCompilationUnit((UElement)propertyNameExpression, (PsiElement)method)) {
                secondary.setVisible(false);
            } else {
                bl2 = issue == MISSING_KEEP;
                boolean bl6 = false;
                boolean bl7 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl8 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                String secondaryMessage = "The method referenced here (" + method.getName() + ") has not been annotated with `@Keep` which means it could be discarded or renamed in release builds";
                if (location == Location.NONE) {
                    location = secondary;
                    message2 = secondaryMessage;
                } else {
                    secondary.setMessage(secondaryMessage);
                }
            }
        } else {
            location = context2.getNameLocation((UElement)propertyNameExpression);
            if (methodLocation != null) {
                location = Location.withSecondary$default(location, methodLocation, "Property setter here", false, 4, null);
            }
        }
        UElement owner = UastUtils.getParentOfType((UElement)((UElement)propertyNameExpression), UDeclaration.class, (boolean)false);
        if (owner != null && context2.getDriver().isSuppressed(context2, issue, owner)) {
            return;
        }
        context2.report(issue, (PsiElement)method, location, message2, fix);
    }

    private final String getExpectedType(UCallExpression method, int evaluatorIndex) {
        String methodName;
        String string = Lint.getMethodName(method);
        if (string == null) {
            return null;
        }
        switch (methodName = string) {
            case "ofInt": 
            case "ofArgb": {
                return "int";
            }
            case "ofFloat": {
                return "float";
            }
            case "ofMultiInt": {
                return "int[]";
            }
            case "ofMultiFloat": {
                return "float[]";
            }
            case "ofKeyframe": {
                return "android.animation.Keyframe";
            }
            case "ofObject": {
                String string2;
                List args = method.getValueArguments();
                if (args.size() <= evaluatorIndex) break;
                Object object = TypeEvaluator.evaluate((UElement)args.get(evaluatorIndex));
                if (object == null) {
                    return null;
                }
                PsiType evaluatorType = object;
                switch (evaluatorType.getCanonicalText()) {
                    case "android.animation.FloatEvaluator": {
                        string2 = "float";
                        break;
                    }
                    case "android.animation.FloatArrayEvaluator": {
                        string2 = "float[]";
                        break;
                    }
                    case "android.animation.IntEvaluator": 
                    case "android.animation.ArgbEvaluator": {
                        string2 = "int";
                        break;
                    }
                    case "android.animation.IntArrayEvaluator": {
                        string2 = "int[]";
                        break;
                    }
                    case "android.animation.PointFEvaluator": {
                        string2 = "android.graphics.PointF";
                        break;
                    }
                    default: {
                        string2 = null;
                    }
                }
                return string2;
            }
        }
        return null;
    }

    private final UCallExpression findHolderConstruction(JavaContext context2, UExpression arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof UCallExpression) {
            if (this.isHolderConstructionMethod(context2, (UCallExpression)arg)) {
                return (UCallExpression)arg;
            }
        } else if (arg instanceof UReferenceExpression) {
            UCallExpression selector;
            if (arg instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)arg).getSelector() instanceof UCallExpression && this.isHolderConstructionMethod(context2, selector = (UCallExpression)((UQualifiedReferenceExpression)arg).getSelector())) {
                return selector;
            }
            PsiElement resolved = ((UReferenceExpression)arg).resolve();
            if (resolved instanceof PsiVariable) {
                UCallExpression callExpression;
                UExpression expression;
                PsiElement el2;
                UExpression lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, (UElement)arg);
                while (lastAssignment instanceof USimpleNameReferenceExpression && (el2 = ((USimpleNameReferenceExpression)lastAssignment).resolve()) instanceof PsiLocalVariable) {
                    lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)el2, (UElement)lastAssignment);
                }
                if (lastAssignment instanceof UCallExpression) {
                    UExpression callExpression2 = lastAssignment;
                    if (this.isHolderConstructionMethod(context2, (UCallExpression)callExpression2)) {
                        return (UCallExpression)callExpression2;
                    }
                } else if (lastAssignment instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)(expression = lastAssignment)).getSelector() instanceof UCallExpression && this.isHolderConstructionMethod(context2, callExpression = (UCallExpression)((UQualifiedReferenceExpression)expression).getSelector())) {
                    return callExpression;
                }
            }
        }
        return null;
    }

    private final boolean isHolderConstructionMethod(JavaContext context2, UCallExpression callExpression) {
        PsiMethod resolved;
        String referenceName = Lint.getMethodName(callExpression);
        return referenceName != null && StringsKt.startsWith$default((String)referenceName, (String)"of", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)referenceName, (Object)"ofKeyframe") && (resolved = callExpression.resolve()) != null && context2.getEvaluator().isMemberInClass((PsiMember)resolved, "android.animation.PropertyValuesHolder");
    }

    private final boolean isInSameCompilationUnit(UElement element1, PsiElement element2) {
        PsiElement psi;
        PsiFile file;
        UFile containingFile = UastUtils.getContainingUFile((UElement)element1);
        UFile uFile = containingFile;
        PsiFile psiFile = file = uFile == null ? null : uFile.getPsi();
        if (file == null && (psi = element1.getPsi()) != null) {
            file = psi.getContainingFile();
        }
        return Intrinsics.areEqual((Object)file, (Object)element2.getContainingFile());
    }

    private final String getMethodName(String prefix, String propertyName) {
        block3: {
            block2: {
                if (propertyName == null) break block2;
                CharSequence charSequence = propertyName;
                boolean bl2 = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String string = propertyName;
        int n10 = 1;
        boolean bl3 = false;
        String string2 = string.substring(n10);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String theRest = string2;
        return prefix + firstLetter + theRest;
    }

    private final boolean isShrinking(Context context2) {
        Project project = context2.isGlobalAnalysis() ? context2.getMainProject() : context2.getProject();
        LintModelModule model = project.getBuildModule();
        return model != null ? !model.neverShrinking() : true;
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[3];
        String string = SdkConstants.MOTION_LAYOUT.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MOTION_LAYOUT.oldName()");
        objectArray[0] = string;
        string = SdkConstants.MOTION_LAYOUT.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MOTION_LAYOUT.newName()");
        objectArray[1] = string;
        objectArray[2] = "CustomAttribute";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (context2.getResourceFolderType() == ResourceFolderType.LAYOUT) {
            String sceneReference = element.getAttributeNS(MOTION_LAYOUT_URI, "layoutDescription");
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneReference, (String)"sceneReference");
            CharSequence charSequence = sceneReference;
            boolean bl2 = false;
            if (charSequence.length() == 0) {
                return;
            }
            Object object = sceneReference;
            int n10 = StringsKt.indexOf$default((CharSequence)sceneReference, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl3 = false;
            String string = ((String)object).substring(n10);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            String sceneName22 = string;
            object = DomExtensions.iterator((Element)element);
            while (object.hasNext()) {
                List list2;
                boolean bl4;
                Object object2;
                Element view22 = (Element)object.next();
                String string2 = view22.getTagName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"view.tagName");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)".", (boolean)false, (int)2, null)) continue;
                String id2 = Lint.stripIdPrefix(view22.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
                CharSequence charSequence2 = id2;
                boolean bl5 = false;
                if (!(charSequence2.length() > 0)) continue;
                Collection<Object> collection = this.sceneIds;
                if (collection == null) {
                    object2 = this;
                    bl4 = false;
                    boolean bl6 = false;
                    ObjectAnimatorDetector $this$visitElement_u24lambda_u2d1 = object2;
                    boolean bl7 = false;
                    ArrayList list3 = new ArrayList();
                    $this$visitElement_u24lambda_u2d1.sceneIds = list3;
                    list2 = list3;
                } else {
                    list2 = collection;
                }
                List list4 = list2;
                collection = list4;
                object2 = view22.getTagName();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"view.tagName");
                object2 = new SceneReference((String)object2, id2, sceneName22);
                bl4 = false;
                collection.add(object2);
            }
        } else {
            Element id2;
            boolean sceneReference = context2.getResourceFolderType() == ResourceFolderType.XML;
            boolean sceneName22 = false;
            boolean bl8 = false;
            if (_Assertions.ENABLED && !sceneReference) {
                boolean view22 = false;
                String view22 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)view22));
            }
            List<SceneReference> sceneName22 = this.sceneIds;
            if (sceneName22 == null) {
                return;
            }
            List<SceneReference> ids = sceneName22;
            Attr attribute = element.getAttributeNodeNS(MOTION_LAYOUT_URI, "attributeName");
            Attr attr = attribute;
            if (attr == null) {
                return;
            }
            String attributeName = attribute.getValue();
            Node list4 = element.getParentNode();
            Element element2 = id2 = list4 instanceof Element ? (Element)list4 : null;
            if (id2 == null) {
                return;
            }
            Element parent = id2;
            String parentId = Lint.stripIdPrefix(parent.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
            String string = context2.file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.name");
            String sceneName = Lint.getBaseName(string);
            for (SceneReference s10 : ids) {
                if (!Intrinsics.areEqual((Object)parentId, (Object)s10.getId()) || !Intrinsics.areEqual((Object)s10.getScene(), (Object)sceneName)) continue;
                String viewClass = s10.getViewClass();
                UastParser uastParser = context2.getClient().getUastParser(context2.getProject());
                JavaEvaluator evaluator = uastParser.getEvaluator();
                PsiClass list3 = evaluator.findClass(viewClass);
                if (list3 == null) continue;
                PsiClass targetClass = list3;
                String methodName = this.getMethodName("set", attributeName);
                PsiMethod[] methods = targetClass.findMethodsByName(methodName, true);
                Intrinsics.checkExpressionValueIsNotNull((Object)methods, (String)"methods");
                PsiMethod[] psiMethodArray = methods;
                int n11 = 0;
                int n12 = psiMethodArray.length;
                while (n11 < n12) {
                    PsiMethod m10 = psiMethodArray[n11];
                    ++n11;
                    if (m10.getParameterList().getParametersCount() != 1) continue;
                    PsiModifierListOwner owner = (PsiModifierListOwner)m10;
                    while (owner != null) {
                        PsiModifierList modifierList = owner.getModifierList();
                        if (modifierList != null) {
                            PsiAnnotation[] psiAnnotationArray = modifierList.getAnnotations();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray, (String)"modifierList.annotations");
                            for (PsiAnnotation annotation : psiAnnotationArray) {
                                if (!KEEP_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
                                return;
                            }
                        }
                        owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)owner), PsiModifierListOwner.class, (boolean)true);
                    }
                    if (!this.isShrinking(context2)) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)attribute, (String)"attribute");
                    Location location = context2.getValueLocation(attribute);
                    LintDriver lintDriver = context2.getDriver();
                    Project project = context2.getProject();
                    Project project2 = context2.getProject();
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)targetClass.getContainingFile().getVirtualFile());
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"virtualToIoFile(targetCl\u2026ntainingFile.virtualFile)");
                    JavaContext javaContext = new JavaContext(lintDriver, project, project2, file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)m10, (String)"m");
                    location.withSecondary(uastParser.getLocation(javaContext, (PsiElement)m10), "This method is accessed via reflection from a MotionScene (" + sceneName + ") so it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds", true);
                    Incident incident = new Incident(MISSING_KEEP, element, location, "This attribute references a method or property in custom view " + viewClass + " which is not annotated with `@Keep`; it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds");
                    context2.report(incident, this.map());
                }
            }
        }
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)incident, (String)"incident");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        return this.isShrinking(context2);
    }

    static {
        Object object = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)ObjectAnimatorDetector.class, Scope.JAVA_AND_RESOURCE_FILES, (EnumSet<Scope>)object);
        object = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        MISSING_KEEP = Issue.Companion.create$default((Issue.Companion)object, "AnimatorKeep", "Missing @Keep for Animated Properties", "\n                    When you use property animators, properties can be accessed via reflection. \\\n                    Those methods should be annotated with @Keep to ensure that during release \\\n                    builds, the methods are not potentially treated as unused and removed, or \\\n                    treated as internal only and get renamed to something shorter.\n\n                    This check will also flag other potential reflection problems it encounters, \\\n                    such as a missing property, wrong argument types, etc.\n                    ", implementation, null, category, 4, severity, false, true, null, null, 3344, null);
        object = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        BROKEN_PROPERTY = Issue.Companion.create$default((Issue.Companion)object, "ObjectAnimatorBinding", "Incorrect ObjectAnimator Property", "\n                    This check cross references properties referenced by String from \\\n                    `ObjectAnimator` and `PropertyValuesHolder` method calls and ensures that \\\n                    the corresponding setter methods exist and have the right signatures.\n                    ", implementation, null, category, 4, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector$SceneReference;", "", "viewClass", "", "id", "scene", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getScene", "getViewClass", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.lint-checks"})
    private static final class SceneReference {
        @NotNull
        private final String viewClass;
        @NotNull
        private final String id;
        @NotNull
        private final String scene;

        public SceneReference(@NotNull String viewClass, @NotNull String id2, @NotNull String scene) {
            Intrinsics.checkParameterIsNotNull((Object)viewClass, (String)"viewClass");
            Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
            this.viewClass = viewClass;
            this.id = id2;
            this.scene = scene;
        }

        @NotNull
        public final String getViewClass() {
            return this.viewClass;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getScene() {
            return this.scene;
        }

        @NotNull
        public final String component1() {
            return this.viewClass;
        }

        @NotNull
        public final String component2() {
            return this.id;
        }

        @NotNull
        public final String component3() {
            return this.scene;
        }

        @NotNull
        public final SceneReference copy(@NotNull String viewClass, @NotNull String id2, @NotNull String scene) {
            Intrinsics.checkParameterIsNotNull((Object)viewClass, (String)"viewClass");
            Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
            return new SceneReference(viewClass, id2, scene);
        }

        public static /* synthetic */ SceneReference copy$default(SceneReference sceneReference, String string, String string2, String string3, int n10, Object object) {
            if ((n10 & 1) != 0) {
                string = sceneReference.viewClass;
            }
            if ((n10 & 2) != 0) {
                string2 = sceneReference.id;
            }
            if ((n10 & 4) != 0) {
                string3 = sceneReference.scene;
            }
            return sceneReference.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SceneReference(viewClass=" + this.viewClass + ", id=" + this.id + ", scene=" + this.scene + ')';
        }

        public int hashCode() {
            int result2 = this.viewClass.hashCode();
            result2 = result2 * 31 + this.id.hashCode();
            result2 = result2 * 31 + this.scene.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SceneReference)) {
                return false;
            }
            SceneReference sceneReference = (SceneReference)other;
            if (!Intrinsics.areEqual((Object)this.viewClass, (Object)sceneReference.viewClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)sceneReference.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scene, (Object)sceneReference.scene);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/ObjectAnimatorDetector$Companion;", "", "()V", "BROKEN_PROPERTY", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KEEP_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "getKEEP_ANNOTATION", "()Lcom/android/support/AndroidxName;", "MISSING_KEEP", "MOTION_LAYOUT_URI", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final AndroidxName getKEEP_ANNOTATION() {
            return KEEP_ANNOTATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

