/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.ResourceCycleDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JH\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0002J,\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\"H\u0016J\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001e\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0005H\u0002J0\u0010&\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J(\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J \u0010+\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0018\u0010,\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u0018H\u0016R(\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/ResourceCycleDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "mChains", "", "Lcom/android/resources/ResourceType;", "", "", "mLocations", "Lcom/google/common/collect/Multimap;", "Lcom/android/tools/lint/detector/api/Location;", "mReferences", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckRootProject", "checkCrashItem", "Lcom/android/tools/lint/detector/api/XmlContext;", "item", "Lorg/w3c/dom/Element;", "dfs", "map", "from", "visiting", "", "visited", "findCycles", "type", "getApplicableAttributes", "", "getApplicableElements", "getLocationMap", "getTypeMap", "handleReference", "node", "Lorg/w3c/dom/Node;", "to", "recordLocation", "recordReference", "visitAttribute", "attribute", "Lorg/w3c/dom/Attr;", "visitElement", "element", "Companion", "android.sdktools.lint-checks"})
public final class ResourceCycleDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<ResourceType, Multimap<String, String>> mReferences;
    @Nullable
    private Map<ResourceType, Multimap<String, Location>> mLocations;
    @Nullable
    private Map<ResourceType, List<List<String>>> mChains;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ResourceCycleDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue CYCLE = Issue.Companion.create("ResourceCycle", "Cycle in resource definitions", "\n                There should be no cycles in resource definitions as this can lead to \\\n                runtime exceptions.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue CRASH = Issue.Companion.create("AaptCrash", "Potential AAPT crash", "\n                Defining a style which sets `android:id` to a dynamically generated id can \\\n                cause many versions of `aapt`, the resource packaging tool, to crash. \\\n                To work around this, declare the id explicitly with \\\n                `<item type=\"id\" name=\"...\" />` instead.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
            this.mReferences = Maps.newEnumMap(ResourceType.class);
        }
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.FONT || folderType == ResourceFolderType.COLOR || folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"include", "style", "color", "item", "font", "string", "dimen"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Collection<String> getApplicableAttributes() {
        List list2 = ResourceXmlDetector.ALL;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ALL");
        return list2;
    }

    private final void recordReference(ResourceType type, String from, String to2) {
        String string;
        CharSequence charSequence = to2;
        boolean bl2 = false;
        if (charSequence.length() == 0 || StringsKt.startsWith$default((String)to2, (String)"@android:", (boolean)false, (int)2, null)) {
            return;
        }
        Multimap<String, String> multimap = this.getTypeMap(type);
        if (multimap == null) {
            return;
        }
        Multimap<String, String> map = multimap;
        if (to2.charAt(0) == '@') {
            int index = StringsKt.indexOf$default((CharSequence)to2, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                String string2 = to2;
                int n10 = index + 1;
                boolean bl3 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n10);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = to2;
            }
        } else {
            string = to2;
        }
        String name = string;
        map.put((Object)from, (Object)name);
    }

    private final Multimap<String, String> getTypeMap(ResourceType type) {
        Map<ResourceType, Multimap<String, String>> map = this.mReferences;
        if (map == null) {
            return null;
        }
        Map<ResourceType, Multimap<String, String>> references2 = map;
        Multimap<String, String> map2 = references2.get(type);
        if (map2 != null) {
            return map2;
        }
        Object object = Multimaps.newListMultimap((Map)new TreeMap(), (Supplier)getTypeMap.newMap.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"newListMultimap(TreeMap(\u2026Size<String>(6)\n        }");
        Multimap newMap2 = (Multimap)object;
        object = references2;
        boolean bl2 = false;
        object.put(type, newMap2);
        return newMap2;
    }

    private final void recordLocation(XmlContext context2, Node node, ResourceType type, String from) {
        Multimap<String, Location> multimap = this.getLocationMap(type);
        if (multimap == null) {
            return;
        }
        Multimap<String, Location> map = multimap;
        Location location = context2.getLocation(node);
        map.put((Object)from, (Object)location);
    }

    private final Multimap<String, Location> getLocationMap(ResourceType type) {
        Map<ResourceType, Multimap<String, Location>> map = this.mLocations;
        if (map == null) {
            return null;
        }
        Map<ResourceType, Multimap<String, Location>> locations = map;
        Multimap<String, Location> map2 = locations.get(type);
        if (map2 != null) {
            return map2;
        }
        Object object = ArrayListMultimap.create((int)30, (int)4);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"create(30, 4)");
        Multimap newMap2 = (Multimap)object;
        object = locations;
        boolean bl2 = false;
        object.put(type, newMap2);
        return newMap2;
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        block60: {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            String tagName = element.getTagName();
            if (tagName == null) break block60;
            int n10 = -1;
            switch (tagName.hashCode()) {
                case 1942574248: {
                    if (tagName.equals("include")) {
                        n10 = 1;
                    }
                    break;
                }
                case 3242771: {
                    if (tagName.equals("item")) {
                        n10 = 2;
                    }
                    break;
                }
                case 95588145: {
                    if (tagName.equals("dimen")) {
                        n10 = 3;
                    }
                    break;
                }
                case 94842723: {
                    if (tagName.equals("color")) {
                        n10 = 3;
                    }
                    break;
                }
                case -891985903: {
                    if (tagName.equals("string")) {
                        n10 = 3;
                    }
                    break;
                }
                case 109780401: {
                    if (tagName.equals("style")) {
                        n10 = 4;
                    }
                    break;
                }
                case 3148879: {
                    if (tagName.equals("font")) {
                        n10 = 5;
                    }
                    break;
                }
            }
            switch (n10) {
                case 2: {
                    String drawable;
                    if (this.mReferences == null) {
                        return;
                    }
                    ResourceFolderType folderType = context2.getResourceFolderType();
                    if (folderType == ResourceFolderType.VALUES) {
                        Attr typeNode = element.getAttributeNode("type");
                        if (typeNode == null) break;
                        String typeName = typeNode.getValue();
                        ResourceType type = ResourceType.fromXmlValue((String)typeName);
                        Attr nameNode2 = element.getAttributeNode("name");
                        if (type == null || nameNode2 == null) break;
                        NodeList childNodes2 = element.getChildNodes();
                        int i102 = 0;
                        int n11 = childNodes2.getLength();
                        while (i102 < n11) {
                            Node child = childNodes2.item(i102);
                            if (child.getNodeType() == 3) {
                                char c10;
                                String text = child.getNodeValue();
                                int k10 = 0;
                                int max = text.length();
                                while (k10 < max && !Character.isWhitespace(c10 = text.charAt(k10)) && c10 == '@') {
                                    Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"text");
                                    String string = type.getName();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.getName()");
                                    if (!StringsKt.startsWith$default((String)text, (String)string, (int)(k10 + 1), (boolean)false, (int)4, null)) break;
                                    String $this$trim$iv = text;
                                    boolean $i$f$trim = false;
                                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                                    boolean $i$f$trim2 = false;
                                    int startIndex$iv$iv = 0;
                                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                    boolean startFound$iv$iv = false;
                                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                                        boolean match$iv$iv;
                                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                        char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                        boolean bl2 = false;
                                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                                        if (!startFound$iv$iv) {
                                            if (!match$iv$iv) {
                                                startFound$iv$iv = true;
                                                continue;
                                            }
                                            ++startIndex$iv$iv;
                                            continue;
                                        }
                                        if (!match$iv$iv) break;
                                        --endIndex$iv$iv;
                                    }
                                    String to22 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                                    if (this.mReferences != null) {
                                        String name = nameNode2.getValue();
                                        if (this.mLocations != null) {
                                            Intrinsics.checkExpressionValueIsNotNull((Object)child, (String)"child");
                                            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                                            this.recordLocation(context2, child, type, name);
                                        } else {
                                            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                                            this.recordReference(type, name, to22);
                                        }
                                    }
                                    int to22 = k10;
                                    k10 = to22 + 1;
                                }
                            }
                            int text = i102;
                            i102 = text + 1;
                        }
                        break;
                    }
                    if (folderType == ResourceFolderType.COLOR) {
                        String color = element.getAttributeNS("http://schemas.android.com/apk/res/android", "color");
                        if (color == null || !StringsKt.startsWith$default((String)color, (String)"@color/", (boolean)false, (int)2, null)) break;
                        String type = context2.file.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"context.file.name");
                        String currentColor = Lint.getBaseName(type);
                        Node node = element;
                        type = color;
                        int nameNode2 = "@color/".length();
                        boolean childNodes2 = false;
                        String string = type.substring(nameNode2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                        this.handleReference(context2, node, ResourceType.COLOR, currentColor, string);
                        break;
                    }
                    if (folderType != ResourceFolderType.DRAWABLE || (drawable = element.getAttributeNS("http://schemas.android.com/apk/res/android", "drawable")) == null || !StringsKt.startsWith$default((String)drawable, (String)"@drawable/", (boolean)false, (int)2, null)) break;
                    String type = context2.file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"context.file.name");
                    String currentColor = Lint.getBaseName(type);
                    Node node = element;
                    type = drawable;
                    int nameNode2 = "@drawable/".length();
                    boolean childNodes2 = false;
                    String string = type.substring(nameNode2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                    this.handleReference(context2, node, ResourceType.DRAWABLE, currentColor, string);
                    break;
                }
                case 4: {
                    boolean n11;
                    int i102;
                    Object name;
                    Attr nameNode = element.getAttributeNode("name");
                    Attr parentNode = element.getAttributeNode("parent");
                    if (parentNode != null && nameNode != null) {
                        name = nameNode.getValue();
                        String parent = parentNode.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)parent, (String)"parent");
                        if (StringsKt.startsWith$default((String)parent, (String)"@style/", (boolean)false, (int)2, null)) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                            if (StringsKt.startsWith$default((String)parent, (String)name, (int)"@style/".length(), (boolean)false, (int)4, null) && StringsKt.startsWith$default((String)parent, (String)".", (int)("@style/".length() + ((String)name).length()), (boolean)false, (int)4, null)) {
                                if (context2.isEnabled(CYCLE) && context2.getDriver().getPhase() == 1) {
                                    Node node = parentNode;
                                    Location location = context2.getLocation(parentNode);
                                    StringBuilder stringBuilder = new StringBuilder().append("Potential cycle: `").append(name).append("` is the implied parent of `");
                                    String nameNode2 = parent;
                                    int childNodes2 = "@style/".length();
                                    boolean i102 = false;
                                    String string = nameNode2.substring(childNodes2);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                                    XmlContext.report$default(context2, CYCLE, node, location, stringBuilder.append(string).append("` and this defines the opposite").toString(), null, 16, null);
                                }
                                return;
                            }
                        }
                        CharSequence nameNode2 = parent;
                        boolean childNodes2 = false;
                        if (!(nameNode2.length() == 0) && !StringsKt.startsWith$default((String)parent, (String)"@android:style/", (boolean)false, (int)2, null)) {
                            String childNodes2 = parent;
                            i102 = StringsKt.lastIndexOf$default((CharSequence)parent, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                            n11 = false;
                            String string = childNodes2.substring(i102);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                            String parentName = string;
                            Node node = parentNode;
                            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                            this.handleReference(context2, node, ResourceType.STYLE, (String)name, parentName);
                            if (StringsKt.startsWith$default((String)parent, (String)"@", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)parent, (CharSequence)"style/", (boolean)false, (int)2, null)) {
                                XmlContext.report$default(context2, CYCLE, parentNode, context2.getLocation(parentNode), "Invalid parent reference: expected a @style", null, 16, null);
                            }
                        }
                    } else if (this.mReferences != null && nameNode != null) {
                        name = nameNode.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                        int index = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)name), (char)'.', (int)0, (boolean)false, (int)6, null);
                        if (index > 0) {
                            Object childNodes2 = name;
                            i102 = 0;
                            n11 = false;
                            String string = ((String)childNodes2).substring(i102, index);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            String parent = string;
                            if (this.mReferences != null) {
                                if (this.mLocations != null) {
                                    Attr node = element.getAttributeNode("name");
                                    Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"node");
                                    this.recordLocation(context2, node, ResourceType.STYLE, (String)name);
                                } else {
                                    this.recordReference(ResourceType.STYLE, (String)name, parent);
                                }
                            }
                        }
                    }
                    if (!context2.isEnabled(CRASH) || context2.getDriver().getPhase() != 1) break;
                    for (Element item : XmlUtils.getSubTags((Node)element)) {
                        if (!Intrinsics.areEqual((Object)"android:id", (Object)item.getAttribute("name"))) continue;
                        Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"item");
                        this.checkCrashItem(context2, item);
                    }
                    break;
                }
                case 1: {
                    Attr layoutNode = element.getAttributeNode("layout");
                    if (layoutNode == null) break;
                    String layout = layoutNode.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)layout, (String)"layout");
                    if (!StringsKt.startsWith$default((String)layout, (String)"@layout/", (boolean)false, (int)2, null)) break;
                    String item = context2.file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"context.file.name");
                    String currentLayout = Lint.getBaseName(item);
                    this.handleReference(context2, layoutNode, ResourceType.LAYOUT, currentLayout, layout);
                    break;
                }
                case 3: {
                    NodeList childNodes = element.getChildNodes();
                    int i11 = 0;
                    int n12 = childNodes.getLength();
                    while (i11 < n12) {
                        Node child = childNodes.item(i11);
                        if (child.getNodeType() == 3) {
                            char c11;
                            String text = child.getNodeValue();
                            int k11 = 0;
                            int max = text.length();
                            while (k11 < max && !Character.isWhitespace(c11 = text.charAt(k11)) && c11 == '@') {
                                Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"text");
                                if (!StringsKt.startsWith$default((String)text, (String)tagName, (int)(k11 + 1), (boolean)false, (int)4, null)) break;
                                String $this$trim$iv = text;
                                int $i$f$trim = 0;
                                CharSequence $this$trim$iv$iv22 = $this$trim$iv;
                                boolean $i$f$trim3 = false;
                                int startIndex$iv$iv = 0;
                                int endIndex$iv$iv = $this$trim$iv$iv22.length() - 1;
                                boolean startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    char it3 = $this$trim$iv$iv22.charAt(index$iv$iv);
                                    boolean bl4 = false;
                                    boolean bl5 = match$iv$iv = Intrinsics.compare((int)it3, (int)32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                $this$trim$iv = ((Object)$this$trim$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                                $i$f$trim = tagName.length() + 2;
                                boolean $this$trim$iv$iv22 = false;
                                String string = $this$trim$iv;
                                if (string == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)string.substring($i$f$trim), (String)"(this as java.lang.String).substring(startIndex)");
                                String name = element.getAttribute("name");
                                ResourceType type = ResourceType.fromXmlTagName((String)tagName);
                                if (type != null) {
                                    String to2;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)child, (String)"child");
                                    Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
                                    this.handleReference(context2, child, type, name, to2);
                                }
                                int to2 = k11;
                                k11 = to2 + 1;
                            }
                        }
                        int text = i11;
                        i11 = text + 1;
                    }
                    break;
                }
                case 5: {
                    Attr text = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "font");
                    if (text == null) break;
                    String i11 = text.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)i11, (String)"text.value");
                    if (!StringsKt.startsWith$default((String)i11, (String)"@font/", (boolean)false, (int)2, null)) break;
                    String n12 = text.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)n12, (String)"text.value");
                    String $this$trim$iv = n12;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim4 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it4 = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl6 = false;
                        boolean bl7 = match$iv$iv = Intrinsics.compare((int)it4, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    int n13 = "@font/".length();
                    boolean bl8 = false;
                    String string = $this$trim$iv;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.substring(n13);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    String font = string2;
                    String string3 = context2.file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.file.name");
                    String currentFont = Lint.getBaseName(string3);
                    this.handleReference(context2, text, ResourceType.FONT, currentFont, font);
                }
            }
        }
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Map<ResourceType, Multimap<String, String>> map = this.mReferences;
        if (map == null) {
            return;
        }
        Map<ResourceType, Multimap<String, String>> references2 = map;
        int phase = context2.getDriver().getPhase();
        if (phase == 1) {
            Object object = references2;
            boolean bl2 = false;
            Iterator<Map.Entry<ResourceType, Multimap<String, String>>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl3 = false;
                ResourceType type = (ResourceType)object2.getKey();
                Object object3 = object;
                boolean bl4 = false;
                Multimap map2 = (Multimap)object3.getValue();
                this.findCycles(context2, type, (Multimap<String, String>)map2);
            }
        } else {
            boolean bl5 = phase == 2;
            boolean bl6 = false;
            boolean bl7 = false;
            if (_Assertions.ENABLED && !bl5) {
                boolean bl8 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Map<ResourceType, List<List<String>>> map3 = this.mChains;
            if (map3 == null) {
                return;
            }
            Map<ResourceType, List<List<String>>> chainsMap = map3;
            Map<ResourceType, Multimap<String, Location>> map4 = this.mLocations;
            if (map4 == null) {
                return;
            }
            Map<ResourceType, Multimap<String, Location>> locationMap = map4;
            Object object = chainsMap;
            boolean bl9 = false;
            map4 = object.entrySet().iterator();
            while (map4.hasNext()) {
                Object object4 = object = (Map.Entry)map4.next();
                boolean bl10 = false;
                ResourceType type = (ResourceType)object4.getKey();
                Object object5 = object;
                boolean bl11 = false;
                List chains = (List)object5.getValue();
                Multimap multimap = locationMap.get(type);
                Multimap locations = multimap == null ? (Multimap)ArrayListMultimap.create() : multimap;
                for (List chain : chains) {
                    String message2;
                    Location location = null;
                    boolean bl12 = !chain.isEmpty();
                    boolean bl13 = false;
                    boolean bl14 = false;
                    if (_Assertions.ENABLED && !bl12) {
                        boolean bl15 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    int i10 = 0;
                    int n10 = chain.size();
                    while (i10 < n10) {
                        String item = (String)chain.get(i10);
                        Collection itemLocations = locations.get((Object)item);
                        if (!itemLocations.isEmpty()) {
                            Location itemLocation = (Location)itemLocations.iterator().next();
                            String next = (String)chain.get((i10 + 1) % chain.size());
                            String label = "Reference from @" + type.getName() + '/' + item + " to " + type.getName() + '/' + next + " here";
                            itemLocation.setMessage(label);
                            itemLocation.setSecondary(location);
                            location = itemLocation;
                        }
                        int n11 = i10;
                        i10 = n11 + 1;
                    }
                    if (location == null) {
                        File item = context2.getProject().getDir();
                        Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"context.project.dir");
                        location = Location.Companion.create(item);
                    } else {
                        Location curr = location.getSecondary();
                        while (curr != null) {
                            Location next = curr.getSecondary();
                            if (next == location) {
                                curr.setSecondary(null);
                                break;
                            }
                            curr = next;
                        }
                    }
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "%1$s Resource definition cycle: %2$s";
                    Object[] objectArray = new Object[]{type.getDisplayName(), Joiner.on((String)" => ").join((Iterable)chain)};
                    boolean bl16 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    Context.report$default(context2, CYCLE, location, message2, null, 8, null);
                }
            }
        }
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        ResourceFolderType resourceFolderType = context2.getResourceFolderType();
        if (resourceFolderType == null || resourceFolderType == ResourceFolderType.VALUES) {
            return;
        }
        String value = attribute.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"value");
        CharSequence charSequence = value;
        boolean bl2 = false;
        if (charSequence.length() == 0 || !StringsKt.startsWith$default((String)value, (String)"@", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"@+id/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"@id/", (boolean)false, (int)2, null)) {
            return;
        }
        List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)resourceFolderType);
        String primary = ((ResourceType)types.get(0)).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)primary, (String)"primary");
        if (!StringsKt.regionMatches((String)value, (int)1, (String)primary, (int)0, (int)primary.length(), (boolean)false)) {
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)value);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl url = resourceUrl;
        if (!types.contains(url.type)) {
            return;
        }
        if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)attribute.getNamespaceURI())) {
            return;
        }
        String string = context2.file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.name");
        String from = Lint.getBaseName(string);
        Node node = attribute;
        string = url.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.type");
        String string2 = string;
        string = url.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.name");
        this.handleReference(context2, node, (ResourceType)string2, from, string);
    }

    private final void handleReference(XmlContext context2, Node node, ResourceType type, String from, String to2) {
        if (Intrinsics.areEqual((Object)from, (Object)to2)) {
            if (context2.isEnabled(CYCLE) && context2.getDriver().getPhase() == 1) {
                String string;
                Location location = context2.getLocation(node);
                StringBuilder stringBuilder = new StringBuilder().append((Object)type.getDisplayName()).append(" `").append(to2).append("` should not ");
                ResourceType resourceType = type;
                int n10 = WhenMappings.$EnumSwitchMapping$0[resourceType.ordinal()];
                switch (n10) {
                    case 1: {
                        string = "include";
                        break;
                    }
                    case 2: {
                        string = "extend";
                        break;
                    }
                    default: {
                        string = "reference";
                    }
                }
                XmlContext.report$default(context2, CYCLE, node, location, stringBuilder.append(string).append(" itself").toString(), null, 16, null);
            }
        } else if (this.mReferences != null) {
            if (this.mLocations != null) {
                this.recordLocation(context2, node, type, from);
            } else {
                this.recordReference(type, from, to2);
            }
        }
    }

    private final void findCycles(Context context2, ResourceType type, Multimap<String, String> map) {
        HashSet visiting = Sets.newHashSet();
        HashSet visited = Sets.newHashSetWithExpectedSize((int)map.size());
        HashSet seen = Sets.newHashSetWithExpectedSize((int)map.size());
        for (String from : map.keySet()) {
            Map map2;
            EnumMap enumMap;
            boolean bl2;
            Object object;
            if (seen.contains(from)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)from, (String)"from");
            Intrinsics.checkExpressionValueIsNotNull((Object)visiting, (String)"visiting");
            Set set = visiting;
            Intrinsics.checkExpressionValueIsNotNull((Object)visited, (String)"visited");
            List<String> chain = this.dfs(map, from, set, visited);
            if (chain == null || chain.size() <= 2) continue;
            seen.addAll((Collection)chain);
            CollectionsKt.reverse(chain);
            EnumMap enumMap2 = this.mChains;
            if (enumMap2 == null) {
                object = this;
                bl2 = false;
                boolean bl3 = false;
                Object[] $this$findCycles_u24lambda_u2d3 = object;
                boolean bl4 = false;
                EnumMap newMap2 = Maps.newEnumMap(ResourceType.class);
                $this$findCycles_u24lambda_u2d3.mChains = newMap2;
                $this$findCycles_u24lambda_u2d3.mLocations = Maps.newEnumMap(ResourceType.class);
                context2.getDriver().requestRepeat((Detector)$this$findCycles_u24lambda_u2d3, Scope.RESOURCE_FILE_SCOPE);
                enumMap = newMap2;
                Intrinsics.checkExpressionValueIsNotNull((Object)enumMap, (String)"run {\n                  \u2026Map\n                    }");
                map2 = enumMap;
            } else {
                map2 = enumMap2;
            }
            EnumMap chains = map2;
            List<List<String>> list2 = chains.get(type);
            if (list2 == null) {
                enumMap = chains;
                object = new List[]{chain};
                object = CollectionsKt.mutableListOf((Object[])object);
                bl2 = false;
                enumMap.put((ResourceType)type, (List<List<String>>)object);
                continue;
            }
            list2.add(chain);
        }
    }

    private final void checkCrashItem(XmlContext context2, Element item) {
        NodeList childNodes = item.getChildNodes();
        int i10 = 0;
        int n10 = childNodes.getLength();
        while (i10 < n10) {
            Node child = childNodes.item(i10);
            if (child.getNodeType() == 3) {
                String text = child.getNodeValue();
                int k10 = 0;
                int max = text.length();
                while (k10 < max) {
                    String name;
                    String string;
                    int n11;
                    char c10 = text.charAt(k10);
                    if (Character.isWhitespace(c10)) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"text");
                    if (StringsKt.startsWith$default((String)text, (String)"@+id/", (int)k10, (boolean)false, (int)4, null)) {
                        String $this$trim$iv = text;
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl2 = false;
                            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                        n11 = "@+id/".length();
                        boolean bl4 = false;
                        string = $this$trim$iv;
                        if (string == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                    } else {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string.substring(n11), (String)"(this as java.lang.String).substring(startIndex)");
                    String message2 = "This construct can potentially crash `aapt` during a build. Change `@+id/" + name + "` to `@id/" + name + "` and define the id explicitly using `<item type=\"id\" name=\"" + name + "\"/>` instead.";
                    XmlContext.report$default(context2, CRASH, item, context2.getLocation(item), message2, null, 16, null);
                    int n12 = k10;
                    k10 = n12 + 1;
                }
            }
            int n13 = i10;
            i10 = n13 + 1;
        }
    }

    private final List<String> dfs(Multimap<String, String> map, String from, Set<String> visiting, Set<String> visited) {
        visiting.add(from);
        visited.add(from);
        Collection targets = map.get((Object)from);
        if (targets != null && !targets.isEmpty()) {
            for (String target2 : targets) {
                List<Object> chain;
                if (visiting.contains(target2)) {
                    chain = Lists.newArrayList();
                    ((ArrayList)chain).add(target2);
                    ((ArrayList)chain).add(from);
                    return chain;
                }
                if (visited.contains(target2)) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)target2, (String)"target");
                chain = this.dfs(map, target2, visiting, visited);
                if (chain == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/ResourceCycleDetector$Companion;", "", "()V", "CRASH", "Lcom/android/tools/lint/detector/api/Issue;", "CYCLE", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            nArray[ResourceType.LAYOUT.ordinal()] = 1;
            nArray[ResourceType.STYLE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

