/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringFormatDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION_XML = new Implementation(StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    private static final Implementation IMPLEMENTATION_XML_AND_JAVA = new Implementation(StringFormatDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE), Scope.JAVA_FILE_SCOPE);
    public static final Issue INVALID = Issue.create("StringFormatInvalid", "Invalid format string", "If a string contains a '%' character, then the string may be a formatting string which will be passed to `String.format` from Java code to replace each '%' occurrence with specific values.\n\nThis lint warning checks for two related problems:\n(1) Formatting strings that are invalid, meaning that `String.format` will throw exceptions at runtime when attempting to use the format string.\n(2) Strings containing '%' that are not formatting strings getting passed to a `String.format` call. In this case the '%' will need to be escaped as '%%'.\n\nNOTE: Not all Strings which look like formatting strings are intended for use by `String.format`; for example, they may contain date formats intended for `android.text.format.Time#format()`. Lint cannot always figure out that a String is a date format, so you may get false warnings in those scenarios. See the suppress help topic for information on how to suppress errors in that case.", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML);
    public static final Issue ARG_COUNT = Issue.create("StringFormatCount", "Formatting argument types incomplete or inconsistent", "When a formatted string takes arguments, it usually needs to reference the same arguments in all translations (or all arguments if there are no translations.\n\nThere are cases where this is not the case, so this issue is a warning rather than an error by default. However, this usually happens when a language is not translated or updated correctly.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML);
    public static final Issue ARG_TYPES = Issue.create("StringFormatMatches", "`String.format` string doesn't match the XML format string", "This lint check ensures the following:\n(1) If there are multiple translations of the format string, then all translations use the same type for the same numbered arguments\n(2) The usage of the format string in Java is consistent with the format string, meaning that the parameter types passed to String.format matches those in the format string.", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML_AND_JAVA);
    public static final Issue POTENTIAL_PLURAL = Issue.create("PluralsCandidate", "Potential Plurals", "This lint check looks for potential errors in internationalization where you have translated a message which involves a quantity and it looks like other parts of the string may need grammatical changes.\n\nFor example, rather than something like this:\n```xml\n  <string name=\"try_again\">Try again in %d seconds.</string>\n```\nyou should be using a plural:\n```xml\n   <plurals name=\"try_again\">\n        <item quantity=\"one\">Try again in %d second</item>\n        <item quantity=\"other\">Try again in %d seconds</item>\n    </plurals>\n```\nThis will ensure that in other languages the right set of translations are provided for the different quantity classes.\n\n(This check depends on some heuristics, so it may not accurately determine whether a string really should be a quantity. You can use tools:ignore to filter out false positives.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML).addMoreInfo("https://developer.android.com/guide/topics/resources/string-resource.html#Plurals");
    private Map<String, List<Pair<Location.Handle, String>>> mFormatStrings;
    private final Map<String, Location.Handle> mNotFormatStrings = new HashMap<String, Location.Handle>();
    private Set<String> mIgnoreStrings;
    private static final int CONVERSION_CLASS_UNKNOWN = 0;
    private static final int CONVERSION_CLASS_STRING = 1;
    private static final int CONVERSION_CLASS_CHARACTER = 2;
    private static final int CONVERSION_CLASS_INTEGER = 3;
    private static final int CONVERSION_CLASS_FLOAT = 4;
    private static final int CONVERSION_CLASS_BOOLEAN = 5;
    private static final int CONVERSION_CLASS_HASHCODE = 6;
    private static final int CONVERSION_CLASS_PERCENT = 7;
    private static final int CONVERSION_CLASS_NEWLINE = 8;
    private static final int CONVERSION_CLASS_DATETIME = 9;
    public static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("string");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() > 0) {
            if (childNodes.getLength() == 1) {
                Node child = childNodes.item(0);
                if (child.getNodeType() == 3) {
                    this.checkTextNode(context2, element, StringFormatDetector.stripQuotes(child.getNodeValue()));
                }
            } else {
                StringBuilder sb2 = new StringBuilder();
                StringFormatDetector.addText(sb2, element);
                if (sb2.length() > 0) {
                    this.checkTextNode(context2, element, sb2.toString());
                }
            }
        }
    }

    static void addText(StringBuilder sb2, Node node) {
        short nodeType = node.getNodeType();
        if (nodeType == 3 || nodeType == 4) {
            sb2.append(StringFormatDetector.stripQuotes(node.getNodeValue().trim()));
        } else {
            NodeList childNodes = node.getChildNodes();
            int n10 = childNodes.getLength();
            for (int i10 = 0; i10 < n10; ++i10) {
                StringFormatDetector.addText(sb2, childNodes.item(i10));
            }
        }
    }

    static String stripQuotes(String s10) {
        StringBuilder sb2 = new StringBuilder();
        boolean isEscaped = false;
        boolean isQuotedBlock = false;
        int len = s10.length();
        for (int i10 = 0; i10 < len; ++i10) {
            char current = s10.charAt(i10);
            if (isEscaped) {
                sb2.append(current);
                isEscaped = false;
                continue;
            }
            boolean bl2 = isEscaped = current == '\\';
            if (current == '\"') {
                isQuotedBlock = !isQuotedBlock;
                continue;
            }
            if (current == '\'') {
                if (!isQuotedBlock) continue;
                sb2.append(current);
                continue;
            }
            sb2.append(current);
        }
        return sb2.toString();
    }

    private void checkTextNode(XmlContext context2, Element element, String text) {
        String name = element.getAttribute("name");
        boolean found = false;
        boolean foundPlural = false;
        int m10 = text.length();
        for (int j10 = 0; j10 < m10; ++j10) {
            char c10 = text.charAt(j10);
            if (c10 == '\\') {
                ++j10;
            }
            if (c10 != '%') continue;
            String formatted = element.getAttribute("formatted");
            if (!formatted.isEmpty() && !Boolean.parseBoolean(formatted)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context2.createLocationHandle(element);
                    handle.setClientData(element);
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            Matcher matcher = FORMAT.matcher(text);
            if (!matcher.find(j10)) {
                if (!this.mNotFormatStrings.containsKey(name)) {
                    Location.Handle handle = context2.createLocationHandle(element);
                    handle.setClientData(element);
                    this.mNotFormatStrings.put(name, handle);
                }
                return;
            }
            String conversion = matcher.group(6);
            int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
            if (conversionClass == 0 || matcher.group(5) != null) {
                if (this.mIgnoreStrings == null) {
                    this.mIgnoreStrings = new HashSet<String>();
                }
                this.mIgnoreStrings.add(name);
                return;
            }
            if (conversionClass == 3 && !foundPlural) {
                for (int k10 = matcher.end(); k10 < m10; ++k10) {
                    char nc2 = text.charAt(k10);
                    if (Character.isWhitespace(nc2)) continue;
                    if (!Character.isLetter(nc2)) break;
                    foundPlural = StringFormatDetector.checkPotentialPlural(context2, element, text, k10);
                    break;
                }
            }
            found = true;
            ++j10;
        }
        if (!context2.getProject().getReportIssues()) {
            return;
        }
        if (name != null) {
            Location.Handle handle = context2.createLocationHandle(element);
            handle.setClientData(element);
            if (found) {
                List<Pair<Location.Handle, String>> list2;
                if (this.mFormatStrings == null) {
                    this.mFormatStrings = new HashMap<String, List<Pair<Location.Handle, String>>>();
                }
                if ((list2 = this.mFormatStrings.get(name)) == null) {
                    list2 = new ArrayList<Pair<Location.Handle, String>>();
                    this.mFormatStrings.put(name, list2);
                }
                list2.add((Pair<Location.Handle, String>)Pair.of((Object)handle, (Object)text));
            } else if (!StringFormatDetector.isReference(text)) {
                this.mNotFormatStrings.put(name, handle);
            }
        }
    }

    private static boolean isReference(String text) {
        int n10 = text.length();
        for (int i10 = 0; i10 < n10; ++i10) {
            char c10 = text.charAt(i10);
            if (Character.isWhitespace(c10)) continue;
            return c10 == '@' || c10 == '?';
        }
        return false;
    }

    private static boolean checkPotentialPlural(XmlContext context2, Element element, String text, int wordBegin) {
        int wordEnd;
        assert (Character.isLetter(text.charAt(wordBegin)));
        for (wordEnd = wordBegin; wordEnd < text.length() && Character.isLetter(text.charAt(wordEnd)); ++wordEnd) {
        }
        if (wordEnd - wordBegin <= 2) {
            return false;
        }
        boolean hasVowel = false;
        for (int i10 = wordBegin; i10 < wordEnd; ++i10) {
            char c10 = text.charAt(i10);
            if (i10 > wordBegin && Character.isUpperCase(c10)) {
                return false;
            }
            if (c10 != 'a' && c10 != 'e' && c10 != 'i' && c10 != 'o' && c10 != 'u' && c10 != 'y') continue;
            hasVowel = true;
        }
        if (!hasVowel) {
            return false;
        }
        String word = text.substring(wordBegin, wordEnd);
        if (word.equals("min")) {
            return false;
        }
        if (Lint.isEnglishResource(context2, true)) {
            String message2 = String.format("Formatting %%d followed by words (\"%1$s\"): This should probably be a plural rather than a string", word);
            context2.report(POTENTIAL_PLURAL, element, context2.getLocation(element), message2);
            return true;
        }
        return false;
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mFormatStrings != null) {
            boolean checkCount = context2.isEnabled(ARG_COUNT);
            boolean checkValid = context2.isEnabled(INVALID);
            boolean checkTypes = context2.isEnabled(ARG_TYPES);
            for (Map.Entry<String, List<Pair<Location.Handle, String>>> entry : this.mFormatStrings.entrySet()) {
                String name = entry.getKey();
                ImmutableList list2 = entry.getValue();
                if (checkCount) {
                    Location.Handle notFormatted = this.mNotFormatStrings.get(name);
                    if (notFormatted != null) {
                        list2 = ImmutableList.builder().add((Object)Pair.of((Object)notFormatted, (Object)name)).addAll(list2).build();
                    }
                    StringFormatDetector.checkArity(context2, name, list2);
                }
                if (!checkValid && !checkTypes) continue;
                StringFormatDetector.checkTypes(context2, checkValid, checkTypes, name, list2);
            }
        }
    }

    private static void checkTypes(Context context2, boolean checkValid, boolean checkTypes, String name, List<Pair<Location.Handle, String>> list2) {
        HashMap<Integer, String> types = new HashMap<Integer, String>();
        HashMap<Integer, Location.Handle> typeDefinition = new HashMap<Integer, Location.Handle>();
        block0: for (Pair<Location.Handle, String> pair : list2) {
            Location.Handle handle = (Location.Handle)pair.getFirst();
            String formatString = (String)pair.getSecond();
            Matcher matcher = FORMAT.matcher(formatString);
            int index = 0;
            int prevIndex = 0;
            int nextNumber = 1;
            while (matcher.find(index)) {
                int number;
                char last;
                int matchStart = matcher.start();
                while (prevIndex < matchStart) {
                    char c10 = formatString.charAt(prevIndex);
                    if (c10 == '\\') {
                        ++prevIndex;
                    }
                    ++prevIndex;
                }
                if (prevIndex > matchStart) {
                    index = prevIndex;
                    continue;
                }
                index = matcher.end();
                String str = formatString.substring(matchStart, matcher.end());
                if (str.equals("%%") || str.equals("%n")) continue;
                if (checkValid && str.length() > 2 && str.charAt(str.length() - 2) == ' ' && (last = str.charAt(str.length() - 1)) != 'd' && last != 'o' && last != 'x' && last != 'X') {
                    Object clientData = handle.getClientData();
                    if (clientData instanceof Node && context2.getDriver().isSuppressed(null, INVALID, (Node)clientData)) {
                        return;
                    }
                    Location location = handle.resolve();
                    String message2 = String.format("Incorrect formatting string `%1$s`; missing conversion character in '`%2$s`' ?", name, str);
                    context2.report(INVALID, location, message2);
                    continue;
                }
                if (!checkTypes) continue;
                String numberString = matcher.group(1);
                if (numberString != null) {
                    numberString = numberString.substring(0, numberString.length() - 1);
                    number = Integer.parseInt(numberString);
                    nextNumber = number + 1;
                } else {
                    number = nextNumber++;
                }
                String format = matcher.group(6);
                String currentFormat = (String)types.get(number);
                if (currentFormat == null) {
                    types.put(number, format);
                    typeDefinition.put(number, handle);
                    continue;
                }
                if (currentFormat.equals(format) || !StringFormatDetector.isIncompatible(currentFormat.charAt(0), format.charAt(0))) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context2.getDriver().isSuppressed(null, ARG_TYPES, (Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                location = StringFormatDetector.refineLocation(context2, location, formatString, matcher.start(), matcher.end());
                Location otherLocation = ((Location.Handle)typeDefinition.get(number)).resolve();
                otherLocation.setMessage("Conflicting argument type (`" + currentFormat + "') here");
                location.setSecondary(otherLocation);
                File f10 = otherLocation.getFile();
                String message3 = String.format(Locale.US, "Inconsistent formatting types for argument #%1$d in format string `%2$s` ('%3$s'): Found both '`%4$s`' here and '`%5$s`' in %6$s", number, name, str, format, currentFormat, Lint.getFileNameWithParent(context2.getClient(), f10));
                context2.report(ARG_TYPES, location, message3);
                continue block0;
            }
        }
    }

    private static boolean isIncompatible(char conversion1, char conversion2) {
        int class2;
        int class1 = StringFormatDetector.getConversionClass(conversion1);
        return class1 != (class2 = StringFormatDetector.getConversionClass(conversion2)) && class1 != 0 && class2 != 0;
    }

    private static int getConversionClass(char conversion) {
        switch (conversion) {
            case 'T': 
            case 't': {
                return 9;
            }
            case 'S': 
            case 's': {
                return 1;
            }
            case 'C': 
            case 'c': {
                return 2;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                return 3;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                return 4;
            }
            case 'B': 
            case 'b': {
                return 5;
            }
            case 'H': 
            case 'h': {
                return 6;
            }
            case '%': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        return 0;
    }

    private static Location refineLocation(Context context2, Location location, String formatString, int substringStart, int substringEnd) {
        Position startLocation = location.getStart();
        Position endLocation = location.getEnd();
        if (startLocation != null && endLocation != null) {
            int formatOffset;
            CharSequence contents;
            int startOffset = startLocation.getOffset();
            int endOffset = endLocation.getOffset();
            if (startOffset >= 0 && endOffset <= (contents = context2.getClient().readFile(location.getFile())).length() && startOffset < endOffset && (formatOffset = CharSequences.indexOf((CharSequence)contents, (CharSequence)formatString, (int)startOffset)) != -1 && formatOffset <= endOffset) {
                return Location.create(location.getFile(), contents, formatOffset + substringStart, formatOffset + substringEnd);
            }
        }
        return location;
    }

    private static void checkArity(Context context2, String name, List<Pair<Location.Handle, String>> list2) {
        int prevCount = -1;
        for (Pair<Location.Handle, String> pair : list2) {
            HashSet<Integer> indices = new HashSet<Integer>();
            int count = StringFormatDetector.getFormatArgumentCount((String)pair.getSecond(), indices);
            Location.Handle handle = (Location.Handle)pair.getFirst();
            if (prevCount != -1 && prevCount != count) {
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context2.getDriver().isSuppressed(null, ARG_COUNT, (Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                Location secondary = ((Location.Handle)list2.get(0).getFirst()).resolve();
                secondary.setMessage("Conflicting number of arguments (" + prevCount + ") here");
                location.setSecondary(secondary);
                String path2 = Lint.getFileNameWithParent(context2.getClient(), secondary.getFile());
                String message2 = String.format(Locale.US, "Inconsistent number of arguments in formatting string `%1$s`; found both %2$d here and %3$d in %4$s", name, count, prevCount, path2);
                context2.report(ARG_COUNT, location, message2);
                break;
            }
            for (int i10 = 1; i10 <= count; ++i10) {
                if (indices.contains(i10)) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context2.getDriver().isSuppressed(null, ARG_COUNT, (Node)clientData)) {
                    return;
                }
                HashSet<Integer> all = new HashSet<Integer>();
                for (int j10 = 1; j10 < count; ++j10) {
                    all.add(j10);
                }
                all.removeAll(indices);
                ArrayList sorted = new ArrayList(all);
                Collections.sort(sorted);
                Location location = handle.resolve();
                String message3 = String.format("Formatting string '`%1$s`' is not referencing numbered arguments %2$s", name, sorted);
                context2.report(ARG_COUNT, location, message3);
                break;
            }
            prevCount = count;
        }
    }

    @VisibleForTesting
    static String getFormatArgumentType(String s10, int argument) {
        Matcher matcher = FORMAT.matcher(s10);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        while (matcher.find(index)) {
            int number;
            String value = matcher.group(6);
            if ("%".equals(value) || "n".equals(value)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c10 = s10.charAt(prevIndex);
                if (c10 == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number == argument) {
                return matcher.group(6);
            }
            index = matcher.end();
        }
        return null;
    }

    static int getFormatArgumentCount(String s10, Set<Integer> seenArguments) {
        Matcher matcher = FORMAT.matcher(s10);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int max = 0;
        while (matcher.find(index)) {
            int number;
            String value = matcher.group(6);
            if ("%".equals(value) || "n".equals(value)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c10 = s10.charAt(prevIndex);
                if (c10 == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number > max) {
                max = number;
            }
            if (seenArguments != null) {
                seenArguments.add(number);
            }
            index = matcher.end();
        }
        return max;
    }

    public static boolean isLocaleSpecific(String format) {
        if (format.indexOf(37) == -1) {
            return false;
        }
        Matcher matcher = FORMAT.matcher(format);
        int index = 0;
        int prevIndex = 0;
        while (matcher.find(index)) {
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c10 = format.charAt(prevIndex);
                if (c10 == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String type = matcher.group(6);
            if (!type.isEmpty()) {
                char t10 = type.charAt(0);
                switch (t10) {
                    case 'E': 
                    case 'G': 
                    case 'T': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 't': {
                        return true;
                    }
                }
            }
            index = matcher.end();
        }
        return false;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("format", "getString");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression node, PsiMethod method) {
        JavaEvaluator evaluator = context2.getEvaluator();
        String methodName = method.getName();
        if (methodName.equals("format")) {
            if (evaluator.isMemberInClass((PsiMember)method, "java.lang.String")) {
                this.checkStringFormatCall(context2, method, node, method.getParameterList().getParametersCount() == 3);
            }
        } else {
            if (method.getParameterList().getParametersCount() < 2) {
                return;
            }
            if (evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.res.Resources", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.content.Context", false) || evaluator.isMemberInSubClassOf((PsiMember)method, "android.app.Fragment", false) || evaluator.isMemberInSubClassOf((PsiMember)method, SdkConstants.CLASS_V4_FRAGMENT.oldName(), false) || evaluator.isMemberInSubClassOf((PsiMember)method, SdkConstants.CLASS_V4_FRAGMENT.newName(), false)) {
                this.checkStringFormatCall(context2, method, node, false);
            }
        }
    }

    private static void checkNotFormattedHandle(JavaContext context2, UCallExpression call, String name, Location.Handle handle) {
        Object clientData = handle.getClientData();
        if (clientData instanceof Node && context2.getDriver().isSuppressed(null, INVALID, (Node)clientData)) {
            return;
        }
        Location location = context2.getLocation((UElement)call);
        Location secondary = handle.resolve();
        secondary.setMessage("This definition does not require arguments");
        location.setSecondary(secondary);
        String message2 = String.format("Format string '`%1$s`' is not a valid format string so it should not be passed to `String.format`", name);
        context2.report(INVALID, (UElement)call, location, message2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkStringFormatCall(JavaContext context2, PsiMethod calledMethod, UCallExpression call, boolean specifiesLocale) {
        ArrayList list2;
        int argIndex = specifiesLocale ? 1 : 0;
        List args = call.getValueArguments();
        if (args.size() <= argIndex) {
            return;
        }
        UExpression argument = (UExpression)args.get(argIndex);
        ResourceUrl resource = ResourceEvaluator.getResource(context2.getEvaluator(), (UElement)argument);
        if (resource == null || resource.isFramework() || resource.type != ResourceType.STRING) {
            return;
        }
        String name = resource.name;
        if (this.mIgnoreStrings != null && this.mIgnoreStrings.contains(name)) {
            return;
        }
        boolean passingVarArgsArray = false;
        int callCount = args.size() - 1 - argIndex;
        if (callCount == 1) {
            UExpression lastArg = (UExpression)args.get(args.size() - 1);
            PsiParameterList parameterList = calledMethod.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount > 0 && parameterList.getParameters()[parameterCount - 1].isVarArgs()) {
                UExpression initializer;
                PsiElement resolved;
                boolean knownArity = false;
                boolean argWasReference = false;
                if (lastArg instanceof UReferenceExpression && (resolved = ((UReferenceExpression)lastArg).resolve()) instanceof PsiVariable && (initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)resolved)) != null && (UastExpressionUtils.isNewArray((UElement)initializer) || UastExpressionUtils.isArrayInitializer((UElement)initializer))) {
                    argWasReference = true;
                    lastArg = initializer;
                }
                if (UastExpressionUtils.isNewArray((UElement)lastArg) || UastExpressionUtils.isArrayInitializer((UElement)lastArg)) {
                    Object o10;
                    UExpression first;
                    Object arrayDimensions;
                    UCallExpression arrayInitializer = (UCallExpression)lastArg;
                    if (UastExpressionUtils.isNewArrayWithInitializer((UElement)lastArg) || UastExpressionUtils.isArrayInitializer((UElement)lastArg)) {
                        callCount = arrayInitializer.getValueArgumentCount();
                        knownArity = true;
                    } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)lastArg) && (arrayDimensions = arrayInitializer.getValueArguments()).size() == 1 && (first = (UExpression)arrayDimensions.get(0)) instanceof ULiteralExpression && (o10 = ((ULiteralExpression)first).getValue()) instanceof Integer) {
                        callCount = (Integer)o10;
                        knownArity = true;
                    }
                    if (!knownArity) {
                        if (!argWasReference) {
                            return;
                        }
                    } else {
                        passingVarArgsArray = true;
                    }
                }
            }
        }
        if (callCount > 0 && this.mNotFormatStrings.containsKey(name)) {
            StringFormatDetector.checkNotFormattedHandle(context2, call, name, this.mNotFormatStrings.get(name));
            return;
        }
        ArrayList arrayList = list2 = this.mFormatStrings != null ? this.mFormatStrings.get(name) : null;
        if (list2 == null) {
            LintClient client = context2.getClient();
            boolean full = context2.isGlobalAnalysis();
            Project project = full ? context2.getMainProject() : context2.getProject();
            ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
            List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.STRING, name);
            for (ResourceItem item : items) {
                String value;
                ResourceValue v10 = item.getResourceValue();
                if (v10 == null || (value = v10.getRawXmlValue()) == null) continue;
                if (StringFormatDetector.isReference(value)) {
                    List l10;
                    ResourceUrl url;
                    for (int i10 = 0; i10 < 3 && (url = ResourceUrl.parse((String)value)) != null && !url.isFramework() && !(l10 = resources.getResources(ResourceNamespace.TODO(), url.type, url.name)).isEmpty() && (v10 = ((ResourceItem)l10.get(0)).getResourceValue()) != null && (value = v10.getValue()) != null && StringFormatDetector.isReference(value); ++i10) {
                    }
                }
                if (value == null || StringFormatDetector.isReference(value)) continue;
                boolean isFormattingString = value.indexOf(37) != -1;
                int m10 = value.length();
                for (int j10 = 0; j10 < m10 && isFormattingString; ++j10) {
                    char c10 = value.charAt(j10);
                    if (c10 == '\\') {
                        ++j10;
                        continue;
                    }
                    if (c10 != '%') continue;
                    Matcher matcher = FORMAT.matcher(value);
                    if (!matcher.find(j10)) {
                        isFormattingString = false;
                    } else {
                        String conversion = matcher.group(6);
                        int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
                        if (conversionClass == 0 || matcher.group(5) != null) {
                            return;
                        }
                    }
                    ++j10;
                }
                Location.ResourceItemHandle handle = client.createResourceItemHandle(item, false, true);
                if (isFormattingString) {
                    if (list2 == null) {
                        list2 = Lists.newArrayList();
                        if (this.mFormatStrings == null) {
                            this.mFormatStrings = Maps.newHashMap();
                        }
                        this.mFormatStrings.put(name, list2);
                    }
                    list2.add(Pair.of((Object)handle, (Object)value));
                    continue;
                }
                if (callCount <= 0) continue;
                StringFormatDetector.checkNotFormattedHandle(context2, call, name, handle);
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            list2.sort((o12, o22) -> {
                Location.Handle h12 = (Location.Handle)o12.getFirst();
                Location.Handle h22 = (Location.Handle)o22.getFirst();
                if (h12 instanceof Location.ResourceItemHandle && h22 instanceof Location.ResourceItemHandle) {
                    FolderConfiguration f22;
                    ResourceItem item1 = ((Location.ResourceItemHandle)h12).getItem();
                    ResourceItem item2 = ((Location.ResourceItemHandle)h22).getItem();
                    FolderConfiguration f12 = item1.getConfiguration();
                    int delta = f12.compareTo(f22 = item2.getConfiguration());
                    if (delta != 0) {
                        return delta;
                    }
                    return item1.toString().compareTo(item2.toString());
                }
                return o12.toString().compareTo(o22.toString());
            });
            Set reported = null;
            for (Pair<Location.Handle, String> pair : list2) {
                String s10 = (String)pair.getSecond();
                if (reported != null && reported.contains(s10)) continue;
                int count = StringFormatDetector.getFormatArgumentCount(s10, null);
                Location.Handle handle = (Location.Handle)pair.getFirst();
                if (count != callCount) {
                    Location location = context2.getLocation((UElement)call);
                    Location secondary = handle.resolve();
                    secondary.setMessage(String.format(Locale.US, "This definition requires %1$d argument%2$s", count, count != 1 ? "s" : ""));
                    location.setSecondary(secondary);
                    String message2 = String.format(Locale.US, "Wrong argument count, format string `%1$s` requires `%2$d` but format call supplies `%3$d`", name, count, callCount);
                    context2.report(ARG_TYPES, (UElement)call, location, message2);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s10);
                    continue;
                }
                if (passingVarArgsArray) {
                    return;
                }
                block11: for (int i11 = 1; i11 <= count; ++i11) {
                    int argumentIndex = i11 + argIndex;
                    PsiType type = ((UExpression)args.get(argumentIndex)).getExpressionType();
                    if (type == null) continue;
                    boolean valid = true;
                    String formatType = StringFormatDetector.getFormatArgumentType(s10, i11);
                    if (formatType == null) continue;
                    char last = formatType.charAt(formatType.length() - 1);
                    if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') continue;
                    switch (last) {
                        case 'B': 
                        case 'b': {
                            valid = StringFormatDetector.isBooleanType(type);
                            break;
                        }
                        case 'A': 
                        case 'E': 
                        case 'G': 
                        case 'X': 
                        case 'a': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'o': 
                        case 'x': {
                            valid = StringFormatDetector.isNumericType(type, true);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            valid = StringFormatDetector.isCharacterType(type);
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            continue block11;
                        }
                        case 'S': 
                        case 's': {
                            valid = !StringFormatDetector.isBooleanType(type) && !StringFormatDetector.isNumericType(type, false);
                        }
                    }
                    if (valid) continue;
                    Location location = context2.getLocation((UElement)args.get(argumentIndex));
                    Location secondary = handle.resolve();
                    secondary.setMessage("Conflicting argument declaration here");
                    location.setSecondary(secondary);
                    String suggestion = null;
                    if (StringFormatDetector.isBooleanType(type)) {
                        suggestion = "`b`";
                    } else if (StringFormatDetector.isCharacterType(type)) {
                        suggestion = "'c'";
                    } else if (PsiType.INT.equals((Object)type) || PsiType.LONG.equals((Object)type) || PsiType.BYTE.equals((Object)type) || PsiType.SHORT.equals((Object)type)) {
                        suggestion = "`d`, 'o' or `x`";
                    } else if (PsiType.FLOAT.equals((Object)type) || PsiType.DOUBLE.equals((Object)type)) {
                        suggestion = "`e`, 'f', 'g' or `a`";
                    } else if (type instanceof PsiClassType) {
                        String fqn = type.getCanonicalText();
                        if ("java.lang.Integer".equals(fqn) || "java.lang.Long".equals(fqn) || "java.lang.Byte".equals(fqn) || "java.lang.Short".equals(fqn)) {
                            suggestion = "`d`, 'o' or `x`";
                        } else if ("java.lang.Float".equals(fqn) || "java.lang.Double".equals(fqn)) {
                            suggestion = "`d`, 'o' or `x`";
                        } else if ("java.lang.Object".equals(fqn)) {
                            suggestion = "'s' or 'h'";
                        }
                    }
                    suggestion = suggestion != null ? " (Did you mean formatting character " + suggestion + "?)" : "";
                    String canonicalText = type.getCanonicalText();
                    canonicalText = canonicalText.substring(canonicalText.lastIndexOf(46) + 1);
                    String message3 = String.format(Locale.US, "Wrong argument type for formatting argument '#%1$d' in `%2$s`: conversion is '`%3$s`', received `%4$s` (argument #%5$d in method call)%6$s", i11, name, formatType, canonicalText, argumentIndex + 1, suggestion);
                    if ((last == 's' || last == 'S') && StringFormatDetector.isNumericType(type, false)) {
                        message3 = String.format(Locale.US, "Suspicious argument type for formatting argument #%1$d in `%2$s`: conversion is `%3$s`, received `%4$s` (argument #%5$d in method call)%6$s", i11, name, formatType, canonicalText, argumentIndex + 1, suggestion);
                    }
                    context2.report(ARG_TYPES, (UElement)call, location, message3);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s10);
                }
            }
        }
    }

    private static boolean isCharacterType(PsiType type) {
        if (type == PsiType.CHAR) {
            return true;
        }
        if (type instanceof PsiClassType) {
            String fqn = type.getCanonicalText();
            return "java.lang.Character".equals(fqn);
        }
        return false;
    }

    private static boolean isBooleanType(PsiType type) {
        if (type == PsiType.BOOLEAN) {
            return true;
        }
        if (type instanceof PsiClassType) {
            String fqn = type.getCanonicalText();
            return "java.lang.Boolean".equals(fqn);
        }
        return false;
    }

    private static boolean isNumericType(PsiType type, boolean allowBigNumbers) {
        if (PsiType.INT.equals((Object)type) || PsiType.FLOAT.equals((Object)type) || PsiType.DOUBLE.equals((Object)type) || PsiType.LONG.equals((Object)type) || PsiType.BYTE.equals((Object)type) || PsiType.SHORT.equals((Object)type)) {
            return true;
        }
        if (type instanceof PsiClassType) {
            String fqn = type.getCanonicalText();
            if ("java.lang.Integer".equals(fqn) || "java.lang.Float".equals(fqn) || "java.lang.Double".equals(fqn) || "java.lang.Long".equals(fqn) || "java.lang.Byte".equals(fqn) || "java.lang.Short".equals(fqn)) {
                return true;
            }
            if (allowBigNumbers && ("java.math.BigInteger".equals(fqn) || "java.math.BigDecimal".equals(fqn))) {
                return true;
            }
        }
        return false;
    }
}

