/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ApiConstraint;
import com.android.tools.lint.checks.SdkIntAnnotation;
import com.android.tools.lint.checks.SdkIntDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 92\u00020\u0001:\u00029:B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\u0010J.\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00132\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\u001eJ\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010 \u001a\u00020\u0018H\u0002J,\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0018H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b$J,\u0010%\u001a\u0004\u0018\u00010\f2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0018H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b&J(\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0018H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b)J0\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b*JF\u0010+\u001a\u0004\u0018\u00010\f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\t2\u001c\b\u0002\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b/JR\u0010+\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\t2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u000e2\u001c\b\u0002\u00101\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b2JD\u00103\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u001a\u00101\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b4J\u0010\u00105\u001a\u00020\t2\u0006\u0010\r\u001a\u000206H\u0002J\u0010\u00105\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006;"}, d2={"Lcom/android/tools/lint/checks/VersionChecks;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "project", "Lcom/android/tools/lint/detector/api/Project;", "lowerBound", "", "(Lcom/android/tools/lint/client/api/LintClient;Lcom/android/tools/lint/client/api/JavaEvaluator;Lcom/android/tools/lint/detector/api/Project;Z)V", "getAndedWithConditional", "Lcom/android/tools/lint/checks/ApiConstraint;", "element", "Lorg/jetbrains/uast/UElement;", "before", "getAndedWithConditional-wgJLwIQ", "getApiLevel", "", "Lorg/jetbrains/uast/UExpression;", "apiLevelLookup", "Lkotlin/Function1;", "Lcom/android/tools/lint/checks/ApiLevelLookup;", "getLambdaInvocation", "Lorg/jetbrains/uast/UCallExpression;", "parameter", "Lcom/intellij/psi/PsiParameter;", "method", "Lcom/intellij/psi/PsiMethod;", "getOredWithConditional", "getOredWithConditional-wgJLwIQ", "getReferenceApiLookup", "call", "getValidFromAnnotation", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "getValidFromAnnotation-wgJLwIQ", "getValidFromInferredAnnotation", "getValidFromInferredAnnotation-wgJLwIQ", "getValidVersionCall", "and", "getValidVersionCall-wgJLwIQ", "getValidVersionCall-PWWxdZI", "getVersionCheckConditional", "binary", "Lorg/jetbrains/uast/UBinaryExpression;", "fromThen", "getVersionCheckConditional-PWWxdZI", "prev", "apiLookup", "getVersionCheckConditional-Xdgp6x0", "getWithinVersionCheckConditional", "getWithinVersionCheckConditional-PWWxdZI", "isSdkInt", "Lcom/intellij/psi/PsiElement;", "isUnconditionalReturn", "statement", "Companion", "VersionCheckWithExitFinder", "android.sdktools.lint-checks"})
public final class VersionChecks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintClient client;
    @NotNull
    private final JavaEvaluator evaluator;
    @Nullable
    private final Project project;
    private final boolean lowerBound;
    @NotNull
    public static final String SDK_INT = "SDK_INT";
    @NotNull
    public static final String CHECKS_SDK_INT_AT_LEAST_ANNOTATION = "androidx.annotation.ChecksSdkIntAtLeast";
    @NotNull
    private static final String GET_BUILD_SDK_INT = "getBuildSdkInt";
    @NotNull
    private static final String[] VERSION_METHOD_NAME_PREFIXES;
    @NotNull
    private static final String[] VERSION_METHOD_NAME_SUFFIXES;

    public VersionChecks(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @Nullable Project project, boolean lowerBound) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
        this.client = client;
        this.evaluator = evaluator;
        this.project = project;
        this.lowerBound = lowerBound;
    }

    public /* synthetic */ VersionChecks(LintClient lintClient, JavaEvaluator javaEvaluator, Project project, boolean bl2, int n10, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n10 & 8) != 0) {
            bl2 = true;
        }
        this(lintClient, javaEvaluator, project, bl2);
    }

    private final boolean isUnconditionalReturn(UExpression statement) {
        List expressions;
        int statements;
        if (statement instanceof UBlockExpression && (statements = (expressions = ((UBlockExpression)statement).getExpressions()).size()) > 0) {
            String methodName;
            UExpression last = (UExpression)expressions.get(statements - 1);
            if (last instanceof UReturnExpression || last instanceof UThrowExpression) {
                return true;
            }
            if (last instanceof UCallExpression && (Intrinsics.areEqual((Object)"error", (Object)(methodName = Lint.getMethodName((UCallExpression)last))) || Intrinsics.areEqual((Object)"TODO", (Object)methodName))) {
                return true;
            }
        }
        return statement instanceof UReturnExpression;
    }

    private final ApiConstraint getWithinVersionCheckConditional-PWWxdZI(JavaEvaluator evaluator, UElement element, Function1<? super UElement, Integer> apiLookup) {
        UElement current = Lint.skipParentheses(element.getUastParent());
        UElement prev = element;
        while (current != null) {
            ApiConstraint apiConstraint;
            if (current instanceof UPolyadicExpression) {
                ApiConstraint anded = this.getAndedWithConditional-wgJLwIQ(current, prev);
                if (anded != null) {
                    return anded;
                }
                ApiConstraint ored = this.getOredWithConditional-wgJLwIQ(current, prev);
                if (ored != null) {
                    return ored;
                }
            }
            if (current instanceof UIfExpression) {
                boolean fromThen;
                UElement ifStatement = current;
                UExpression condition = ((UIfExpression)ifStatement).getCondition();
                if (prev != condition && (apiConstraint = this.getVersionCheckConditional-Xdgp6x0((UElement)condition, fromThen = Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)ifStatement).getThenExpression()), prev, apiLookup)) != null) {
                    ApiConstraint apiConstraint2 = apiConstraint;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int it2 = apiConstraint2.unbox-impl();
                    boolean bl4 = false;
                    return ApiConstraint.box-impl(it2);
                }
            } else if (current instanceof USwitchClauseExpressionWithBody) {
                for (UExpression condition : ((USwitchClauseExpressionWithBody)current).getCaseValues()) {
                    ApiConstraint fromThen = this.getVersionCheckConditional-Xdgp6x0((UElement)condition, true, prev, apiLookup);
                    if (fromThen == null) continue;
                    apiConstraint = fromThen;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    int it3 = apiConstraint.unbox-impl();
                    boolean bl7 = false;
                    return ApiConstraint.box-impl(it3);
                }
            } else if (current instanceof UCallExpression && prev instanceof ULambdaExpression) {
                UElement call = current;
                PsiMethod method = ((UCallExpression)call).resolve();
                if (method != null) {
                    ApiConstraint constraint;
                    UCallExpression lambdaInvocation;
                    Integer value;
                    SdkIntAnnotation annotation = SdkIntAnnotation.Companion.get((PsiModifierListOwner)method);
                    if (annotation != null && (value = annotation.getApiLevel(evaluator, (PsiModifierListOwner)method, (UCallExpression)call)) != null) {
                        return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(value));
                    }
                    Map<UExpression, PsiParameter> mapping = evaluator.computeArgumentMapping((UCallExpression)call, method);
                    PsiParameter parameter = mapping.get(prev);
                    if (parameter != null && (lambdaInvocation = this.getLambdaInvocation(parameter, method)) != null && (constraint = this.getWithinVersionCheckConditional-PWWxdZI(evaluator, (UElement)lambdaInvocation, this.getReferenceApiLookup((UCallExpression)call))) != null) {
                        return constraint;
                    }
                }
            } else if (current instanceof UCallExpression && prev instanceof UObjectLiteralExpression) {
                PsiMethod method = ((UCallExpression)current).resolve();
                if (method != null) {
                    ApiConstraint constraint;
                    UCallExpression lambdaInvocation;
                    Integer value;
                    SdkIntAnnotation annotation = SdkIntAnnotation.Companion.get((PsiModifierListOwner)method);
                    if (annotation != null && (value = annotation.getApiLevel(evaluator, (PsiModifierListOwner)method, (UCallExpression)current)) != null) {
                        return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(value));
                    }
                    Map<UExpression, PsiParameter> mapping = evaluator.computeArgumentMapping((UCallExpression)current, method);
                    PsiParameter parameter = mapping.get(prev);
                    if (parameter != null && (lambdaInvocation = this.getLambdaInvocation(parameter, method)) != null && (constraint = this.getWithinVersionCheckConditional-PWWxdZI(evaluator, (UElement)lambdaInvocation, this.getReferenceApiLookup((UCallExpression)current))) != null) {
                        return constraint;
                    }
                }
            } else if (current instanceof UMethod ? !(((UMethod)current).getUastParent() instanceof UAnonymousClass) : current instanceof PsiFile) {
                return null;
            }
            prev = current;
            current = Lint.skipParentheses(current.getUastParent());
        }
        return null;
    }

    private final Function1<UElement, Integer> getReferenceApiLookup(UCallExpression call) {
        return (Function1)new Function1<UElement, Integer>(call, this){
            final /* synthetic */ UCallExpression $call;
            final /* synthetic */ VersionChecks this$0;
            {
                this.$call = $call;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull UElement reference) {
                PsiParameterList parameterList;
                PsiElement resolved;
                Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                int apiLevel = -1;
                if (reference instanceof UReferenceExpression && (resolved = ((UReferenceExpression)reference).resolve()) instanceof PsiParameter && (parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class)) != null) {
                    int index = parameterList.getParameterIndex((PsiParameter)resolved);
                    List arguments = this.$call.getValueArguments();
                    if (index != -1 && index < arguments.size()) {
                        apiLevel = VersionChecks.access$getApiLevel(this.this$0, (UExpression)arguments.get(index), null);
                    }
                }
                return apiLevel;
            }
        };
    }

    private final UCallExpression getLambdaInvocation(PsiParameter parameter, PsiMethod method) {
        if (method instanceof PsiCompiledElement) {
            return null;
        }
        UMethod uMethod = (UMethod)UastFacade.INSTANCE.convertElementWithParent((PsiElement)method, UMethod.class);
        if (uMethod == null) {
            return null;
        }
        UMethod uMethod2 = uMethod;
        Ref match2 = new Ref();
        String string = parameter.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parameter.name");
        String parameterName = string;
        uMethod2.accept((UastVisitor)new AbstractUastVisitor(parameterName, (Ref<UCallExpression>)match2){
            final /* synthetic */ String $parameterName;
            final /* synthetic */ Ref<UCallExpression> $match;
            {
                this.$parameterName = $parameterName;
                this.$match = $match;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                String callName;
                String name;
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                UExpression receiver = node.getReceiver();
                if (receiver instanceof USimpleNameReferenceExpression) {
                    name = ((USimpleNameReferenceExpression)receiver).getIdentifier();
                    if (Intrinsics.areEqual((Object)name, (Object)this.$parameterName)) {
                        this.$match.set((Object)node);
                    }
                } else if (receiver instanceof UReferenceExpression && Intrinsics.areEqual((Object)(name = ((UReferenceExpression)receiver).getResolvedName()), (Object)this.$parameterName)) {
                    this.$match.set((Object)node);
                }
                if (Intrinsics.areEqual((Object)(callName = Lint.getMethodName(node)), (Object)this.$parameterName)) {
                    this.$match.set((Object)node);
                }
                return super.visitCallExpression(node);
            }
        });
        return (UCallExpression)match2.get();
    }

    private final ApiConstraint getVersionCheckConditional-Xdgp6x0(UElement element, boolean and, UElement prev, Function1<? super UElement, Integer> apiLookup) {
        if (element instanceof UPolyadicExpression) {
            ApiConstraint constraint;
            ApiConstraint apiConstraint;
            if (element instanceof UBinaryExpression && (apiConstraint = this.getVersionCheckConditional-PWWxdZI((UBinaryExpression)element, and, apiLookup)) != null) {
                ApiConstraint apiConstraint2 = apiConstraint;
                boolean bl2 = false;
                boolean bl3 = false;
                int it2 = apiConstraint2.unbox-impl();
                boolean bl4 = false;
                return ApiConstraint.box-impl(it2);
            }
            UastBinaryOperator tokenType = ((UPolyadicExpression)element).getOperator();
            if (and && tokenType == UastBinaryOperator.LOGICAL_AND) {
                ApiConstraint constraint2 = this.getAndedWithConditional-wgJLwIQ(element, prev);
                if (constraint2 != null) {
                    return constraint2;
                }
            } else if (!and && tokenType == UastBinaryOperator.LOGICAL_OR && (constraint = this.getOredWithConditional-wgJLwIQ(element, prev)) != null) {
                return constraint;
            }
        } else {
            UExpression operand;
            ApiConstraint apiConstraint;
            if (element instanceof UCallExpression) {
                return this.getValidVersionCall-wgJLwIQ(and, (UCallExpression)element);
            }
            if (element instanceof UReferenceExpression) {
                PsiElement resolved = ((UReferenceExpression)element).resolve();
                if (resolved instanceof PsiField) {
                    ApiConstraint constraint;
                    UExpression initializer;
                    PsiElement field = resolved;
                    ApiConstraint validFromAnnotation = VersionChecks.getValidFromAnnotation-wgJLwIQ$default(this, (PsiModifierListOwner)field, null, 2, null);
                    if (validFromAnnotation != null) {
                        return validFromAnnotation;
                    }
                    ApiConstraint validFromInferredAnnotation = VersionChecks.getValidFromInferredAnnotation-wgJLwIQ$default(this, (PsiModifierListOwner)field, null, 2, null);
                    if (validFromInferredAnnotation != null) {
                        return validFromInferredAnnotation;
                    }
                    PsiModifierList modifierList = ((PsiField)field).getModifierList();
                    if (modifierList != null && modifierList.hasExplicitModifier("static") && (initializer = UastFacade.INSTANCE.getInitializerBody((PsiVariable)field)) != null && (constraint = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(this, (UElement)initializer, and, null, null, 12, null)) != null) {
                        return constraint;
                    }
                } else {
                    UExpression selector;
                    if (resolved instanceof PsiMethod && element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getSelector() instanceof UCallExpression) {
                        UCallExpression call = (UCallExpression)((UQualifiedReferenceExpression)element).getSelector();
                        return this.getValidVersionCall-wgJLwIQ(and, call);
                    }
                    if (resolved instanceof PsiMethod) {
                        return this.getValidVersionCall-PWWxdZI(and, element, (PsiMethod)resolved);
                    }
                    if (resolved == null && element instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)element).getSelector()) instanceof UCallExpression) {
                        return this.getValidVersionCall-wgJLwIQ(and, (UCallExpression)selector);
                    }
                }
            } else if (element instanceof UUnaryExpression && ((UUnaryExpression)element).getOperator() == UastPrefixOperator.LOGICAL_NOT && (apiConstraint = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(this, (UElement)(operand = ((UUnaryExpression)element).getOperand()), !and, null, null, 12, null)) != null) {
                ApiConstraint apiConstraint3 = apiConstraint;
                boolean bl5 = false;
                boolean bl6 = false;
                int it3 = apiConstraint3.unbox-impl();
                boolean bl7 = false;
                return ApiConstraint.box-impl(it3);
            }
        }
        return null;
    }

    static /* synthetic */ ApiConstraint getVersionCheckConditional-Xdgp6x0$default(VersionChecks versionChecks, UElement uElement, boolean bl2, UElement uElement2, Function1 function1, int n10, Object object) {
        if ((n10 & 4) != 0) {
            uElement2 = null;
        }
        if ((n10 & 8) != 0) {
            function1 = null;
        }
        return versionChecks.getVersionCheckConditional-Xdgp6x0(uElement, bl2, uElement2, (Function1<? super UElement, Integer>)function1);
    }

    private final ApiConstraint getValidFromAnnotation-wgJLwIQ(PsiModifierListOwner owner, UCallExpression call) {
        String[] stringArray = new String[]{CHECKS_SDK_INT_AT_LEAST_ANNOTATION};
        Object object = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)true, (String[])stringArray);
        if (object == null) {
            return null;
        }
        Object object2 = object;
        PsiAnnotation annotation = object2;
        if ((object = new SdkIntAnnotation(annotation).getApiLevel(this.evaluator, owner, call)) == null) {
            return null;
        }
        int value = (Integer)object;
        return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(value));
    }

    static /* synthetic */ ApiConstraint getValidFromAnnotation-wgJLwIQ$default(VersionChecks versionChecks, PsiModifierListOwner psiModifierListOwner, UCallExpression uCallExpression, int n10, Object object) {
        if ((n10 & 2) != 0) {
            uCallExpression = null;
        }
        return versionChecks.getValidFromAnnotation-wgJLwIQ(psiModifierListOwner, uCallExpression);
    }

    private final ApiConstraint getValidFromInferredAnnotation-wgJLwIQ(PsiModifierListOwner owner, UCallExpression call) {
        SdkIntAnnotation sdkIntAnnotation;
        Object object;
        if (!this.client.supportsPartialAnalysis()) {
            return null;
        }
        if (this.project == null || !(owner instanceof PsiCompiledElement)) {
            return null;
        }
        PsiModifierListOwner psiModifierListOwner = owner;
        if (psiModifierListOwner instanceof PsiMethod) {
            object = SdkIntDetector.Companion.findSdkIntAnnotation(this.client, this.evaluator, this.project, owner);
            if (object == null) {
                return null;
            }
            sdkIntAnnotation = object;
        } else if (psiModifierListOwner instanceof PsiField) {
            object = SdkIntDetector.Companion.findSdkIntAnnotation(this.client, this.evaluator, this.project, owner);
            if (object == null) {
                return null;
            }
            sdkIntAnnotation = object;
        } else {
            return null;
        }
        SdkIntAnnotation annotation = sdkIntAnnotation;
        object = annotation.getApiLevel(this.evaluator, owner, call);
        if (object == null) {
            return null;
        }
        int value = (Integer)object;
        return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(value));
    }

    static /* synthetic */ ApiConstraint getValidFromInferredAnnotation-wgJLwIQ$default(VersionChecks versionChecks, PsiModifierListOwner psiModifierListOwner, UCallExpression uCallExpression, int n10, Object object) {
        if ((n10 & 2) != 0) {
            uCallExpression = null;
        }
        return versionChecks.getValidFromInferredAnnotation-wgJLwIQ(psiModifierListOwner, uCallExpression);
    }

    private final ApiConstraint getValidVersionCall-wgJLwIQ(boolean and, UCallExpression call) {
        PsiMethod method = call.resolve();
        if (method == null) {
            String name;
            int version;
            UIdentifier identifier = call.getMethodIdentifier();
            if (identifier != null && (version = Companion.getMinSdkVersionFromMethodName(name = identifier.getName())) != -1) {
                return (ApiConstraint)((Function1)(and ? (KFunction)new Function1<Integer, ApiConstraint>((Object)ApiConstraint.Companion){

                    public final int invoke-14ggzL0(int p02) {
                        return ((ApiConstraint.Companion)this.receiver).atMost-14ggzL0(p02);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "atMost-14ggzL0(I)I";
                    }

                    @NotNull
                    public final String getName() {
                        return "atMost";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ApiConstraint.Companion.class);
                    }
                } : (KFunction)new Function1<Integer, ApiConstraint>((Object)ApiConstraint.Companion){

                    public final int invoke-14ggzL0(int p02) {
                        return ((ApiConstraint.Companion)this.receiver).above-14ggzL0(p02);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "above-14ggzL0(I)I";
                    }

                    @NotNull
                    public final String getName() {
                        return "above";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ApiConstraint.Companion.class);
                    }
                })).invoke((Object)version);
            }
            return null;
        }
        return this.getValidVersionCall-PWWxdZI(and, (UElement)call, method);
    }

    private final ApiConstraint getValidVersionCall-PWWxdZI(boolean and, UElement call, PsiMethod method) {
        int version;
        PsiClass containingClass;
        UCallExpression callExpression = call instanceof UCallExpression ? (UCallExpression)call : null;
        ApiConstraint validFromAnnotation = this.getValidFromAnnotation-wgJLwIQ((PsiModifierListOwner)method, callExpression);
        if (validFromAnnotation != null) {
            return validFromAnnotation;
        }
        ApiConstraint validFromInferredAnnotation = this.getValidFromInferredAnnotation-wgJLwIQ((PsiModifierListOwner)method, callExpression);
        if (validFromInferredAnnotation != null) {
            return validFromInferredAnnotation;
        }
        String string = method.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.name");
        String name = string;
        if (StringsKt.startsWith$default((String)name, (String)"isAtLeast", (boolean)false, (int)2, null) && (containingClass = method.getContainingClass()) != null && Intrinsics.areEqual((Object)"BuildCompat", (Object)containingClass.getName())) {
            if (Intrinsics.areEqual((Object)name, (Object)"isAtLeastN")) {
                return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(24));
            }
            if (Intrinsics.areEqual((Object)name, (Object)"isAtLeastNMR1")) {
                return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(25));
            }
            if (Intrinsics.areEqual((Object)name, (Object)"isAtLeastO")) {
                return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(26));
            }
            if (StringsKt.startsWith$default((String)name, (String)"isAtLeastP", (boolean)false, (int)2, null)) {
                return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(28));
            }
            if (StringsKt.startsWith$default((String)name, (String)"isAtLeastQ", (boolean)false, (int)2, null)) {
                return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(29));
            }
            if (StringsKt.startsWith$default((String)name, (String)"isAtLeast", (boolean)false, (int)2, null) && name.length() == 10 && Character.isUpperCase(name.charAt(9)) && Intrinsics.compare((int)name.charAt(9), (int)81) > 0) {
                return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(32));
            }
        }
        if ((version = Companion.getMinSdkVersionFromMethodName(name)) != -1) {
            return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(version));
        }
        if (!method.hasModifierProperty("abstract")) {
            List expressions;
            UExpression uExpression = UastFacade.INSTANCE.getMethodBody(method);
            if (uExpression == null) {
                return null;
            }
            UExpression body = uExpression;
            List list2 = expressions = body instanceof UBlockExpression ? ((UBlockExpression)body).getExpressions() : CollectionsKt.listOf((Object)body);
            if (expressions.size() == 1) {
                UExpression returnValue;
                UExpression statement = (UExpression)expressions.get(0);
                UExpression uExpression2 = returnValue = statement instanceof UReturnExpression ? ((UReturnExpression)statement).getReturnExpression() : statement;
                if (returnValue != null) {
                    Function1 lookup2;
                    ApiConstraint constraint;
                    List arguments;
                    List list3 = arguments = call instanceof UCallExpression ? ((UCallExpression)call).getValueArguments() : CollectionsKt.emptyList();
                    if (arguments.isEmpty()) {
                        ApiConstraint constraint2;
                        if ((returnValue instanceof UPolyadicExpression || returnValue instanceof UCallExpression || returnValue instanceof UQualifiedReferenceExpression) && (constraint2 = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(this, (UElement)returnValue, and, null, null, 12, null)) != null) {
                            return constraint2;
                        }
                    } else if (arguments.size() == 1 && (constraint = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(this, (UElement)returnValue, and, null, lookup2 = (Function1)new Function1<UElement, Integer>((List<? extends UExpression>)arguments, this){
                        final /* synthetic */ List<UExpression> $arguments;
                        final /* synthetic */ VersionChecks this$0;
                        {
                            this.$arguments = $arguments;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Integer invoke(@NotNull UElement reference) {
                            int index;
                            PsiParameterList parameterList;
                            PsiElement resolved;
                            Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
                            int apiLevel = -1;
                            if (reference instanceof UReferenceExpression && (resolved = ((UReferenceExpression)reference).resolve()) instanceof PsiParameter && (parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class)) != null && (index = parameterList.getParameterIndex((PsiParameter)resolved)) != -1 && index < this.$arguments.size()) {
                                apiLevel = VersionChecks.access$getApiLevel(this.this$0, this.$arguments.get(index), null);
                            }
                            return apiLevel;
                        }
                    }, 4, null)) != null) {
                        return constraint;
                    }
                }
            }
        }
        return null;
    }

    private final boolean isSdkInt(PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiExpression initializer;
            if (Intrinsics.areEqual((Object)SDK_INT, (Object)((PsiReferenceExpression)element).getReferenceName())) {
                return true;
            }
            PsiElement resolved = ((PsiReferenceExpression)element).resolve();
            if (resolved instanceof PsiVariable && (initializer = ((PsiVariable)resolved).getInitializer()) != null) {
                return this.isSdkInt((PsiElement)initializer);
            }
        } else if (element instanceof PsiMethodCallExpression && Intrinsics.areEqual((Object)GET_BUILD_SDK_INT, (Object)((PsiMethodCallExpression)element).getMethodExpression().getReferenceName())) {
            return true;
        }
        return false;
    }

    private final boolean isSdkInt(UElement element) {
        if (element instanceof UReferenceExpression) {
            PsiExpression initializer;
            if (Intrinsics.areEqual((Object)SDK_INT, (Object)((UReferenceExpression)element).getResolvedName())) {
                return true;
            }
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof ULocalVariable) {
                UExpression initializer2 = ((ULocalVariable)resolved).getUastInitializer();
                if (initializer2 != null) {
                    return this.isSdkInt((UElement)initializer2);
                }
            } else if (resolved instanceof PsiVariable && (initializer = ((PsiVariable)resolved).getInitializer()) != null) {
                return this.isSdkInt((PsiElement)initializer);
            }
        } else if (element instanceof UCallExpression && Intrinsics.areEqual((Object)GET_BUILD_SDK_INT, (Object)Lint.getMethodName((UCallExpression)element))) {
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ApiConstraint getVersionCheckConditional-PWWxdZI(UBinaryExpression binary, boolean fromThen, Function1<? super UElement, Integer> apiLevelLookup) {
        boolean fromThen2 = fromThen;
        UastBinaryOperator tokenType = binary.getOperator();
        if (tokenType != UastBinaryOperator.GREATER && tokenType != UastBinaryOperator.GREATER_OR_EQUALS && tokenType != UastBinaryOperator.LESS_OR_EQUALS && tokenType != UastBinaryOperator.LESS && tokenType != UastBinaryOperator.EQUALS && tokenType != UastBinaryOperator.IDENTITY_EQUALS && tokenType != UastBinaryOperator.NOT_EQUALS) {
            if (tokenType != UastBinaryOperator.IDENTITY_NOT_EQUALS) return null;
        }
        UExpression left = binary.getLeftOperand();
        int level = 0;
        UExpression right = null;
        if (!this.isSdkInt((UElement)left)) {
            right = binary.getRightOperand();
            if (!this.isSdkInt((UElement)right)) return null;
            fromThen2 = !fromThen2;
            level = this.getApiLevel(left, apiLevelLookup);
        } else {
            right = binary.getRightOperand();
            level = this.getApiLevel(right, apiLevelLookup);
        }
        if (level == -1) return null;
        if (tokenType == UastBinaryOperator.GREATER_OR_EQUALS) {
            ApiConstraint apiConstraint;
            if (this.lowerBound) {
                if (!fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(level));
                return apiConstraint;
            } else {
                if (fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atLeast-14ggzL0(level - 2));
            }
            return apiConstraint;
        }
        if (tokenType == UastBinaryOperator.GREATER) {
            ApiConstraint apiConstraint;
            if (this.lowerBound) {
                if (!fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(level + 1));
                return apiConstraint;
            } else {
                if (fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atLeast-14ggzL0(level - 1));
            }
            return apiConstraint;
        }
        if (tokenType == UastBinaryOperator.LESS_OR_EQUALS) {
            ApiConstraint apiConstraint;
            if (this.lowerBound) {
                if (fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(level + 1));
                return apiConstraint;
            } else {
                if (!fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atLeast-14ggzL0(level - 2));
            }
            return apiConstraint;
        }
        if (tokenType == UastBinaryOperator.LESS) {
            ApiConstraint apiConstraint;
            if (this.lowerBound) {
                if (fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(level));
                return apiConstraint;
            } else {
                if (!fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atLeast-14ggzL0(level - 3));
            }
            return apiConstraint;
        }
        if (tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
            ApiConstraint apiConstraint;
            if (this.lowerBound) {
                if (!fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(level));
                return apiConstraint;
            } else {
                if (!fromThen2) return null;
                apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.atLeast-14ggzL0(level));
            }
            return apiConstraint;
        }
        if (tokenType == UastBinaryOperator.NOT_EQUALS || tokenType == UastBinaryOperator.IDENTITY_NOT_EQUALS) {
            if (fromThen2) return null;
            ApiConstraint apiConstraint = ApiConstraint.box-impl(ApiConstraint.Companion.range-q7eFxUo(level, level + 1));
            return apiConstraint;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (!_Assertions.ENABLED) return null;
        boolean bl4 = false;
        UastBinaryOperator uastBinaryOperator = tokenType;
        throw (Throwable)((Object)new AssertionError(uastBinaryOperator));
    }

    static /* synthetic */ ApiConstraint getVersionCheckConditional-PWWxdZI$default(VersionChecks versionChecks, UBinaryExpression uBinaryExpression, boolean bl2, Function1 function1, int n10, Object object) {
        if ((n10 & 4) != 0) {
            function1 = null;
        }
        return versionChecks.getVersionCheckConditional-PWWxdZI(uBinaryExpression, bl2, (Function1<? super UElement, Integer>)function1);
    }

    private final int getApiLevel(UExpression element, Function1<? super UElement, Integer> apiLevelLookup) {
        Object value;
        int level = -1;
        if (element instanceof UReferenceExpression) {
            Object constant;
            String codeName = ((UReferenceExpression)element).getResolvedName();
            if (codeName != null) {
                level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)false);
            }
            if (level == -1 && (constant = ConstantEvaluator.evaluate(null, (UElement)element)) instanceof Number) {
                level = ((Number)constant).intValue();
            }
        } else if (element instanceof ULiteralExpression && (value = ((ULiteralExpression)element).getValue()) instanceof Integer) {
            level = ((Number)value).intValue();
        }
        if (level == -1 && apiLevelLookup != null && element != null) {
            level = ((Number)apiLevelLookup.invoke((Object)element)).intValue();
        }
        return level;
    }

    private final ApiConstraint getOredWithConditional-wgJLwIQ(UElement element, UElement before) {
        if (element instanceof UBinaryExpression) {
            ApiConstraint apiConstraint;
            ApiConstraint right;
            UExpression left;
            if (((UBinaryExpression)element).getOperator() == UastBinaryOperator.LOGICAL_OR && before != (left = ((UBinaryExpression)element).getLeftOperand())) {
                ApiConstraint apiConstraint2 = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(this, (UElement)left, false, null, null, 12, null);
                if (apiConstraint2 != null) {
                    ApiConstraint apiConstraint3 = apiConstraint2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int it2 = apiConstraint3.unbox-impl();
                    boolean bl4 = false;
                    return ApiConstraint.box-impl(it2);
                }
                right = ((UBinaryExpression)element).getRightOperand();
                ApiConstraint apiConstraint4 = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(this, (UElement)right, false, null, null, 12, null);
                if (apiConstraint4 != null) {
                    ApiConstraint apiConstraint5 = apiConstraint4;
                    boolean bl5 = false;
                    boolean it2 = false;
                    int it3 = apiConstraint5.unbox-impl();
                    boolean bl6 = false;
                    return ApiConstraint.box-impl(it3);
                }
            }
            if ((apiConstraint = VersionChecks.getVersionCheckConditional-PWWxdZI$default(this, (UBinaryExpression)element, false, null, 4, null)) != null) {
                right = apiConstraint;
                boolean bl7 = false;
                boolean bl8 = false;
                int it4 = right.unbox-impl();
                boolean bl9 = false;
                return ApiConstraint.box-impl(it4);
            }
        } else if (element instanceof UPolyadicExpression && ((UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_OR) {
            UExpression operand;
            Iterator iterator = ((UPolyadicExpression)element).getOperands().iterator();
            while (iterator.hasNext() && !Intrinsics.areEqual((Object)(operand = (UExpression)iterator.next()), (Object)before)) {
                ApiConstraint constraint = this.getOredWithConditional-wgJLwIQ((UElement)operand, before);
                if (constraint == null) continue;
                return constraint;
            }
        }
        return null;
    }

    private final ApiConstraint getAndedWithConditional-wgJLwIQ(UElement element, UElement before) {
        if (element instanceof UBinaryExpression) {
            ApiConstraint apiConstraint;
            ApiConstraint right;
            UExpression left;
            if (((UBinaryExpression)element).getOperator() == UastBinaryOperator.LOGICAL_AND && before != (left = ((UBinaryExpression)element).getLeftOperand())) {
                ApiConstraint apiConstraint2 = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(this, (UElement)left, true, null, null, 12, null);
                if (apiConstraint2 != null) {
                    ApiConstraint apiConstraint3 = apiConstraint2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int it2 = apiConstraint3.unbox-impl();
                    boolean bl4 = false;
                    return ApiConstraint.box-impl(it2);
                }
                right = ((UBinaryExpression)element).getRightOperand();
                ApiConstraint apiConstraint4 = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(this, (UElement)right, true, null, null, 12, null);
                if (apiConstraint4 != null) {
                    ApiConstraint apiConstraint5 = apiConstraint4;
                    boolean bl5 = false;
                    boolean it2 = false;
                    int it3 = apiConstraint5.unbox-impl();
                    boolean bl6 = false;
                    return ApiConstraint.box-impl(it3);
                }
            }
            if ((apiConstraint = VersionChecks.getVersionCheckConditional-PWWxdZI$default(this, (UBinaryExpression)element, true, null, 4, null)) != null) {
                right = apiConstraint;
                boolean bl7 = false;
                boolean bl8 = false;
                int it4 = right.unbox-impl();
                boolean bl9 = false;
                return ApiConstraint.box-impl(it4);
            }
        } else if (element instanceof UPolyadicExpression && ((UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_AND) {
            UExpression operand;
            Iterator iterator = ((UPolyadicExpression)element).getOperands().iterator();
            while (iterator.hasNext() && !Intrinsics.areEqual((Object)(operand = (UExpression)iterator.next()), (Object)before)) {
                ApiConstraint constraint = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(this, (UElement)operand, true, null, null, 12, null);
                if (constraint == null) continue;
                return constraint;
            }
        }
        return null;
    }

    @JvmStatic
    public static final int codeNameToApi(@NotNull String text) {
        return Companion.codeNameToApi(text);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, int api, boolean lowerBound) {
        return Companion.isWithinVersionCheckConditional(context2, element, api, lowerBound);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, boolean lowerBound) {
        return Companion.isWithinVersionCheckConditional(client, evaluator, element, api, lowerBound);
    }

    @JvmStatic
    public static final boolean isPrecededByVersionCheckExit(@NotNull JavaContext context2, @NotNull UElement element, int api) {
        return Companion.isPrecededByVersionCheckExit(context2, element, api);
    }

    @JvmStatic
    public static final boolean isPrecededByVersionCheckExit(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, @Nullable Project project) {
        return Companion.isPrecededByVersionCheckExit(client, evaluator, element, api, project);
    }

    @JvmStatic
    @Nullable
    public static final ApiConstraint getVersionCheckConditional-xCz0aec(@NotNull UBinaryExpression binary) {
        return Companion.getVersionCheckConditional-xCz0aec(binary);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, int api) {
        return Companion.isWithinVersionCheckConditional(context2, element, api);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api) {
        return Companion.isWithinVersionCheckConditional(client, evaluator, element, api);
    }

    public static final /* synthetic */ int access$getApiLevel(VersionChecks $this, UExpression element, Function1 apiLevelLookup) {
        return $this.getApiLevel(element, (Function1<? super UElement, Integer>)apiLevelLookup);
    }

    static {
        String[] stringArray = new String[]{"isAtLeast", "isRunning", "is", "runningOn", "running", "has"};
        VERSION_METHOD_NAME_PREFIXES = stringArray;
        stringArray = new String[]{"OrLater", "OrAbove", "OrHigher", "OrNewer", "Sdk"};
        VERSION_METHOD_NAME_SUFFIXES = stringArray;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J \u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\u0014J4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J \u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0007J2\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\b\b\u0002\u0010#\u001a\u00020\u0016H\u0007J*\u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\b\b\u0002\u0010#\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/VersionChecks$Companion;", "", "()V", "CHECKS_SDK_INT_AT_LEAST_ANNOTATION", "", "GET_BUILD_SDK_INT", "SDK_INT", "VERSION_METHOD_NAME_PREFIXES", "", "[Ljava/lang/String;", "VERSION_METHOD_NAME_SUFFIXES", "codeNameToApi", "", "text", "getMinSdkVersionFromMethodName", "name", "getVersionCheckConditional", "Lcom/android/tools/lint/checks/ApiConstraint;", "binary", "Lorg/jetbrains/uast/UBinaryExpression;", "getVersionCheckConditional-xCz0aec", "isPrecededByVersionCheckExit", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "element", "Lorg/jetbrains/uast/UElement;", "api", "project", "Lcom/android/tools/lint/detector/api/Project;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "isWithinVersionCheckConditional", "lowerBound", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int codeNameToApi(@NotNull String text) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)text, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex != -1) {
                String string2 = text;
                int n10 = dotIndex + 1;
                boolean bl2 = false;
                String string3 = string2.substring(n10);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = text;
            }
            String buildCode = string;
            return SdkVersionInfo.getApiByBuildCode((String)buildCode, (boolean)true);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, int api, boolean lowerBound) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            LintClient client = context2.getClient();
            JavaEvaluator evaluator = context2.getEvaluator();
            Project project = context2.getProject();
            VersionChecks check = new VersionChecks(client, evaluator, project, lowerBound);
            ApiConstraint apiConstraint = check.getWithinVersionCheckConditional-PWWxdZI(evaluator, element, (Function1<? super UElement, Integer>)null);
            if (apiConstraint == null) {
                return false;
            }
            int constraint = apiConstraint.unbox-impl();
            return ApiConstraint.matches-impl(constraint, api);
        }

        public static /* synthetic */ boolean isWithinVersionCheckConditional$default(Companion companion, JavaContext javaContext, UElement uElement, int n10, boolean bl2, int n11, Object object) {
            if ((n11 & 8) != 0) {
                bl2 = true;
            }
            return companion.isWithinVersionCheckConditional(javaContext, uElement, n10, bl2);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, boolean lowerBound) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            VersionChecks check = new VersionChecks(client, evaluator, null, lowerBound);
            ApiConstraint apiConstraint = check.getWithinVersionCheckConditional-PWWxdZI(evaluator, element, (Function1<? super UElement, Integer>)null);
            if (apiConstraint == null) {
                return false;
            }
            int constraint = apiConstraint.unbox-impl();
            return ApiConstraint.matches-impl(constraint, api);
        }

        public static /* synthetic */ boolean isWithinVersionCheckConditional$default(Companion companion, LintClient lintClient, JavaEvaluator javaEvaluator, UElement uElement, int n10, boolean bl2, int n11, Object object) {
            if ((n11 & 0x10) != 0) {
                bl2 = true;
            }
            return companion.isWithinVersionCheckConditional(lintClient, javaEvaluator, uElement, n10, bl2);
        }

        @JvmStatic
        public final boolean isPrecededByVersionCheckExit(@NotNull JavaContext context2, @NotNull UElement element, int api) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            LintClient client = context2.getClient();
            JavaEvaluator evaluator = context2.getEvaluator();
            Project project = context2.getProject();
            return this.isPrecededByVersionCheckExit(client, evaluator, element, api, project);
        }

        @JvmStatic
        public final boolean isPrecededByVersionCheckExit(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api, @Nullable Project project) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            VersionChecks check = new VersionChecks(client, evaluator, project, false, 8, null);
            UElement prev = element;
            Class[] classArray = new Class[]{UMethod.class, UClass.class};
            UExpression current = (UExpression)UastUtils.getParentOfType((UElement)prev, UExpression.class, (boolean)true, (Class[])classArray);
            while (current != null) {
                VersionCheckWithExitFinder visitor2 = check.new VersionCheckWithExitFinder(prev, api);
                current.accept((UastVisitor)visitor2);
                if (visitor2.found()) {
                    return true;
                }
                prev = (UElement)current;
                Class[] classArray2 = new Class[]{UMethod.class, UClass.class};
                current = (UExpression)UastUtils.getParentOfType((UElement)((UElement)current), UExpression.class, (boolean)true, (Class[])classArray2);
            }
            return false;
        }

        public static /* synthetic */ boolean isPrecededByVersionCheckExit$default(Companion companion, LintClient lintClient, JavaEvaluator javaEvaluator, UElement uElement, int n10, Project project, int n11, Object object) {
            if ((n11 & 0x10) != 0) {
                project = null;
            }
            return companion.isPrecededByVersionCheckExit(lintClient, javaEvaluator, uElement, n10, project);
        }

        @JvmStatic
        @Nullable
        public final ApiConstraint getVersionCheckConditional-xCz0aec(@NotNull UBinaryExpression binary) {
            UExpression left;
            Intrinsics.checkParameterIsNotNull((Object)binary, (String)"binary");
            UastBinaryOperator tokenType = binary.getOperator();
            if ((tokenType == UastBinaryOperator.GREATER || tokenType == UastBinaryOperator.GREATER_OR_EQUALS || tokenType == UastBinaryOperator.LESS_OR_EQUALS || tokenType == UastBinaryOperator.LESS || tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) && (left = binary.getLeftOperand()) instanceof UReferenceExpression && Intrinsics.areEqual((Object)VersionChecks.SDK_INT, (Object)((UReferenceExpression)left).getResolvedName())) {
                Object value;
                UExpression right = binary.getRightOperand();
                int level = -1;
                if (right instanceof UReferenceExpression) {
                    String string = ((UReferenceExpression)right).getResolvedName();
                    if (string == null) {
                        return null;
                    }
                    String codeName = string;
                    level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
                } else if (right instanceof ULiteralExpression && (value = ((ULiteralExpression)right).getValue()) instanceof Integer) {
                    level = ((Number)value).intValue();
                }
                if (level != -1) {
                    if (tokenType == UastBinaryOperator.GREATER_OR_EQUALS) {
                        return ApiConstraint.box-impl(ApiConstraint.Companion.atLeast-14ggzL0(level));
                    }
                    if (tokenType == UastBinaryOperator.GREATER) {
                        return ApiConstraint.box-impl(ApiConstraint.Companion.above-14ggzL0(level));
                    }
                    if (tokenType == UastBinaryOperator.LESS_OR_EQUALS) {
                        return ApiConstraint.box-impl(ApiConstraint.Companion.atMost-14ggzL0(level));
                    }
                    if (tokenType == UastBinaryOperator.LESS) {
                        return ApiConstraint.box-impl(ApiConstraint.Companion.below-14ggzL0(level));
                    }
                    if (tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
                        return ApiConstraint.box-impl(ApiConstraint.Companion.range-q7eFxUo(level, level + 1));
                    }
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @VisibleForTesting
        public final int getMinSdkVersionFromMethodName(@NotNull String name) {
            Object object;
            int n10;
            int $i$f$firstOrNull;
            Object $this$firstOrNull$iv;
            String prefix;
            int n11;
            String[] $this$firstOrNull$iv2;
            block11: {
                String[] stringArray;
                String element$iv;
                block10: {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    $this$firstOrNull$iv2 = VERSION_METHOD_NAME_PREFIXES;
                    boolean $i$f$firstOrNull2 = false;
                    String[] stringArray2 = $this$firstOrNull$iv2;
                    int n12 = stringArray2.length;
                    n11 = 0;
                    while (n11 < n12) {
                        String it2 = element$iv = stringArray2[n11];
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)name, (String)it2, (boolean)false, (int)2, null)) {
                            ++n11;
                            continue;
                        }
                        break block10;
                    }
                    return -1;
                }
                String string = element$iv;
                String string2 = string;
                if (string2 == null) {
                    return -1;
                }
                prefix = string2;
                $this$firstOrNull$iv = VERSION_METHOD_NAME_SUFFIXES;
                $i$f$firstOrNull = 0;
                String[] stringArray3 = $this$firstOrNull$iv;
                n11 = stringArray3.length;
                for (n10 = 0; n10 < n11; ++n10) {
                    String[] element$iv2;
                    String[] it3 = element$iv2 = stringArray3[n10];
                    boolean bl3 = false;
                    if (!SdkUtils.endsWithIgnoreCase((String)name, (String)it3)) continue;
                    stringArray = element$iv2;
                    break block11;
                }
                stringArray = $this$firstOrNull$iv2 = null;
            }
            if ($this$firstOrNull$iv2 == null) {
                if (Intrinsics.areEqual((Object)prefix, (Object)"is")) return -1;
                object = "";
            } else {
                object = $this$firstOrNull$iv2;
            }
            String[] suffix = object;
            $this$firstOrNull$iv = name;
            $i$f$firstOrNull = prefix.length();
            int n13 = name.length() - suffix.length();
            n11 = 0;
            String string = ((String)$this$firstOrNull$iv).substring($i$f$firstOrNull, n13);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String codeName = string;
            int version = SdkVersionInfo.getApiByPreviewName((String)codeName, (boolean)false);
            if (version != -1) return version;
            version = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)false);
            if (version == -1 && codeName.length() == 1 && Character.isUpperCase(codeName.charAt(0))) {
                return 32;
            }
            if (!SdkUtils.startsWithIgnoreCase((String)codeName, (String)"api")) return version;
            int begin = 3;
            int length = codeName.length();
            if (begin < length && codeName.charAt(begin) == '_') {
                n11 = begin;
                begin = n11 + 1;
            }
            int end = begin;
            while (end < length && Character.isDigit(codeName.charAt(end))) {
                n10 = end;
                end = n10 + 1;
            }
            if (begin >= end) return version;
            String string3 = codeName;
            boolean bl4 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(begin, end);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Integer n14 = Integer.decode(string5);
            Intrinsics.checkExpressionValueIsNotNull((Object)n14, (String)"decode(codeName.substring(begin, end))");
            return ((Number)n14).intValue();
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull JavaContext context2, @NotNull UElement element, int api) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return com.android.tools.lint.checks.VersionChecks$Companion.isWithinVersionCheckConditional$default(this, context2, element, api, false, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isWithinVersionCheckConditional(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull UElement element, int api) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return com.android.tools.lint.checks.VersionChecks$Companion.isWithinVersionCheckConditional$default(this, client, evaluator, element, api, false, 16, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/VersionChecks$VersionCheckWithExitFinder;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "endElement", "Lorg/jetbrains/uast/UElement;", "api", "", "(Lcom/android/tools/lint/checks/VersionChecks;Lorg/jetbrains/uast/UElement;I)V", "done", "", "found", "visitElement", "node", "visitIfExpression", "Lorg/jetbrains/uast/UIfExpression;", "android.sdktools.lint-checks"})
    private final class VersionCheckWithExitFinder
    extends AbstractUastVisitor {
        @NotNull
        private final UElement endElement;
        private final int api;
        private boolean found;
        private boolean done;

        public VersionCheckWithExitFinder(UElement endElement, int api) {
            Intrinsics.checkParameterIsNotNull((Object)VersionChecks.this, (String)"this$0");
            Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
            this.endElement = endElement;
            this.api = api;
        }

        public boolean visitElement(@NotNull UElement node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (this.done) {
                return true;
            }
            if (node == this.endElement) {
                this.done = true;
            }
            return this.done;
        }

        public boolean visitIfExpression(@NotNull UIfExpression node) {
            ApiConstraint constraint;
            ApiConstraint apiConstraint;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            super.visitIfExpression(node);
            if (this.done) {
                return true;
            }
            if (UastUtils.isUastChildOf((UElement)this.endElement, (UElement)((UElement)node), (boolean)true)) {
                this.done = true;
                return true;
            }
            UExpression thenBranch = node.getThenExpression();
            UExpression elseBranch = node.getElseExpression();
            if (thenBranch != null && ((apiConstraint = (constraint = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(VersionChecks.this, (UElement)node.getCondition(), false, null, null, 12, null))) == null ? false : ApiConstraint.matches-impl(apiConstraint.unbox-impl(), this.api)) && VersionChecks.this.isUnconditionalReturn(thenBranch)) {
                this.found = true;
                this.done = true;
            }
            if (elseBranch != null && ((apiConstraint = (constraint = VersionChecks.getVersionCheckConditional-Xdgp6x0$default(VersionChecks.this, (UElement)node.getCondition(), true, null, null, 12, null))) == null ? false : ApiConstraint.matches-impl(apiConstraint.unbox-impl(), this.api)) && VersionChecks.this.isUnconditionalReturn(elseBranch)) {
                this.found = true;
                this.done = true;
            }
            return true;
        }

        public final boolean found() {
            return this.found;
        }
    }
}

