/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.SdkInfo;
import com.google.common.annotations.Beta;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/client/api/DefaultSdkInfo;", "Lcom/android/tools/lint/client/api/SdkInfo;", "()V", "getInterface", "", "cls", "getParent", "layout", "getParentViewClass", "fqcn", "getParentViewName", "name", "getRawType", "type", "implementsInterface", "", "className", "interfaceName", "isLayout", "tag", "isSubViewOf", "parentViewFqcn", "childViewFqcn", "android.sdktools.lint-api"})
@Beta
public final class DefaultSdkInfo
extends SdkInfo {
    @Override
    @Nullable
    public String getParentViewName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = this.getRawType(name);
        if (string == null) {
            return null;
        }
        String rawType = string;
        return this.getParent(rawType);
    }

    @Override
    @Nullable
    public String getParentViewClass(@NotNull String fqcn) {
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)fqcn, (String)"fqcn");
        String simpleName = fqcn;
        int index = StringsKt.lastIndexOf$default((CharSequence)simpleName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string3 = simpleName;
            int n10 = index + 1;
            boolean bl2 = false;
            String string4 = string3.substring(n10);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            simpleName = string4;
        }
        if ((string2 = this.getParent(simpleName)) == null) {
            return null;
        }
        switch (string2) {
            case "ViewGroup": 
            case "View": 
            case "SurfaceView": {
                String parent;
                string = Intrinsics.stringPlus((String)"android.view.", (Object)parent);
                break;
            }
            default: {
                String parent;
                string = Intrinsics.stringPlus((String)"android.widget.", (Object)parent);
            }
        }
        return string;
    }

    @Override
    public boolean isSubViewOf(@NotNull String parentViewFqcn, @NotNull String childViewFqcn) {
        boolean bl2;
        int n10;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)parentViewFqcn, (String)"parentViewFqcn");
        Intrinsics.checkParameterIsNotNull((Object)childViewFqcn, (String)"childViewFqcn");
        String string2 = this.getRawType(parentViewFqcn);
        if (string2 == null) {
            return false;
        }
        String parent = string2;
        String child = this.getRawType(childViewFqcn);
        if (StringsKt.indexOf$default((CharSequence)parent, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
            string = parent;
            n10 = StringsKt.lastIndexOf$default((CharSequence)parent, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            bl2 = false;
            String string3 = string.substring(n10);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            parent = string3;
        }
        String string4 = child;
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.indexOf$default((CharSequence)string4, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
            string = child;
            n10 = StringsKt.lastIndexOf$default((CharSequence)child, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            bl2 = false;
            String string5 = string.substring(n10);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            child = string5;
        }
        if (Intrinsics.areEqual((Object)parent, (Object)"View")) {
            return true;
        }
        while (!Intrinsics.areEqual((Object)child, (Object)"View")) {
            if (Intrinsics.areEqual((Object)parent, (Object)child)) {
                return true;
            }
            String string6 = child;
            if (string6 == null) {
                Intrinsics.throwNpe();
            }
            if (this.implementsInterface(string6, parent)) {
                return true;
            }
            if ((child = this.getParent(child)) != null) continue;
            return true;
        }
        return false;
    }

    private final boolean implementsInterface(String className, String interfaceName) {
        return Intrinsics.areEqual((Object)interfaceName, (Object)this.getInterface(className));
    }

    private final String getRawType(String type) {
        int index;
        if (type != null && (index = StringsKt.indexOf$default((CharSequence)type, (char)'<', (int)0, (boolean)false, (int)6, null)) != -1) {
            String string = type;
            int n10 = 0;
            boolean bl2 = false;
            String string2 = string.substring(n10, index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string2;
        }
        return type;
    }

    @Override
    public boolean isLayout(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (super.isLayout(tag)) {
            return true;
        }
        switch (tag) {
            case "MediaController": 
            case "SlidingDrawer": 
            case "RadioGroup": 
            case "TabHost": 
            case "ImageSwitcher": 
            case "TabWidget": 
            case "AdapterViewFlipper": 
            case "ViewSwitcher": 
            case "DialerFilter": 
            case "ViewFlipper": 
            case "ListView": 
            case "ViewAnimator": 
            case "ScrollView": 
            case "SearchView": 
            case "TableRow": 
            case "TextSwitcher": 
            case "GridView": 
            case "StackView": 
            case "HorizontalScrollView": 
            case "ExpandableListView": {
                return true;
            }
        }
        return false;
    }

    private final String getParent(String layout) {
        switch (layout) {
            case "CompoundButton": {
                return "Button";
            }
            case "AbsSpinner": {
                return "AdapterView";
            }
            case "AbsListView": {
                return "AdapterView";
            }
            case "AbsSeekBar": {
                return "ProgressBar";
            }
            case "AdapterView": {
                return "ViewGroup";
            }
            case "ViewGroup": {
                return "View";
            }
            case "TextView": {
                return "View";
            }
            case "CheckedTextView": {
                return "TextView";
            }
            case "RadioButton": {
                return "CompoundButton";
            }
            case "Spinner": {
                return "AbsSpinner";
            }
            case "ImageButton": {
                return "ImageView";
            }
            case "ImageView": {
                return "View";
            }
            case "EditText": {
                return "TextView";
            }
            case "ProgressBar": {
                return "View";
            }
            case "ToggleButton": {
                return "CompoundButton";
            }
            case "ViewStub": {
                return "View";
            }
            case "Button": {
                return "TextView";
            }
            case "SeekBar": {
                return "AbsSeekBar";
            }
            case "CheckBox": {
                return "CompoundButton";
            }
            case "Switch": {
                return "CompoundButton";
            }
            case "Gallery": {
                return "AbsSpinner";
            }
            case "SurfaceView": {
                return "View";
            }
            case "AbsoluteLayout": {
                return "ViewGroup";
            }
            case "LinearLayout": {
                return "ViewGroup";
            }
            case "RelativeLayout": {
                return "ViewGroup";
            }
            case "ListView": {
                return "AbsListView";
            }
            case "ViewSwitcher": {
                return "ViewAnimator";
            }
            case "FrameLayout": {
                return "ViewGroup";
            }
            case "HorizontalScrollView": {
                return "FrameLayout";
            }
            case "ViewAnimator": {
                return "FrameLayout";
            }
            case "TabHost": {
                return "FrameLayout";
            }
            case "TableRow": {
                return "LinearLayout";
            }
            case "RadioGroup": {
                return "LinearLayout";
            }
            case "TabWidget": {
                return "LinearLayout";
            }
            case "ExpandableListView": {
                return "ListView";
            }
            case "TableLayout": {
                return "LinearLayout";
            }
            case "ScrollView": {
                return "FrameLayout";
            }
            case "GridView": {
                return "AbsListView";
            }
            case "WebView": {
                return "AbsoluteLayout";
            }
            case "AutoCompleteTextView": {
                return "EditText";
            }
            case "MultiAutoCompleteTextView": {
                return "AutoCompleteTextView";
            }
            case "MediaController": {
                return "FrameLayout";
            }
            case "SlidingDrawer": {
                return "ViewGroup";
            }
            case "DialerFilter": {
                return "RelativeLayout";
            }
            case "DigitalClock": {
                return "TextView";
            }
            case "Chronometer": {
                return "TextView";
            }
            case "ImageSwitcher": {
                return "ViewSwitcher";
            }
            case "TextSwitcher": {
                return "ViewSwitcher";
            }
            case "AnalogClock": {
                return "View";
            }
            case "TwoLineListItem": {
                return "RelativeLayout";
            }
            case "ZoomControls": {
                return "LinearLayout";
            }
            case "DatePicker": {
                return "FrameLayout";
            }
            case "TimePicker": {
                return "FrameLayout";
            }
            case "VideoView": {
                return "SurfaceView";
            }
            case "ZoomButton": {
                return "ImageButton";
            }
            case "RatingBar": {
                return "AbsSeekBar";
            }
            case "ViewFlipper": {
                return "ViewAnimator";
            }
            case "NumberPicker": {
                return "LinearLayout";
            }
        }
        return null;
    }

    private final String getInterface(String cls) {
        String string = cls;
        return (Intrinsics.areEqual((Object)string, (Object)"CheckedTextView") ? true : Intrinsics.areEqual((Object)string, (Object)"CompoundButton")) ? "Checkable" : null;
    }
}

