/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Position;
import com.android.utils.CharSequences;
import com.google.common.annotations.Beta;
import java.io.File;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0017\u0018\u0000 32\u00020\u0001:\u0006345678B#\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J!\u0010 \u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020\u001eJ\u0006\u0010-\u001a\u00020\u001eJ\u0012\u0010.\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0016J\u0018\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010/\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001J\b\u00100\u001a\u00020\u0012H\u0016J\"\u00101\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0001R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\n\"\u0004\b!\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000eR\u001a\u0010#\u001a\u00020\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00069"}, d2={"Lcom/android/tools/lint/detector/api/Location;", "", "file", "Ljava/io/File;", "start", "Lcom/android/tools/lint/detector/api/Position;", "end", "(Ljava/io/File;Lcom/android/tools/lint/detector/api/Position;Lcom/android/tools/lint/detector/api/Position;)V", "clientData", "getClientData", "()Ljava/lang/Object;", "setClientData", "(Ljava/lang/Object;)V", "getEnd", "()Lcom/android/tools/lint/detector/api/Position;", "getFile", "()Ljava/io/File;", "value", "", "message", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "secondary", "getSecondary", "()Lcom/android/tools/lint/detector/api/Location;", "setSecondary", "(Lcom/android/tools/lint/detector/api/Location;)V", "selfExplanatory", "", "source", "getSource", "setSource", "getStart", "visible", "getVisible", "()Z", "setVisible", "(Z)V", "T", "clz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "isSelfExplanatory", "isSingleLine", "setData", "setSelfExplanatory", "toString", "withSecondary", "withSource", "Companion", "DefaultLocationHandle", "Handle", "ResourceItemHandle", "SearchDirection", "SearchHints", "android.sdktools.lint-api"})
@Beta
public class Location {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @Nullable
    private final Position start;
    @Nullable
    private final Position end;
    @Nullable
    private String message;
    @Nullable
    private Object clientData;
    private boolean visible;
    private boolean selfExplanatory;
    @Nullable
    private Location secondary;
    @Nullable
    private Object source;
    @NotNull
    private static final String SUPER_KEYWORD = "super";
    @JvmField
    @NotNull
    public static final Location NONE;

    protected Location(@NotNull File file, @Nullable Position start, @Nullable Position end) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        this.start = start;
        this.end = end;
        this.visible = true;
        this.selfExplanatory = true;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Nullable
    public final Position getStart() {
        return this.start;
    }

    @Nullable
    public final Position getEnd() {
        return this.end;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(@Nullable String value) {
        this.message = value;
        this.setSelfExplanatory(false);
    }

    @Nullable
    public final Object getClientData() {
        return this.clientData;
    }

    public final void setClientData(@Nullable Object object) {
        this.clientData = object;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        this.visible = bl2;
    }

    @Nullable
    public Location getSecondary() {
        return this.secondary;
    }

    public void setSecondary(@Nullable Location location) {
        this.secondary = location;
    }

    @Nullable
    public final Object getSource() {
        return this.source;
    }

    public final void setSource(@Nullable Object object) {
        this.source = object;
    }

    @JvmOverloads
    @NotNull
    public final Location withSecondary(@NotNull Location secondary, @NotNull String message2, boolean selfExplanatory) {
        Intrinsics.checkParameterIsNotNull((Object)secondary, (String)"secondary");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.setSecondary(secondary);
        secondary.setMessage(message2);
        secondary.selfExplanatory = selfExplanatory;
        return this;
    }

    public static /* synthetic */ Location withSecondary$default(Location location, Location location2, String string, boolean bl2, int n10, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withSecondary");
        }
        if ((n10 & 4) != 0) {
            bl2 = false;
        }
        return location.withSecondary(location2, string, bl2);
    }

    @NotNull
    public final Location withSource(@NotNull Object source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = source;
        return this;
    }

    @Nullable
    public final <T> T getSource(@NotNull Class<T> clz) {
        Intrinsics.checkParameterIsNotNull(clz, (String)"clz");
        Object object = this.source;
        if (object == null) {
            return null;
        }
        Object source = object;
        if (clz.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        return null;
    }

    @NotNull
    public final Location setSource(@Nullable Object source) {
        this.source = source;
        return this;
    }

    @NotNull
    public Location setMessage(@NotNull String message2, boolean selfExplanatory) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.setMessage(message2);
        this.setSelfExplanatory(selfExplanatory);
        return this;
    }

    public final boolean isSelfExplanatory() {
        return this.selfExplanatory;
    }

    @NotNull
    public Location setSelfExplanatory(boolean selfExplanatory) {
        this.selfExplanatory = selfExplanatory;
        return this;
    }

    @NotNull
    public Location setData(@Nullable Object clientData) {
        this.clientData = clientData;
        return this;
    }

    public final boolean isSingleLine() {
        return this.start == null || this.end == null || this.start.sameLine(this.end);
    }

    @NotNull
    public String toString() {
        return "Location [file=" + this.file.getName() + ", start=" + this.start + ", end=" + this.end + ", message=" + this.message + ']';
    }

    @JvmOverloads
    @NotNull
    public final Location withSecondary(@NotNull Location secondary, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)secondary, (String)"secondary");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        return Location.withSecondary$default(this, secondary, message2, false, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file) {
        return Companion.create(file);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @NotNull SourcePosition position) {
        return Companion.create(file, position);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @NotNull Position start, @Nullable Position end) {
        return Companion.create(file, start, end);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @Nullable CharSequence contents, int startOffset, int endOffset) {
        return Companion.create(file, contents, startOffset, endOffset);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @NotNull String contents, int line) {
        return Companion.create(file, contents, line);
    }

    @JvmStatic
    @NotNull
    public static final Location create(@NotNull File file, @NotNull CharSequence contents, int line, @Nullable String patternStart, @Nullable String patternEnd, @Nullable SearchHints hints) {
        return Companion.create(file, contents, line, patternStart, patternEnd, hints);
    }

    @JvmStatic
    @NotNull
    public static final Location reverse(@NotNull Location location) {
        return Companion.reverse(location);
    }

    static {
        File file = new File("NONE");
        NONE = new Location(file){
            private boolean visible;
            @Nullable
            private Location secondary;

            @NotNull
            public Location setMessage(@NotNull String message2, boolean selfExplanatory) {
                Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
                return this;
            }

            @NotNull
            public Location setData(@Nullable Object clientData) {
                return this;
            }

            @NotNull
            public Location setSelfExplanatory(boolean selfExplanatory) {
                return this;
            }

            public boolean getVisible() {
                return this.visible;
            }

            public void setVisible(boolean value) {
            }

            public static /* synthetic */ void getVisible$annotations() {
            }

            @Nullable
            public Location getSecondary() {
                return this.secondary;
            }

            public void setSecondary(@Nullable Location value) {
            }

            public static /* synthetic */ void getSecondary$annotations() {
            }
        };
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0007\u001a\u00020\bH&R\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/detector/api/Location$Handle;", "", "clientData", "getClientData", "()Ljava/lang/Object;", "setClientData", "(Ljava/lang/Object;)V", "resolve", "Lcom/android/tools/lint/detector/api/Location;", "android.sdktools.lint-api"})
    public static interface Handle {
        @NotNull
        public Location resolve();

        @Nullable
        public Object getClientData();

        public void setClientData(@Nullable Object var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/detector/api/Location$DefaultLocationHandle;", "Lcom/android/tools/lint/detector/api/Location$Handle;", "context", "Lcom/android/tools/lint/detector/api/Context;", "startOffset", "", "endOffset", "(Lcom/android/tools/lint/detector/api/Context;II)V", "clientData", "", "getClientData", "()Ljava/lang/Object;", "setClientData", "(Ljava/lang/Object;)V", "contents", "", "file", "Ljava/io/File;", "resolve", "Lcom/android/tools/lint/detector/api/Location;", "android.sdktools.lint-api"})
    public static final class DefaultLocationHandle
    implements Handle {
        private final int startOffset;
        private final int endOffset;
        @NotNull
        private final File file;
        @NotNull
        private final CharSequence contents;
        @Nullable
        private Object clientData;

        public DefaultLocationHandle(@NotNull Context context2, int startOffset, int endOffset) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.file = context2.file;
            CharSequence charSequence = context2.getContents();
            this.contents = charSequence == null ? (CharSequence)"" : charSequence;
        }

        @Override
        @Nullable
        public Object getClientData() {
            return this.clientData;
        }

        @Override
        public void setClientData(@Nullable Object object) {
            this.clientData = object;
        }

        @Override
        @NotNull
        public Location resolve() {
            return Companion.create(this.file, this.contents, this.startOffset, this.endOffset);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/detector/api/Location$ResourceItemHandle;", "Lcom/android/tools/lint/detector/api/Location$Handle;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "item", "Lcom/android/ide/common/resources/ResourceItem;", "nameOnly", "", "valueOnly", "(Lcom/android/tools/lint/client/api/LintClient;Lcom/android/ide/common/resources/ResourceItem;ZZ)V", "<anonymous parameter 0>", "", "clientData", "getClientData", "()Ljava/lang/Object;", "setClientData", "(Ljava/lang/Object;)V", "getItem", "()Lcom/android/ide/common/resources/ResourceItem;", "resolve", "Lcom/android/tools/lint/detector/api/Location;", "toString", "", "android.sdktools.lint-api"})
    public static class ResourceItemHandle
    implements Handle {
        @NotNull
        private final LintClient client;
        @NotNull
        private final ResourceItem item;
        private final boolean nameOnly;
        private final boolean valueOnly;

        public ResourceItemHandle(@NotNull LintClient client, @NotNull ResourceItem item, boolean nameOnly, boolean valueOnly) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            this.client = client;
            this.item = item;
            this.nameOnly = nameOnly;
            this.valueOnly = valueOnly;
        }

        @NotNull
        public final ResourceItem getItem() {
            return this.item;
        }

        @Override
        @NotNull
        public Location resolve() {
            XmlParser parser = this.client.getXmlParser();
            Location location = this.valueOnly ? parser.getValueLocation(this.client, this.item) : (this.nameOnly ? parser.getNameLocation(this.client, this.item) : parser.getLocation(this.client, this.item));
            Location location2 = location;
            if (location2 == null) {
                ResourceItem resourceItem = this.item;
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(resourceItem.toString());
            }
            return location2;
        }

        @Override
        @Nullable
        public Object getClientData() {
            return null;
        }

        @Override
        public void setClientData(@Nullable Object $noName_0) {
        }

        @NotNull
        public String toString() {
            return Intrinsics.stringPlus((String)"Handle:", (Object)this.item);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/detector/api/Location$SearchDirection;", "", "(Ljava/lang/String;I)V", "FORWARD", "BACKWARD", "EOL_BACKWARD", "NEAREST", "EOL_NEAREST", "android.sdktools.lint-api"})
    public static final class SearchDirection
    extends Enum<SearchDirection> {
        public static final /* enum */ SearchDirection FORWARD = new SearchDirection();
        public static final /* enum */ SearchDirection BACKWARD = new SearchDirection();
        public static final /* enum */ SearchDirection EOL_BACKWARD = new SearchDirection();
        public static final /* enum */ SearchDirection NEAREST = new SearchDirection();
        public static final /* enum */ SearchDirection EOL_NEAREST = new SearchDirection();
        private static final /* synthetic */ SearchDirection[] $VALUES;

        public static SearchDirection[] values() {
            return (SearchDirection[])$VALUES.clone();
        }

        public static SearchDirection valueOf(String value) {
            return Enum.valueOf(SearchDirection.class, value);
        }

        static {
            $VALUES = searchDirectionArray = new SearchDirection[]{SearchDirection.FORWARD, SearchDirection.BACKWARD, SearchDirection.EOL_BACKWARD, SearchDirection.NEAREST, SearchDirection.EOL_NEAREST};
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/detector/api/Location$SearchHints;", "", "direction", "Lcom/android/tools/lint/detector/api/Location$SearchDirection;", "(Lcom/android/tools/lint/detector/api/Location$SearchDirection;)V", "getDirection", "()Lcom/android/tools/lint/detector/api/Location$SearchDirection;", "<set-?>", "", "isConstructor", "()Z", "isJavaSymbol", "isWholeWord", "matchConstructor", "matchJavaSymbol", "matchWholeWord", "Companion", "android.sdktools.lint-api"})
    public static final class SearchHints {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SearchDirection direction;
        private boolean isWholeWord;
        private boolean isJavaSymbol;
        private boolean isConstructor;

        private SearchHints(SearchDirection direction) {
            this.direction = direction;
        }

        @NotNull
        public final SearchDirection getDirection() {
            return this.direction;
        }

        public final boolean isWholeWord() {
            return this.isWholeWord;
        }

        public final boolean isJavaSymbol() {
            return this.isJavaSymbol;
        }

        public final boolean isConstructor() {
            return this.isConstructor;
        }

        @NotNull
        public final SearchHints matchWholeWord() {
            this.isWholeWord = true;
            return this;
        }

        @NotNull
        public final SearchHints matchJavaSymbol() {
            this.isJavaSymbol = true;
            this.isWholeWord = true;
            return this;
        }

        @NotNull
        public final SearchHints matchConstructor() {
            this.isConstructor = true;
            this.isWholeWord = true;
            this.isJavaSymbol = true;
            return this;
        }

        @JvmStatic
        @NotNull
        public static final SearchHints create(@NotNull SearchDirection direction) {
            return Companion.create(direction);
        }

        public /* synthetic */ SearchHints(SearchDirection direction, DefaultConstructorMarker $constructor_marker) {
            this(direction);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/detector/api/Location$SearchHints$Companion;", "", "()V", "create", "Lcom/android/tools/lint/detector/api/Location$SearchHints;", "direction", "Lcom/android/tools/lint/detector/api/Location$SearchDirection;", "android.sdktools.lint-api"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final SearchHints create(@NotNull SearchDirection direction) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
                return new SearchHints(direction, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0003J \u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0003J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0016H\u0007J>\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J*\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0007J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0018\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\nH\u0002J*\u0010\"\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0003J*\u0010$\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0003J*\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0003J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/lint/detector/api/Location$Companion;", "", "()V", "NONE", "Lcom/android/tools/lint/detector/api/Location;", "SUPER_KEYWORD", "", "adjustLine", "", "doc", "", "line", "offset", "newOffset", "countLines", "start", "end", "create", "file", "Ljava/io/File;", "position", "Lcom/android/ide/common/blame/SourcePosition;", "Lcom/android/tools/lint/detector/api/Position;", "contents", "patternStart", "patternEnd", "hints", "Lcom/android/tools/lint/detector/api/Location$SearchHints;", "startOffset", "endOffset", "findLineBeginFromOffset", "findLineFromOffset", "findLineOffset", "targetLine", "findNextMatch", "pattern", "findPreviousMatch", "isMatch", "", "reverse", "location", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return new Location(file, null, null);
        }

        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @NotNull SourcePosition position) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            if (Intrinsics.areEqual((Object)position, (Object)SourcePosition.UNKNOWN)) {
                return new Location(file, null, null);
            }
            return new Location(file, new DefaultPosition(position.getStartLine(), position.getStartColumn(), position.getStartOffset()), new DefaultPosition(position.getEndLine(), position.getEndColumn(), position.getEndOffset()));
        }

        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @NotNull Position start, @Nullable Position end) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
            return new Location(file, start, end);
        }

        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @Nullable CharSequence contents, int startOffset, int endOffset) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            if (startOffset < 0 || endOffset < startOffset) {
                throw new IllegalArgumentException("Invalid offsets");
            }
            if (contents == null) {
                return new Location(file, new DefaultPosition(-1, -1, startOffset), new DefaultPosition(-1, -1, endOffset));
            }
            int size = contents.length();
            int startOffset2 = startOffset;
            int endOffset2 = endOffset;
            boolean bl2 = false;
            endOffset2 = Math.min(endOffset2, size);
            bl2 = false;
            startOffset2 = Math.min(startOffset2, endOffset2);
            int lineOffset = this.findLineBeginFromOffset(startOffset2, contents);
            int line = this.findLineFromOffset(lineOffset, contents);
            DefaultPosition start = new DefaultPosition(line, startOffset2 - lineOffset, startOffset2);
            int n10 = startOffset2;
            if (n10 <= size) {
                int offset;
                do {
                    if ((offset = n10++) == endOffset2) {
                        DefaultPosition end = new DefaultPosition(line, offset - lineOffset, offset);
                        return new Location(file, start, end);
                    }
                    char c10 = contents.charAt(offset);
                    if (c10 != '\n') continue;
                    lineOffset = offset + 1;
                    int n11 = line;
                    line = n11 + 1;
                } while (offset != size);
            }
            DefaultPosition end = new DefaultPosition(line, size - lineOffset, size);
            return new Location(file, start, end);
        }

        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @NotNull String contents, int line) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
            return this.create(file, contents, line, null, null, null);
        }

        @JvmStatic
        @NotNull
        public final Location create(@NotNull File file, @NotNull CharSequence contents, int line, @Nullable String patternStart, @Nullable String patternEnd, @Nullable SearchHints hints) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
            int targetLine = line;
            String targetPattern = patternStart;
            int offset = this.findLineOffset(targetLine, contents);
            if (offset == -1) {
                return this.create(file);
            }
            if (targetPattern != null) {
                int before;
                int lineEnd;
                SearchDirection direction = SearchDirection.NEAREST;
                if (hints != null) {
                    direction = hints.getDirection();
                }
                int index = 0;
                if (direction == SearchDirection.BACKWARD) {
                    index = this.findPreviousMatch(contents, offset, targetPattern, hints);
                    targetLine = this.adjustLine(contents, targetLine, offset, index);
                } else if (direction == SearchDirection.EOL_BACKWARD) {
                    lineEnd = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)offset);
                    if (lineEnd == -1) {
                        lineEnd = contents.length();
                    }
                    index = this.findPreviousMatch(contents, lineEnd, targetPattern, hints);
                    targetLine = this.adjustLine(contents, targetLine, offset, index);
                } else if (direction == SearchDirection.FORWARD) {
                    index = this.findNextMatch(contents, offset, targetPattern, hints);
                    targetLine = this.adjustLine(contents, targetLine, offset, index);
                } else {
                    lineEnd = direction == SearchDirection.NEAREST || direction == SearchDirection.EOL_NEAREST ? 1 : 0;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (_Assertions.ENABLED && lineEnd == 0) {
                        boolean bl4 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    lineEnd = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)offset);
                    if (lineEnd == -1) {
                        lineEnd = contents.length();
                    }
                    offset = lineEnd;
                    before = this.findPreviousMatch(contents, offset, targetPattern, hints);
                    int after = this.findNextMatch(contents, offset, targetPattern, hints);
                    if (before == -1) {
                        index = after;
                        targetLine = this.adjustLine(contents, targetLine, offset, index);
                    } else if (after == -1) {
                        index = before;
                        targetLine = this.adjustLine(contents, targetLine, offset, index);
                    } else {
                        int newLinesBefore = 0;
                        int n10 = before;
                        if (n10 < offset) {
                            do {
                                int i10;
                                if (contents.charAt(i10 = n10++) != '\n') continue;
                                int n11 = newLinesBefore;
                                newLinesBefore = n11 + 1;
                            } while (n10 < offset);
                        }
                        int newLinesAfter = 0;
                        int n12 = offset;
                        if (n12 < after) {
                            do {
                                int i11;
                                if (contents.charAt(i11 = n12++) != '\n') continue;
                                int n13 = newLinesAfter;
                                newLinesAfter = n13 + 1;
                            } while (n12 < after);
                        }
                        if (newLinesBefore < newLinesAfter || newLinesBefore == newLinesAfter && offset - before < after - offset) {
                            index = before;
                            targetLine = this.adjustLine(contents, targetLine, offset, index);
                        } else {
                            index = after;
                            targetLine = this.adjustLine(contents, targetLine, offset, index);
                        }
                    }
                }
                if (index != -1) {
                    int lineStart = StringsKt.lastIndexOf$default((CharSequence)contents, (char)'\n', (int)index, (boolean)false, (int)4, null);
                    if (lineStart == -1) {
                        lineStart = 0;
                    } else {
                        before = lineStart;
                        lineStart = before + 1;
                    }
                    int column = index - lineStart;
                    if (patternEnd != null) {
                        int end = CharSequences.indexOf((CharSequence)contents, (CharSequence)patternEnd, (int)(offset + targetPattern.length()));
                        if (end != -1) {
                            return new Location(file, new DefaultPosition(targetLine, column, index), new DefaultPosition(targetLine, -1, end + patternEnd.length()));
                        }
                    } else if (hints != null && (hints.isJavaSymbol() || hints.isWholeWord())) {
                        if (hints.isConstructor() && CharSequences.startsWith((CharSequence)contents, (CharSequence)Location.SUPER_KEYWORD, (int)index)) {
                            targetPattern = Location.SUPER_KEYWORD;
                        }
                        return new Location(file, new DefaultPosition(targetLine, column, index), new DefaultPosition(targetLine, column + targetPattern.length(), index + targetPattern.length()));
                    }
                    return new Location(file, new DefaultPosition(targetLine, column, index), new DefaultPosition(targetLine, column, index + targetPattern.length()));
                }
            }
            DefaultPosition position = new DefaultPosition(targetLine, -1, offset);
            return new Location(file, position, position);
        }

        @JvmStatic
        private final int findPreviousMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
            int currentOffset = offset;
            int n10 = 1;
            int n11 = pattern.length();
            boolean bl2 = false;
            int loopDecrement = Math.max(n10, n11);
            int index;
            while ((index = CharSequences.lastIndexOf((CharSequence)contents, (String)pattern, (int)currentOffset)) != -1) {
                if (this.isMatch(contents, index, pattern, hints)) {
                    return index;
                }
                currentOffset = index - loopDecrement;
            }
            return -1;
        }

        @JvmStatic
        private final int findNextMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
            int n10;
            int n11;
            int currentOffset = offset;
            int constructorIndex = -1;
            if (hints != null && hints.isConstructor()) {
                boolean bl2 = hints.isWholeWord();
                n11 = 0;
                n10 = 0;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl3 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int index = CharSequences.indexOf((CharSequence)contents, (CharSequence)Location.SUPER_KEYWORD, (int)currentOffset);
                if (index != -1 && this.isMatch(contents, index, Location.SUPER_KEYWORD, hints)) {
                    constructorIndex = index;
                }
            }
            n11 = 1;
            n10 = pattern.length();
            boolean bl4 = false;
            int loopIncrement = Math.max(n11, n10);
            int index;
            while ((index = CharSequences.indexOf((CharSequence)contents, (CharSequence)pattern, (int)currentOffset)) != -1 && index != contents.length()) {
                if (this.isMatch(contents, index, pattern, hints)) {
                    if (constructorIndex != -1) {
                        n10 = 0;
                        return Math.min(constructorIndex, index);
                    }
                    return index;
                }
                currentOffset = index + loopIncrement;
            }
            return constructorIndex;
        }

        @JvmStatic
        private final boolean isMatch(CharSequence contents, int offset, String pattern, SearchHints hints) {
            if (!CharSequences.startsWith((CharSequence)contents, (CharSequence)pattern, (int)offset)) {
                return false;
            }
            if (hints != null) {
                char nextChar;
                char prevChar = offset > 0 ? (char)contents.charAt(offset - 1) : (char)'\n';
                int lastIndex = offset + pattern.length() - 1;
                char c10 = nextChar = lastIndex < contents.length() - 1 ? (char)contents.charAt(lastIndex + 1) : (char)'\n';
                if (hints.isWholeWord() && (Character.isLetter(prevChar) || Character.isLetter(nextChar))) {
                    return false;
                }
                if (hints.isJavaSymbol()) {
                    if (Character.isJavaIdentifierPart(prevChar) || Character.isJavaIdentifierPart(nextChar)) {
                        return false;
                    }
                    if (prevChar == '\"') {
                        return false;
                    }
                }
                if (hints.isConstructor() && Intrinsics.areEqual((Object)Location.SUPER_KEYWORD, (Object)pattern)) {
                    char c11;
                    int index = lastIndex + 1;
                    while (index < contents.length() - 1 && (c11 = contents.charAt(index)) != '(') {
                        if (!Character.isWhitespace(c11)) {
                            return false;
                        }
                        int n10 = index;
                        index = n10 + 1;
                    }
                }
            }
            return true;
        }

        @JvmStatic
        private final int adjustLine(CharSequence doc, int line, int offset, int newOffset) {
            if (newOffset == -1) {
                return line;
            }
            return newOffset < offset ? line - this.countLines(doc, newOffset, offset) : line + this.countLines(doc, offset, newOffset);
        }

        @JvmStatic
        private final int countLines(CharSequence doc, int start, int end) {
            int lines = 0;
            int n10 = start;
            if (n10 < end) {
                do {
                    int offset;
                    char c10;
                    if ((c10 = doc.charAt(offset = n10++)) != '\n') continue;
                    int n11 = lines;
                    lines = n11 + 1;
                } while (n10 < end);
            }
            return lines;
        }

        @JvmStatic
        @NotNull
        public final Location reverse(@NotNull Location location) {
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            Location currentLocation = location;
            Location next = currentLocation.getSecondary();
            currentLocation.setSecondary(null);
            while (next != null) {
                Location nextNext = next.getSecondary();
                next.setSecondary(currentLocation);
                currentLocation = next;
                next = nextNext;
            }
            return currentLocation;
        }

        private final int findLineBeginFromOffset(int offset, CharSequence contents) {
            int i10 = offset - 1;
            while (i10 >= 0) {
                if (contents.charAt(i10) == '\n') {
                    return i10 + 1;
                }
                int n10 = i10;
                i10 = n10 + -1;
            }
            return 0;
        }

        private final int findLineOffset(int targetLine, CharSequence contents) {
            int currentLine = 0;
            int offset = 0;
            while (currentLine < targetLine) {
                if ((offset = CharSequences.indexOf((CharSequence)contents, (char)'\n', (int)offset)) == -1) {
                    return -1;
                }
                int n10 = currentLine;
                currentLine = n10 + 1;
                n10 = offset;
                offset = n10 + 1;
            }
            return offset;
        }

        private final int findLineFromOffset(int startOffset, CharSequence contents) {
            int size = contents.length();
            boolean bl2 = false;
            int target2 = Math.min(startOffset, size);
            int line = 0;
            int n10 = 0;
            if (n10 <= size) {
                int offset;
                do {
                    if ((offset = n10++) == target2) {
                        return line;
                    }
                    char c10 = contents.charAt(offset);
                    if (c10 != '\n') continue;
                    int n11 = line;
                    line = n11 + 1;
                } while (offset != size);
            }
            return line;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

