/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Queries {
    private static final String DEFAULT_PACKAGE = "<default>";

    public static Map<String, Set<ClassObj>> allClasses(Snapshot snapshot) {
        return Queries.classes(snapshot, null);
    }

    public static Map<String, Set<ClassObj>> classes(Snapshot snapshot, String[] excludedPrefixes) {
        TreeMap<String, Set<ClassObj>> result2 = new TreeMap<String, Set<ClassObj>>();
        TreeSet<ClassObj> classes = new TreeSet<ClassObj>();
        for (Heap heap : snapshot.mHeaps) {
            classes.addAll(heap.getClasses());
        }
        if (excludedPrefixes != null) {
            int N10 = excludedPrefixes.length;
            Iterator iter = classes.iterator();
            block1: while (iter.hasNext()) {
                ClassObj theClass = (ClassObj)iter.next();
                String classPath = theClass.toString();
                for (int i10 = 0; i10 < N10; ++i10) {
                    if (!classPath.startsWith(excludedPrefixes[i10])) continue;
                    iter.remove();
                    continue block1;
                }
            }
        }
        for (ClassObj theClass : classes) {
            Set<ClassObj> classSet;
            String packageName = DEFAULT_PACKAGE;
            int lastDot = theClass.mClassName.lastIndexOf(46);
            if (lastDot != -1) {
                packageName = theClass.mClassName.substring(0, lastDot);
            }
            if ((classSet = result2.get(packageName)) == null) {
                classSet = new TreeSet<ClassObj>();
                result2.put(packageName, classSet);
            }
            classSet.add(theClass);
        }
        return result2;
    }

    public static Collection<ClassObj> commonClasses(Snapshot first, Snapshot second) {
        ArrayList<ClassObj> classes = new ArrayList<ClassObj>();
        for (Heap heap : first.getHeaps()) {
            for (ClassObj clazz : heap.getClasses()) {
                if (second.findClass(clazz.getClassName()) == null) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }

    public static ClassObj findClass(Snapshot snapshot, String name) {
        return snapshot.findClass(name);
    }

    public static Instance[] instancesOf(Snapshot snapshot, String baseClassName) {
        ClassObj theClass = snapshot.findClass(baseClassName);
        if (theClass == null) {
            throw new IllegalArgumentException("Class not found: " + baseClassName);
        }
        List<Instance> instances = theClass.getInstancesList();
        return instances.toArray(new Instance[instances.size()]);
    }

    public static Instance[] allInstancesOf(Snapshot snapshot, String baseClassName) {
        ClassObj theClass = snapshot.findClass(baseClassName);
        if (theClass == null) {
            throw new IllegalArgumentException("Class not found: " + baseClassName);
        }
        ArrayList<ClassObj> classList = new ArrayList<ClassObj>();
        classList.add(theClass);
        classList.addAll(Queries.traverseSubclasses(theClass));
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (ClassObj someClass : classList) {
            instanceList.addAll(someClass.getInstancesList());
        }
        Instance[] result2 = new Instance[instanceList.size()];
        instanceList.toArray(result2);
        return result2;
    }

    private static ArrayList<ClassObj> traverseSubclasses(ClassObj base) {
        ArrayList<ClassObj> result2 = new ArrayList<ClassObj>();
        for (ClassObj subclass : base.mSubclasses) {
            result2.add(subclass);
            result2.addAll(Queries.traverseSubclasses(subclass));
        }
        return result2;
    }

    public static Instance findObject(Snapshot snapshot, String id2) {
        long id22 = Long.parseLong(id2, 16);
        return snapshot.findInstance(id22);
    }

    @Deprecated
    public static Collection<RootObj> getRoots(Snapshot snapshot) {
        return snapshot.getGCRoots();
    }

    public static final Instance[] newInstances(Snapshot older, Snapshot newer) {
        final ArrayList resultList = new ArrayList();
        for (Heap newHeap : newer.mHeaps) {
            final Heap oldHeap = older.getHeap(newHeap.getName());
            if (oldHeap == null) continue;
            newHeap.forEachInstance(new TObjectProcedure<Instance>(){

                public boolean execute(Instance instance) {
                    Instance oldInstance = oldHeap.getInstance(instance.mId);
                    if (oldInstance == null || instance.getClassObj() != oldInstance.getClassObj()) {
                        resultList.add(instance);
                    }
                    return true;
                }
            });
        }
        Instance[] resultArray = new Instance[resultList.size()];
        return resultList.toArray(resultArray);
    }
}

