/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.analyzer.Capture;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.HprofParser;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.RootType;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.ThreadObj;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.analysis.ComputationProgress;
import com.android.tools.perflib.heap.analysis.DominatorsBase;
import com.android.tools.perflib.heap.analysis.LinkEvalDominators;
import com.android.tools.perflib.heap.analysis.ShortestDistanceVisitor;
import com.android.tools.perflib.heap.analysis.TopologicalSort;
import com.android.tools.perflib.heap.ext.NativeRegistryPostProcessor;
import com.android.tools.perflib.heap.ext.SnapshotPostProcessor;
import com.android.tools.proguard.ProguardMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Snapshot
extends Capture {
    public static final String TYPE_NAME = "hprof";
    private static final String JAVA_LANG_CLASS = "java.lang.Class";
    public static final Instance SENTINEL_ROOT = new RootObj(RootType.UNKNOWN);
    private static final int DEFAULT_HEAP_ID = 0;
    private final DataBuffer mBuffer;
    ArrayList<Heap> mHeaps = new ArrayList();
    Heap mCurrentHeap;
    ArrayList<RootObj> mRoots = new ArrayList();
    TIntObjectHashMap<StackTrace> mTraces = new TIntObjectHashMap();
    TLongObjectHashMap<StackFrame> mFrames = new TLongObjectHashMap();
    private List<Instance> mTopSort;
    private DominatorsBase mDominators;
    private volatile DominatorComputationStage mDominatorComputationStage = DominatorComputationStage.INITIALIZING;
    private THashSet<ClassObj> mReferenceClasses = new THashSet();
    private int[] mTypeSizes;
    private long mIdSizeMask = 0xFFFFFFFFL;

    public static Snapshot createSnapshot(DataBuffer buffer) {
        return Snapshot.createSnapshot(buffer, new ProguardMap());
    }

    public static Snapshot createSnapshot(DataBuffer buffer, ProguardMap map) {
        return Snapshot.createSnapshot(buffer, map, Arrays.asList(new NativeRegistryPostProcessor()));
    }

    public static Snapshot createSnapshot(DataBuffer buffer, ProguardMap map, List<SnapshotPostProcessor> postProcessors) {
        try {
            Snapshot snapshot = new Snapshot(buffer);
            HprofParser.parseBuffer(snapshot, buffer, map);
            for (SnapshotPostProcessor processor : postProcessors) {
                processor.postProcess(snapshot);
            }
            return snapshot;
        }
        catch (RuntimeException e10) {
            buffer.dispose();
            throw e10;
        }
    }

    public Snapshot(DataBuffer buffer) {
        this.mBuffer = buffer;
        this.setToDefaultHeap();
    }

    public void dispose() {
        this.mBuffer.dispose();
    }

    DataBuffer getBuffer() {
        return this.mBuffer;
    }

    public Heap setToDefaultHeap() {
        return this.setHeapTo(0, "default");
    }

    public Heap setHeapTo(int id2, String name) {
        Heap heap = this.getHeap(id2);
        if (heap == null) {
            heap = new Heap(id2, name);
            heap.mSnapshot = this;
            this.mHeaps.add(heap);
        }
        this.mCurrentHeap = heap;
        return this.mCurrentHeap;
    }

    public int getHeapIndex(Heap heap) {
        return this.mHeaps.indexOf(heap);
    }

    public Heap getHeap(int id2) {
        for (int i10 = 0; i10 < this.mHeaps.size(); ++i10) {
            if (this.mHeaps.get(i10).getId() != id2) continue;
            return this.mHeaps.get(i10);
        }
        return null;
    }

    public Heap getHeap(String name) {
        for (int i10 = 0; i10 < this.mHeaps.size(); ++i10) {
            if (!name.equals(this.mHeaps.get(i10).getName())) continue;
            return this.mHeaps.get(i10);
        }
        return null;
    }

    public Collection<Heap> getHeaps() {
        return this.mHeaps;
    }

    public Collection<RootObj> getGCRoots() {
        return this.mRoots;
    }

    public final void addStackFrame(StackFrame theFrame) {
        this.mFrames.put(theFrame.mId, (Object)theFrame);
    }

    public final StackFrame getStackFrame(long id2) {
        return (StackFrame)this.mFrames.get(id2);
    }

    public final void addStackTrace(StackTrace theTrace) {
        this.mTraces.put(theTrace.mSerialNumber, (Object)theTrace);
    }

    public final StackTrace getStackTrace(int traceSerialNumber) {
        return (StackTrace)this.mTraces.get(traceSerialNumber);
    }

    public final StackTrace getStackTraceAtDepth(int traceSerialNumber, int depth) {
        StackTrace trace = (StackTrace)this.mTraces.get(traceSerialNumber);
        if (trace != null) {
            trace = trace.fromDepth(depth);
        }
        return trace;
    }

    public final void addRoot(RootObj root) {
        this.mRoots.add(root);
        root.setHeap(this.mCurrentHeap);
    }

    public final void addThread(ThreadObj thread, int serialNumber) {
        this.mCurrentHeap.addThread(thread, serialNumber);
    }

    public final ThreadObj getThread(int serialNumber) {
        return this.mCurrentHeap.getThread(serialNumber);
    }

    public final void setIdSize(int size) {
        int i10;
        int maxId = -1;
        for (i10 = 0; i10 < Type.values().length; ++i10) {
            maxId = Math.max(Type.values()[i10].getTypeId(), maxId);
        }
        assert (maxId > 0 && maxId <= Type.LONG.getTypeId());
        this.mTypeSizes = new int[maxId + 1];
        Arrays.fill(this.mTypeSizes, -1);
        for (i10 = 0; i10 < Type.values().length; ++i10) {
            this.mTypeSizes[Type.values()[i10].getTypeId()] = Type.values()[i10].getSize();
        }
        this.mTypeSizes[Type.OBJECT.getTypeId()] = size;
        this.mIdSizeMask = -1L >>> (8 - size) * 8;
    }

    public final int getTypeSize(Type type) {
        return this.mTypeSizes[type.getTypeId()];
    }

    public final long getIdSizeMask() {
        return this.mIdSizeMask;
    }

    public final void addInstance(long id2, Instance instance) {
        this.mCurrentHeap.addInstance(id2, instance);
        instance.setHeap(this.mCurrentHeap);
    }

    public final void addClass(long id2, ClassObj theClass) {
        this.mCurrentHeap.addClass(id2, theClass);
        theClass.setHeap(this.mCurrentHeap);
    }

    public final Instance findInstance(long id2) {
        for (int i10 = 0; i10 < this.mHeaps.size(); ++i10) {
            Instance instance = this.mHeaps.get(i10).getInstance(id2);
            if (instance == null) continue;
            return instance;
        }
        return this.findClass(id2);
    }

    public final ClassObj findClass(long id2) {
        for (int i10 = 0; i10 < this.mHeaps.size(); ++i10) {
            ClassObj theClass = this.mHeaps.get(i10).getClass(id2);
            if (theClass == null) continue;
            return theClass;
        }
        return null;
    }

    public final ClassObj findClass(String name) {
        for (int i10 = 0; i10 < this.mHeaps.size(); ++i10) {
            ClassObj theClass = this.mHeaps.get(i10).getClass(name);
            if (theClass == null) continue;
            return theClass;
        }
        return null;
    }

    public final Collection<ClassObj> findClasses(String name) {
        ArrayList<ClassObj> classObjs = new ArrayList<ClassObj>();
        for (int i10 = 0; i10 < this.mHeaps.size(); ++i10) {
            classObjs.addAll(this.mHeaps.get(i10).getClasses(name));
        }
        return classObjs;
    }

    public void resolveClasses() {
        ClassObj clazz = this.findClass(JAVA_LANG_CLASS);
        int javaLangClassSize = clazz != null ? clazz.getInstanceSize() : 0;
        for (Heap heap : this.mHeaps) {
            for (ClassObj classObj : heap.getClasses()) {
                ClassObj superClass = classObj.getSuperClassObj();
                if (superClass != null) {
                    superClass.addSubclass(classObj);
                }
                int classSize = javaLangClassSize;
                for (Field f10 : classObj.mStaticFields) {
                    classSize += this.getTypeSize(f10.getType());
                }
                classObj.setSize(classSize);
            }
            final int heapId = heap.getId();
            heap.forEachInstance(new TObjectProcedure<Instance>(){

                public boolean execute(Instance instance) {
                    ClassObj classObj = instance.getClassObj();
                    if (classObj != null) {
                        classObj.addInstance(heapId, instance);
                    }
                    return true;
                }
            });
        }
    }

    public void identifySoftReferences() {
        List<ClassObj> referenceDescendants = this.findAllDescendantClasses(ClassObj.getReferenceClassName());
        for (ClassObj classObj : referenceDescendants) {
            classObj.setIsSoftReference();
            this.mReferenceClasses.add((Object)classObj);
        }
    }

    public void resolveReferences() {
        for (Heap heap : this.getHeaps()) {
            for (ClassObj clazz : heap.getClasses()) {
                clazz.resolveReferences();
            }
            heap.forEachInstance(new TObjectProcedure<Instance>(){

                public boolean execute(Instance instance) {
                    instance.resolveReferences();
                    return true;
                }
            });
        }
    }

    public void compactMemory() {
        for (Heap heap : this.getHeaps()) {
            heap.forEachInstance(new TObjectProcedure<Instance>(){

                public boolean execute(Instance instance) {
                    instance.compactMemory();
                    return true;
                }
            });
        }
    }

    public List<ClassObj> findAllDescendantClasses(String className) {
        Collection<ClassObj> ancestorClasses = this.findClasses(className);
        ArrayList<ClassObj> descendants = new ArrayList<ClassObj>();
        for (ClassObj ancestor : ancestorClasses) {
            descendants.addAll(ancestor.getDescendantClasses());
        }
        return descendants;
    }

    public void computeDominators() {
        this.prepareDominatorComputation();
        this.doComputeDominators(new LinkEvalDominators(this));
    }

    public void prepareDominatorComputation() {
        if (this.mDominators != null) {
            return;
        }
        this.mDominatorComputationStage = DominatorComputationStage.RESOLVING_REFERENCES;
        this.resolveReferences();
        this.compactMemory();
        this.mDominatorComputationStage = DominatorComputationStage.COMPUTING_SHORTEST_DISTANCE;
        ShortestDistanceVisitor shortestDistanceVisitor = new ShortestDistanceVisitor();
        shortestDistanceVisitor.doVisit(this.getGCRoots());
        this.mDominatorComputationStage = DominatorComputationStage.COMPUTING_TOPOLOGICAL_SORT;
        this.mTopSort = TopologicalSort.compute(this.getGCRoots());
        for (Instance instance : this.mTopSort) {
            instance.dedupeReferences();
        }
    }

    public void doComputeDominators(DominatorsBase computable) {
        if (this.mDominators != null) {
            return;
        }
        this.mDominators = computable;
        this.mDominatorComputationStage = DominatorComputationStage.COMPUTING_DOMINATORS;
        this.mDominators.computeDominators();
        this.mDominatorComputationStage = DominatorComputationStage.COMPUTING_RETAINED_SIZES;
        this.mDominators.computeRetainedSizes();
    }

    public ComputationProgress getComputationProgress() {
        if (this.mDominatorComputationStage == DominatorComputationStage.COMPUTING_DOMINATORS) {
            return this.mDominators.getComputationProgress();
        }
        return this.mDominatorComputationStage.getInitialProgress();
    }

    public DominatorComputationStage getDominatorComputationStage() {
        return this.mDominatorComputationStage;
    }

    public List<Instance> getReachableInstances() {
        ArrayList<Instance> result2 = new ArrayList<Instance>(this.mTopSort.size());
        for (Instance node : this.mTopSort) {
            if (node.getImmediateDominator() == null) continue;
            result2.add(node);
        }
        return result2;
    }

    public List<Instance> getTopologicalOrdering() {
        return this.mTopSort;
    }

    public final void dumpInstanceCounts() {
        for (Heap heap : this.mHeaps) {
            System.out.println("+------------------ instance counts for heap: " + heap.getName());
            heap.dumpInstanceCounts();
        }
    }

    public final void dumpSizes() {
        for (Heap heap : this.mHeaps) {
            System.out.println("+------------------ sizes for heap: " + heap.getName());
            heap.dumpSizes();
        }
    }

    public final void dumpSubclasses() {
        for (Heap heap : this.mHeaps) {
            System.out.println("+------------------ subclasses for heap: " + heap.getName());
            heap.dumpSubclasses();
        }
    }

    @Override
    public <T> T getRepresentation(Class<T> asClass) {
        if (asClass.isAssignableFrom(this.getClass())) {
            return asClass.cast(this);
        }
        return null;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    public static enum DominatorComputationStage {
        INITIALIZING(new ComputationProgress("Preparing for dominator calculation...", 0.0), 0.1, 0.0),
        RESOLVING_REFERENCES(new ComputationProgress("Resolving references...", 0.0), 0.1, 0.2),
        COMPUTING_SHORTEST_DISTANCE(new ComputationProgress("Computing depth to nodes...", 0.0), 0.3, 0.03),
        COMPUTING_TOPOLOGICAL_SORT(new ComputationProgress("Performing topological sorting...", 0.0), 0.33, 0.3),
        COMPUTING_DOMINATORS(new ComputationProgress("Calculating dominators...", 0.0), 0.63, 0.35),
        COMPUTING_RETAINED_SIZES(new ComputationProgress("Calculating retained sizes...", 0.0), 0.98, 0.02);

        private final ComputationProgress mInitialProgress;
        private final double mOffset;
        private final double mScale;

        private DominatorComputationStage(ComputationProgress initialProgress, double offset, double scale) {
            this.mInitialProgress = initialProgress;
            this.mOffset = offset;
            this.mScale = scale;
        }

        public ComputationProgress getInitialProgress() {
            return this.mInitialProgress;
        }

        public static double toAbsoluteProgressPercentage(DominatorComputationStage baseStage, ComputationProgress computationProgress) {
            return computationProgress.getProgress() * baseStage.mScale + baseStage.mOffset;
        }
    }
}

