/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace;

import com.android.tools.perflib.vmtrace.Call;
import com.android.tools.perflib.vmtrace.TraceAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class CallStackReconstructor {
    private final long mTopLevelCallId;
    private final List<Call.Builder> mTopLevelCalls = new ArrayList<Call.Builder>();
    private final Stack<Call.Builder> mCallStack = new Stack();
    private Call mTopLevelCall;

    public CallStackReconstructor(long topLevelCallId) {
        this.mTopLevelCallId = topLevelCallId;
    }

    public void addTraceAction(long methodId, TraceAction action, int threadTime, int globalTime) {
        if (action == TraceAction.METHOD_ENTER) {
            this.enterMethod(methodId, threadTime, globalTime);
        } else {
            this.exitMethod(methodId, threadTime, globalTime);
        }
    }

    private void enterMethod(long methodId, int threadTime, int globalTime) {
        Call.Builder cb2 = new Call.Builder(methodId);
        cb2.setMethodEntryTime(threadTime, globalTime);
        if (this.mCallStack.isEmpty()) {
            this.mTopLevelCalls.add(cb2);
        } else {
            Call.Builder caller = this.mCallStack.peek();
            caller.addCallee(cb2);
        }
        this.mCallStack.push(cb2);
    }

    private void exitMethod(long methodId, int threadTime, int globalTime) {
        if (!this.mCallStack.isEmpty()) {
            Call.Builder c10 = this.mCallStack.pop();
            if (c10.getMethodId() != methodId) {
                String msg = String.format("Error during call stack reconstruction. Attempt to exit from method 0x%1$x while in method 0x%2$x", c10.getMethodId(), methodId);
                throw new RuntimeException(msg);
            }
            c10.setMethodExitTime(threadTime, globalTime);
        } else {
            Call.Builder c11 = new Call.Builder(methodId);
            for (Call.Builder cb2 : this.mTopLevelCalls) {
                c11.addCallee(cb2);
            }
            this.mTopLevelCalls.clear();
            this.mTopLevelCalls.add(c11);
            c11.setMethodExitTime(threadTime, globalTime);
            int entryThreadTime = threadTime - 1;
            int entryGlobalTime = globalTime - 1;
            if (c11.getCallees() != null && !c11.getCallees().isEmpty()) {
                Call.Builder callee = c11.getCallees().get(0);
                entryThreadTime = Math.max(callee.getMethodEntryThreadTime() - 1, 0);
                entryGlobalTime = Math.max(callee.getMethodEntryGlobalTime() - 1, 0);
            }
            c11.setMethodEntryTime(entryThreadTime, entryGlobalTime);
        }
    }

    private void exitMethod(long methoId, int entryThreadTime, int entryGlobalTime, List<Call.Builder> callees) {
        int lastExitGlobalTime;
        int lastExitThreadTime;
        if (callees == null || callees.isEmpty()) {
            lastExitThreadTime = entryThreadTime + 1;
            lastExitGlobalTime = entryGlobalTime + 1;
        } else {
            Call.Builder last = callees.get(callees.size() - 1);
            lastExitThreadTime = last.getMethodExitThreadTime() + 1;
            lastExitGlobalTime = last.getMethodExitGlobalTime() + 1;
        }
        this.exitMethod(methoId, lastExitThreadTime, lastExitGlobalTime);
    }

    private void fixupCallStacks() {
        if (this.mTopLevelCall != null) {
            return;
        }
        while (!this.mCallStack.isEmpty()) {
            Call.Builder cb2 = this.mCallStack.peek();
            this.exitMethod(cb2.getMethodId(), cb2.getMethodEntryThreadTime(), cb2.getMethodEntryGlobalTime(), cb2.getCallees());
        }
        this.exitMethod(this.mTopLevelCallId, 0, 0, this.mTopLevelCalls);
        assert (this.mTopLevelCalls.size() == 1);
        this.mTopLevelCall = this.mTopLevelCalls.get(0).build(new Stack<Long>());
    }

    public Call getTopLevel() {
        this.fixupCallStacks();
        return this.mTopLevelCall;
    }
}

