/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace;

import com.android.tools.perflib.vmtrace.Call;
import com.android.tools.perflib.vmtrace.CallStackReconstructor;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.MethodInfo;
import com.android.tools.perflib.vmtrace.MethodProfileData;
import com.android.tools.perflib.vmtrace.SearchResult;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.android.tools.perflib.vmtrace.TimeSelector;
import com.android.tools.perflib.vmtrace.TraceAction;
import com.android.tools.perflib.vmtrace.VmClockType;
import com.android.tools.perflib.vmtrace.VmTraceHandler;
import com.android.utils.SparseArray;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class VmTraceData {
    private final int mVersion;
    private final boolean mDataFileOverflow;
    private final VmClockType mVmClockType;
    private final String mVm;
    private final Map<String, String> mTraceProperties;
    private final long mStartTimeUs;
    private final long mElapsedTimeUs;
    private final Map<Long, MethodInfo> mMethods;
    private final Map<String, ThreadInfo> mThreadInfo;

    private VmTraceData(Builder b10) {
        this.mVersion = b10.mVersion;
        this.mDataFileOverflow = b10.mDataFileOverflow;
        this.mVmClockType = b10.mVmClockType;
        this.mVm = b10.mVm;
        this.mTraceProperties = b10.mProperties;
        this.mMethods = b10.mMethods;
        this.mStartTimeUs = b10.mStartTimeUs;
        this.mElapsedTimeUs = b10.mElapsedTimeUs;
        this.mThreadInfo = Maps.newHashMapWithExpectedSize((int)b10.mThreads.size());
        for (int i10 = 0; i10 < b10.mThreads.size(); ++i10) {
            int id2 = b10.mThreads.keyAt(i10);
            String name = (String)b10.mThreads.valueAt(i10);
            ThreadInfo info = this.mThreadInfo.get(name);
            if (info != null) {
                name = String.format("%1$s-%2$d", name, id2);
            }
            info = new ThreadInfo(id2, name, (Call)b10.mTopLevelCalls.get(id2));
            this.mThreadInfo.put(name, info);
        }
    }

    public int getVersion() {
        return this.mVersion;
    }

    public boolean isDataFileOverflow() {
        return this.mDataFileOverflow;
    }

    public VmClockType getVmClockType() {
        return this.mVmClockType;
    }

    public String getVm() {
        return this.mVm;
    }

    public Map<String, String> getTraceProperties() {
        return this.mTraceProperties;
    }

    public static TimeUnit getDefaultTimeUnits() {
        return TimeUnit.MICROSECONDS;
    }

    public Collection<ThreadInfo> getThreads() {
        return this.mThreadInfo.values();
    }

    public List<ThreadInfo> getThreads(boolean excludeThreadsWithNoActivity) {
        Collection<ThreadInfo> allThreads = this.getThreads();
        if (!excludeThreadsWithNoActivity) {
            return ImmutableList.copyOf(allThreads);
        }
        return Lists.newArrayList((Iterable)Iterables.filter(allThreads, input -> input.getTopLevelCall() != null));
    }

    public ThreadInfo getThread(String name) {
        return this.mThreadInfo.get(name);
    }

    public Map<Long, MethodInfo> getMethods() {
        return this.mMethods;
    }

    public MethodInfo getMethod(long methodId) {
        return this.mMethods.get(methodId);
    }

    public long getStartTimeUs() {
        return this.mStartTimeUs;
    }

    public long getElapsedTimeUs() {
        return this.mElapsedTimeUs;
    }

    public double getDurationPercentage(Call call, ThreadInfo thread, ClockType clockType, boolean inclusiveTime) {
        MethodInfo methodInfo = this.getMethod(call.getMethodId());
        TimeSelector selector = TimeSelector.create(clockType, inclusiveTime);
        long methodTime = selector.get(methodInfo, thread, TimeUnit.NANOSECONDS);
        return this.getDurationPercentage(methodTime, thread, clockType);
    }

    public double getDurationPercentage(long methodTime, ThreadInfo thread, ClockType clockType) {
        Call topCall = this.getThread(thread.getName()).getTopLevelCall();
        if (topCall == null) {
            return 100.0;
        }
        MethodInfo topInfo = this.getMethod(topCall.getMethodId());
        TimeSelector selector = TimeSelector.create(clockType, true);
        long topLevelTime = selector.get(topInfo, thread, TimeUnit.NANOSECONDS);
        return (double)methodTime / (double)topLevelTime * 100.0;
    }

    public SearchResult searchFor(String pattern, ThreadInfo thread) {
        pattern = pattern.toLowerCase(Locale.US);
        HashSet<MethodInfo> methods = new HashSet<MethodInfo>();
        HashSet<Call> calls = new HashSet<Call>();
        Call topLevelCall = this.getThread(thread.getName()).getTopLevelCall();
        if (topLevelCall == null) {
            return new SearchResult(methods, calls);
        }
        for (MethodInfo method : this.getMethods().values()) {
            long inclusiveTime;
            String fullName = method.getFullName().toLowerCase(Locale.US);
            if (!fullName.contains(pattern) || (inclusiveTime = method.getProfileData().getInclusiveTime(thread, ClockType.GLOBAL, TimeUnit.NANOSECONDS)) <= 0L) continue;
            methods.add(method);
        }
        Iterator<Call> iterator = topLevelCall.getCallHierarchyIterator();
        while (iterator.hasNext()) {
            Call c10 = iterator.next();
            MethodInfo method = this.getMethod(c10.getMethodId());
            if (!methods.contains(method)) continue;
            calls.add(c10);
        }
        return new SearchResult(methods, calls);
    }

    private static class ProfileDataBuilder {
        private final Map<Long, MethodProfileData.Builder> mBuilderMap = Maps.newHashMap();

        private ProfileDataBuilder() {
        }

        public void computeCallStats(Call c10, Call parent, ThreadInfo thread) {
            long methodId = c10.getMethodId();
            MethodProfileData.Builder builder = this.getProfileDataBuilder(methodId);
            builder.addCallTime(c10, parent, thread);
            builder.incrementInvocationCount(c10, parent, thread);
            if (c10.isRecursive()) {
                builder.setRecursive();
            }
            for (Call callee : c10.getCallees()) {
                this.computeCallStats(callee, c10, thread);
            }
        }

        private MethodProfileData.Builder getProfileDataBuilder(long methodId) {
            MethodProfileData.Builder builder = this.mBuilderMap.get(methodId);
            if (builder == null) {
                builder = new MethodProfileData.Builder();
                this.mBuilderMap.put(methodId, builder);
            }
            return builder;
        }

        public Set<Long> getMethodsWithProfileData() {
            return this.mBuilderMap.keySet();
        }

        public MethodProfileData getProfileData(Long methodId) {
            return this.mBuilderMap.get(methodId).build();
        }
    }

    public static class Builder
    implements VmTraceHandler {
        private static final String KEY_CLOCK = "clock";
        private static final String KEY_DATA_OVERFLOW = "data-file-overflow";
        private static final String KEY_VM = "vm";
        private static final String KEY_ELAPSED_TIME_US = "elapsed-time-usec";
        private static final boolean DEBUG = false;
        private int mVersion;
        private long mStartTimeUs;
        private long mElapsedTimeUs;
        private boolean mDataFileOverflow;
        private VmClockType mVmClockType = VmClockType.THREAD_CPU;
        private String mVm = "";
        private final Map<String, String> mProperties = new HashMap<String, String>(10);
        private final SparseArray<String> mThreads = new SparseArray(10);
        private final Map<Long, MethodInfo> mMethods = new HashMap<Long, MethodInfo>(100);
        private final SparseArray<CallStackReconstructor> mStackReconstructors = new SparseArray(10);
        private final SparseArray<Call> mTopLevelCalls = new SparseArray(10);

        @Override
        public void setVersion(int version) {
            this.mVersion = version;
        }

        @Override
        public void setProperty(String key, String value) {
            if (key.equals(KEY_CLOCK)) {
                if (value.equals("thread-cpu")) {
                    this.mVmClockType = VmClockType.THREAD_CPU;
                } else if (value.equals("wall")) {
                    this.mVmClockType = VmClockType.WALL;
                } else if (value.equals("dual")) {
                    this.mVmClockType = VmClockType.DUAL;
                }
            } else if (key.equals(KEY_DATA_OVERFLOW)) {
                this.mDataFileOverflow = Boolean.parseBoolean(value);
            } else if (key.equals(KEY_VM)) {
                this.mVm = value;
            } else if (key.equals(KEY_ELAPSED_TIME_US)) {
                this.mElapsedTimeUs = Long.parseLong(value);
            } else {
                this.mProperties.put(key, value);
            }
        }

        @Override
        public void addThread(int id2, String name) {
            this.mThreads.put(id2, (Object)name);
        }

        @Override
        public void addMethod(long id2, MethodInfo info) {
            this.mMethods.put(id2, info);
        }

        @Override
        public void addMethodAction(int threadId, long methodId, TraceAction methodAction, int threadTime, int globalTime) {
            CallStackReconstructor reconstructor;
            if (this.mThreads.get(threadId) == null) {
                this.mThreads.put(threadId, (Object)String.format("Thread id: %1$d", threadId));
            }
            if (this.mMethods.get(methodId) == null) {
                MethodInfo info = new MethodInfo(methodId, "unknown", "unknown", "unknown", "unknown", -1);
                this.mMethods.put(methodId, info);
            }
            if ((reconstructor = (CallStackReconstructor)this.mStackReconstructors.get(threadId)) == null) {
                long topLevelCallId = this.createUniqueMethodIdForThread(threadId);
                reconstructor = new CallStackReconstructor(topLevelCallId);
                this.mStackReconstructors.put(threadId, (Object)reconstructor);
            }
            reconstructor.addTraceAction(methodId, methodAction, threadTime, globalTime);
        }

        private long createUniqueMethodIdForThread(int threadId) {
            long id2 = Long.MAX_VALUE - (long)threadId;
            assert (this.mMethods.get(id2) == null) : "Unexpected error while attempting to create a unique key - key already exists";
            MethodInfo info = new MethodInfo(id2, (String)this.mThreads.get(threadId), "", "", "", 0);
            this.mMethods.put(id2, info);
            return id2;
        }

        public VmTraceData build() {
            for (int i10 = 0; i10 < this.mStackReconstructors.size(); ++i10) {
                int threadId = this.mStackReconstructors.keyAt(i10);
                CallStackReconstructor reconstructor = (CallStackReconstructor)this.mStackReconstructors.valueAt(i10);
                this.mTopLevelCalls.put(threadId, (Object)reconstructor.getTopLevel());
            }
            VmTraceData data = new VmTraceData(this);
            this.computeTimingStatistics(data);
            return data;
        }

        @Override
        public void setStartTimeUs(long startTimeUs) {
            this.mStartTimeUs = startTimeUs;
        }

        private void computeTimingStatistics(VmTraceData data) {
            ProfileDataBuilder builder = new ProfileDataBuilder();
            for (ThreadInfo thread : data.getThreads()) {
                Call c10 = thread.getTopLevelCall();
                if (c10 == null) continue;
                builder.computeCallStats(c10, null, thread);
            }
            for (Long methodId : builder.getMethodsWithProfileData()) {
                MethodInfo method = data.getMethod(methodId);
                method.setProfileData(builder.getProfileData(methodId));
            }
        }
    }
}

