/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.QualifiedRecommendation;
import com.google.archivepatcher.shared.JreDeflateParameters;
import com.google.archivepatcher.shared.TypedRange;
import java.util.Iterator;
import java.util.List;

public class PreDiffPlan {
    private final List<TypedRange<Void>> oldFileUncompressionPlan;
    private final List<TypedRange<JreDeflateParameters>> newFileUncompressionPlan;
    private final List<TypedRange<JreDeflateParameters>> deltaFriendlyNewFileRecompressionPlan;
    private final List<QualifiedRecommendation> qualifiedRecommendations;

    public PreDiffPlan(List<QualifiedRecommendation> qualifiedRecommendations, List<TypedRange<Void>> oldFileUncompressionPlan, List<TypedRange<JreDeflateParameters>> newFileUncompressionPlan) {
        this(qualifiedRecommendations, oldFileUncompressionPlan, newFileUncompressionPlan, null);
    }

    public PreDiffPlan(List<QualifiedRecommendation> qualifiedRecommendations, List<TypedRange<Void>> oldFileUncompressionPlan, List<TypedRange<JreDeflateParameters>> newFileUncompressionPlan, List<TypedRange<JreDeflateParameters>> deltaFriendlyNewFileRecompressionPlan) {
        this.ensureOrdered(oldFileUncompressionPlan);
        this.ensureOrdered(newFileUncompressionPlan);
        this.ensureOrdered(deltaFriendlyNewFileRecompressionPlan);
        this.qualifiedRecommendations = qualifiedRecommendations;
        this.oldFileUncompressionPlan = oldFileUncompressionPlan;
        this.newFileUncompressionPlan = newFileUncompressionPlan;
        this.deltaFriendlyNewFileRecompressionPlan = deltaFriendlyNewFileRecompressionPlan;
    }

    private <T> void ensureOrdered(List<TypedRange<T>> list2) {
        if (list2 != null && list2.size() >= 2) {
            Iterator<TypedRange<T>> iterator = list2.iterator();
            TypedRange<T> lastEntry = iterator.next();
            while (iterator.hasNext()) {
                TypedRange<T> nextEntry = iterator.next();
                if (lastEntry.compareTo(nextEntry) <= 0) continue;
                throw new IllegalArgumentException("List must be ordered");
            }
        }
    }

    public final List<TypedRange<Void>> getOldFileUncompressionPlan() {
        return this.oldFileUncompressionPlan;
    }

    public final List<TypedRange<JreDeflateParameters>> getNewFileUncompressionPlan() {
        return this.newFileUncompressionPlan;
    }

    public final List<TypedRange<JreDeflateParameters>> getDeltaFriendlyNewFileRecompressionPlan() {
        return this.deltaFriendlyNewFileRecompressionPlan;
    }

    public final List<QualifiedRecommendation> getQualifiedRecommendations() {
        return this.qualifiedRecommendations;
    }
}

