/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import com.google.archivepatcher.generator.bsdiff.RandomAccessObject;
import com.google.archivepatcher.generator.bsdiff.RandomAccessObjectFactory;
import com.google.archivepatcher.generator.bsdiff.SuffixSorter;
import java.io.IOException;

public final class DivSuffixSorter
implements SuffixSorter {
    private static final int ALPHABET_SIZE = 256;
    private static final int BUCKET_A_SIZE = 256;
    private static final int BUCKET_B_SIZE = 65536;
    private static final int SS_INSERTIONSORT_THRESHOLD = 8;
    private static final int SS_BLOCKSIZE = 1024;
    private static final int SS_MISORT_STACKSIZE = 16;
    private static final int SS_SMERGE_STACKSIZE = 32;
    private static final int TR_STACKSIZE = 64;
    private static final int TR_INSERTIONSORT_THRESHOLD = 8;
    private static final int[] SQQ_TABLE = new int[]{0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61, 64, 65, 67, 69, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97, 98, 99, 101, 102, 103, 104, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 163, 164, 165, 166, 167, 167, 168, 169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181, 181, 182, 183, 183, 184, 185, 185, 186, 187, 187, 188, 189, 189, 190, 191, 192, 192, 193, 193, 194, 195, 195, 196, 197, 197, 198, 199, 199, 200, 201, 201, 202, 203, 203, 204, 204, 205, 206, 206, 207, 208, 208, 209, 209, 210, 211, 211, 212, 212, 213, 214, 214, 215, 215, 216, 217, 217, 218, 218, 219, 219, 220, 221, 221, 222, 222, 223, 224, 224, 225, 225, 226, 226, 227, 227, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 255};
    private static final int[] LG_TABLE = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private final RandomAccessObjectFactory randomAccessObjectFactory;
    private RandomAccessObject suffixArray;
    private RandomAccessObject input;

    public DivSuffixSorter(RandomAccessObjectFactory randomAccessObjectFactory) {
        this.randomAccessObjectFactory = randomAccessObjectFactory;
    }

    @Override
    public RandomAccessObject suffixSort(RandomAccessObject input) throws IOException, InterruptedException {
        if (4L * (input.length() + 1L) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Input too large (" + input.length() + " bytes)");
        }
        int length = (int)input.length();
        RandomAccessObject suffixArray = this.randomAccessObjectFactory.create((length + 1) * 4);
        suffixArray.seek(0L);
        suffixArray.writeInt(length);
        this.suffixArray = suffixArray;
        if (length == 0) {
            return suffixArray;
        }
        if (length == 1) {
            this.writeSuffixArray(0L, 0);
            return suffixArray;
        }
        this.input = input;
        int[] bucketA = new int[256];
        int[] bucketB = new int[65536];
        int m10 = this.sortTypeBstar(bucketA, bucketB, length);
        this.constructSuffixArray(bucketA, bucketB, length, m10);
        return suffixArray;
    }

    private final void constructSuffixArray(int[] bucketA, int[] bucketB, int n10, int m10) throws IOException {
        int c02;
        int s10;
        int j10;
        int c22;
        int k10;
        int i10;
        if (0 < m10) {
            for (int c12 = 254; 0 <= c12; --c12) {
                i10 = bucketB[c12 * 256 + (c12 + 1)];
                k10 = 0;
                c22 = -1;
                for (j10 = bucketA[c12 + 1] - 1; i10 <= j10; --j10) {
                    s10 = this.readSuffixArray(j10);
                    if (0 < s10) {
                        this.writeSuffixArray(j10, ~s10);
                        c02 = this.readInput(--s10);
                        if (0 < s10 && this.readInput(s10 - 1) > c02) {
                            s10 ^= 0xFFFFFFFF;
                        }
                        if (c02 != c22) {
                            if (0 <= c22) {
                                bucketB[c12 * 256 + c22] = k10;
                            }
                            c22 = c02;
                            k10 = bucketB[c12 * 256 + c22];
                        }
                        this.writeSuffixArray(k10--, s10);
                        continue;
                    }
                    this.writeSuffixArray(j10, ~s10);
                }
            }
        }
        c22 = this.readInput(n10 - 1);
        k10 = bucketA[c22];
        this.writeSuffixArray(k10++, this.readInput(n10 - 2) < c22 ? ~(n10 - 1) : n10 - 1);
        j10 = n10;
        for (i10 = 0; i10 < j10; ++i10) {
            s10 = this.readSuffixArray(i10);
            if (0 < s10) {
                c02 = this.readInput(--s10);
                if (s10 == 0 || this.readInput(s10 - 1) < c02) {
                    s10 ^= 0xFFFFFFFF;
                }
                if (c02 != c22) {
                    bucketA[c22] = k10;
                    c22 = c02;
                    k10 = bucketA[c22];
                }
                this.writeSuffixArray(k10++, s10);
                continue;
            }
            this.writeSuffixArray(i10, ~s10);
        }
    }

    private final int sortTypeBstar(int[] bucketA, int[] bucketB, int n10) throws IOException, InterruptedException {
        int t10;
        int c12 = 0;
        int i10 = n10 - 1;
        int m10 = n10;
        int c02 = this.readInput(n10 - 1);
        while (0 <= i10) {
            do {
                c12 = c02;
                bucketA[c12] = bucketA[c12] + 1;
            } while (0 <= --i10 && (c02 = this.readInput(i10)) >= c12);
            if (0 > i10) continue;
            int n11 = c02 * 256 + c12;
            bucketB[n11] = bucketB[n11] + 1;
            this.writeSuffixArray(--m10, i10);
            --i10;
            c12 = c02;
            while (0 <= i10 && (c02 = this.readInput(i10)) <= c12) {
                int n12 = c12 * 256 + c02;
                bucketB[n12] = bucketB[n12] + 1;
                --i10;
                c12 = c02;
            }
        }
        m10 = n10 - m10;
        i10 = 0;
        int j10 = 0;
        for (c02 = 0; c02 < 256; ++c02) {
            t10 = i10 + bucketA[c02];
            bucketA[c02] = i10 + j10;
            i10 = t10 + bucketB[c02 * 256 + c02];
            for (c12 = c02 + 1; c12 < 256; ++c12) {
                bucketB[c02 * 256 + c12] = j10 += bucketB[c02 * 256 + c12];
                i10 += bucketB[c12 * 256 + c02];
            }
        }
        if (0 < m10) {
            int PAb = n10 - m10;
            int ISAb = m10;
            for (i10 = m10 - 2; 0 <= i10; --i10) {
                t10 = this.readSuffixArray(PAb + i10);
                c02 = this.readInput(t10);
                c12 = this.readInput(t10 + 1);
                int n13 = c02 * 256 + c12;
                int n14 = bucketB[n13] - 1;
                bucketB[n13] = n14;
                this.writeSuffixArray(n14, i10);
            }
            t10 = this.readSuffixArray(PAb + m10 - 1);
            c02 = this.readInput(t10);
            c12 = this.readInput(t10 + 1);
            int n15 = c02 * 256 + c12;
            int n16 = bucketB[n15] - 1;
            bucketB[n15] = n16;
            this.writeSuffixArray(n16, m10 - 1);
            int buf = m10;
            int bufsize = n10 - 2 * m10;
            c02 = 254;
            j10 = m10;
            while (0 < j10) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                for (c12 = 255; c02 < c12; --c12) {
                    i10 = bucketB[c02 * 256 + c12];
                    if (1 < j10 - i10) {
                        this.ssSort(PAb, i10, j10, buf, bufsize, 2, n10, this.readSuffixArray(i10) == m10 - 1);
                    }
                    j10 = i10;
                }
                --c02;
            }
            for (i10 = m10 - 1; 0 <= i10; --i10) {
                if (0 <= this.readSuffixArray(i10)) {
                    j10 = i10;
                    do {
                        this.writeSuffixArray(ISAb + this.readSuffixArray(i10), i10);
                    } while (0 <= --i10 && 0 <= this.readSuffixArray(i10));
                    this.writeSuffixArray(i10 + 1, i10 - j10);
                    if (i10 <= 0) break;
                }
                j10 = i10;
                do {
                    this.writeSuffixArray(ISAb + this.writeSuffixArray(i10, ~this.readSuffixArray(i10)), j10);
                } while (this.readSuffixArray(--i10) < 0);
                this.writeSuffixArray(ISAb + this.readSuffixArray(i10), j10);
            }
            this.trSort(ISAb, m10, 1);
            i10 = n10 - 1;
            j10 = m10;
            c02 = this.readInput(n10 - 1);
            while (0 <= i10) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                --i10;
                c12 = c02;
                while (0 <= i10 && (c02 = this.readInput(i10)) >= c12) {
                    --i10;
                    c12 = c02;
                }
                if (0 > i10) continue;
                t10 = i10--;
                c12 = c02;
                while (0 <= i10 && (c02 = this.readInput(i10)) <= c12) {
                    --i10;
                    c12 = c02;
                }
                this.writeSuffixArray(this.readSuffixArray(ISAb + --j10), t10 == 0 || 1 < t10 - i10 ? t10 : ~t10);
            }
            bucketB[65535] = n10;
            int k10 = m10 - 1;
            for (c02 = 254; 0 <= c02; --c02) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                i10 = bucketA[c02 + 1] - 1;
                for (c12 = 255; c02 < c12; --c12) {
                    t10 = i10 - bucketB[c12 * 256 + c02];
                    bucketB[c12 * 256 + c02] = i10;
                    i10 = t10;
                    j10 = bucketB[c02 * 256 + c12];
                    while (j10 <= k10) {
                        this.writeSuffixArray(i10, this.readSuffixArray(k10));
                        --i10;
                        --k10;
                    }
                }
                bucketB[c02 * 256 + (c02 + 1)] = i10 - bucketB[c02 * 256 + c02] + 1;
                bucketB[c02 * 256 + c02] = i10;
            }
        }
        return m10;
    }

    private final void ssSort(int PA2, int first, int last, int buf, int bufsize, int depth, int n10, boolean lastsuffix) throws IOException {
        int k10;
        int middle;
        int limit;
        if (lastsuffix) {
            ++first;
        }
        if (bufsize < 1024 && bufsize < last - first && bufsize < (limit = DivSuffixSorter.ssIsqrt(last - first))) {
            if (1024 < limit) {
                limit = 1024;
            }
            buf = middle = last - limit;
            bufsize = limit;
        } else {
            middle = last;
            limit = 0;
        }
        int a10 = first;
        int i10 = 0;
        while (1024 < middle - a10) {
            this.ssMintroSort(PA2, a10, a10 + 1024, depth);
            int curbufsize = last - (a10 + 1024);
            int curbuf = a10 + 1024;
            if (curbufsize <= bufsize) {
                curbufsize = bufsize;
                curbuf = buf;
            }
            int b10 = a10;
            k10 = 1024;
            int j10 = i10;
            while ((j10 & 1) != 0) {
                this.ssSwapMerge(PA2, b10 - k10, b10, b10 + k10, curbuf, curbufsize, depth);
                b10 -= k10;
                k10 <<= 1;
                j10 >>= 1;
            }
            a10 += 1024;
            ++i10;
        }
        this.ssMintroSort(PA2, a10, middle, depth);
        k10 = 1024;
        while (i10 != 0) {
            if (i10 & true) {
                this.ssSwapMerge(PA2, a10 - k10, a10, middle, buf, bufsize, depth);
                a10 -= k10;
            }
            k10 <<= 1;
            i10 >>= 1;
        }
        if (limit != 0) {
            this.ssMintroSort(PA2, middle, last, depth);
            this.ssInplaceMerge(PA2, first, middle, last, depth);
        }
        if (lastsuffix) {
            int p12 = this.readSuffixArray(PA2 + this.readSuffixArray(first - 1));
            int p11 = n10 - 2;
            i10 = this.readSuffixArray(first - 1);
            for (a10 = first; a10 < last && (this.readSuffixArray(a10) < 0 || 0 < this.ssCompare(p12, p11, PA2 + this.readSuffixArray(a10), depth)); ++a10) {
                this.writeSuffixArray(a10 - 1, this.readSuffixArray(a10));
            }
            this.writeSuffixArray(a10 - 1, i10);
        }
    }

    private final int ssCompare(int pa2, int pb2, int p22, int depth) throws IOException {
        int U22;
        int U12 = depth + pa2;
        int U1n = pb2 + 2;
        int U2n = this.readSuffixArray(p22 + 1) + 2;
        for (U22 = depth + this.readSuffixArray(p22); U12 < U1n && U22 < U2n && this.readInput(U12) == this.readInput(U22); ++U12, ++U22) {
        }
        return U12 < U1n ? (U22 < U2n ? this.readInput(U12) - this.readInput(U22) : 1) : (U22 < U2n ? -1 : 0);
    }

    private final int ssCompare(int p12, int p22, int depth) throws IOException {
        int U22;
        int U12 = depth + this.readSuffixArray(p12);
        int U1n = this.readSuffixArray(p12 + 1) + 2;
        int U2n = this.readSuffixArray(p22 + 1) + 2;
        for (U22 = depth + this.readSuffixArray(p22); U12 < U1n && U22 < U2n && this.readInput(U12) == this.readInput(U22); ++U12, ++U22) {
        }
        return U12 < U1n ? (U22 < U2n ? this.readInput(U12) - this.readInput(U22) : 1) : (U22 < U2n ? -1 : 0);
    }

    private final void ssInplaceMerge(int PA2, int first, int middle, int last, int depth) throws IOException {
        do {
            int p10;
            boolean x10;
            if (this.readSuffixArray(last - 1) < 0) {
                x10 = true;
                p10 = PA2 + ~this.readSuffixArray(last - 1);
            } else {
                x10 = false;
                p10 = PA2 + this.readSuffixArray(last - 1);
            }
            int a10 = first;
            int len = middle - first;
            int half = len >> 1;
            int r10 = -1;
            while (0 < len) {
                int b10 = a10 + half;
                int q10 = this.ssCompare(PA2 + (0 <= this.readSuffixArray(b10) ? this.readSuffixArray(b10) : ~this.readSuffixArray(b10)), p10, depth);
                if (q10 < 0) {
                    a10 = b10 + 1;
                    half -= len & 1 ^ 1;
                } else {
                    r10 = q10;
                }
                len = half;
                half >>= 1;
            }
            if (a10 < middle) {
                if (r10 == 0) {
                    this.writeSuffixArray(a10, ~this.readSuffixArray(a10));
                }
                this.ssRotate(a10, middle, last);
                last -= middle - a10;
                middle = a10;
                if (first == middle) break;
            }
            --last;
            if (!x10) continue;
            while (this.readSuffixArray(--last) < 0) {
            }
        } while (middle != last);
    }

    private final void ssRotate(int first, int middle, int last) throws IOException {
        int l10 = middle - first;
        int r10 = last - middle;
        block0: while (0 < l10 && 0 < r10) {
            int t10;
            int b10;
            int a10;
            if (l10 == r10) {
                this.ssBlockSwap(first, middle, l10);
                break;
            }
            if (l10 < r10) {
                a10 = last - 1;
                b10 = middle - 1;
                t10 = this.readSuffixArray(a10);
                while (true) {
                    this.writeSuffixArray(a10--, this.readSuffixArray(b10));
                    this.writeSuffixArray(b10--, this.readSuffixArray(a10));
                    if (b10 >= first) continue;
                    this.writeSuffixArray(a10, t10);
                    last = a10--;
                    if ((r10 -= l10 + 1) <= l10) continue block0;
                    b10 = middle - 1;
                    t10 = this.readSuffixArray(a10);
                }
            }
            a10 = first;
            b10 = middle;
            t10 = this.readSuffixArray(a10);
            while (true) {
                this.writeSuffixArray(a10++, this.readSuffixArray(b10));
                this.writeSuffixArray(b10++, this.readSuffixArray(a10));
                if (last > b10) continue;
                this.writeSuffixArray(a10, t10);
                first = a10 + 1;
                if ((l10 -= r10 + 1) <= r10) continue block0;
                b10 = middle;
                t10 = this.readSuffixArray(++a10);
            }
        }
    }

    private final void ssBlockSwap(int a10, int b10, int n10) throws IOException {
        while (0 < n10) {
            int t10 = this.readSuffixArray(a10);
            this.writeSuffixArray(a10, this.readSuffixArray(b10));
            this.writeSuffixArray(b10, t10);
            --n10;
            ++a10;
            ++b10;
        }
    }

    private static final int getIDX(int a10) {
        return 0 <= a10 ? a10 : ~a10;
    }

    private static final int min(int a10, int b10) {
        return a10 < b10 ? a10 : b10;
    }

    private final void ssSwapMerge(int PA2, int first, int middle, int last, int buf, int bufsize, int depth) throws IOException {
        int STACK_SIZE = 32;
        StackElement[] stack = new StackElement[32];
        int check = 0;
        int ssize = 0;
        while (true) {
            StackElement se2;
            if (last - middle <= bufsize) {
                if (first < middle && middle < last) {
                    this.ssMergeBackward(PA2, first, middle, last, buf, depth);
                }
                if (check & true || (check & 2) != 0 && this.ssCompare(PA2 + DivSuffixSorter.getIDX(this.readSuffixArray(first - 1)), PA2 + this.readSuffixArray(first), depth) == 0) {
                    this.writeSuffixArray(first, ~this.readSuffixArray(first));
                }
                if ((check & 4) != 0 && this.ssCompare(PA2 + DivSuffixSorter.getIDX(this.readSuffixArray(last - 1)), PA2 + this.readSuffixArray(last), depth) == 0) {
                    this.writeSuffixArray(last, ~this.readSuffixArray(last));
                }
                if (ssize > 0) {
                    se2 = stack[--ssize];
                    first = se2.a;
                    middle = se2.b;
                    last = se2.c;
                    check = se2.d;
                    continue;
                }
                return;
            }
            if (middle - first <= bufsize) {
                if (first < middle) {
                    this.ssMergeForward(PA2, first, middle, last, buf, depth);
                }
                if ((check & 1) != 0 || (check & 2) != 0 && this.ssCompare(PA2 + DivSuffixSorter.getIDX(this.readSuffixArray(first - 1)), PA2 + this.readSuffixArray(first), depth) == 0) {
                    this.writeSuffixArray(first, ~this.readSuffixArray(first));
                }
                if ((check & 4) != 0 && this.ssCompare(PA2 + DivSuffixSorter.getIDX(this.readSuffixArray(last - 1)), PA2 + this.readSuffixArray(last), depth) == 0) {
                    this.writeSuffixArray(last, ~this.readSuffixArray(last));
                }
                if (ssize > 0) {
                    se2 = stack[--ssize];
                    first = se2.a;
                    middle = se2.b;
                    last = se2.c;
                    check = se2.d;
                    continue;
                }
                return;
            }
            int m10 = 0;
            int len = DivSuffixSorter.min(middle - first, last - middle);
            int half = len >> 1;
            while (0 < len) {
                if (this.ssCompare(PA2 + DivSuffixSorter.getIDX(this.readSuffixArray(middle + m10 + half)), PA2 + DivSuffixSorter.getIDX(this.readSuffixArray(middle - m10 - half - 1)), depth) < 0) {
                    m10 += half + 1;
                    half -= len & 1 ^ 1;
                }
                len = half;
                half >>= 1;
            }
            if (0 < m10) {
                int r10;
                int lm2 = middle - m10;
                int rm2 = middle + m10;
                this.ssBlockSwap(lm2, middle, m10);
                int l10 = r10 = middle;
                int next = 0;
                if (rm2 < last) {
                    if (this.readSuffixArray(rm2) < 0) {
                        this.writeSuffixArray(rm2, ~this.readSuffixArray(rm2));
                        if (first < lm2) {
                            while (this.readSuffixArray(--l10) < 0) {
                            }
                            next |= 4;
                        }
                        next |= 1;
                    } else if (first < lm2) {
                        while (this.readSuffixArray(r10) < 0) {
                            ++r10;
                        }
                        next |= 2;
                    }
                }
                if (l10 - first <= last - r10) {
                    stack[ssize++] = new StackElement(r10, rm2, last, next & 3 | check & 4);
                    middle = lm2;
                    last = l10;
                    check = check & 3 | next & 4;
                    continue;
                }
                if ((next & 2) != 0 && r10 == middle) {
                    next ^= 6;
                }
                stack[ssize++] = new StackElement(first, lm2, l10, check & 3 | next & 4);
                first = r10;
                middle = rm2;
                check = next & 3 | check & 4;
                continue;
            }
            if (this.ssCompare(PA2 + DivSuffixSorter.getIDX(this.readSuffixArray(middle - 1)), PA2 + this.readSuffixArray(middle), depth) == 0) {
                this.writeSuffixArray(middle, ~this.readSuffixArray(middle));
            }
            if ((check & 1) != 0 || (check & 2) != 0 && this.ssCompare(PA2 + DivSuffixSorter.getIDX(this.readSuffixArray(first - 1)), PA2 + this.readSuffixArray(first), depth) == 0) {
                this.writeSuffixArray(first, ~this.readSuffixArray(first));
            }
            if ((check & 4) != 0 && this.ssCompare(PA2 + DivSuffixSorter.getIDX(this.readSuffixArray(last - 1)), PA2 + this.readSuffixArray(last), depth) == 0) {
                this.writeSuffixArray(last, ~this.readSuffixArray(last));
            }
            if (ssize <= 0) break;
            se2 = stack[--ssize];
            first = se2.a;
            middle = se2.b;
            last = se2.c;
            check = se2.d;
        }
    }

    private final void ssMergeForward(int PA2, int first, int middle, int last, int buf, int depth) throws IOException {
        int bufend = buf + (middle - first) - 1;
        this.ssBlockSwap(buf, first, middle - first);
        int a10 = first;
        int t10 = this.readSuffixArray(a10);
        int b10 = buf;
        int c10 = middle;
        while (true) {
            int r10;
            if ((r10 = this.ssCompare(PA2 + this.readSuffixArray(b10), PA2 + this.readSuffixArray(c10), depth)) < 0) {
                do {
                    this.writeSuffixArray(a10++, this.readSuffixArray(b10));
                    if (bufend <= b10) {
                        this.writeSuffixArray(bufend, t10);
                        return;
                    }
                    this.writeSuffixArray(b10++, this.readSuffixArray(a10));
                } while (this.readSuffixArray(b10) < 0);
                continue;
            }
            if (r10 > 0) {
                do {
                    this.writeSuffixArray(a10++, this.readSuffixArray(c10));
                    this.writeSuffixArray(c10++, this.readSuffixArray(a10));
                    if (last > c10) continue;
                    while (b10 < bufend) {
                        this.writeSuffixArray(a10++, this.readSuffixArray(b10));
                        this.writeSuffixArray(b10++, this.readSuffixArray(a10));
                    }
                    this.writeSuffixArray(a10, this.readSuffixArray(b10));
                    this.writeSuffixArray(b10, t10);
                    return;
                } while (this.readSuffixArray(c10) < 0);
                continue;
            }
            this.writeSuffixArray(c10, ~this.readSuffixArray(c10));
            do {
                this.writeSuffixArray(a10++, this.readSuffixArray(b10));
                if (bufend <= b10) {
                    this.writeSuffixArray(bufend, t10);
                    return;
                }
                this.writeSuffixArray(b10++, this.readSuffixArray(a10));
            } while (this.readSuffixArray(b10) < 0);
            do {
                this.writeSuffixArray(a10++, this.readSuffixArray(c10));
                this.writeSuffixArray(c10++, this.readSuffixArray(a10));
                if (last > c10) continue;
                while (b10 < bufend) {
                    this.writeSuffixArray(a10++, this.readSuffixArray(b10));
                    this.writeSuffixArray(b10++, this.readSuffixArray(a10));
                }
                this.writeSuffixArray(a10, this.readSuffixArray(b10));
                this.writeSuffixArray(b10, t10);
                return;
            } while (this.readSuffixArray(c10) < 0);
        }
    }

    private final void ssMergeBackward(int PA2, int first, int middle, int last, int buf, int depth) throws IOException {
        int p22;
        int p12;
        int bufend = buf + (last - middle) - 1;
        this.ssBlockSwap(buf, middle, last - middle);
        int x10 = 0;
        if (this.readSuffixArray(bufend) < 0) {
            p12 = PA2 + ~this.readSuffixArray(bufend);
            x10 |= 1;
        } else {
            p12 = PA2 + this.readSuffixArray(bufend);
        }
        if (this.readSuffixArray(middle - 1) < 0) {
            p22 = PA2 + ~this.readSuffixArray(middle - 1);
            x10 |= 2;
        } else {
            p22 = PA2 + this.readSuffixArray(middle - 1);
        }
        int a10 = last - 1;
        int t10 = this.readSuffixArray(a10);
        int b10 = bufend;
        int c10 = middle - 1;
        while (true) {
            int r10;
            if (0 < (r10 = this.ssCompare(p12, p22, depth))) {
                if ((x10 & 1) != 0) {
                    do {
                        this.writeSuffixArray(a10--, this.readSuffixArray(b10));
                        this.writeSuffixArray(b10--, this.readSuffixArray(a10));
                    } while (this.readSuffixArray(b10) < 0);
                    x10 ^= 1;
                }
                this.writeSuffixArray(a10--, this.readSuffixArray(b10));
                if (b10 <= buf) {
                    this.writeSuffixArray(buf, t10);
                    break;
                }
                this.writeSuffixArray(b10--, this.readSuffixArray(a10));
                if (this.readSuffixArray(b10) < 0) {
                    p12 = PA2 + ~this.readSuffixArray(b10);
                    x10 |= 1;
                    continue;
                }
                p12 = PA2 + this.readSuffixArray(b10);
                continue;
            }
            if (r10 < 0) {
                if ((x10 & 2) != 0) {
                    do {
                        this.writeSuffixArray(a10--, this.readSuffixArray(c10));
                        this.writeSuffixArray(c10--, this.readSuffixArray(a10));
                    } while (this.readSuffixArray(c10) < 0);
                    x10 ^= 2;
                }
                this.writeSuffixArray(a10--, this.readSuffixArray(c10));
                this.writeSuffixArray(c10--, this.readSuffixArray(a10));
                if (c10 < first) {
                    while (buf < b10) {
                        this.writeSuffixArray(a10--, this.readSuffixArray(b10));
                        this.writeSuffixArray(b10--, this.readSuffixArray(a10));
                    }
                    this.writeSuffixArray(a10, this.readSuffixArray(b10));
                    this.writeSuffixArray(b10, t10);
                    break;
                }
                if (this.readSuffixArray(c10) < 0) {
                    p22 = PA2 + ~this.readSuffixArray(c10);
                    x10 |= 2;
                    continue;
                }
                p22 = PA2 + this.readSuffixArray(c10);
                continue;
            }
            if ((x10 & 1) != 0) {
                do {
                    this.writeSuffixArray(a10--, this.readSuffixArray(b10));
                    this.writeSuffixArray(b10--, this.readSuffixArray(a10));
                } while (this.readSuffixArray(b10) < 0);
                x10 ^= 1;
            }
            this.writeSuffixArray(a10--, ~this.readSuffixArray(b10));
            if (b10 <= buf) {
                this.writeSuffixArray(buf, t10);
                break;
            }
            this.writeSuffixArray(b10--, this.readSuffixArray(a10));
            if ((x10 & 2) != 0) {
                do {
                    this.writeSuffixArray(a10--, this.readSuffixArray(c10));
                    this.writeSuffixArray(c10--, this.readSuffixArray(a10));
                } while (this.readSuffixArray(c10) < 0);
                x10 ^= 2;
            }
            this.writeSuffixArray(a10--, this.readSuffixArray(c10));
            this.writeSuffixArray(c10--, this.readSuffixArray(a10));
            if (c10 < first) {
                while (buf < b10) {
                    this.writeSuffixArray(a10--, this.readSuffixArray(b10));
                    this.writeSuffixArray(b10--, this.readSuffixArray(a10));
                }
                this.writeSuffixArray(a10, this.readSuffixArray(b10));
                this.writeSuffixArray(b10, t10);
                break;
            }
            if (this.readSuffixArray(b10) < 0) {
                p12 = PA2 + ~this.readSuffixArray(b10);
                x10 |= 1;
            } else {
                p12 = PA2 + this.readSuffixArray(b10);
            }
            if (this.readSuffixArray(c10) < 0) {
                p22 = PA2 + ~this.readSuffixArray(c10);
                x10 |= 2;
                continue;
            }
            p22 = PA2 + this.readSuffixArray(c10);
        }
    }

    private final void ssInsertionSort(int PA2, int first, int last, int depth) throws IOException {
        for (int i10 = last - 2; first <= i10; --i10) {
            int r10;
            int t10 = this.readSuffixArray(i10);
            int j10 = i10 + 1;
            while (0 < (r10 = this.ssCompare(PA2 + t10, PA2 + this.readSuffixArray(j10), depth))) {
                do {
                    this.writeSuffixArray(j10 - 1, this.readSuffixArray(j10));
                } while (++j10 < last && this.readSuffixArray(j10) < 0);
                if (last > j10) continue;
            }
            if (r10 == 0) {
                this.writeSuffixArray(j10, ~this.readSuffixArray(j10));
            }
            this.writeSuffixArray(j10 - 1, t10);
        }
    }

    private static final int ssIsqrt(int x10) {
        int y10;
        int e10;
        if (x10 >= 0x100000) {
            return 1024;
        }
        int n10 = (x10 & 0xFFFF0000) != 0 ? ((x10 & 0xFF000000) != 0 ? 24 + LG_TABLE[x10 >> 24 & 0xFF] : 16 + LG_TABLE[x10 >> 16 & 0xFF]) : (e10 = (x10 & 0xFF00) != 0 ? 8 + LG_TABLE[x10 >> 8 & 0xFF] : LG_TABLE[x10 >> 0 & 0xFF]);
        if (e10 >= 16) {
            y10 = SQQ_TABLE[x10 >> e10 - 6 - (e10 & 1)] << (e10 >> 1) - 7;
            if (e10 >= 24) {
                y10 = y10 + 1 + x10 / y10 >> 1;
            }
            y10 = y10 + 1 + x10 / y10 >> 1;
        } else if (e10 >= 8) {
            y10 = (SQQ_TABLE[x10 >> e10 - 6 - (e10 & 1)] >> 7 - (e10 >> 1)) + 1;
        } else {
            return SQQ_TABLE[x10] >> 4;
        }
        return x10 < y10 * y10 ? y10 - 1 : y10;
    }

    private final void ssMintroSort(int PA2, int first, int last, int depth) throws IOException {
        int STACK_SIZE = 16;
        StackElement[] stack = new StackElement[16];
        int x10 = 0;
        int ssize = 0;
        int limit = DivSuffixSorter.ssIlg(last - first);
        while (true) {
            int a10;
            int v10;
            if (last - first <= 8) {
                if (1 < last - first) {
                    this.ssInsertionSort(PA2, first, last, depth);
                }
                if (ssize > 0) {
                    StackElement se2 = stack[--ssize];
                    first = se2.a;
                    last = se2.b;
                    depth = se2.c;
                    limit = se2.d;
                    continue;
                }
                return;
            }
            int Td2 = depth;
            if (limit-- == 0) {
                this.ssHeapSort(Td2, PA2, first, last - first);
            }
            if (limit < 0) {
                v10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(first)));
                for (a10 = first + 1; a10 < last; ++a10) {
                    x10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(a10)));
                    if (x10 == v10) continue;
                    if (1 < a10 - first) break;
                    v10 = x10;
                    first = a10;
                }
                if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(first)) - 1) < v10) {
                    first = this.ssPartition(PA2, first, a10, depth);
                }
                if (a10 - first <= last - a10) {
                    if (1 < a10 - first) {
                        stack[ssize++] = new StackElement(a10, last, depth, -1);
                        last = a10;
                        ++depth;
                        limit = DivSuffixSorter.ssIlg(a10 - first);
                        continue;
                    }
                    first = a10;
                    limit = -1;
                    continue;
                }
                if (1 < last - a10) {
                    stack[ssize++] = new StackElement(first, a10, depth + 1, DivSuffixSorter.ssIlg(a10 - first));
                    first = a10;
                    limit = -1;
                    continue;
                }
                last = a10;
                ++depth;
                limit = DivSuffixSorter.ssIlg(a10 - first);
                continue;
            }
            a10 = this.ssPivot(Td2, PA2, first, last);
            v10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(a10)));
            this.swapInSA(first, a10);
            int b10 = first;
            while (++b10 < last && (x10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(b10)))) == v10) {
            }
            a10 = b10;
            if (a10 < last && x10 < v10) {
                while (++b10 < last && (x10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(b10)))) <= v10) {
                    if (x10 != v10) continue;
                    this.swapInSA(b10, a10);
                    ++a10;
                }
            }
            int c10 = last;
            while (b10 < --c10 && (x10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(c10)))) == v10) {
            }
            int d10 = c10;
            if (b10 < d10 && x10 > v10) {
                while (b10 < --c10 && (x10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(c10)))) >= v10) {
                    if (x10 != v10) continue;
                    this.swapInSA(c10, d10);
                    --d10;
                }
            }
            while (b10 < c10) {
                this.swapInSA(b10, c10);
                while (++b10 < c10 && (x10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(b10)))) <= v10) {
                    if (x10 != v10) continue;
                    this.swapInSA(b10, a10);
                    ++a10;
                }
                while (b10 < --c10 && (x10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(c10)))) >= v10) {
                    if (x10 != v10) continue;
                    this.swapInSA(c10, d10);
                    --d10;
                }
            }
            if (a10 <= d10) {
                c10 = b10 - 1;
                int s10 = a10 - first;
                int t10 = b10 - a10;
                if (s10 > t10) {
                    s10 = t10;
                }
                int e10 = first;
                int f10 = b10 - s10;
                while (0 < s10) {
                    this.swapInSA(e10, f10);
                    --s10;
                    ++e10;
                    ++f10;
                }
                s10 = d10 - c10;
                t10 = last - d10 - 1;
                if (s10 > t10) {
                    s10 = t10;
                }
                e10 = b10;
                f10 = last - s10;
                while (0 < s10) {
                    this.swapInSA(e10, f10);
                    --s10;
                    ++e10;
                    ++f10;
                }
                a10 = first + (b10 - a10);
                c10 = last - (d10 - c10);
                int n10 = b10 = v10 <= this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(a10)) - 1) ? a10 : this.ssPartition(PA2, a10, c10, depth);
                if (a10 - first <= last - c10) {
                    if (last - c10 <= c10 - b10) {
                        stack[ssize++] = new StackElement(b10, c10, depth + 1, DivSuffixSorter.ssIlg(c10 - b10));
                        stack[ssize++] = new StackElement(c10, last, depth, limit);
                        last = a10;
                        continue;
                    }
                    if (a10 - first <= c10 - b10) {
                        stack[ssize++] = new StackElement(c10, last, depth, limit);
                        stack[ssize++] = new StackElement(b10, c10, depth + 1, DivSuffixSorter.ssIlg(c10 - b10));
                        last = a10;
                        continue;
                    }
                    stack[ssize++] = new StackElement(c10, last, depth, limit);
                    stack[ssize++] = new StackElement(first, a10, depth, limit);
                    first = b10;
                    last = c10;
                    ++depth;
                    limit = DivSuffixSorter.ssIlg(c10 - b10);
                    continue;
                }
                if (a10 - first <= c10 - b10) {
                    stack[ssize++] = new StackElement(b10, c10, depth + 1, DivSuffixSorter.ssIlg(c10 - b10));
                    stack[ssize++] = new StackElement(first, a10, depth, limit);
                    first = c10;
                    continue;
                }
                if (last - c10 <= c10 - b10) {
                    stack[ssize++] = new StackElement(first, a10, depth, limit);
                    stack[ssize++] = new StackElement(b10, c10, depth + 1, DivSuffixSorter.ssIlg(c10 - b10));
                    first = c10;
                    continue;
                }
                stack[ssize++] = new StackElement(first, a10, depth, limit);
                stack[ssize++] = new StackElement(c10, last, depth, limit);
                first = b10;
                last = c10;
                ++depth;
                limit = DivSuffixSorter.ssIlg(c10 - b10);
                continue;
            }
            ++limit;
            if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(first)) - 1) < v10) {
                first = this.ssPartition(PA2, first, last, depth);
                limit = DivSuffixSorter.ssIlg(last - first);
            }
            ++depth;
        }
    }

    private final int ssPivot(int Td2, int PA2, int first, int last) throws IOException {
        int t10 = last - first;
        int middle = first + t10 / 2;
        if (t10 <= 512) {
            if (t10 <= 32) {
                return this.ssMedian3(Td2, PA2, first, middle, last - 1);
            }
            return this.ssMedian5(Td2, PA2, first, first + (t10 >>= 2), middle, last - 1 - t10, last - 1);
        }
        first = this.ssMedian3(Td2, PA2, first, first + (t10 >>= 3), first + (t10 << 1));
        middle = this.ssMedian3(Td2, PA2, middle - t10, middle, middle + t10);
        last = this.ssMedian3(Td2, PA2, last - 1 - (t10 << 1), last - 1 - t10, last - 1);
        return this.ssMedian3(Td2, PA2, first, middle, last);
    }

    private final int ssMedian5(int Td2, int PA2, int v12, int v22, int v32, int v42, int v52) throws IOException {
        int t10;
        if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v22))) > this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v32)))) {
            t10 = v22;
            v22 = v32;
            v32 = t10;
        }
        if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v42))) > this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v52)))) {
            t10 = v42;
            v42 = v52;
            v52 = t10;
        }
        if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v22))) > this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v42)))) {
            t10 = v22;
            v22 = v42;
            v42 = t10;
            t10 = v32;
            v32 = v52;
            v52 = t10;
        }
        if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v12))) > this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v32)))) {
            t10 = v12;
            v12 = v32;
            v32 = t10;
        }
        if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v12))) > this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v42)))) {
            t10 = v12;
            v12 = v42;
            v42 = t10;
            t10 = v32;
            v32 = v52;
            v52 = t10;
        }
        if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v32))) > this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v42)))) {
            return v42;
        }
        return v32;
    }

    private final int ssMedian3(int Td2, int PA2, int v12, int v22, int v32) throws IOException {
        if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v12))) > this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v22)))) {
            int t10 = v12;
            v12 = v22;
            v22 = t10;
        }
        if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v22))) > this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v32)))) {
            if (this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v12))) > this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(v32)))) {
                return v12;
            }
            return v32;
        }
        return v22;
    }

    private final int ssPartition(int PA2, int first, int last, int depth) throws IOException {
        int a10 = first - 1;
        int b10 = last;
        while (true) {
            if (++a10 < b10 && this.readSuffixArray(PA2 + this.readSuffixArray(a10)) + depth >= this.readSuffixArray(PA2 + this.readSuffixArray(a10) + 1) + 1) {
                this.writeSuffixArray(a10, ~this.readSuffixArray(a10));
                continue;
            }
            while (a10 < --b10 && this.readSuffixArray(PA2 + this.readSuffixArray(b10)) + depth < this.readSuffixArray(PA2 + this.readSuffixArray(b10) + 1) + 1) {
            }
            if (b10 <= a10) break;
            int t10 = ~this.readSuffixArray(b10);
            this.writeSuffixArray(b10, this.readSuffixArray(a10));
            this.writeSuffixArray(a10, t10);
        }
        if (first < a10) {
            this.writeSuffixArray(first, ~this.readSuffixArray(first));
        }
        return a10;
    }

    private final void ssHeapSort(int Td2, int PA2, int sa2, int size) throws IOException {
        int i10;
        int m10 = size;
        if (size % 2 == 0 && this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(sa2 + --m10 / 2))) < this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(sa2 + m10)))) {
            this.swapInSA(sa2 + m10, sa2 + m10 / 2);
        }
        for (i10 = m10 / 2 - 1; 0 <= i10; --i10) {
            this.ssFixDown(Td2, PA2, sa2, i10, m10);
        }
        if (size % 2 == 0) {
            this.swapInSA(sa2, sa2 + m10);
            this.ssFixDown(Td2, PA2, sa2, 0, m10);
        }
        for (i10 = m10 - 1; 0 < i10; --i10) {
            int t10 = this.readSuffixArray(sa2);
            this.writeSuffixArray(sa2, this.readSuffixArray(sa2 + i10));
            this.ssFixDown(Td2, PA2, sa2, 0, i10);
            this.writeSuffixArray(sa2 + i10, t10);
        }
    }

    private final void ssFixDown(int Td2, int PA2, int sa2, int i10, int size) throws IOException {
        int j10;
        int v10 = this.readSuffixArray(sa2 + i10);
        int c10 = this.readInput(Td2 + this.readSuffixArray(PA2 + v10));
        while ((j10 = 2 * i10 + 1) < size) {
            int e10;
            int k10;
            int d10;
            if ((d10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(sa2 + (k10 = j10++))))) < (e10 = this.readInput(Td2 + this.readSuffixArray(PA2 + this.readSuffixArray(sa2 + j10))))) {
                k10 = j10;
                d10 = e10;
            }
            if (d10 <= c10) break;
            this.writeSuffixArray(sa2 + i10, this.readSuffixArray(sa2 + k10));
            i10 = k10;
        }
        this.writeSuffixArray(i10 + sa2, v10);
    }

    private static final int ssIlg(int n10) {
        return (n10 & 0xFF00) != 0 ? 8 + LG_TABLE[n10 >> 8 & 0xFF] : LG_TABLE[n10 >> 0 & 0xFF];
    }

    private final void swapInSA(int a10, int b10) throws IOException {
        int tmp = this.readSuffixArray(a10);
        this.writeSuffixArray(a10, this.readSuffixArray(b10));
        this.writeSuffixArray(b10, tmp);
    }

    private final void trSort(int ISA, int n10, int depth) throws IOException, InterruptedException {
        TRBudget budget = new TRBudget(DivSuffixSorter.trIlg(n10) * 2 / 3, n10);
        int ISAd = ISA + depth;
        while (-n10 < this.readSuffixArray(0L)) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            int first = 0;
            int skip = 0;
            int unsorted = 0;
            do {
                int last;
                int t10;
                if ((t10 = this.readSuffixArray(first)) < 0) {
                    first -= t10;
                    skip += t10;
                    continue;
                }
                if (skip != 0) {
                    this.writeSuffixArray(first + skip, skip);
                    skip = 0;
                }
                if (1 < (last = this.readSuffixArray(ISA + t10) + 1) - first) {
                    budget.count = 0;
                    this.trIntroSort(ISA, ISAd, first, last, budget);
                    if (budget.count != 0) {
                        unsorted += budget.count;
                    } else {
                        skip = first - last;
                    }
                } else if (last - first == 1) {
                    skip = -1;
                }
                first = last;
            } while (first < n10);
            if (skip != 0) {
                this.writeSuffixArray(first + skip, skip);
            }
            if (unsorted == 0) break;
            ISAd += ISAd - ISA;
        }
    }

    private final TRPartitionResult trPartition(int ISAd, int first, int middle, int last, int v10) throws IOException {
        int x10 = 0;
        int b10 = middle - 1;
        while (++b10 < last && (x10 = this.readSuffixArray(ISAd + this.readSuffixArray(b10))) == v10) {
        }
        int a10 = b10;
        if (a10 < last && x10 < v10) {
            while (++b10 < last && (x10 = this.readSuffixArray(ISAd + this.readSuffixArray(b10))) <= v10) {
                if (x10 != v10) continue;
                this.swapInSA(a10, b10);
                ++a10;
            }
        }
        int c10 = last;
        while (b10 < --c10 && (x10 = this.readSuffixArray(ISAd + this.readSuffixArray(c10))) == v10) {
        }
        int d10 = c10;
        if (b10 < d10 && x10 > v10) {
            while (b10 < --c10 && (x10 = this.readSuffixArray(ISAd + this.readSuffixArray(c10))) >= v10) {
                if (x10 != v10) continue;
                this.swapInSA(c10, d10);
                --d10;
            }
        }
        while (b10 < c10) {
            this.swapInSA(c10, b10);
            while (++b10 < c10 && (x10 = this.readSuffixArray(ISAd + this.readSuffixArray(b10))) <= v10) {
                if (x10 != v10) continue;
                this.swapInSA(a10, b10);
                ++a10;
            }
            while (b10 < --c10 && (x10 = this.readSuffixArray(ISAd + this.readSuffixArray(c10))) >= v10) {
                if (x10 != v10) continue;
                this.swapInSA(c10, d10);
                --d10;
            }
        }
        if (a10 <= d10) {
            c10 = b10 - 1;
            int s10 = a10 - first;
            int t10 = b10 - a10;
            if (s10 > t10) {
                s10 = t10;
            }
            int e10 = first;
            int f10 = b10 - s10;
            while (0 < s10) {
                this.swapInSA(e10, f10);
                --s10;
                ++e10;
                ++f10;
            }
            s10 = d10 - c10;
            t10 = last - d10 - 1;
            if (s10 > t10) {
                s10 = t10;
            }
            e10 = b10;
            f10 = last - s10;
            while (0 < s10) {
                this.swapInSA(e10, f10);
                --s10;
                ++e10;
                ++f10;
            }
            first += b10 - a10;
            last -= d10 - c10;
        }
        return new TRPartitionResult(first, last);
    }

    private final void trIntroSort(int ISA, int ISAd, int first, int last, TRBudget budget) throws IOException {
        int STACK_SIZE = 64;
        StackElement[] stack = new StackElement[64];
        int a10 = 0;
        int b10 = 0;
        int x10 = 0;
        int incr = ISAd - ISA;
        int trlink = -1;
        int ssize = 0;
        int limit = DivSuffixSorter.trIlg(last - first);
        while (true) {
            int next;
            StackElement se2;
            int c10;
            int v10;
            TRPartitionResult res;
            if (limit < 0) {
                StackElement se3;
                if (limit == -1) {
                    res = this.trPartition(ISAd - incr, first, first, last, last - 1);
                    a10 = res.a;
                    b10 = res.b;
                    if (a10 < last) {
                        v10 = a10 - 1;
                        for (c10 = first; c10 < a10; ++c10) {
                            this.writeSuffixArray(ISA + this.readSuffixArray(c10), v10);
                        }
                    }
                    if (b10 < last) {
                        v10 = b10 - 1;
                        for (c10 = a10; c10 < b10; ++c10) {
                            this.writeSuffixArray(ISA + this.readSuffixArray(c10), v10);
                        }
                    }
                    if (1 < b10 - a10) {
                        stack[ssize++] = new StackElement(0, a10, b10, 0, 0);
                        stack[ssize++] = new StackElement(ISAd - incr, first, last, -2, trlink);
                        trlink = ssize - 2;
                    }
                    if (a10 - first <= last - b10) {
                        if (1 < a10 - first) {
                            stack[ssize++] = new StackElement(ISAd, b10, last, DivSuffixSorter.trIlg(last - b10), trlink);
                            last = a10;
                            limit = DivSuffixSorter.trIlg(a10 - first);
                            continue;
                        }
                        if (1 < last - b10) {
                            first = b10;
                            limit = DivSuffixSorter.trIlg(last - b10);
                            continue;
                        }
                        if (ssize > 0) {
                            se2 = stack[--ssize];
                            ISAd = se2.a;
                            first = se2.b;
                            last = se2.c;
                            limit = se2.d;
                            trlink = se2.e;
                            continue;
                        }
                        return;
                    }
                    if (1 < last - b10) {
                        stack[ssize++] = new StackElement(ISAd, first, a10, DivSuffixSorter.trIlg(a10 - first), trlink);
                        first = b10;
                        limit = DivSuffixSorter.trIlg(last - b10);
                        continue;
                    }
                    if (1 < a10 - first) {
                        last = a10;
                        limit = DivSuffixSorter.trIlg(a10 - first);
                        continue;
                    }
                    if (ssize > 0) {
                        se2 = stack[--ssize];
                        ISAd = se2.a;
                        first = se2.b;
                        last = se2.c;
                        limit = se2.d;
                        trlink = se2.e;
                        continue;
                    }
                    return;
                }
                if (limit == -2) {
                    se3 = stack[--ssize];
                    a10 = se3.b;
                    b10 = se3.c;
                    if (stack[ssize].d == 0) {
                        this.trCopy(ISA, first, a10, b10, last, ISAd - ISA);
                    } else {
                        if (0 <= trlink) {
                            stack[trlink].d = -1;
                        }
                        this.trPartialCopy(ISA, first, a10, b10, last, ISAd - ISA);
                    }
                    if (ssize > 0) {
                        se3 = stack[--ssize];
                        ISAd = se3.a;
                        first = se3.b;
                        last = se3.c;
                        limit = se3.d;
                        trlink = se3.e;
                        continue;
                    }
                    return;
                }
                if (0 <= this.readSuffixArray(first)) {
                    a10 = first;
                    do {
                        this.writeSuffixArray(ISA + this.readSuffixArray(a10), a10);
                    } while (++a10 < last && 0 <= this.readSuffixArray(a10));
                    first = a10;
                }
                if (first < last) {
                    a10 = first;
                    do {
                        this.writeSuffixArray(a10, ~this.readSuffixArray(a10));
                    } while (this.readSuffixArray(++a10) < 0);
                    int n10 = next = this.readSuffixArray(ISA + this.readSuffixArray(a10)) != this.readSuffixArray(ISAd + this.readSuffixArray(a10)) ? DivSuffixSorter.trIlg(a10 - first + 1) : -1;
                    if (++a10 < last) {
                        v10 = a10 - 1;
                        for (b10 = first; b10 < a10; ++b10) {
                            this.writeSuffixArray(ISA + this.readSuffixArray(b10), v10);
                        }
                    }
                    if (budget.check(a10 - first) != 0) {
                        if (a10 - first <= last - a10) {
                            stack[ssize++] = new StackElement(ISAd, a10, last, -3, trlink);
                            ISAd += incr;
                            last = a10;
                            limit = next;
                            continue;
                        }
                        if (1 < last - a10) {
                            stack[ssize++] = new StackElement(ISAd + incr, first, a10, next, trlink);
                            first = a10;
                            limit = -3;
                            continue;
                        }
                        ISAd += incr;
                        last = a10;
                        limit = next;
                        continue;
                    }
                    if (0 <= trlink) {
                        stack[trlink].d = -1;
                    }
                    if (1 < last - a10) {
                        first = a10;
                        limit = -3;
                        continue;
                    }
                    if (ssize > 0) {
                        se3 = stack[--ssize];
                        ISAd = se3.a;
                        first = se3.b;
                        last = se3.c;
                        limit = se3.d;
                        trlink = se3.e;
                        continue;
                    }
                    return;
                }
                if (ssize > 0) {
                    se3 = stack[--ssize];
                    ISAd = se3.a;
                    first = se3.b;
                    last = se3.c;
                    limit = se3.d;
                    trlink = se3.e;
                    continue;
                }
                return;
            }
            if (last - first <= 8) {
                this.trInsertionSort(ISAd, first, last);
                limit = -3;
                continue;
            }
            if (limit-- == 0) {
                this.trHeapSort(ISAd, first, last - first);
                a10 = last - 1;
                while (first < a10) {
                    x10 = this.readSuffixArray(ISAd + this.readSuffixArray(a10));
                    for (b10 = a10 - 1; first <= b10 && this.readSuffixArray(ISAd + this.readSuffixArray(b10)) == x10; --b10) {
                        this.writeSuffixArray(b10, ~this.readSuffixArray(b10));
                    }
                    a10 = b10;
                }
                limit = -3;
                continue;
            }
            a10 = this.trPivot(ISAd, first, last);
            this.swapInSA(first, a10);
            v10 = this.readSuffixArray(ISAd + this.readSuffixArray(first));
            res = this.trPartition(ISAd, first, first + 1, last, v10);
            a10 = res.a;
            b10 = res.b;
            if (last - first != b10 - a10) {
                next = this.readSuffixArray(ISA + this.readSuffixArray(a10)) != v10 ? DivSuffixSorter.trIlg(b10 - a10) : -1;
                v10 = a10 - 1;
                for (c10 = first; c10 < a10; ++c10) {
                    this.writeSuffixArray(ISA + this.readSuffixArray(c10), v10);
                }
                if (b10 < last) {
                    v10 = b10 - 1;
                    for (c10 = a10; c10 < b10; ++c10) {
                        this.writeSuffixArray(ISA + this.readSuffixArray(c10), v10);
                    }
                }
                if (1 < b10 - a10 && budget.check(b10 - a10) != 0) {
                    if (a10 - first <= last - b10) {
                        if (last - b10 <= b10 - a10) {
                            if (1 < a10 - first) {
                                stack[ssize++] = new StackElement(ISAd + incr, a10, b10, next, trlink);
                                stack[ssize++] = new StackElement(ISAd, b10, last, limit, trlink);
                                last = a10;
                                continue;
                            }
                            if (1 < last - b10) {
                                stack[ssize++] = new StackElement(ISAd + incr, a10, b10, next, trlink);
                                first = b10;
                                continue;
                            }
                            ISAd += incr;
                            first = a10;
                            last = b10;
                            limit = next;
                            continue;
                        }
                        if (a10 - first <= b10 - a10) {
                            if (1 < a10 - first) {
                                stack[ssize++] = new StackElement(ISAd, b10, last, limit, trlink);
                                stack[ssize++] = new StackElement(ISAd + incr, a10, b10, next, trlink);
                                last = a10;
                                continue;
                            }
                            stack[ssize++] = new StackElement(ISAd, b10, last, limit, trlink);
                            ISAd += incr;
                            first = a10;
                            last = b10;
                            limit = next;
                            continue;
                        }
                        stack[ssize++] = new StackElement(ISAd, b10, last, limit, trlink);
                        stack[ssize++] = new StackElement(ISAd, first, a10, limit, trlink);
                        ISAd += incr;
                        first = a10;
                        last = b10;
                        limit = next;
                        continue;
                    }
                    if (a10 - first <= b10 - a10) {
                        if (1 < last - b10) {
                            stack[ssize++] = new StackElement(ISAd + incr, a10, b10, next, trlink);
                            stack[ssize++] = new StackElement(ISAd, first, a10, limit, trlink);
                            first = b10;
                            continue;
                        }
                        if (1 < a10 - first) {
                            stack[ssize++] = new StackElement(ISAd + incr, a10, b10, next, trlink);
                            last = a10;
                            continue;
                        }
                        ISAd += incr;
                        first = a10;
                        last = b10;
                        limit = next;
                        continue;
                    }
                    if (last - b10 <= b10 - a10) {
                        if (1 < last - b10) {
                            stack[ssize++] = new StackElement(ISAd, first, a10, limit, trlink);
                            stack[ssize++] = new StackElement(ISAd + incr, a10, b10, next, trlink);
                            first = b10;
                            continue;
                        }
                        stack[ssize++] = new StackElement(ISAd, first, a10, limit, trlink);
                        ISAd += incr;
                        first = a10;
                        last = b10;
                        limit = next;
                        continue;
                    }
                    stack[ssize++] = new StackElement(ISAd, first, a10, limit, trlink);
                    stack[ssize++] = new StackElement(ISAd, b10, last, limit, trlink);
                    ISAd += incr;
                    first = a10;
                    last = b10;
                    limit = next;
                    continue;
                }
                if (1 < b10 - a10 && 0 <= trlink) {
                    stack[trlink].d = -1;
                }
                if (a10 - first <= last - b10) {
                    if (1 < a10 - first) {
                        stack[ssize++] = new StackElement(ISAd, b10, last, limit, trlink);
                        last = a10;
                        continue;
                    }
                    if (1 < last - b10) {
                        first = b10;
                        continue;
                    }
                    if (ssize > 0) {
                        se2 = stack[--ssize];
                        ISAd = se2.a;
                        first = se2.b;
                        last = se2.c;
                        limit = se2.d;
                        trlink = se2.e;
                        continue;
                    }
                    return;
                }
                if (1 < last - b10) {
                    stack[ssize++] = new StackElement(ISAd, first, a10, limit, trlink);
                    first = b10;
                    continue;
                }
                if (1 < a10 - first) {
                    last = a10;
                    continue;
                }
                if (ssize > 0) {
                    se2 = stack[--ssize];
                    ISAd = se2.a;
                    first = se2.b;
                    last = se2.c;
                    limit = se2.d;
                    trlink = se2.e;
                    continue;
                }
                return;
            }
            if (budget.check(last - first) != 0) {
                limit = DivSuffixSorter.trIlg(last - first);
                ISAd += incr;
                continue;
            }
            if (0 <= trlink) {
                stack[trlink].d = -1;
            }
            if (ssize <= 0) break;
            se2 = stack[--ssize];
            ISAd = se2.a;
            first = se2.b;
            last = se2.c;
            limit = se2.d;
            trlink = se2.e;
        }
    }

    private final int trPivot(int ISAd, int first, int last) throws IOException {
        int t10 = last - first;
        int middle = first + t10 / 2;
        if (t10 <= 512) {
            if (t10 <= 32) {
                return this.trMedian3(ISAd, first, middle, last - 1);
            }
            return this.trMedian5(ISAd, first, first + (t10 >>= 2), middle, last - 1 - t10, last - 1);
        }
        first = this.trMedian3(ISAd, first, first + (t10 >>= 3), first + (t10 << 1));
        middle = this.trMedian3(ISAd, middle - t10, middle, middle + t10);
        last = this.trMedian3(ISAd, last - 1 - (t10 << 1), last - 1 - t10, last - 1);
        return this.trMedian3(ISAd, first, middle, last);
    }

    private final int trMedian5(int ISAd, int v12, int v22, int v32, int v42, int v52) throws IOException {
        int t10;
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v22)) > this.readSuffixArray(ISAd + this.readSuffixArray(v32))) {
            t10 = v22;
            v22 = v32;
            v32 = t10;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v42)) > this.readSuffixArray(ISAd + this.readSuffixArray(v52))) {
            t10 = v42;
            v42 = v52;
            v52 = t10;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v22)) > this.readSuffixArray(ISAd + this.readSuffixArray(v42))) {
            t10 = v22;
            v22 = v42;
            v42 = t10;
            t10 = v32;
            v32 = v52;
            v52 = t10;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v12)) > this.readSuffixArray(ISAd + this.readSuffixArray(v32))) {
            t10 = v12;
            v12 = v32;
            v32 = t10;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v12)) > this.readSuffixArray(ISAd + this.readSuffixArray(v42))) {
            t10 = v12;
            v12 = v42;
            v42 = t10;
            t10 = v32;
            v32 = v52;
            v52 = t10;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v32)) > this.readSuffixArray(ISAd + this.readSuffixArray(v42))) {
            return v42;
        }
        return v32;
    }

    private final int trMedian3(int ISAd, int v12, int v22, int v32) throws IOException {
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v12)) > this.readSuffixArray(ISAd + this.readSuffixArray(v22))) {
            int t10 = v12;
            v12 = v22;
            v22 = t10;
        }
        if (this.readSuffixArray(ISAd + this.readSuffixArray(v22)) > this.readSuffixArray(ISAd + this.readSuffixArray(v32))) {
            if (this.readSuffixArray(ISAd + this.readSuffixArray(v12)) > this.readSuffixArray(ISAd + this.readSuffixArray(v32))) {
                return v12;
            }
            return v32;
        }
        return v22;
    }

    private final void trHeapSort(int ISAd, int sa2, int size) throws IOException {
        int i10;
        int m10 = size;
        if (size % 2 == 0 && this.readSuffixArray(ISAd + this.readSuffixArray(sa2 + --m10 / 2)) < this.readSuffixArray(ISAd + this.readSuffixArray(sa2 + m10))) {
            this.swapInSA(sa2 + m10, sa2 + m10 / 2);
        }
        for (i10 = m10 / 2 - 1; 0 <= i10; --i10) {
            this.trFixDown(ISAd, sa2, i10, m10);
        }
        if (size % 2 == 0) {
            this.swapInSA(sa2, sa2 + m10);
            this.trFixDown(ISAd, sa2, 0, m10);
        }
        for (i10 = m10 - 1; 0 < i10; --i10) {
            int t10 = this.readSuffixArray(sa2);
            this.writeSuffixArray(sa2, this.readSuffixArray(sa2 + i10));
            this.trFixDown(ISAd, sa2, 0, i10);
            this.writeSuffixArray(sa2 + i10, t10);
        }
    }

    private final void trFixDown(int ISAd, int sa2, int i10, int size) throws IOException {
        int j10;
        int v10 = this.readSuffixArray(sa2 + i10);
        int c10 = this.readSuffixArray(ISAd + v10);
        while ((j10 = 2 * i10 + 1) < size) {
            int e10;
            int k10;
            int d10;
            if ((d10 = this.readSuffixArray(ISAd + this.readSuffixArray(sa2 + (k10 = j10++)))) < (e10 = this.readSuffixArray(ISAd + this.readSuffixArray(sa2 + j10)))) {
                k10 = j10;
                d10 = e10;
            }
            if (d10 <= c10) break;
            this.writeSuffixArray(sa2 + i10, this.readSuffixArray(sa2 + k10));
            i10 = k10;
        }
        this.writeSuffixArray(sa2 + i10, v10);
    }

    private final void trInsertionSort(int ISAd, int first, int last) throws IOException {
        for (int a10 = first + 1; a10 < last; ++a10) {
            int r10;
            int t10 = this.readSuffixArray(a10);
            int b10 = a10 - 1;
            while (0 > (r10 = this.readSuffixArray(ISAd + t10) - this.readSuffixArray(ISAd + this.readSuffixArray(b10)))) {
                do {
                    this.writeSuffixArray(b10 + 1, this.readSuffixArray(b10));
                } while (first <= --b10 && this.readSuffixArray(b10) < 0);
                if (b10 >= first) continue;
            }
            if (r10 == 0) {
                this.writeSuffixArray(b10, ~this.readSuffixArray(b10));
            }
            this.writeSuffixArray(b10 + 1, t10);
        }
    }

    private final void trPartialCopy(int ISA, int first, int a10, int b10, int last, int depth) throws IOException {
        int e10;
        int rank;
        int s10;
        int c10;
        int newrank = -1;
        int v10 = b10 - 1;
        int lastrank = -1;
        int d10 = a10 - 1;
        for (c10 = first; c10 <= d10; ++c10) {
            s10 = this.readSuffixArray(c10) - depth;
            if (0 > s10 || this.readSuffixArray(ISA + s10) != v10) continue;
            this.writeSuffixArray(++d10, s10);
            rank = this.readSuffixArray(ISA + s10 + depth);
            if (lastrank != rank) {
                lastrank = rank;
                newrank = d10;
            }
            this.writeSuffixArray(ISA + s10, newrank);
        }
        lastrank = -1;
        for (e10 = d10; first <= e10; --e10) {
            rank = this.readSuffixArray(ISA + this.readSuffixArray(e10));
            if (lastrank != rank) {
                lastrank = rank;
                newrank = e10;
            }
            if (newrank == rank) continue;
            this.writeSuffixArray(ISA + this.readSuffixArray(e10), newrank);
        }
        lastrank = -1;
        c10 = last - 1;
        e10 = d10 + 1;
        d10 = b10;
        while (e10 < d10) {
            s10 = this.readSuffixArray(c10) - depth;
            if (0 <= s10 && this.readSuffixArray(ISA + s10) == v10) {
                this.writeSuffixArray(--d10, s10);
                rank = this.readSuffixArray(ISA + s10 + depth);
                if (lastrank != rank) {
                    lastrank = rank;
                    newrank = d10;
                }
                this.writeSuffixArray(ISA + s10, newrank);
            }
            --c10;
        }
    }

    private final void trCopy(int ISA, int first, int a10, int b10, int last, int depth) throws IOException {
        int s10;
        int c10;
        int v10 = b10 - 1;
        int d10 = a10 - 1;
        for (c10 = first; c10 <= d10; ++c10) {
            s10 = this.readSuffixArray(c10) - depth;
            if (0 > s10 || this.readSuffixArray(ISA + s10) != v10) continue;
            this.writeSuffixArray(++d10, s10);
            this.writeSuffixArray(ISA + s10, d10);
        }
        c10 = last - 1;
        int e10 = d10 + 1;
        d10 = b10;
        while (e10 < d10) {
            s10 = this.readSuffixArray(c10) - depth;
            if (0 <= s10 && this.readSuffixArray(ISA + s10) == v10) {
                this.writeSuffixArray(--d10, s10);
                this.writeSuffixArray(ISA + s10, d10);
            }
            --c10;
        }
    }

    private static final int trIlg(int n10) {
        return (n10 & 0xFFFF0000) != 0 ? ((n10 & 0xFF000000) != 0 ? 24 + LG_TABLE[n10 >> 24 & 0xFF] : 16 + LG_TABLE[n10 >> 16 & 0xFF]) : ((n10 & 0xFF00) != 0 ? 8 + LG_TABLE[n10 >> 8 & 0xFF] : LG_TABLE[n10 >> 0 & 0xFF]);
    }

    private int readInput(long pos) throws IOException {
        this.input.seek(pos);
        return this.input.readUnsignedByte();
    }

    private int readSuffixArray(long pos) throws IOException {
        this.suffixArray.seekToIntAligned(pos + 1L);
        return this.suffixArray.readInt();
    }

    private int writeSuffixArray(long pos, int write) throws IOException {
        this.suffixArray.seekToIntAligned(pos + 1L);
        this.suffixArray.writeInt(write);
        return write;
    }

    private static final class TRPartitionResult {
        final int a;
        final int b;

        public TRPartitionResult(int a10, int b10) {
            this.a = a10;
            this.b = b10;
        }
    }

    private static final class TRBudget {
        int chance;
        int remain;
        int incval;
        int count;

        private TRBudget(int chance, int incval) {
            this.chance = chance;
            this.remain = incval;
            this.incval = incval;
        }

        private int check(int size) {
            if (size <= this.remain) {
                this.remain -= size;
                return 1;
            }
            if (this.chance == 0) {
                this.count += size;
                return 0;
            }
            this.remain += this.incval - size;
            --this.chance;
            return 1;
        }
    }

    private static final class StackElement {
        final int a;
        final int b;
        final int c;
        final int e;
        int d;

        StackElement(int a10, int b10, int c10, int d10, int e10) {
            this.a = a10;
            this.b = b10;
            this.c = c10;
            this.d = d10;
            this.e = e10;
        }

        StackElement(int a10, int b10, int c10, int d10) {
            this(a10, b10, c10, d10, 0);
        }
    }
}

