/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.devrel.gmscore.tools.apk.arsc.ArscBlamer;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceString;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceTableChunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeSpecChunk;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceEntryStatsCollector {
    private static final int OFFSET_SIZE = 4;
    private static final int STYLE_OVERHEAD = 8;
    private static final int PACKAGE_CHUNK_OVERHEAD = 8;
    private final Map<ArscBlamer.ResourceEntry, ResourceStatistics> stats = new HashMap<ArscBlamer.ResourceEntry, ResourceStatistics>();
    private final ArscBlamer blamer;
    private final ResourceTableChunk resourceTable;

    public ResourceEntryStatsCollector(ArscBlamer blamer, ResourceTableChunk resourceTable) {
        this.resourceTable = resourceTable;
        this.blamer = blamer;
    }

    public void compute() throws IOException {
        Preconditions.checkState((boolean)this.stats.isEmpty(), (Object)"Must only call #compute once.");
        this.blamer.blame();
        this.computeStringPoolSizes();
        this.computePackageSizes();
    }

    public Map<ArscBlamer.ResourceEntry, ResourceStatistics> getStats() {
        Preconditions.checkState((!this.stats.isEmpty() ? 1 : 0) != 0, (Object)"Must call #compute() first.");
        return Collections.unmodifiableMap(this.stats);
    }

    public ResourceStatistics getStats(ArscBlamer.ResourceEntry entry) {
        Preconditions.checkState((!this.stats.isEmpty() ? 1 : 0) != 0, (Object)"Must call #compute() first.");
        return this.stats.containsKey(entry) ? this.stats.get(entry) : ResourceStatistics.EMPTY;
    }

    private void computeStringPoolSizes() throws IOException {
        this.computePoolSizes(this.resourceTable.getStringPool(), this.blamer.getStringToBlamedResources());
    }

    private void computePackageSizes() throws IOException {
        this.computeTypePoolSizes();
        this.computeKeyPoolSizes();
        this.computeTypeSpecSizes();
        this.computeTypeChunkSizes();
        this.computePackageChunkSizes();
    }

    private void computeTypePoolSizes() throws IOException {
        for (Map.Entry<PackageChunk, List<ArscBlamer.ResourceEntry>[]> entry : this.blamer.getTypeToBlamedResources().entrySet()) {
            this.computePoolSizes(entry.getKey().getTypeStringPool(), entry.getValue());
        }
    }

    private void computeKeyPoolSizes() throws IOException {
        for (Map.Entry<PackageChunk, List<ArscBlamer.ResourceEntry>[]> entry : this.blamer.getKeyToBlamedResources().entrySet()) {
            this.computePoolSizes(entry.getKey().getKeyStringPool(), entry.getValue());
        }
    }

    private void computeTypeSpecSizes() {
        for (Map.Entry<PackageChunk, List<ArscBlamer.ResourceEntry>[]> entry : this.blamer.getTypeToBlamedResources().entrySet()) {
            this.computeTypeSpecSizes(entry.getKey(), entry.getValue());
        }
    }

    private void computeTypeChunkSizes() {
        for (Map.Entry entry : this.blamer.getTypeEntryToBlamedResources().asMap().entrySet()) {
            TypeChunk.Entry chunkEntry = (TypeChunk.Entry)entry.getKey();
            TypeChunk typeChunk = chunkEntry.parent();
            int size = chunkEntry.size() + 4;
            int count = typeChunk.getEntries().size();
            int nullEntries = typeChunk.getTotalEntryCount() - typeChunk.getEntries().size();
            int overhead = typeChunk.getHeaderSize() + nullEntries * 4;
            this.addSizes((Collection)entry.getValue(), overhead, size, count);
        }
    }

    private void computePackageChunkSizes() {
        for (Map.Entry entry : this.blamer.getPackageToBlamedResources().asMap().entrySet()) {
            int overhead = ((PackageChunk)entry.getKey()).getHeaderSize() + 8;
            this.addSizes((Collection)entry.getValue(), overhead, 0, 1);
        }
    }

    private void computePoolSizes(StringPoolChunk stringPool, List<ArscBlamer.ResourceEntry>[] usages) throws IOException {
        int i10;
        int overhead = stringPool.getHeaderSize();
        if (stringPool.getStyleCount() > 0) {
            overhead += 8;
        }
        int count = 0;
        for (i10 = 0; i10 < usages.length; ++i10) {
            if (usages[i10].isEmpty()) {
                overhead += this.computeStringAndStyleSize(stringPool, i10);
                continue;
            }
            ++count;
        }
        for (i10 = 0; i10 < usages.length; ++i10) {
            if (usages[i10].isEmpty()) continue;
            int size = this.computeStringAndStyleSize(stringPool, i10);
            this.addSizes(usages[i10], overhead, size, count);
        }
    }

    private void computeTypeSpecSizes(PackageChunk packageChunk, List<ArscBlamer.ResourceEntry>[] usages) {
        for (int i10 = 0; i10 < usages.length; ++i10) {
            TypeSpecChunk typeSpec = packageChunk.getTypeSpecChunk(i10 + 1);
            this.addSizes(usages[i10], typeSpec.getOriginalChunkSize(), 0, 1);
        }
    }

    private int computeStringAndStyleSize(StringPoolChunk stringPool, int index) throws IOException {
        return this.computeStringSize(stringPool, index) + this.computeStyleSize(stringPool, index);
    }

    private int computeStringSize(StringPoolChunk stringPool, int index) {
        String string = stringPool.getString(index);
        int result2 = BinaryResourceString.encodeString(string, stringPool.getStringType()).length;
        return result2 += 4;
    }

    private int computeStyleSize(StringPoolChunk stringPool, int index) throws IOException {
        if (index >= stringPool.getStyleCount()) {
            return 0;
        }
        return stringPool.getStyle(index).toByteArray().length + 4;
    }

    private void addSizes(Collection<ArscBlamer.ResourceEntry> entries, int overhead, int size, int count) {
        int usageCount = entries.size();
        for (ArscBlamer.ResourceEntry resourceEntry : entries) {
            if (!this.stats.containsKey(resourceEntry)) {
                this.stats.put(resourceEntry, new ResourceStatistics());
            }
            ResourceStatistics resourceStats = this.stats.get(resourceEntry);
            if (usageCount == 1) {
                resourceStats.addPrivateSize(size);
            } else {
                resourceStats.addSharedSize(size);
            }
            if (usageCount == 1 && count == 1) {
                resourceStats.addPrivateSize(overhead);
            }
            resourceStats.addProportionalSize(size, usageCount);
            resourceStats.addProportionalSize(overhead, usageCount * count);
        }
    }

    public static class ResourceStatistics {
        public static final ResourceStatistics EMPTY = new ResourceStatistics();
        private int privateSize = 0;
        private int sharedSize = 0;
        private double proportionalSize = 0.0;

        private ResourceStatistics() {
        }

        public int getPrivateSize() {
            return this.privateSize;
        }

        public int getSharedSize() {
            return this.sharedSize;
        }

        public double getProportionalSize() {
            return this.proportionalSize;
        }

        private void addPrivateSize(int privateSize) {
            this.privateSize += privateSize;
        }

        private void addSharedSize(int sharedSize) {
            this.sharedSize += sharedSize;
        }

        private void addProportionalSize(int numerator, int denominator) {
            this.proportionalSize += 1.0 * (double)numerator / (double)denominator;
        }
    }
}

