/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.common.primitives.UnsignedBytes;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceConfiguration;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceIdentifier;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceTableChunk;
import com.google.devrel.gmscore.tools.apk.arsc.SerializableResource;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class TypeChunk
extends Chunk {
    private final int id;
    private final int entryCount;
    private final int entriesStart;
    private BinaryResourceConfiguration configuration;
    private final Map<Integer, Entry> entries = new TreeMap<Integer, Entry>();

    protected TypeChunk(ByteBuffer buffer, Chunk parent) {
        super(buffer, parent);
        this.id = UnsignedBytes.toInt((byte)buffer.get());
        buffer.position(buffer.position() + 3);
        this.entryCount = buffer.getInt();
        this.entriesStart = buffer.getInt();
        this.configuration = BinaryResourceConfiguration.create(buffer);
    }

    @Override
    protected void init(ByteBuffer buffer) {
        int offset = this.offset + this.entriesStart;
        for (int i10 = 0; i10 < this.entryCount; ++i10) {
            Entry entry = Entry.create(buffer, offset, this);
            if (entry == null) continue;
            this.entries.put(i10, entry);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getTypeName() {
        PackageChunk packageChunk = this.getPackageChunk();
        Preconditions.checkNotNull((Object)packageChunk, (String)"%s has no parent package.", this.getClass());
        StringPoolChunk typePool = packageChunk.getTypeStringPool();
        Preconditions.checkNotNull((Object)typePool, (String)"%s's parent package has no type pool.", this.getClass());
        return typePool.getString(this.getId() - 1);
    }

    public BinaryResourceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BinaryResourceConfiguration configuration) {
        this.configuration = configuration;
    }

    public int getTotalEntryCount() {
        return this.entryCount;
    }

    public Map<Integer, Entry> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public boolean containsResource(BinaryResourceIdentifier resourceId) {
        PackageChunk packageChunk = (PackageChunk)Preconditions.checkNotNull((Object)this.getPackageChunk());
        int packageId = packageChunk.getId();
        int typeId = this.getId();
        return resourceId.packageId() == packageId && resourceId.typeId() == typeId && this.entries.containsKey(resourceId.entryId());
    }

    public void overrideEntries(Map<Integer, Entry> entries) {
        for (Map.Entry<Integer, Entry> entry : entries.entrySet()) {
            int index = entry.getKey() != null ? entry.getKey() : -1;
            this.overrideEntry(index, entry.getValue());
        }
    }

    public void overrideEntry(int index, Entry entry) {
        if (index >= 0 && index < this.entryCount) {
            if (entry != null) {
                this.entries.put(index, entry);
            } else {
                this.entries.remove(index);
            }
        }
    }

    protected String getString(int index) {
        ResourceTableChunk resourceTable = this.getResourceTableChunk();
        Preconditions.checkNotNull((Object)resourceTable, (String)"%s has no resource table.", this.getClass());
        return resourceTable.getStringPool().getString(index);
    }

    protected String getKeyName(int index) {
        PackageChunk packageChunk = this.getPackageChunk();
        Preconditions.checkNotNull((Object)packageChunk, (String)"%s has no parent package.", this.getClass());
        StringPoolChunk keyPool = packageChunk.getKeyStringPool();
        Preconditions.checkNotNull((Object)keyPool, (String)"%s's parent package has no key pool.", this.getClass());
        return keyPool.getString(index);
    }

    private ResourceTableChunk getResourceTableChunk() {
        Chunk chunk;
        for (chunk = this.getParent(); chunk != null && !(chunk instanceof ResourceTableChunk); chunk = chunk.getParent()) {
        }
        return chunk != null ? (ResourceTableChunk)chunk : null;
    }

    public PackageChunk getPackageChunk() {
        Chunk chunk;
        for (chunk = this.getParent(); chunk != null && !(chunk instanceof PackageChunk); chunk = chunk.getParent()) {
        }
        return chunk != null ? (PackageChunk)chunk : null;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE_TYPE;
    }

    private int getOffsetSize() {
        return this.entryCount * 4;
    }

    private int writeEntries(DataOutput payload, ByteBuffer offsets, boolean shrink) throws IOException {
        int entryOffset = 0;
        for (int i10 = 0; i10 < this.entryCount; ++i10) {
            Entry entry = this.entries.get(i10);
            if (entry == null) {
                offsets.putInt(-1);
                continue;
            }
            byte[] encodedEntry = entry.toByteArray(shrink);
            payload.write(encodedEntry);
            offsets.putInt(entryOffset);
            entryOffset += encodedEntry.length;
        }
        entryOffset = this.writePad(payload, entryOffset);
        return entryOffset;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        int entriesStart = this.getHeaderSize() + this.getOffsetSize();
        output.putInt(this.id);
        output.putInt(this.entryCount);
        output.putInt(entriesStart);
        output.put(this.configuration.toByteArray(false));
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBuffer offsets = ByteBuffer.allocate(this.getOffsetSize()).order(ByteOrder.LITTLE_ENDIAN);
        try (LittleEndianDataOutputStream payload = new LittleEndianDataOutputStream((OutputStream)baos);){
            this.writeEntries((DataOutput)payload, offsets, shrink);
        }
        output.write(offsets.array());
        output.write(baos.toByteArray());
    }

    public static class Entry
    implements SerializableResource {
        public static final int NO_ENTRY = -1;
        private static final int FLAG_COMPLEX = 1;
        private static final int MAPPING_SIZE = 12;
        private final int headerSize;
        private final int flags;
        private final int keyIndex;
        private final BinaryResourceValue value;
        private final Map<Integer, BinaryResourceValue> values;
        private final int parentEntry;
        private final TypeChunk parent;

        private Entry(int headerSize, int flags, int keyIndex, BinaryResourceValue value, Map<Integer, BinaryResourceValue> values, int parentEntry, TypeChunk parent) {
            this.headerSize = headerSize;
            this.flags = flags;
            this.keyIndex = keyIndex;
            this.value = value;
            this.values = values;
            this.parentEntry = parentEntry;
            this.parent = parent;
        }

        public int headerSize() {
            return this.headerSize;
        }

        public int flags() {
            return this.flags;
        }

        public int keyIndex() {
            return this.keyIndex;
        }

        public BinaryResourceValue value() {
            return this.value;
        }

        public Map<Integer, BinaryResourceValue> values() {
            return this.values;
        }

        public int parentEntry() {
            return this.parentEntry;
        }

        public TypeChunk parent() {
            return this.parent;
        }

        public final String typeName() {
            return this.parent().getTypeName();
        }

        public final int size() {
            return this.headerSize() + (this.isComplex() ? this.values().size() * 12 : 8);
        }

        public final String key() {
            return this.parent().getKeyName(this.keyIndex());
        }

        public final boolean isComplex() {
            return (this.flags() & 1) != 0;
        }

        public static Entry create(ByteBuffer buffer, int baseOffset, TypeChunk parent) {
            int offset = buffer.getInt();
            if (offset == -1) {
                return null;
            }
            int position = buffer.position();
            buffer.position(baseOffset + offset);
            Entry result2 = Entry.newInstance(buffer, parent);
            buffer.position(position);
            return result2;
        }

        private static Entry newInstance(ByteBuffer buffer, TypeChunk parent) {
            int headerSize = buffer.getShort() & 0xFFFF;
            int flags = buffer.getShort() & 0xFFFF;
            int keyIndex = buffer.getInt();
            BinaryResourceValue value = null;
            LinkedHashMap<Integer, BinaryResourceValue> values = new LinkedHashMap<Integer, BinaryResourceValue>();
            int parentEntry = 0;
            if ((flags & 1) != 0) {
                parentEntry = buffer.getInt();
                int valueCount = buffer.getInt();
                for (int i10 = 0; i10 < valueCount; ++i10) {
                    values.put(buffer.getInt(), BinaryResourceValue.create(buffer));
                }
            } else {
                value = BinaryResourceValue.create(buffer);
            }
            return new Entry(headerSize, flags, keyIndex, value, values, parentEntry, parent);
        }

        @Override
        public final byte[] toByteArray() {
            return this.toByteArray(false);
        }

        @Override
        public final byte[] toByteArray(boolean shrink) {
            ByteBuffer buffer = ByteBuffer.allocate(this.size());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort((short)this.headerSize());
            buffer.putShort((short)this.flags());
            buffer.putInt(this.keyIndex());
            if (this.isComplex()) {
                buffer.putInt(this.parentEntry());
                buffer.putInt(this.values().size());
                for (Map.Entry<Integer, BinaryResourceValue> entry : this.values().entrySet()) {
                    buffer.putInt(entry.getKey());
                    buffer.put(entry.getValue().toByteArray(shrink));
                }
            } else {
                BinaryResourceValue value = this.value();
                Preconditions.checkNotNull((Object)value, (Object)"A non-complex TypeChunk entry must have a value.");
                buffer.put(value.toByteArray());
            }
            return buffer.array();
        }

        public final String toString() {
            return String.format("Entry{key=%s}", this.key());
        }

        public boolean equals(Object o10) {
            if (this == o10) {
                return true;
            }
            if (o10 == null || this.getClass() != o10.getClass()) {
                return false;
            }
            Entry entry = (Entry)o10;
            return this.headerSize == entry.headerSize && this.flags == entry.flags && this.keyIndex == entry.keyIndex && this.parentEntry == entry.parentEntry && Objects.equals(this.value, entry.value) && Objects.equals(this.values, entry.values) && Objects.equals(this.parent, entry.parent);
        }

        public int hashCode() {
            return Objects.hash(this.headerSize, this.flags, this.keyIndex, this.value, this.values, this.parentEntry, this.parent);
        }
    }
}

