/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import com.google.gson.JsonParseException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.PathKt;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.report.ReportProvider;
import org.jetbrains.qodana.report.ReportReader;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/report/ReportParser;", "Lorg/jetbrains/qodana/report/ReportProvider;", "reportPath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "failMessagesProvider", "Lorg/jetbrains/qodana/report/ReportReader$FailMessagesProvider;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/report/ReportReader$FailMessagesProvider;)V", "getSarifReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "FailMessagesProvider", "intellij.qodana"})
public final class ReportParser
implements ReportProvider {
    private final Path reportPath;
    private final Project project;
    private final ReportReader.FailMessagesProvider failMessagesProvider;

    @Override
    @Nullable
    public SarifReport getSarifReport() {
        if (!PathKt.isFile((Path)this.reportPath)) {
            if (this.failMessagesProvider != null) {
                new Notification("Qodana", QodanaBundle.message("notification.title.cant.parse.report", new Object[0]), this.failMessagesProvider.getFileNotExistsMessage(), NotificationType.WARNING).notify(this.project);
            }
            return null;
        }
        try {
            return SarifUtil.readReport((Path)this.reportPath);
        }
        catch (JsonParseException e) {
            if (this.failMessagesProvider != null) {
                new Notification("Qodana", QodanaBundle.message("notification.title.cant.parse.report", new Object[0]), this.failMessagesProvider.getFailedParseMessage(), NotificationType.WARNING).notify(this.project);
            }
            return null;
        }
    }

    public ReportParser(@NotNull Path reportPath, @Nullable Project project, @Nullable ReportReader.FailMessagesProvider failMessagesProvider) {
        Intrinsics.checkNotNullParameter((Object)reportPath, (String)"reportPath");
        this.reportPath = reportPath;
        this.project = project;
        this.failMessagesProvider = failMessagesProvider;
    }

    @Override
    @Nullable
    public SarifReport getReport() {
        return ReportProvider.DefaultImpls.getReport(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\r\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H&J\r\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/qodana/report/ReportParser$FailMessagesProvider;", "", "getFailedParseMessage", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "getFileNotExistsMessage", "intellij.qodana"})
    public static interface FailMessagesProvider {
        @NotNull
        public String getFileNotExistsMessage();

        @NotNull
        public String getFailedParseMessage();
    }
}

