/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth;

import com.google.api.client.auth.oauth.OAuthSigner;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Data;
import com.google.api.client.util.escape.PercentEscaper;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@Beta
public final class OAuthParameters
implements HttpExecuteInterceptor,
HttpRequestInitializer {
    private static final SecureRandom RANDOM = new SecureRandom();
    public OAuthSigner signer;
    public String callback;
    public String consumerKey;
    public String nonce;
    public String realm;
    public String signature;
    public String signatureMethod;
    public String timestamp;
    public String token;
    public String verifier;
    public String version;
    private static final PercentEscaper ESCAPER = new PercentEscaper("-_.~");

    public void computeNonce() {
        this.nonce = Long.toHexString(Math.abs(RANDOM.nextLong()));
    }

    public void computeTimestamp() {
        this.timestamp = Long.toString(System.currentTimeMillis() / 1000L);
    }

    public void computeSignature(String requestMethod, GenericUrl requestUrl) throws GeneralSecurityException {
        OAuthSigner signer = this.signer;
        String signatureMethod = this.signatureMethod = signer.getSignatureMethod();
        TreeMultiset parameters = TreeMultiset.create();
        this.putParameterIfValueNotNull((Multiset<Parameter>)parameters, "oauth_callback", this.callback);
        this.putParameterIfValueNotNull((Multiset<Parameter>)parameters, "oauth_consumer_key", this.consumerKey);
        this.putParameterIfValueNotNull((Multiset<Parameter>)parameters, "oauth_nonce", this.nonce);
        this.putParameterIfValueNotNull((Multiset<Parameter>)parameters, "oauth_signature_method", signatureMethod);
        this.putParameterIfValueNotNull((Multiset<Parameter>)parameters, "oauth_timestamp", this.timestamp);
        this.putParameterIfValueNotNull((Multiset<Parameter>)parameters, "oauth_token", this.token);
        this.putParameterIfValueNotNull((Multiset<Parameter>)parameters, "oauth_verifier", this.verifier);
        this.putParameterIfValueNotNull((Multiset<Parameter>)parameters, "oauth_version", this.version);
        for (Map.Entry<String, Object> fieldEntry : requestUrl.entrySet()) {
            Iterator value = fieldEntry.getValue();
            if (value == null) continue;
            String name = fieldEntry.getKey();
            if (value instanceof Collection) {
                for (Object repeatedValue : (Collection)((Object)value)) {
                    this.putParameter((Multiset<Parameter>)parameters, name, repeatedValue);
                }
                continue;
            }
            this.putParameter((Multiset<Parameter>)parameters, name, value);
        }
        StringBuilder parametersBuf = new StringBuilder();
        boolean first = true;
        for (Parameter parameter : parameters.elementSet()) {
            if (first) {
                first = false;
            } else {
                parametersBuf.append('&');
            }
            parametersBuf.append(parameter.getKey());
            String value = parameter.getValue();
            if (value == null) continue;
            parametersBuf.append('=').append(value);
        }
        String normalizedParameters = parametersBuf.toString();
        GenericUrl normalized = new GenericUrl();
        String scheme = requestUrl.getScheme();
        normalized.setScheme(scheme);
        normalized.setHost(requestUrl.getHost());
        normalized.setPathParts(requestUrl.getPathParts());
        int port = requestUrl.getPort();
        if ("http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443) {
            port = -1;
        }
        normalized.setPort(port);
        String normalizedPath = normalized.build();
        StringBuilder buf = new StringBuilder();
        buf.append(OAuthParameters.escape(requestMethod)).append('&');
        buf.append(OAuthParameters.escape(normalizedPath)).append('&');
        buf.append(OAuthParameters.escape(normalizedParameters));
        String signatureBaseString = buf.toString();
        this.signature = signer.computeSignature(signatureBaseString);
    }

    public String getAuthorizationHeader() {
        StringBuilder buf = new StringBuilder("OAuth");
        this.appendParameter(buf, "realm", this.realm);
        this.appendParameter(buf, "oauth_callback", this.callback);
        this.appendParameter(buf, "oauth_consumer_key", this.consumerKey);
        this.appendParameter(buf, "oauth_nonce", this.nonce);
        this.appendParameter(buf, "oauth_signature", this.signature);
        this.appendParameter(buf, "oauth_signature_method", this.signatureMethod);
        this.appendParameter(buf, "oauth_timestamp", this.timestamp);
        this.appendParameter(buf, "oauth_token", this.token);
        this.appendParameter(buf, "oauth_verifier", this.verifier);
        this.appendParameter(buf, "oauth_version", this.version);
        return buf.substring(0, buf.length() - 1);
    }

    private void appendParameter(StringBuilder buf, String name, String value) {
        if (value != null) {
            buf.append(' ').append(OAuthParameters.escape(name)).append("=\"").append(OAuthParameters.escape(value)).append("\",");
        }
    }

    private void putParameterIfValueNotNull(Multiset<Parameter> parameters, String key, String value) {
        if (value != null) {
            this.putParameter(parameters, key, value);
        }
    }

    private void putParameter(Multiset<Parameter> parameters, String key, Object value) {
        parameters.add((Object)new Parameter(OAuthParameters.escape(key), value == null ? null : OAuthParameters.escape(value.toString())));
    }

    public static String escape(String value) {
        return ESCAPER.escape(value);
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(this);
    }

    @Override
    public void intercept(HttpRequest request) throws IOException {
        this.computeNonce();
        this.computeTimestamp();
        try {
            GenericUrl url = request.getUrl();
            HttpContent content2 = request.getContent();
            Map<String, Object> urlEncodedParams = null;
            if (content2 instanceof UrlEncodedContent) {
                urlEncodedParams = Data.mapOf(((UrlEncodedContent)content2).getData());
                url.putAll((Map<? extends String, ?>)urlEncodedParams);
            }
            this.computeSignature(request.getRequestMethod(), url);
            if (urlEncodedParams != null) {
                for (Map.Entry<String, Object> entry : urlEncodedParams.entrySet()) {
                    url.remove(entry.getKey());
                }
            }
        }
        catch (GeneralSecurityException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
        request.getHeaders().setAuthorization(this.getAuthorizationHeader());
    }

    private static class Parameter
    implements Comparable<Parameter> {
        private final String key;
        private final String value;

        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Parameter p) {
            int result = this.key.compareTo(p.key);
            return result == 0 ? this.value.compareTo(p.value) : result;
        }
    }
}

