/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.images;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.images.ConfigureImageDialog;
import org.intellij.plugins.markdown.editor.images.ConfigureImageLineMarkerProviderBase;
import org.intellij.plugins.markdown.editor.images.MarkdownImageData;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownImage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.util.PsiUtilsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureMarkdownImageLineMarkerProvider;", "Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownImage;", "()V", "applyChanges", "", "element", "Lcom/intellij/psi/PsiElement;", "imageData", "Lorg/intellij/plugins/markdown/editor/images/MarkdownImageData;", "createDialog", "Lorg/intellij/plugins/markdown/editor/images/ConfigureImageDialog;", "createHtmlReplacement", "isInsideParagraph", "", "obtainLeafElement", "obtainOuterElement", "obtainPathText", "", "intellij.markdown.core"})
@ApiStatus.Internal
public final class ConfigureMarkdownImageLineMarkerProvider
extends ConfigureImageLineMarkerProviderBase<MarkdownImage> {
    @Override
    @Nullable
    public String obtainPathText(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownImage markdownImage = this.obtainOuterElement(element2);
        if (markdownImage == null) {
            return null;
        }
        MarkdownImage image = markdownImage;
        MarkdownLinkDestination markdownLinkDestination = image.getLinkDestination();
        return markdownLinkDestination != null ? markdownLinkDestination.getText() : null;
    }

    @Override
    @Nullable
    public PsiElement obtainLeafElement(@NotNull PsiElement element2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownImage outer = MarkdownImage.Companion.getByLeadingExclamationMark(element2);
        PsiElement it = psiElement = element2;
        boolean bl = false;
        return outer != null ? psiElement : null;
    }

    @Override
    @Nullable
    public MarkdownImage obtainOuterElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        return psiElement instanceof MarkdownImage ? (MarkdownImage)element2 : MarkdownImage.Companion.getByLeadingExclamationMark(element2);
    }

    @Override
    @Nullable
    public ConfigureImageDialog createDialog(@NotNull MarkdownImage element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownImage markdownImage = this.obtainOuterElement((PsiElement)element2);
        if (markdownImage == null) {
            return null;
        }
        MarkdownImage image = markdownImage;
        Project project = image.getProject();
        String string = MarkdownBundle.message("markdown.configure.image.title.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026figure.image.title.text\")");
        return new ConfigureImageDialog(project, string, this.obtainPathText((PsiElement)element2), null, null, image.collectLinkTitleText(), image.collectLinkDescriptionText(), false, 24, null);
    }

    private final boolean isInsideParagraph(PsiElement element2) {
        Object v1;
        block1: {
            Sequence sequence;
            Sequence sequence2 = sequence = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)false);
            for (Object e : sequence2) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                IElementType iElementType = MarkdownElementTypes.PARAGRAPH;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownElementTypes.PARAGRAPH");
                if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                v1 = e;
                break block1;
            }
            v1 = null;
        }
        return v1 != null;
    }

    private final PsiElement createHtmlReplacement(PsiElement element2, MarkdownImageData imageData) {
        PsiElement psiElement;
        if (this.isInsideParagraph(element2)) {
            PsiElement psiElement2 = MarkdownPsiElementFactory.createHtmlImageTag(element2.getProject(), imageData);
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"MarkdownPsiElementFactor\u2026ement.project, imageData)");
        } else {
            PsiElement psiElement3 = MarkdownPsiElementFactory.createHtmlBlockWithImage(element2.getProject(), imageData);
            psiElement = psiElement3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"MarkdownPsiElementFactor\u2026ement.project, imageData)");
        }
        return psiElement;
    }

    @Override
    public void applyChanges(@NotNull PsiElement element2, @NotNull MarkdownImageData imageData) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        MarkdownImage markdownImage = this.obtainOuterElement(element2);
        if (markdownImage == null) {
            return;
        }
        MarkdownImage outerElement = markdownImage;
        Project project = outerElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"outerElement.project");
        Project project2 = project;
        if (imageData.getShouldConvertToHtml()) {
            psiElement = this.createHtmlReplacement((PsiElement)outerElement, imageData);
        } else {
            PsiElement psiElement2 = MarkdownPsiElementFactory.createImage(project2, imageData.getDescription(), imageData.getPath(), imageData.getTitle());
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"MarkdownPsiElementFactor\u2026  imageData.title\n      )");
        }
        PsiElement replacement = psiElement;
        Runnable action2 = new Runnable(outerElement, replacement){
            final /* synthetic */ MarkdownImage $outerElement;
            final /* synthetic */ PsiElement $replacement;

            public final void run() {
                this.$outerElement.replace(this.$replacement);
            }
            {
                this.$outerElement = markdownImage;
                this.$replacement = psiElement;
            }
        };
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)MarkdownBundle.message("markdown.configure.image.title.text", new Object[0]), null, (Runnable)action2, (PsiFile[])new PsiFile[0]);
    }
}

