/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.row;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.row.InsertRowAction$performAction$;
import org.intellij.plugins.markdown.editor.tables.actions.row.RowBasedTableAction;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction;", "Lorg/intellij/plugins/markdown/editor/tables/actions/row/RowBasedTableAction;", "insertAbove", "", "(Z)V", "findRowOrSeparator", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "obtainCellsWidths", "", "", "element", "performAction", "", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "rowElement", "InsertAbove", "InsertBelow", "intellij.markdown.core"})
public abstract class InsertRowAction
extends RowBasedTableAction {
    private final boolean insertAbove;

    @Override
    protected void performAction(@NotNull Editor editor2, @NotNull MarkdownTable table, @NotNull PsiElement rowElement) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)rowElement, (String)"rowElement");
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(this, rowElement, table){
            final /* synthetic */ InsertRowAction this$0;
            final /* synthetic */ PsiElement $rowElement$inlined;
            final /* synthetic */ MarkdownTable $table$inlined;
            {
                this.this$0 = insertRowAction;
                this.$rowElement$inlined = psiElement;
                this.$table$inlined = markdownTable;
            }

            public final T compute() {
                boolean bl = false;
                Collection widths = InsertRowAction.access$obtainCellsWidths(this.this$0, this.$rowElement$inlined);
                MarkdownTableRow markdownTableRow = MarkdownPsiElementFactory.createTableEmptyRow(this.$table$inlined.getProject(), widths);
                Intrinsics.checkNotNullExpressionValue((Object)markdownTableRow, (String)"MarkdownPsiElementFactor\u2026ow(table.project, widths)");
                MarkdownTableRow newRow = markdownTableRow;
                boolean bl2 = Intrinsics.areEqual((Object)this.$rowElement$inlined.getParent(), (Object)this.$table$inlined);
                if (!bl2) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                Project project$iv = this.$rowElement$inlined.getProject();
                String name$iv = null;
                String groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(newRow, this){
                    final /* synthetic */ MarkdownTableRow $newRow$inlined;
                    final /* synthetic */ performAction$$inlined$runWriteAction$1 this$0;
                    {
                        this.$newRow$inlined = markdownTableRow;
                        this.this$0 = var2_2;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (InsertRowAction.access$getInsertAbove$p(this.this$0.this$0)) {
                            this.this$0.$table$inlined.addRangeBefore((PsiElement)this.$newRow$inlined, this.$newRow$inlined.getNextSibling(), this.this$0.$rowElement$inlined);
                        } else {
                            this.this$0.$table$inlined.addRangeAfter(this.$newRow$inlined.getPrevSibling(), (PsiElement)this.$newRow$inlined, this.this$0.$rowElement$inlined);
                        }
                    }
                }, name$iv, (Object)groupId$iv);
                return (T)Unit.INSTANCE;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Integer> obtainCellsWidths(PsiElement element2) {
        Collection collection;
        PsiElement psiElement = element2;
        if (psiElement instanceof MarkdownTableRow) {
            void $this$mapTo$iv$iv;
            List<MarkdownTableCell> list2 = ((MarkdownTableRow)element2).getCells();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"element.cells");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MarkdownTableCell markdownTableCell = (MarkdownTableCell)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                Integer n = v1.getTextLength();
                collection2.add(n);
            }
            collection = (List)destination$iv$iv;
        } else if (psiElement instanceof MarkdownTableSeparatorRow) {
            Iterable $this$map$iv = ((MarkdownTableSeparatorRow)element2).getCellsRanges();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TextRange it = (TextRange)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getLength();
                collection3.add(n);
            }
            collection = (List)destination$iv$iv;
        } else {
            String string = "element should be either MarkdownTableRow or MarkdownTableSeparatorRow";
            throw new IllegalStateException(string.toString());
        }
        return collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    protected PsiElement findRowOrSeparator(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement psiElement = super.findRowOrSeparator(file, editor2);
        if (psiElement == null) return null;
        PsiElement element2 = psiElement;
        PsiElement psiElement2 = element2;
        if (!(psiElement2 instanceof MarkdownTableRow)) {
            psiElement2 = null;
        }
        MarkdownTableRow markdownTableRow = (MarkdownTableRow)psiElement2;
        if (markdownTableRow != null) {
            if (TableUtils.INSTANCE.isHeaderRow(markdownTableRow)) {
                return null;
            }
        }
        if (this.insertAbove && element2 instanceof MarkdownTableSeparatorRow) {
            return null;
        }
        PsiElement psiElement3 = element2;
        return psiElement3;
    }

    public InsertRowAction(boolean insertAbove) {
        super(true);
        this.insertAbove = insertAbove;
    }

    public static final /* synthetic */ Collection access$obtainCellsWidths(InsertRowAction $this, PsiElement element2) {
        return $this.obtainCellsWidths(element2);
    }

    public static final /* synthetic */ boolean access$getInsertAbove$p(InsertRowAction $this) {
        return $this.insertAbove;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction$InsertAbove;", "Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction;", "()V", "intellij.markdown.core"})
    public static final class InsertAbove
    extends InsertRowAction {
        public InsertAbove() {
            super(true);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction$InsertBelow;", "Lorg/intellij/plugins/markdown/editor/tables/actions/row/InsertRowAction;", "()V", "intellij.markdown.core"})
    public static final class InsertBelow
    extends InsertRowAction {
        public InsertBelow() {
            super(false);
        }
    }
}

